/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gogui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import net.sf.gogui.game.GameInformation;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.MarkType;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.NodeUtils;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.BoardUtils;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.gogui.AboutDialog;
import net.sf.gogui.gogui.GoGuiMenuBar;
import net.sf.gogui.gogui.GoGuiToolBar;
import net.sf.gogui.gogui.GotoVariationDialog;
import net.sf.gogui.gogui.Interrupt;
import net.sf.gogui.gogui.MoveNumberDialog;
import net.sf.gogui.gogui.Print;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpUtils;
import net.sf.gogui.gui.AnalyzeCommand;
import net.sf.gogui.gui.AnalyzeDialog;
import net.sf.gogui.gui.AnalyzeShow;
import net.sf.gogui.gui.BoardSizeDialog;
import net.sf.gogui.gui.Bookmark;
import net.sf.gogui.gui.BookmarkDialog;
import net.sf.gogui.gui.Clock;
import net.sf.gogui.gui.CommandThread;
import net.sf.gogui.gui.Comment;
import net.sf.gogui.gui.ContextMenu;
import net.sf.gogui.gui.EditBookmarksDialog;
import net.sf.gogui.gui.FindDialog;
import net.sf.gogui.gui.GameInfo;
import net.sf.gogui.gui.GameInfoDialog;
import net.sf.gogui.gui.GameTreeViewer;
import net.sf.gogui.gui.GtpShell;
import net.sf.gogui.gui.GuiBoard;
import net.sf.gogui.gui.GuiBoardUtils;
import net.sf.gogui.gui.GuiUtils;
import net.sf.gogui.gui.Help;
import net.sf.gogui.gui.LiveGfx;
import net.sf.gogui.gui.OptionalMessage;
import net.sf.gogui.gui.ParameterDialog;
import net.sf.gogui.gui.RecentFileMenu;
import net.sf.gogui.gui.ScoreDialog;
import net.sf.gogui.gui.SelectProgram;
import net.sf.gogui.gui.Session;
import net.sf.gogui.gui.SimpleDialogs;
import net.sf.gogui.gui.StatusBar;
import net.sf.gogui.gui.TextViewer;
import net.sf.gogui.gui.Utils;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.sgf.SgfWriter;
import net.sf.gogui.tex.TexWriter;
import net.sf.gogui.thumbnail.Thumbnail;
import net.sf.gogui.utils.ErrorMessage;
import net.sf.gogui.utils.FileUtils;
import net.sf.gogui.utils.Platform;
import net.sf.gogui.utils.Preferences;
import net.sf.gogui.utils.ProgressShow;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.version.Version;

public class GoGui
extends JFrame
implements ActionListener,
AnalyzeDialog.Callback,
GuiBoard.Listener,
GameTreeViewer.Listener,
GtpShell.Callback {
    private boolean m_analyzeAutoRun;
    private boolean m_analyzeOneRunOnly;
    private boolean m_auto;
    private boolean m_beepAfterMove;
    private boolean m_computerBlack;
    private boolean m_computerWhite;
    private boolean m_fastPaint;
    private boolean m_ignoreInvalidResponses;
    private boolean m_interruptComputerBoth;
    private boolean m_isRootExecuted;
    private boolean m_isSingleMove;
    private boolean m_lostOnTimeShown;
    private boolean m_needsSave;
    private boolean m_resigned;
    private boolean m_scoreMode;
    private boolean m_setupMode;
    private boolean m_showInfoPanel;
    private boolean m_showLastMove;
    private boolean m_showToolbar;
    private boolean m_showVariations;
    private boolean m_verbose;
    private int m_boardSize;
    private int m_currentNodeExecuted;
    private int m_handicap;
    private int m_move;
    private static final long serialVersionUID = 0L;
    private Board m_board;
    private GuiBoard m_guiBoard;
    private Clock m_clock;
    private CommandThread m_commandThread;
    private Comment m_comment;
    private File m_loadedFile;
    private GameInfo m_gameInfo;
    private GtpShell m_gtpShell;
    private GameTree m_gameTree;
    private GameTreeViewer m_gameTreeViewer;
    private Help m_help;
    private JPanel m_infoPanel;
    private JPanel m_innerPanel;
    private JSplitPane m_splitPane;
    private GoGuiMenuBar m_menuBar;
    private Node m_currentNode;
    private OptionalMessage m_gameFinishedMessage;
    private OptionalMessage m_overwriteWarning;
    private OptionalMessage m_passWarning;
    private OptionalMessage m_saveQuestion;
    private Pattern m_pattern;
    private AnalyzeCommand m_analyzeCommand;
    private File m_file;
    private StatusBar m_statusBar;
    private String m_gtpCommand;
    private String m_gtpFile;
    private String m_initAnalyze;
    private String m_lastAnalyzeCommand;
    private String m_name;
    private String m_program;
    private String m_titleFromProgram;
    private String m_version = "";
    private AnalyzeDialog m_analyzeDialog;
    private Preferences m_prefs;
    private ScoreDialog m_scoreDialog;
    private String m_programAnalyzeCommands;
    private Thumbnail m_thumbnail = new Thumbnail(false);
    private TimeSettings m_timeSettings;
    private GoGuiToolBar m_toolBar;
    private ArrayList m_bookmarks;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GoGui(String string, Preferences preferences, String string2, int n, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string4, String string5, String string6, boolean bl5) throws GtpError, ErrorMessage {
        this.m_fastPaint = bl5;
        this.m_prefs = preferences;
        this.m_boardSize = preferences.getInt("boardsize");
        this.m_beepAfterMove = preferences.getBool("beep-after-move");
        if (string2 != null) {
            this.m_file = new File(string2);
        }
        this.m_gtpFile = string4;
        this.m_gtpCommand = string5;
        this.m_move = n;
        this.m_computerBlack = bl2;
        this.m_computerWhite = bl3;
        this.m_auto = bl4;
        this.m_verbose = bl;
        this.m_initAnalyze = string6;
        this.m_showInfoPanel = true;
        this.m_showToolbar = false;
        Container container = this.getContentPane();
        this.m_innerPanel = new JPanel(new BorderLayout());
        container.add((Component)this.m_innerPanel, "Center");
        this.m_toolBar = new GoGuiToolBar(this);
        this.m_infoPanel = new JPanel(new BorderLayout());
        this.m_clock = new Clock();
        this.m_gameInfo = new GameInfo(this.m_clock);
        this.m_gameInfo.setBorder(GuiUtils.createSmallEmptyBorder());
        this.m_infoPanel.add((Component)this.m_gameInfo, "North");
        this.m_board = new Board(this.m_boardSize);
        this.m_guiBoard = new GuiBoard(this.m_boardSize, bl5);
        this.m_guiBoard.setListener(this);
        this.m_statusBar = new StatusBar();
        this.m_innerPanel.add((Component)this.m_statusBar, "South");
        Comment.Listener listener = new Comment.Listener(){

            public void changed() {
                GoGui.this.cbCommentChanged();
            }

            public void textSelected(String string) {
                if (string == null) {
                    string = "";
                }
                GoPoint[] goPointArray = GtpUtils.parsePointString(string, GoGui.this.m_boardSize);
                GuiBoardUtils.showPointList(GoGui.this.m_guiBoard, goPointArray);
            }
        };
        this.m_comment = new Comment(listener, this.m_fastPaint);
        this.m_comment.setFontFixed(this.m_prefs.getBool("comment-font-fixed"));
        this.m_infoPanel.add((Component)this.m_comment, "Center");
        this.m_splitPane = new JSplitPane(1, this.m_guiBoard, this.m_infoPanel);
        GuiUtils.removeKeyBinding(this.m_splitPane, "F8");
        this.m_splitPane.setResizeWeight(1.0);
        this.m_innerPanel.add((Component)this.m_splitPane, "Center");
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GoGui.this.close();
            }
        };
        this.addWindowListener(windowAdapter);
        this.setDefaultCloseOperation(0);
        GuiUtils.setGoIcon(this);
        RecentFileMenu.Callback callback = new RecentFileMenu.Callback(){

            public void fileSelected(String string, File file) {
                if (!GoGui.this.checkSaveGame()) {
                    return;
                }
                GoGui.this.loadFile(file, -1);
                GoGui.this.boardChangedBegin(false, true);
            }
        };
        RecentFileMenu.Callback callback2 = new RecentFileMenu.Callback(){

            public void fileSelected(String string, File file) {
                if (GoGui.this.m_gtpShell == null) {
                    return;
                }
                GoGui.this.sendGtpFile(file);
                GoGui.this.m_menuBar.addRecentGtp(file);
            }
        };
        this.m_menuBar = new GoGuiMenuBar(this, callback, callback2);
        this.m_menuBar.selectBoardSizeItem(this.m_boardSize);
        boolean bl6 = this.m_prefs.getBool("analyze-only-supported-commands");
        this.m_menuBar.setAnalyzeOnlySupported(bl6);
        this.m_menuBar.setAnalyzeSort(this.m_prefs.getBool("analyze-sort"));
        this.m_menuBar.setGameTreeLabels(this.m_prefs.getInt("gametree-labels"));
        this.m_menuBar.setGameTreeSize(this.m_prefs.getInt("gametree-size"));
        boolean bl7 = this.m_prefs.getBool("gametree-show-subtree-sizes");
        this.m_menuBar.setShowSubtreeSizes(bl7);
        this.m_menuBar.setAutoNumber(this.m_prefs.getBool("gtpshell-autonumber"));
        boolean bl8 = !this.m_prefs.getBool("gtpshell-disable-completions");
        this.m_menuBar.setCommandCompletion(bl8);
        this.m_menuBar.setCommentFontFixed(this.m_prefs.getBool("comment-font-fixed"));
        this.m_menuBar.setTimeStamp(this.m_prefs.getBool("gtpshell-timestamp"));
        this.m_menuBar.setBeepAfterMove(this.m_beepAfterMove);
        this.m_menuBar.setShowInfoPanel(this.m_showInfoPanel);
        this.m_menuBar.setShowToolbar(this.m_showToolbar);
        this.m_menuBar.setShowLastMove(this.m_prefs.getBool("show-last-move"));
        this.m_menuBar.setShowVariations(this.m_prefs.getBool("show-variations"));
        this.m_showLastMove = this.m_prefs.getBool("show-last-move");
        this.m_showVariations = this.m_prefs.getBool("show-variations");
        this.m_menuBar.setShowCursor(this.m_prefs.getBool("show-cursor"));
        this.m_menuBar.setShowGrid(this.m_prefs.getBool("show-grid"));
        this.m_guiBoard.setShowCursor(this.m_prefs.getBool("show-cursor"));
        this.m_guiBoard.setShowGrid(this.m_prefs.getBool("show-grid"));
        this.setJMenuBar(this.m_menuBar.getMenuBar());
        if (string != null) {
            this.m_program = string;
        } else if (this.m_prefs.contains("program")) {
            this.m_program = this.m_prefs.getString("program");
        }
        if (this.m_program != null && this.m_program.trim().equals("")) {
            this.m_program = null;
        }
        if (this.m_program == null) {
            this.m_toolBar.setComputerEnabled(false);
            this.m_menuBar.setComputerEnabled(false);
        }
        this.m_menuBar.setNormalMode();
        this.m_guiBoard.requestFocusInWindow();
        if (string3 != null) {
            this.m_timeSettings = TimeSettings.parse(string3);
        }
        Runnable runnable = new Runnable(){

            public void run() {
                GoGui.this.initialize();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (!(!this.isCommandInProgress() || string.equals("about") || string.equals("beep-after-move") || string.equals("comment-font-fixed") || string.equals("computer-black") || string.equals("computer-both") || string.equals("computer-none") || string.equals("computer-white") || string.equals("detach-program") || string.equals("gtpshell-save") || string.equals("gtpshell-save-commands") || string.equals("command-completion") || string.equals("auto-number") || string.equals("timestamp") || string.equals("help") || string.equals("interrupt") || string.equals("show-grid") || string.equals("show-shell") || string.equals("show-toolbar") || string.equals("show-tree") || string.equals("show-info-panel") || string.equals("show-last-move") || string.equals("exit"))) {
            return;
        }
        if (string.equals("about")) {
            this.cbAbout();
        } else if (string.equals("add-bookmark")) {
            this.cbAddBookmark();
        } else if (string.equals("edit-bookmarks")) {
            this.cbEditBookmarks();
        } else if (string.equals("analyze")) {
            this.cbAnalyze();
        } else if (string.equals("analyze-only-supported")) {
            this.cbAnalyzeOnlySupported();
        } else if (string.equals("analyze-reload")) {
            this.cbAnalyzeReload();
        } else if (string.equals("analyze-sort")) {
            this.cbAnalyzeSort();
        } else if (string.equals("attach-program")) {
            this.cbAttachProgram();
        } else if (string.equals("auto-number")) {
            this.cbAutoNumber();
        } else if (string.equals("back-to-main-variation")) {
            this.cbBackToMainVar();
        } else if (string.equals("backward")) {
            this.cbBackward(1);
        } else if (string.equals("backward-10")) {
            this.cbBackward(10);
        } else if (string.equals("beep-after-move")) {
            this.cbBeepAfterMove();
        } else if (string.equals("beginning")) {
            this.cbBeginning();
        } else if (string.equals("board-size-other")) {
            this.cbBoardSizeOther();
        } else if (string.startsWith("board-size-")) {
            this.cbBoardSize(string.substring("board-size-".length()));
        } else if (string.startsWith("bookmark-")) {
            this.cbBookmark(string.substring("bookmark-".length()));
        } else if (string.equals("clock-halt")) {
            this.cbClockHalt();
        } else if (string.equals("clock-resume")) {
            this.cbClockResume();
        } else if (string.equals("clock-restore")) {
            this.cbClockRestore();
        } else if (string.equals("command-completion")) {
            this.cbCommandCompletion();
        } else if (string.equals("comment-font-fixed")) {
            this.cbCommentFontFixed();
        } else if (string.equals("computer-black")) {
            this.computerBlack();
        } else if (string.equals("computer-both")) {
            this.cbComputerBoth();
        } else if (string.equals("computer-none")) {
            this.computerNone();
        } else if (string.equals("computer-white")) {
            this.computerWhite();
        } else if (string.equals("detach-program")) {
            this.cbDetachProgram();
        } else if (string.equals("end")) {
            this.cbEnd();
        } else if (string.equals("exit")) {
            this.close();
        } else if (string.equals("export-ascii")) {
            this.cbExportAscii();
        } else if (string.equals("export-latex")) {
            this.cbExportLatex();
        } else if (string.equals("export-latex-position")) {
            this.cbExportLatexPosition();
        } else if (string.equals("export-sgf-position")) {
            this.cbExportSgfPosition();
        } else if (string.equals("find-in-comments")) {
            this.cbFindInComments();
        } else if (string.equals("find-next")) {
            this.cbFindNext();
        } else if (string.equals("forward")) {
            this.cbForward(1);
        } else if (string.equals("forward-10")) {
            this.cbForward(10);
        } else if (string.equals("game-info")) {
            this.cbGameInfo();
        } else if (string.equals("goto")) {
            this.cbGoto();
        } else if (string.equals("goto-variation")) {
            this.cbGotoVariation();
        } else if (string.equals("gametree-move")) {
            this.cbGameTreeLabels(1);
        } else if (string.equals("gametree-number")) {
            this.cbGameTreeLabels(0);
        } else if (string.equals("gametree-none")) {
            this.cbGameTreeLabels(2);
        } else if (string.equals("gametree-large")) {
            this.cbGameTreeSize(0);
        } else if (string.equals("gametree-normal")) {
            this.cbGameTreeSize(1);
        } else if (string.equals("gametree-small")) {
            this.cbGameTreeSize(2);
        } else if (string.equals("gametree-tiny")) {
            this.cbGameTreeSize(3);
        } else if (string.equals("gametree-show-subtree-sizes")) {
            this.cbGameTreeShowSubtreeSizes();
        } else if (string.equals("gtpshell-save")) {
            this.cbGtpShellSave();
        } else if (string.equals("gtpshell-save-commands")) {
            this.cbGtpShellSaveCommands();
        } else if (string.equals("gtpshell-send-file")) {
            this.cbGtpShellSendFile();
        } else if (string.startsWith("handicap-")) {
            this.cbHandicap(string.substring("handicap-".length()));
        } else if (string.equals("help")) {
            this.cbHelp();
        } else if (string.equals("interrupt")) {
            this.cbInterrupt();
        } else if (string.equals("keep-only-main-variation")) {
            this.cbKeepOnlyMainVariation();
        } else if (string.equals("keep-only-position")) {
            this.cbKeepOnlyPosition();
        } else if (string.equals("make-main-variation")) {
            this.cbMakeMainVariation();
        } else if (string.equals("next-variation")) {
            this.cbNextVariation();
        } else if (string.equals("next-earlier-variation")) {
            this.cbNextEarlierVariation();
        } else if (string.equals("new-game")) {
            this.cbNewGame(this.m_boardSize);
        } else if (string.equals("open")) {
            this.cbOpen();
        } else if (string.equals("pass")) {
            this.cbPass();
        } else if (string.equals("play")) {
            this.cbPlay(false);
        } else if (string.equals("play-single")) {
            this.cbPlay(true);
        } else if (string.equals("previous-variation")) {
            this.cbPreviousVariation();
        } else if (string.equals("previous-earlier-variation")) {
            this.cbPreviousEarlierVariation();
        } else if (string.equals("print")) {
            this.cbPrint();
        } else if (string.equals("save")) {
            this.cbSave();
        } else if (string.equals("save-as")) {
            this.cbSaveAs();
        } else if (string.equals("score")) {
            this.cbScore();
        } else if (string.equals("score-cancel")) {
            this.cbScoreDone(false);
        } else if (string.equals("score-done")) {
            this.cbScoreDone(true);
        } else if (string.equals("setup")) {
            this.cbSetup();
        } else if (string.equals("setup-black")) {
            this.cbSetupBlack();
        } else if (string.equals("setup-white")) {
            this.cbSetupWhite();
        } else if (string.equals("show-cursor")) {
            this.cbShowCursor();
        } else if (string.equals("show-grid")) {
            this.cbShowGrid();
        } else if (string.equals("show-info-panel")) {
            this.cbShowInfoPanel();
        } else if (string.equals("show-last-move")) {
            this.cbShowLastMove();
        } else if (string.equals("show-shell")) {
            this.cbShowShell();
        } else if (string.equals("show-toolbar")) {
            this.cbShowToolbar();
        } else if (string.equals("show-tree")) {
            this.cbShowTree();
        } else if (string.equals("show-variations")) {
            this.cbShowVariations();
        } else if (string.equals("timestamp")) {
            this.cbTimeStamp();
        } else if (string.equals("truncate")) {
            this.cbTruncate();
        } else if (string.equals("truncate-children")) {
            this.cbTruncateChildren();
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void cbAnalyze() {
        if (this.m_commandThread == null) {
            return;
        }
        if (this.m_menuBar.getShowAnalyze()) {
            if (this.m_analyzeDialog == null) {
                boolean bl = this.m_menuBar.getAnalyzeOnlySupported();
                boolean bl2 = this.m_menuBar.getAnalyzeSort();
                this.m_analyzeDialog = new AnalyzeDialog(this, this, bl, bl2, this.m_commandThread.getSupportedCommands(), this.m_programAnalyzeCommands, this.m_commandThread);
                this.m_analyzeDialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        GoGui.this.m_menuBar.setShowAnalyze(false);
                    }
                });
                this.m_analyzeDialog.setBoardSize(this.m_board.getSize());
                this.restoreSize(this.m_analyzeDialog, "window-analyze");
                this.setTitle();
            }
            this.m_analyzeDialog.setVisible(true);
        } else {
            if (this.m_analyzeDialog != null) {
                this.m_analyzeDialog.close();
            }
            this.m_analyzeDialog = null;
        }
    }

    public void cbAnalyzeOnlySupported() {
        boolean bl = this.m_menuBar.getAnalyzeOnlySupported();
        this.m_prefs.setBool("analyze-only-supported-commands", bl);
        if (this.m_analyzeDialog != null) {
            this.m_analyzeDialog.setOnlySupported(bl);
        }
    }

    public void cbAnalyzeReload() {
        if (this.m_analyzeDialog != null) {
            this.m_analyzeDialog.reload();
        }
    }

    public void cbAnalyzeSort() {
        boolean bl = this.m_menuBar.getAnalyzeSort();
        this.m_prefs.setBool("analyze-sort", bl);
        if (this.m_analyzeDialog != null) {
            this.m_analyzeDialog.setSort(bl);
        }
    }

    public void cbAttachProgram() {
        String string = SelectProgram.select(this);
        if (string == null) {
            return;
        }
        if (this.m_commandThread != null && !this.cbDetachProgram()) {
            return;
        }
        if (!this.attachProgram(string)) {
            this.m_prefs.setString("program", "");
            return;
        }
        this.m_prefs.setString("program", this.m_program);
        if (this.m_gtpShell != null && this.m_prefs.getBool("show-gtpshell")) {
            this.m_menuBar.setShowShell(true);
            this.cbShowShell();
        }
        if (this.m_prefs.getBool("show-analyze")) {
            this.m_menuBar.setShowAnalyze(true);
            this.cbAnalyze();
        }
        this.toFrontLater();
    }

    public void cbAutoNumber(boolean bl) {
        if (this.m_commandThread != null) {
            this.m_commandThread.setAutoNumber(bl);
        }
    }

    public void cbBackward(int n) {
        this.backward(n);
        this.boardChangedBegin(false, false);
    }

    public void cbBeginning() {
        this.backward(NodeUtils.getDepth(this.m_currentNode));
        this.boardChangedBegin(false, false);
    }

    public void cbCommandCompletion() {
        if (this.m_gtpShell == null) {
            return;
        }
        boolean bl = this.m_menuBar.getCommandCompletion();
        this.m_gtpShell.setCommandCompletion(bl);
        this.m_prefs.setBool("gtpshell-disable-completions", !bl);
    }

    public boolean cbDetachProgram() {
        if (this.m_commandThread == null) {
            return false;
        }
        if (this.isCommandInProgress() && !this.showQuestion("Kill program?")) {
            return false;
        }
        this.detachProgram();
        this.m_prefs.setString("program", "");
        return true;
    }

    public void cbEnd() {
        this.forward(NodeUtils.getNodesLeft(this.m_currentNode));
        this.boardChangedBegin(false, false);
    }

    public void cbForward(int n) {
        this.forward(n);
        this.boardChangedBegin(false, false);
    }

    public void cbGotoNode(Node node) {
        this.gotoNode(node);
        this.boardChangedBegin(false, false);
    }

    public void cbGtpShellSave() {
        if (this.m_gtpShell == null) {
            return;
        }
        this.m_gtpShell.saveLog(this);
    }

    public void cbGtpShellSaveCommands() {
        if (this.m_gtpShell == null) {
            return;
        }
        this.m_gtpShell.saveCommands(this);
    }

    public void cbGtpShellSendFile() {
        if (this.m_gtpShell == null) {
            return;
        }
        File file = SimpleDialogs.showOpen(this, "Choose GTP file");
        if (file == null) {
            return;
        }
        this.sendGtpFile(file);
        this.m_menuBar.addRecentGtp(file);
    }

    public void cbNextVariation() {
        Node node = NodeUtils.getNextVariation(this.m_currentNode);
        if (node != null) {
            this.cbGotoNode(node);
        }
    }

    public void cbNextEarlierVariation() {
        Node node = NodeUtils.getNextEarlierVariation(this.m_currentNode);
        if (node != null) {
            this.cbGotoNode(node);
        }
    }

    public void cbPreviousVariation() {
        Node node = NodeUtils.getPreviousVariation(this.m_currentNode);
        if (node != null) {
            this.cbGotoNode(node);
        }
    }

    public void cbPreviousEarlierVariation() {
        Node node = NodeUtils.getPreviousEarlierVariation(this.m_currentNode);
        if (node != null) {
            this.cbGotoNode(node);
        }
    }

    public void cbShowShell() {
        if (this.m_gtpShell == null) {
            return;
        }
        this.m_gtpShell.setVisible(this.m_menuBar.getShowShell());
    }

    public void cbShowInfoPanel() {
        if (GuiUtils.isNormalSizeMode(this)) {
            if (this.m_showInfoPanel) {
                this.m_comment.setPreferredSize(this.m_comment.getSize());
            }
            this.m_guiBoard.setPreferredFieldSize(this.m_guiBoard.getFieldSize());
        }
        this.showInfoPanel();
    }

    public void cbShowToolbar() {
        if (GuiUtils.isNormalSizeMode(this)) {
            if (this.m_showInfoPanel) {
                this.m_comment.setPreferredSize(this.m_comment.getSize());
            }
            this.m_guiBoard.setPreferredFieldSize(this.m_guiBoard.getFieldSize());
        }
        this.showToolbar();
    }

    public void cbShowTree() {
        if (this.m_menuBar.getShowTree()) {
            if (this.m_gameTreeViewer == null) {
                this.m_gameTreeViewer = new GameTreeViewer((Frame)this, this, this.m_fastPaint);
                this.m_gameTreeViewer.setLabelMode(this.m_menuBar.getGameTreeLabels());
                this.m_gameTreeViewer.setSizeMode(this.m_menuBar.getGameTreeSize());
                boolean bl = this.m_menuBar.getShowSubtreeSizes();
                this.m_gameTreeViewer.setShowSubtreeSizes(bl);
                this.restoreSize(this.m_gameTreeViewer, "window-gametree");
            }
            this.updateGameTree(true);
            if (this.m_gameTreeViewer != null) {
                this.m_gameTreeViewer.setVisible(true);
            }
            return;
        }
        this.disposeGameTree();
    }

    public void clearAnalyzeCommand() {
        this.clearAnalyzeCommand(true);
    }

    public void clearAnalyzeCommand(boolean bl) {
        if (this.m_analyzeCommand != null) {
            if (this.isCommandInProgress()) {
                this.showError("Cannot clear analyze command\nwhile command in progress");
                return;
            }
            if (this.m_setupMode) {
                this.showError("Cannot clear analyze command\nin setup mode");
                return;
            }
            this.m_analyzeCommand = null;
            this.setBoardCursorDefault();
        }
        if (bl) {
            this.resetBoard();
            this.clearStatus();
        }
    }

    public void contextMenu(GoPoint goPoint, Component component, int n, int n2) {
        if (this.isCommandInProgress()) {
            return;
        }
        if (this.m_setupMode || this.m_analyzeCommand != null && this.m_analyzeCommand.needsPointListArg()) {
            this.fieldClicked(goPoint, true);
            return;
        }
        ContextMenu contextMenu = this.createContextMenu(goPoint);
        contextMenu.show(component, n, n2);
    }

    public void disposeGameTree() {
        if (this.m_gameTreeViewer == null) {
            return;
        }
        this.m_gameTreeViewer.dispose();
        this.m_gameTreeViewer = null;
        this.m_menuBar.setShowTree(false);
    }

    public void fieldClicked(GoPoint goPoint, boolean bl) {
        if (this.isCommandInProgress()) {
            return;
        }
        if (this.m_setupMode) {
            GoColor goColor = this.m_board.getToMove();
            GoColor goColor2 = bl ? goColor.otherColor() : (this.m_board.getColor(goPoint) == goColor ? GoColor.EMPTY : goColor);
            this.m_board.play(goPoint, goColor2);
            this.m_board.setToMove(goColor);
            this.updateGameInfo(true);
            this.updateFromGoBoard();
            this.setNeedsSave(true);
        } else {
            if (this.m_analyzeCommand != null && this.m_analyzeCommand.needsPointArg() && !bl) {
                this.m_analyzeCommand.setPointArg(goPoint);
                this.m_guiBoard.clearAllSelect();
                this.m_guiBoard.setSelect(goPoint, true);
                this.analyzeBegin(false, false);
                return;
            }
            if (this.m_analyzeCommand != null && this.m_analyzeCommand.needsPointListArg()) {
                ArrayList arrayList = this.m_analyzeCommand.getPointListArg();
                if (arrayList.contains(goPoint)) {
                    arrayList.remove(goPoint);
                    if (bl) {
                        arrayList.add(goPoint);
                    }
                } else {
                    arrayList.add(goPoint);
                }
                this.m_guiBoard.clearAllSelect();
                GuiBoardUtils.setSelect(this.m_guiBoard, arrayList, true);
                if (bl && arrayList.size() > 0) {
                    this.analyzeBegin(false, false);
                }
                return;
            }
            if (this.m_scoreMode && !bl) {
                GuiBoardUtils.scoreSetDead(this.m_guiBoard, this.m_board, goPoint);
                double d = this.m_gameTree.getGameInformation().m_komi;
                this.m_scoreDialog.showScore(this.m_board.scoreGet(d, this.getRules()));
                return;
            }
            if (bl) {
                this.m_guiBoard.contextMenu(goPoint);
            } else {
                if (this.m_board.isSuicide(goPoint, this.m_board.getToMove()) && !this.showQuestion("Play suicide?")) {
                    return;
                }
                if (this.m_board.isKo(goPoint) && !this.showQuestion("Play illegal Ko move?")) {
                    return;
                }
                Move move = Move.get(goPoint, this.m_board.getToMove());
                this.humanMoved(move);
            }
        }
    }

    public boolean sendGtpCommand(String string, boolean bl) throws GtpError {
        if (this.isCommandInProgress() || this.m_commandThread == null) {
            return false;
        }
        if (this.m_setupMode) {
            this.showError("Cannot send command in setup mode");
            return false;
        }
        if (bl) {
            this.m_commandThread.send(string);
            return true;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                GoGui.this.sendGtpCommandContinue();
            }
        };
        this.beginLengthyCommand();
        this.m_commandThread.send(string, runnable);
        return true;
    }

    public void sendGtpCommandContinue() {
        this.endLengthyCommand();
    }

    public void initAnalyzeCommand(AnalyzeCommand analyzeCommand, boolean bl) {
        if (this.m_commandThread == null) {
            return;
        }
        this.m_analyzeCommand = analyzeCommand;
        this.m_analyzeAutoRun = bl;
        if (analyzeCommand.needsPointArg()) {
            this.setBoardCursor(12);
            this.showStatusSelectTarget();
        } else if (analyzeCommand.needsPointListArg()) {
            this.setBoardCursor(12);
            this.showStatusSelectPointList();
        }
    }

    public void setAnalyzeCommand(AnalyzeCommand analyzeCommand, boolean bl, boolean bl2, boolean bl3) {
        if (this.isCommandInProgress()) {
            this.showError("Cannot run analyze command\nwhile command in progress");
            return;
        }
        if (this.m_setupMode) {
            this.showError("Cannot run analyze command\nin setup mode");
            return;
        }
        this.initAnalyzeCommand(analyzeCommand, bl);
        this.m_analyzeOneRunOnly = bl3;
        boolean bl4 = this.m_analyzeCommand.needsPointArg();
        if (bl4 && !this.m_analyzeCommand.isPointArgMissing()) {
            this.m_guiBoard.clearAllSelect();
            this.m_guiBoard.setSelect(this.m_analyzeCommand.getPointArg(), true);
        } else if (bl4 || this.m_analyzeCommand.needsPointListArg()) {
            this.m_guiBoard.clearAllSelect();
            if (this.m_analyzeCommand.getType() == 3) {
                GuiBoardUtils.setSelect(this.m_guiBoard, this.m_analyzeCommand.getPointListArg(), true);
            }
            this.toFront();
            return;
        }
        this.analyzeBegin(false, bl2);
    }

    private void analyzeBegin(boolean bl, boolean bl2) {
        if (this.m_commandThread == null || this.m_analyzeCommand == null || this.m_analyzeCommand.isPointArgMissing()) {
            return;
        }
        this.showStatus("Running " + this.m_analyzeCommand.getResultTitle() + "...");
        GoColor goColor = this.m_board.getToMove();
        this.m_lastAnalyzeCommand = this.m_analyzeCommand.replaceWildCards(goColor);
        this.runLengthyCommand(this.m_lastAnalyzeCommand, new AnalyzeContinue(bl, bl2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeContinue(boolean bl, boolean bl2) {
        if (bl2) {
            this.resetBoard();
        }
        if (!this.endLengthyCommand()) {
            return;
        }
        String string = this.m_analyzeCommand.getResultTitle();
        try {
            ArrayList arrayList;
            boolean bl3 = false;
            String string2 = this.m_commandThread.getResponse();
            String string3 = AnalyzeShow.show(this.m_analyzeCommand, this.m_guiBoard, this.m_board, string2);
            if (string3 != null) {
                this.m_statusBar.setText(string3);
                bl3 = true;
            }
            int n = this.m_analyzeCommand.getType();
            GoPoint goPoint = null;
            if (this.m_analyzeCommand.needsPointArg()) {
                goPoint = this.m_analyzeCommand.getPointArg();
            } else if (this.m_analyzeCommand.needsPointListArg() && (arrayList = this.m_analyzeCommand.getPointListArg()).size() > 0) {
                goPoint = (GoPoint)arrayList.get(arrayList.size() - 1);
            }
            if (n == 8) {
                ParameterDialog.editParameters(this.m_lastAnalyzeCommand, this, string, string2, this.m_commandThread);
            }
            if (AnalyzeCommand.isTextType(n)) {
                if (string2.indexOf("\n") < 0) {
                    this.showStatus(string + ": " + string2);
                    bl3 = true;
                } else {
                    this.showAnalyzeTextOutput(n, goPoint, string, string2);
                }
            }
            if (!bl3 && n != 8) {
                this.showStatus(string);
            }
            if (bl) {
                this.checkComputerMove();
            }
        }
        catch (GtpError gtpError) {
            this.showStatus(string);
            this.showError(gtpError);
        }
        finally {
            if (this.m_analyzeOneRunOnly) {
                this.clearAnalyzeCommand(false);
            }
        }
    }

    private boolean attachProgram(String string) {
        if ((string = string.trim()).equals("")) {
            return false;
        }
        this.m_program = string;
        if (this.m_gtpShell != null) {
            this.m_gtpShell.dispose();
            this.m_gtpShell = null;
        }
        this.m_gtpShell = new GtpShell((Frame)this, this, this.m_prefs, this.m_fastPaint);
        this.m_gtpShell.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GoGui.this.m_menuBar.setShowShell(false);
            }
        });
        this.m_gtpShell.setProgramCommand(string);
        this.m_gtpShell.setTimeStamp(this.m_menuBar.getTimeStamp());
        this.m_gtpShell.setCommandCompletion(this.m_menuBar.getCommandCompletion());
        this.m_ignoreInvalidResponses = false;
        GtpClient.InvalidResponseCallback invalidResponseCallback = new GtpClient.InvalidResponseCallback(){

            public void show(String string) {
                if (GoGui.this.m_ignoreInvalidResponses) {
                    return;
                }
                GoGui.this.m_ignoreInvalidResponses = true;
                ShowInvalidResponse showInvalidResponse = new ShowInvalidResponse(string);
                if (SwingUtilities.isEventDispatchThread()) {
                    showInvalidResponse.run();
                } else {
                    GoGui.this.invokeAndWait(showInvalidResponse);
                }
            }
        };
        GtpClient.IOCallback iOCallback = new GtpClient.IOCallback(){
            private LiveGfx m_liveGfx;
            {
                this.m_liveGfx = new LiveGfx(GoGui.this.m_guiBoard, GoGui.this.m_statusBar);
            }

            public void receivedInvalidResponse(String string) {
                GoGui.this.m_gtpShell.receivedInvalidResponse(string);
            }

            public void receivedResponse(boolean bl, String string) {
                GoGui.this.m_gtpShell.receivedResponse(bl, string);
            }

            public void receivedStdErr(String string) {
                GoGui.this.m_gtpShell.receivedStdErr(string);
                this.m_liveGfx.receivedStdErr(string);
            }

            public void sentCommand(String string) {
                GoGui.this.m_gtpShell.sentCommand(string);
            }
        };
        try {
            GtpClient gtpClient = new GtpClient(this.m_program, this.m_verbose, iOCallback);
            gtpClient.setInvalidResponseCallback(invalidResponseCallback);
            gtpClient.setAutoNumber(this.m_menuBar.getAutoNumber());
            this.m_commandThread = new CommandThread(gtpClient, this);
            this.m_commandThread.start();
        }
        catch (GtpError gtpError) {
            this.showError(gtpError);
            this.m_toolBar.setComputerEnabled(false);
            this.m_menuBar.setComputerEnabled(false);
            return false;
        }
        this.m_menuBar.setComputerEnabled(true);
        this.m_toolBar.setComputerEnabled(true);
        this.m_name = null;
        this.m_titleFromProgram = null;
        try {
            this.m_name = this.m_commandThread.send("name").trim();
        }
        catch (GtpError gtpError) {
            // empty catch block
        }
        if (this.m_name == null) {
            this.m_name = "Unknown Program";
        }
        try {
            this.m_commandThread.queryProtocolVersion();
        }
        catch (GtpError gtpError) {
            // empty catch block
        }
        try {
            this.m_version = this.m_commandThread.queryVersion();
            this.m_gtpShell.setProgramVersion(this.m_version);
            this.m_commandThread.querySupportedCommands();
            this.m_commandThread.queryInterruptSupport();
        }
        catch (GtpError gtpError) {
            // empty catch block
        }
        boolean bl = this.m_commandThread.isCommandSupported("kgs-genmove_cleanup") || this.m_commandThread.isCommandSupported("genmove_cleanup");
        this.m_menuBar.enableCleanup(bl);
        this.initProgramAnalyzeCommands();
        this.restoreSize(this.m_gtpShell, "window-gtpshell");
        this.m_gtpShell.setProgramName(this.m_name);
        ArrayList arrayList = this.m_commandThread.getSupportedCommands();
        this.m_gtpShell.setInitialCompletions(arrayList);
        if (!this.m_gtpFile.equals("")) {
            this.sendGtpFile(new File(this.m_gtpFile));
        }
        if (!this.m_gtpCommand.equals("")) {
            this.sendGtpString(this.m_gtpCommand);
        }
        Node node = this.m_currentNode;
        this.m_board.initSize(this.m_boardSize);
        if (this.executeRoot()) {
            this.gotoNode(node);
        }
        this.setTitle();
        return true;
    }

    private boolean backward(int n) {
        int n2;
        if (n == 0) {
            return true;
        }
        int n3 = 0;
        Node node = this.m_currentNode;
        for (n2 = 0; n2 < n && node != this.m_gameTree.getRoot(); node = node.getFather(), ++n2) {
            n3 += NodeUtils.getAllAsMoves(node).size();
        }
        try {
            if (this.m_commandThread != null && n3 > 1 && this.m_commandThread.isCommandSupported("gg-undo")) {
                this.m_commandThread.send("gg-undo " + n3);
                this.m_board.undo(n3);
                this.m_currentNode = node;
                this.m_currentNodeExecuted = NodeUtils.getAllAsMoves(this.m_currentNode).size();
            } else {
                for (n2 = 0; n2 < n; ++n2) {
                    if (this.m_currentNode.getFather() == null) {
                        return false;
                    }
                    this.undoCurrentNode();
                    this.m_currentNode = this.m_currentNode.getFather();
                    this.m_currentNodeExecuted = NodeUtils.getAllAsMoves(this.m_currentNode).size();
                    this.m_gameInfo.fastUpdateMoveNumber(this.m_currentNode);
                }
            }
        }
        catch (GtpError gtpError) {
            this.showError(gtpError);
            return false;
        }
        return true;
    }

    private void beginLengthyCommand() {
        this.setBoardCursor(3);
        this.m_menuBar.setCommandInProgress();
        this.m_toolBar.setCommandInProgress();
        this.m_gtpShell.setCommandInProgess(true);
    }

    private void boardChangedBegin(boolean bl, boolean bl2) {
        this.updateFromGoBoard();
        this.updateGameInfo(bl2);
        this.m_toolBar.update(this.m_currentNode);
        this.updateMenuBar();
        this.m_menuBar.selectBoardSizeItem(this.m_board.getSize());
        if (this.m_commandThread != null && this.isCurrentNodeExecuted() && this.m_analyzeCommand != null && this.m_analyzeAutoRun && !this.m_analyzeCommand.isPointArgMissing()) {
            this.analyzeBegin(bl, true);
        } else {
            this.resetBoard();
            this.showToMove();
            if (bl) {
                this.checkComputerMove();
            }
        }
    }

    private void cbAbout() {
        String string = null;
        String string2 = null;
        if (this.m_commandThread != null) {
            string = Integer.toString(this.m_commandThread.getProtocolVersion());
            string2 = this.m_commandThread.getProgramCommand();
        }
        AboutDialog.show(this, this.m_name, this.m_version, string, string2);
    }

    private void cbAddBookmark() {
        if (this.m_loadedFile == null) {
            this.showError("Cannot set bookmark if no file loaded");
            return;
        }
        if (this.m_needsSave) {
            this.showError("Cannot set bookmark if file modified");
            return;
        }
        if (this.m_currentNode.getFather() != null && this.m_currentNode.getMove() == null) {
            this.showError("Cannot set bookmark at non-root node without move");
            return;
        }
        String string = NodeUtils.getVariationString(this.m_currentNode);
        int n = NodeUtils.getMoveNumber(this.m_currentNode);
        Bookmark bookmark = new Bookmark(this.m_loadedFile, n, string);
        if (!BookmarkDialog.show(this, "Add Bookmark", bookmark, true)) {
            return;
        }
        this.m_bookmarks.add(bookmark);
        this.m_menuBar.setBookmarks(this.m_bookmarks);
    }

    private void cbAutoNumber() {
        if (this.m_commandThread == null) {
            return;
        }
        boolean bl = this.m_menuBar.getAutoNumber();
        this.m_commandThread.setAutoNumber(bl);
        this.m_prefs.setBool("gtpshell-autonumber", bl);
    }

    private void cbBeepAfterMove() {
        this.m_beepAfterMove = this.m_menuBar.getBeepAfterMove();
        this.m_prefs.setBool("beep-after-move", this.m_beepAfterMove);
    }

    private void cbBackToMainVar() {
        Node node = NodeUtils.getBackToMainVariation(this.m_currentNode);
        this.cbGotoNode(node);
    }

    private void cbBoardSize(String string) {
        block2: {
            try {
                this.saveSession();
                this.cbNewGame(Integer.parseInt(string));
                this.m_clock.reset();
                this.m_clock.halt();
                this.m_gameInfo.updateTime();
                this.updateMenuBar();
            }
            catch (NumberFormatException numberFormatException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private void cbBoardSizeOther() {
        int n = BoardSizeDialog.show(this, this.m_boardSize);
        if (n < 1 || n > 25) {
            return;
        }
        this.saveSession();
        this.cbNewGame(n);
        this.m_clock.reset();
        this.m_clock.halt();
        this.updateMenuBar();
        this.m_gameInfo.updateTime();
    }

    private void cbBookmark(String string) {
        block8: {
            if (!this.checkSaveGame()) {
                return;
            }
            try {
                int n = Integer.parseInt(string);
                if (n < 0 || n >= this.m_bookmarks.size()) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return;
                }
                Bookmark bookmark = (Bookmark)this.m_bookmarks.get(n);
                File file = bookmark.m_file;
                if (!(this.m_loadedFile != null && file.equals(this.m_loadedFile) || this.loadFile(file, 0))) {
                    return;
                }
                String string2 = bookmark.m_variation;
                Node node = this.m_gameTree.getRoot();
                if (!string2.equals("") && (node = NodeUtils.findByVariation(node, string2)) == null) {
                    this.showError("Bookmark has invalid variation");
                    return;
                }
                if ((node = NodeUtils.findByMoveNumber(node, bookmark.m_move)) == null) {
                    this.showError("Bookmark has invalid move number");
                    return;
                }
                this.gotoNode(node);
                this.boardChangedBegin(false, true);
            }
            catch (NumberFormatException numberFormatException) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
    }

    private void cbClockHalt() {
        if (!this.m_clock.isRunning()) {
            return;
        }
        this.m_clock.halt();
        this.updateMenuBar();
    }

    private void cbClockResume() {
        if (this.m_clock.isRunning()) {
            return;
        }
        this.m_clock.startMove(this.m_board.getToMove());
        this.updateMenuBar();
    }

    private void cbClockRestore() {
        GoColor goColor = this.m_board.getToMove();
        this.clockRestore(this.m_currentNode, goColor.otherColor());
        Node node = this.m_currentNode.getFather();
        if (node != null) {
            this.clockRestore(node, goColor);
        }
        this.m_gameInfo.updateTime();
        this.updateMenuBar();
    }

    private void cbCommentChanged() {
        this.setNeedsSave(true);
        if (this.m_gameTreeViewer != null) {
            this.m_gameTreeViewer.redrawCurrentNode();
        }
    }

    private void cbCommentFontFixed() {
        boolean bl = this.m_menuBar.getCommentFontFixed();
        this.m_comment.setFontFixed(bl);
        this.m_prefs.setBool("comment-font-fixed", bl);
    }

    private void cbComputerBoth() {
        this.computerBoth();
        if (!this.isCommandInProgress()) {
            this.checkComputerMove();
        }
    }

    private void cbEditBookmarks() {
        if (!EditBookmarksDialog.show(this, this.m_bookmarks)) {
            return;
        }
        this.m_menuBar.setBookmarks(this.m_bookmarks);
    }

    private void cbExportAscii() {
        File file = SimpleDialogs.showSave(this, "Export Text Diagram");
        if (file == null) {
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BoardUtils.print(this.m_board, new PrintStream(fileOutputStream), false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.showError("Export failed", fileNotFoundException);
        }
    }

    private void cbExportSgfPosition() {
        File file = SimpleDialogs.showSaveSgf(this);
        if (file == null) {
            return;
        }
        try {
            this.savePosition(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.showError("Could not save position", fileNotFoundException);
        }
    }

    private void cbExportLatex() {
        File file = SimpleDialogs.showSave(this, "Export LaTeX");
        if (file == null) {
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            String string = FileUtils.removeExtension(new File(file.getName()), "tex");
            new TexWriter(string, fileOutputStream, this.m_gameTree, false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.showError("Export failed", fileNotFoundException);
        }
    }

    private void cbExportLatexPosition() {
        File file = SimpleDialogs.showSave(this, "Export LaTeX Position");
        if (file == null) {
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            String string = FileUtils.removeExtension(new File(file.getName()), "tex");
            new TexWriter(string, fileOutputStream, this.m_board, false, GuiBoardUtils.getLabels(this.m_guiBoard), GuiBoardUtils.getMarkSquare(this.m_guiBoard), GuiBoardUtils.getSelects(this.m_guiBoard));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.showError("Export failed", fileNotFoundException);
        }
    }

    private void cbFindInComments() {
        Pattern pattern = FindDialog.run(this, this.m_comment.getSelectedText());
        if (pattern == null) {
            return;
        }
        this.m_pattern = pattern;
        this.m_menuBar.enableFindNext(true);
        if (NodeUtils.commentContains(this.m_currentNode, this.m_pattern)) {
            this.m_comment.markAll(this.m_pattern);
        } else {
            this.cbFindNext();
        }
    }

    private void cbFindNext() {
        if (this.m_pattern == null) {
            return;
        }
        Node node = this.m_gameTree.getRoot();
        Node node2 = NodeUtils.findInComments(this.m_currentNode, this.m_pattern);
        if (node2 == null && this.m_currentNode != node && this.showQuestion("End of tree reached. Continue from start?") && !NodeUtils.commentContains(node2 = node, this.m_pattern)) {
            node2 = NodeUtils.findInComments(node2, this.m_pattern);
        }
        if (node2 == null) {
            this.showInfo("Not found");
            this.m_menuBar.enableFindNext(false);
        } else {
            this.cbGotoNode(node2);
            this.m_comment.markAll(this.m_pattern);
        }
    }

    private void cbGameInfo() {
        TimeSettings timeSettings;
        GameInformation gameInformation = this.m_gameTree.getGameInformation();
        if (!GameInfoDialog.show(this, gameInformation)) {
            return;
        }
        if (gameInformation.m_komi != this.m_prefs.getDouble("komi")) {
            this.m_prefs.setDouble("komi", gameInformation.m_komi);
            this.setKomi(gameInformation.m_komi);
        }
        if (gameInformation.m_rules != null && !gameInformation.m_rules.equals(this.m_prefs.getString("rules"))) {
            this.m_prefs.setString("rules", gameInformation.m_rules);
            this.setRules();
        }
        if ((timeSettings = gameInformation.m_timeSettings) == null) {
            this.m_timeSettings = null;
        } else {
            this.m_timeSettings = new TimeSettings(timeSettings);
            this.setTimeSettings();
        }
        this.setTitle();
    }

    private void cbGameTreeLabels(int n) {
        this.m_prefs.setInt("gametree-labels", n);
        if (this.m_gameTreeViewer != null) {
            this.m_gameTreeViewer.setLabelMode(n);
            this.updateGameTree(true);
        }
    }

    private void cbGameTreeSize(int n) {
        this.m_prefs.setInt("gametree-size", n);
        if (this.m_gameTreeViewer != null) {
            this.m_gameTreeViewer.setSizeMode(n);
            this.updateGameTree(true);
        }
    }

    private void cbGameTreeShowSubtreeSizes() {
        boolean bl = this.m_menuBar.getShowSubtreeSizes();
        this.m_prefs.setBool("gametree-show-subtree-sizes", bl);
        if (this.m_gameTreeViewer != null) {
            this.m_gameTreeViewer.setShowSubtreeSizes(bl);
            this.updateGameTree(true);
        }
    }

    private void cbGoto() {
        Node node = MoveNumberDialog.show(this, this.m_currentNode);
        if (node == null) {
            return;
        }
        this.cbGotoNode(node);
    }

    private void cbGotoVariation() {
        Node node = GotoVariationDialog.show(this, this.m_gameTree, this.m_currentNode);
        if (node == null) {
            return;
        }
        this.cbGotoNode(node);
    }

    private void cbHandicap(String string) {
        block4: {
            try {
                this.m_handicap = Integer.parseInt(string);
                if (this.m_board.isModified()) {
                    this.showInfo("Handicap will take effect on next game.");
                } else {
                    this.computerBlack();
                    this.newGame(this.m_boardSize);
                }
            }
            catch (NumberFormatException numberFormatException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cbHelp() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource("net/sf/gogui/doc/index.html");
        if (uRL == null) {
            this.showError("Help not found");
            return;
        }
        if (Platform.isGnuClasspath()) {
            File file = null;
            String string = uRL.toString();
            int n = string.indexOf("lib/gogui.jar!/");
            if (n >= 0 && string.startsWith("jar:file:")) {
                String string2 = string.substring(9, n);
                File file2 = new File(string2, "doc/manual/html/index.html");
                File file3 = new File(string2, "../doc/gogui/index.html");
                if (file2.exists()) {
                    file = file2;
                } else {
                    if (!file3.exists()) {
                        this.showError("Documentation not found in:\n" + file2.toString() + "\n" + file3.toString());
                        return;
                    }
                    file = file3;
                }
            } else {
                this.showError("Cannot show documentation  (must run from gogui.jar)");
                return;
            }
            try {
                if (Platform.openInExternalBrowser(file.toURI().toURL())) return;
                this.showError("Could not open browser");
                return;
            }
            catch (MalformedURLException malformedURLException) {
                if ($assertionsDisabled) return;
                throw new AssertionError();
            }
        }
        if (this.m_help == null) {
            this.m_help = new Help((Frame)this, uRL);
            this.restoreSize(this.m_help, "window-help");
        }
        this.m_help.setVisible(true);
        this.m_help.toFront();
    }

    private void cbInterrupt() {
        if (!this.isCommandInProgress() || this.m_commandThread == null || this.m_commandThread.isProgramDead()) {
            return;
        }
        if (Interrupt.run(this, this.m_commandThread)) {
            this.showStatus("Interrupting...");
        }
    }

    private void cbKeepOnlyMainVariation() {
        if (!NodeUtils.isInMainVariation(this.m_currentNode)) {
            return;
        }
        if (!this.showQuestion("Delete all variations but main?")) {
            return;
        }
        this.m_gameTree.keepOnlyMainVariation();
        this.setNeedsSave(true);
        this.boardChangedBegin(false, true);
    }

    private void cbKeepOnlyPosition() {
        if (!this.showQuestion("Delete all moves?")) {
            return;
        }
        GameInformation gameInformation = this.m_gameTree.getGameInformation();
        this.m_gameTree = NodeUtils.makeTreeFromPosition(gameInformation, this.m_board);
        this.m_board.initSize(this.m_boardSize);
        this.executeRoot();
        this.setNeedsSave(true);
        this.boardChangedBegin(false, true);
    }

    private void cbMakeMainVariation() {
        if (!this.showQuestion("Make current to main variation?")) {
            return;
        }
        NodeUtils.makeMainVariation(this.m_currentNode);
        this.setNeedsSave(true);
        this.boardChangedBegin(false, true);
    }

    private void cbNewGame(int n) {
        if (!this.checkSaveGame()) {
            return;
        }
        this.m_prefs.setInt("boardsize", n);
        this.fileInvalid();
        this.newGame(n);
        this.computerWhite();
        this.m_clock.startMove(GoColor.BLACK);
        this.updateMenuBar();
        this.boardChangedBegin(true, true);
    }

    private void cbOpen() {
        if (!this.checkSaveGame()) {
            return;
        }
        File file = SimpleDialogs.showOpenSgf(this);
        if (file == null) {
            return;
        }
        this.m_menuBar.addRecent(file);
        this.loadFile(file, -1);
        this.boardChangedBegin(false, true);
    }

    private void cbPass() {
        if (this.isCommandInProgress()) {
            return;
        }
        if (this.m_passWarning == null) {
            this.m_passWarning = new OptionalMessage(this);
        }
        if (!this.m_passWarning.showQuestion("Really pass?")) {
            return;
        }
        this.humanMoved(Move.getPass(this.m_board.getToMove()));
    }

    private void cbPlay(boolean bl) {
        if (this.m_commandThread == null || this.isCommandInProgress()) {
            return;
        }
        if (!this.checkCurrentNodeExecuted()) {
            return;
        }
        if (!bl && !this.isComputerBoth()) {
            if (this.m_board.getToMove() == GoColor.BLACK) {
                this.computerBlack();
            } else {
                this.computerWhite();
            }
        }
        this.m_interruptComputerBoth = false;
        this.generateMove(bl);
        if (this.m_currentNode == this.m_gameTree.getRoot() && this.m_currentNode.getNumberChildren() == 0) {
            this.m_clock.reset();
        }
        this.m_clock.startMove(this.m_board.getToMove());
    }

    private void cbPrint() {
        Print.run(this, this.m_guiBoard);
    }

    private void cbSave() {
        if (this.m_loadedFile != null) {
            if (this.m_loadedFile.exists()) {
                String string;
                if (this.m_overwriteWarning == null) {
                    this.m_overwriteWarning = new OptionalMessage(this);
                }
                if (!this.m_overwriteWarning.showWarning(string = "Overwrite " + this.m_loadedFile + "?")) {
                    return;
                }
            }
            this.save(this.m_loadedFile);
        } else {
            this.saveDialog();
        }
    }

    private void cbSaveAs() {
        this.saveDialog();
    }

    private void cbScore() {
        if (this.m_commandThread == null) {
            this.showInfo("No program is attached.\nPlease mark dead groups manually.");
            this.initScore(null);
            return;
        }
        if (this.m_commandThread.isCommandSupported("final_status_list")) {
            Runnable runnable = new Runnable(){

                public void run() {
                    GoGui.this.cbScoreContinue();
                }
            };
            this.showStatus("Scoring...");
            this.runLengthyCommand("final_status_list dead", runnable);
        } else {
            this.showInfo(this.m_name + " does not support scoring.\n" + "Please mark dead groups manually.");
            this.initScore(null);
        }
    }

    private void cbScoreContinue() {
        boolean bl = this.endLengthyCommand();
        this.clearStatus();
        GoPoint[] goPointArray = null;
        if (bl) {
            String string = this.m_commandThread.getResponse();
            try {
                goPointArray = GtpUtils.parsePointList(string, this.m_boardSize);
            }
            catch (GtpError gtpError) {
                this.showError(gtpError);
            }
        }
        this.initScore(goPointArray);
    }

    private void cbScoreDone(boolean bl) {
        this.m_scoreDialog.setVisible(false);
        if (bl) {
            double d = this.m_gameTree.getGameInformation().m_komi;
            this.setResult(this.m_board.scoreGet(d, this.getRules()).formatResult());
        }
        this.clearStatus();
        this.m_guiBoard.clearAll();
        this.m_scoreMode = false;
        this.m_toolBar.enableAll(true, this.m_currentNode);
        this.m_menuBar.setNormalMode();
    }

    private void cbSetup() {
        if (this.m_setupMode) {
            this.setupDone();
            return;
        }
        if (!this.checkSaveGame()) {
            return;
        }
        this.m_menuBar.setSetupMode();
        this.m_showLastMove = false;
        if (this.m_gameTreeViewer != null) {
            this.m_gameTree = new GameTree(this.m_boardSize, 0.0, null, null, null);
            this.m_currentNode = this.m_gameTree.getRoot();
            this.m_currentNode.addBlack(GoPoint.get(0, 0));
            this.m_clock.reset();
            this.updateGameInfo(true);
        }
        this.resetBoard();
        this.m_setupMode = true;
        this.m_toolBar.enableAll(false, null);
        this.showStatus("Setup Black");
        this.m_board.setToMove(GoColor.BLACK);
    }

    private void cbSetupBlack() {
        this.showStatus("Setup Black");
        this.m_board.setToMove(GoColor.BLACK);
        this.updateGameInfo(false);
    }

    private void cbSetupWhite() {
        this.showStatus("Setup White");
        this.m_board.setToMove(GoColor.WHITE);
        this.updateGameInfo(false);
    }

    private void cbShowCursor() {
        boolean bl = this.m_menuBar.getShowCursor();
        this.m_guiBoard.setShowCursor(bl);
        this.m_prefs.setBool("show-cursor", bl);
    }

    private void cbShowGrid() {
        boolean bl = this.m_menuBar.getShowGrid();
        this.m_guiBoard.setShowGrid(bl);
        this.m_prefs.setBool("show-grid", bl);
    }

    private void cbShowLastMove() {
        this.m_showLastMove = this.m_menuBar.getShowLastMove();
        this.m_prefs.setBool("show-last-move", this.m_showLastMove);
        this.updateFromGoBoard();
        this.updateGameInfo(false);
    }

    private void cbShowVariations() {
        this.m_showVariations = this.m_menuBar.getShowVariations();
        this.m_prefs.setBool("show-variations", this.m_showVariations);
        this.resetBoard();
        this.updateGameInfo(false);
    }

    private void cbTimeStamp() {
        if (this.m_gtpShell == null) {
            return;
        }
        boolean bl = this.m_menuBar.getTimeStamp();
        this.m_gtpShell.setTimeStamp(bl);
        this.m_prefs.setBool("gtpshell-timestamp", bl);
    }

    private void cbTruncate() {
        if (this.m_currentNode.getFather() == null) {
            return;
        }
        if (!this.showQuestion("Truncate current?")) {
            return;
        }
        Node node = this.m_currentNode;
        this.backward(1);
        this.m_currentNode.removeChild(node);
        this.setNeedsSave(true);
        this.boardChangedBegin(false, true);
    }

    private void cbTruncateChildren() {
        int n = this.m_currentNode.getNumberChildren();
        if (n == 0) {
            return;
        }
        if (!this.showQuestion("Truncate children?")) {
            return;
        }
        NodeUtils.truncateChildren(this.m_currentNode);
        this.setNeedsSave(true);
        this.boardChangedBegin(false, true);
    }

    private void checkComputerMove() {
        boolean bl;
        boolean bl2;
        if (this.m_commandThread == null || !this.isCurrentNodeExecuted()) {
            return;
        }
        int n = NodeUtils.getMoveNumber(this.m_currentNode);
        boolean bl3 = bl2 = n >= 2 && this.m_board.bothPassed();
        if (bl2) {
            this.m_menuBar.setCleanup(true);
        }
        boolean bl4 = bl = bl2 || this.m_resigned;
        if (this.isComputerBoth()) {
            if (bl) {
                if (this.m_auto) {
                    this.newGame(this.m_boardSize);
                    this.checkComputerMove();
                    return;
                }
                this.m_clock.halt();
                this.showGameFinished();
                return;
            }
            this.generateMove(false);
        } else {
            if (bl) {
                this.m_clock.halt();
                this.showGameFinished();
                return;
            }
            if (this.computerToMove()) {
                this.generateMove(false);
            }
        }
    }

    private void checkLostOnTime(GoColor goColor) {
        if (this.m_clock.lostOnTime(goColor) && !this.m_clock.lostOnTime(goColor.otherColor()) && !this.m_lostOnTimeShown) {
            if (goColor == GoColor.BLACK) {
                this.showInfo("Black lost on time.");
                this.setResult("W+Time");
            } else {
                if (!$assertionsDisabled && goColor != GoColor.WHITE) {
                    throw new AssertionError();
                }
                this.showInfo("White lost on time.");
                this.setResult("B+Time");
            }
            this.m_lostOnTimeShown = true;
        }
    }

    private boolean checkCurrentNodeExecuted() {
        if (this.m_commandThread == null) {
            return true;
        }
        if (!this.isCurrentNodeExecuted()) {
            String string = "Could not synchronize current\nposition with Go program";
            Object[] objectArray = new Object[]{"Detach Program", "Cancel"};
            int n = JOptionPane.showOptionDialog(this, string, "Error", 0, 0, null, objectArray, objectArray[1]);
            if (n == 0) {
                this.cbDetachProgram();
            }
            return false;
        }
        return true;
    }

    private boolean checkSaveGame() {
        if (!this.m_needsSave) {
            return true;
        }
        if (this.m_saveQuestion == null) {
            this.m_saveQuestion = new OptionalMessage(this);
        }
        int n = this.m_saveQuestion.showYesNoCancelQuestion("Save current game?");
        switch (n) {
            case 0: {
                if (this.m_loadedFile != null) {
                    return this.save(this.m_loadedFile);
                }
                return this.saveDialog();
            }
            case 1: {
                this.setNeedsSave(false);
                return true;
            }
            case 2: {
                return false;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return true;
    }

    private void clearStatus() {
        this.m_statusBar.clear();
    }

    private void clockRestore(Node node, GoColor goColor) {
        Move move = node.getMove();
        if (move == null) {
            if (node == this.m_gameTree.getRoot()) {
                this.m_clock.reset();
            }
            return;
        }
        if (move.getColor() != goColor) {
            return;
        }
        double d = node.getTimeLeft(goColor);
        int n = node.getMovesLeft(goColor);
        if (!Double.isNaN(d)) {
            this.m_clock.setTimeLeft(goColor, (long)(d * 1000.0), n);
        }
    }

    private void close() {
        if (this.isCommandInProgress() && !this.showQuestion("Kill program?")) {
            return;
        }
        if (this.m_setupMode) {
            this.setupDone();
        }
        if (!this.checkSaveGame()) {
            return;
        }
        this.saveSession();
        if (this.m_commandThread != null) {
            this.m_analyzeCommand = null;
            this.detachProgram();
        }
        this.dispose();
        this.m_prefs.save();
        System.exit(0);
    }

    private void computerBlack() {
        this.m_computerBlack = true;
        this.m_computerWhite = false;
        this.m_menuBar.setComputerBlack();
    }

    private void computerBoth() {
        this.m_computerBlack = true;
        this.m_computerWhite = true;
        this.m_menuBar.setComputerBoth();
    }

    private void computerMoved() {
        if (!this.endLengthyCommand()) {
            return;
        }
        if (this.m_beepAfterMove) {
            Toolkit.getDefaultToolkit().beep();
        }
        try {
            this.m_clock.stopMove();
            String string = this.m_commandThread.getResponse();
            GoColor goColor = this.m_board.getToMove();
            this.checkLostOnTime(goColor);
            boolean bl = false;
            if (string.equalsIgnoreCase("resign")) {
                if (!this.isComputerBoth()) {
                    this.showInfo(this.m_name + " resigns");
                }
                this.m_resigned = true;
                this.setResult((goColor == GoColor.BLACK ? "W" : "B") + "+Resign");
            } else {
                Node node;
                GoPoint goPoint = GtpUtils.parsePoint(string, this.m_boardSize);
                if (goPoint != null && this.m_board.getColor(goPoint) != GoColor.EMPTY) {
                    this.showWarning("Program played move on non-empty point");
                }
                Move move = Move.get(goPoint, goColor);
                this.setNeedsSave(true);
                this.m_board.play(move);
                this.m_currentNode = node = this.createNode(move);
                this.m_currentNodeExecuted = 1;
                if (goPoint == null && !this.isComputerBoth()) {
                    this.showInfo(this.m_name + " passes");
                }
                this.m_resigned = false;
                bl = true;
                if (this.m_currentNode.getFather().getNumberChildren() == 1) {
                    if (this.m_gameTreeViewer != null) {
                        this.m_gameTreeViewer.addNewSingleChild(this.m_currentNode);
                    }
                    bl = false;
                }
            }
            this.m_clock.startMove(this.m_board.getToMove());
            this.updateMenuBar();
            boolean bl2 = !this.m_isSingleMove && (!this.isComputerBoth() || !this.m_interruptComputerBoth);
            this.boardChangedBegin(bl2, bl);
        }
        catch (GtpError gtpError) {
            this.showError(gtpError);
            this.clearStatus();
        }
    }

    private void computerNone() {
        this.m_computerBlack = false;
        this.m_computerWhite = false;
        this.m_menuBar.setComputerNone();
    }

    private boolean computerToMove() {
        if (this.m_board.getToMove() == GoColor.BLACK) {
            return this.m_computerBlack;
        }
        return this.m_computerWhite;
    }

    private void computerWhite() {
        this.m_computerBlack = false;
        this.m_computerWhite = true;
        this.m_menuBar.setComputerWhite();
    }

    private Node createNode(Move move) {
        return Utils.createNode(this.m_currentNode, move, this.m_clock);
    }

    private ContextMenu createContextMenu(GoPoint goPoint) {
        boolean bl;
        ContextMenu.Listener listener = new ContextMenu.Listener(){

            public void clearAnalyze() {
                GoGui.this.clearAnalyzeCommand();
            }

            public void editLabel(GoPoint goPoint) {
                GoGui.this.editLabel(goPoint);
            }

            public void mark(GoPoint goPoint, MarkType markType, boolean bl) {
                GoGui.this.mark(goPoint, markType, bl);
            }

            public void setAnalyzeCommand(AnalyzeCommand analyzeCommand) {
                GoGui.this.setAnalyzeCommand(analyzeCommand, false, true, true);
            }
        };
        ArrayList arrayList = null;
        boolean bl2 = bl = this.m_commandThread == null;
        if (!bl) {
            arrayList = this.m_commandThread.getSupportedCommands();
        }
        return new ContextMenu(goPoint, bl, arrayList, this.m_programAnalyzeCommands, this.m_guiBoard.getMark(goPoint), this.m_guiBoard.getMarkCircle(goPoint), this.m_guiBoard.getMarkSquare(goPoint), this.m_guiBoard.getMarkTriangle(goPoint), listener);
    }

    private void createThumbnail(File file) {
        if (!Thumbnail.checkThumbnailSupport()) {
            return;
        }
        if (Platform.isGnuClasspath()) {
            return;
        }
        String string = file.getAbsolutePath();
        if (!string.startsWith("/tmp") && !string.startsWith("/var/tmp")) {
            this.m_thumbnail.create(file);
        }
    }

    private void detachProgram() {
        block11: {
            if (this.isCommandInProgress()) {
                this.m_commandThread.destroyGtp();
                this.m_commandThread.close();
            } else if (this.m_commandThread != null && !this.m_commandThread.isProgramDead()) {
                try {
                    if (this.m_commandThread.isCommandSupported("quit")) {
                        this.m_commandThread.send("quit");
                    }
                }
                catch (GtpError gtpError) {
                    // empty catch block
                }
                this.m_commandThread.close();
            }
            this.saveSession();
            if (this.m_analyzeCommand != null) {
                this.clearAnalyzeCommand();
            }
            this.m_commandThread = null;
            this.m_name = null;
            this.m_version = null;
            this.m_toolBar.setComputerEnabled(false);
            this.m_menuBar.setComputerEnabled(false);
            this.m_gtpShell.dispose();
            this.m_gtpShell = null;
            if (this.m_analyzeDialog != null) {
                this.m_analyzeDialog.saveRecent();
                this.m_analyzeDialog.dispose();
                this.m_analyzeDialog = null;
            }
            this.resetBoard();
            this.clearStatus();
            this.setTitle();
            if (!this.isCurrentNodeExecuted()) {
                try {
                    this.undoCurrentNode();
                    this.executeCurrentNode();
                    this.updateFromGoBoard();
                }
                catch (GtpError gtpError) {
                    if ($assertionsDisabled) break block11;
                    throw new AssertionError();
                }
            }
        }
    }

    private void editLabel(GoPoint goPoint) {
        String string = this.m_currentNode.getLabel(goPoint);
        string = JOptionPane.showInputDialog(this, "Label " + goPoint, string);
        if (string == null) {
            return;
        }
        this.m_currentNode.setLabel(goPoint, string);
        this.m_guiBoard.setLabel(goPoint, string);
        this.setNeedsSave(true);
        this.updateBoard();
    }

    private boolean endLengthyCommand() {
        this.clearStatus();
        this.m_menuBar.setNormalMode();
        this.m_toolBar.enableAll(true, this.m_currentNode);
        if (this.m_gtpShell != null) {
            this.m_gtpShell.setCommandInProgess(false);
        }
        if (this.m_analyzeCommand != null && (this.m_analyzeCommand.needsPointArg() || this.m_analyzeCommand.needsPointListArg())) {
            this.setBoardCursor(12);
        } else {
            this.setBoardCursorDefault();
        }
        if (this.m_commandThread == null) {
            return false;
        }
        GtpError gtpError = this.m_commandThread.getException();
        if (gtpError != null) {
            this.showError(gtpError);
            return false;
        }
        return true;
    }

    private void executeCurrentNode() throws GtpError {
        Object object;
        this.m_currentNodeExecuted = 0;
        ArrayList arrayList = NodeUtils.getAllAsMoves(this.m_currentNode);
        if (arrayList.size() > 1 && this.m_commandThread != null && this.m_commandThread.isCommandSupported("play_sequence")) {
            object = GtpUtils.getPlaySequenceCommand(arrayList);
            this.m_commandThread.send((String)object);
            for (int i = 0; i < arrayList.size(); ++i) {
                this.m_board.play((Move)arrayList.get(i));
            }
            this.m_currentNodeExecuted = arrayList.size();
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                Move move = (Move)arrayList.get(i);
                if (this.m_commandThread != null) {
                    this.m_commandThread.sendPlay(move);
                }
                this.m_board.play(move);
                ++this.m_currentNodeExecuted;
            }
        }
        object = this.m_currentNode.getToMove();
        if (object != GoColor.EMPTY) {
            this.m_board.setToMove((GoColor)object);
        }
    }

    private boolean executeRoot() {
        this.m_currentNode = this.m_gameTree.getRoot();
        this.m_currentNodeExecuted = 0;
        this.m_isRootExecuted = true;
        if (this.m_commandThread != null) {
            try {
                this.m_commandThread.sendBoardsize(this.m_boardSize);
                this.m_commandThread.sendClearBoard(this.m_boardSize);
            }
            catch (GtpError gtpError) {
                this.showError(gtpError);
                this.m_isRootExecuted = false;
                return false;
            }
        }
        GameInformation gameInformation = this.m_gameTree.getGameInformation();
        this.setKomi(gameInformation.m_komi);
        this.setRules();
        this.setTimeSettings();
        try {
            this.executeCurrentNode();
        }
        catch (GtpError gtpError) {
            this.showError(gtpError);
            return false;
        }
        return true;
    }

    private void fileInvalid() {
        if (this.m_loadedFile == null) {
            return;
        }
        this.m_loadedFile = null;
        this.setTitle();
    }

    private void forward(int n) {
        Node node;
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!this.checkCurrentNodeExecuted()) {
            return;
        }
        Node node2 = this.m_currentNode;
        for (int i = 0; i < n && (node = node2.getChild()) != null; ++i) {
            node2 = node;
        }
        this.gotoNode(node2);
    }

    private void generateMove(boolean bl) {
        String string;
        this.showStatus(this.m_name + " is thinking...");
        GoColor goColor = this.m_board.getToMove();
        if (this.m_menuBar.getCleanup() && (this.m_commandThread.isCommandSupported("kgs-genmove_cleanup") || this.m_commandThread.isCommandSupported("genmove_cleanup"))) {
            string = this.m_commandThread.isCommandSupported("genmove_cleanup") ? "genmove_cleanup" : "kgs-genmove_cleanup";
            if (goColor == GoColor.BLACK) {
                string = string + " b";
            } else if (goColor == GoColor.WHITE) {
                string = string + " w";
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        } else {
            string = this.m_commandThread.getCommandGenmove(goColor);
            this.m_clock.startMove(goColor);
        }
        this.m_isSingleMove = bl;
        Runnable runnable = new Runnable(){

            public void run() {
                GoGui.this.computerMoved();
            }
        };
        this.runLengthyCommand(string, runnable);
    }

    private File getGoGuiFile(String string) {
        String string2 = System.getProperty("user.home", "");
        File file = new File(string2, ".gogui");
        if (!file.exists()) {
            file.mkdir();
        }
        return new File(file, string);
    }

    private int getRules() {
        int n = 0;
        String string = this.m_gameTree.getGameInformation().m_rules;
        if (string != null) {
            if ((string = string.trim().toLowerCase()).equals("japanese")) {
                n = 2;
            } else if (string.equals("chinese")) {
                n = 1;
            }
        }
        return n;
    }

    private void gotoNode(Node node) {
        if (this.m_scoreMode) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        int n = NodeUtils.getShortestPath(this.m_currentNode, node, arrayList);
        if (this.backward(n)) {
            ArrayList arrayList2 = NodeUtils.getAllAsMoves(arrayList);
            if (this.checkCurrentNodeExecuted() && arrayList2.size() > 1 && this.m_commandThread != null && this.m_commandThread.isCommandSupported("play_sequence")) {
                try {
                    String string = GtpUtils.getPlaySequenceCommand(arrayList2);
                    this.m_commandThread.send(string);
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        this.m_board.play((Move)arrayList2.get(i));
                    }
                    this.m_currentNode = (Node)arrayList.get(arrayList.size() - 1);
                    this.m_currentNodeExecuted = NodeUtils.getAllAsMoves(this.m_currentNode).size();
                }
                catch (GtpError gtpError) {
                    this.showError(gtpError);
                }
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Node node2 = (Node)arrayList.get(i);
                    if (!this.checkCurrentNodeExecuted()) break;
                    if (!$assertionsDisabled && !node2.isChildOf(this.m_currentNode)) {
                        throw new AssertionError();
                    }
                    this.m_currentNode = node2;
                    try {
                        this.executeCurrentNode();
                    }
                    catch (GtpError gtpError) {
                        this.showError(gtpError);
                        break;
                    }
                    this.m_gameInfo.fastUpdateMoveNumber(this.m_currentNode);
                }
            }
        }
    }

    private void humanMoved(Move move) {
        try {
            boolean bl;
            GoPoint goPoint = move.getPoint();
            if (goPoint != null && this.m_board.getColor(goPoint) != GoColor.EMPTY) {
                return;
            }
            this.m_clock.stopMove();
            if (goPoint != null) {
                this.m_guiBoard.setColor(goPoint, move.getColor());
                if (this.m_showLastMove) {
                    this.m_guiBoard.markLastMove(goPoint);
                }
                this.m_guiBoard.paintImmediately(goPoint);
            }
            if (bl = this.play(move)) {
                this.m_clock.startMove(this.m_board.getToMove());
            }
            this.setNeedsSave(bl);
            this.checkLostOnTime(move.getColor());
            this.m_resigned = false;
            boolean bl2 = bl;
            if (bl && this.m_currentNode.getFather().getNumberChildren() == 1) {
                if (this.m_gameTreeViewer != null) {
                    this.m_gameTreeViewer.addNewSingleChild(this.m_currentNode);
                }
                bl2 = false;
            }
            this.boardChangedBegin(true, bl2);
        }
        catch (GtpError gtpError) {
            this.updateFromGoBoard();
            this.showError(gtpError);
        }
    }

    private void initGame(int n) {
        ArrayList arrayList;
        if (n != this.m_boardSize) {
            this.m_boardSize = n;
            this.m_board.initSize(n);
            this.m_guiBoard.initSize(n);
            this.m_guiBoard.setShowGrid(this.m_menuBar.getShowGrid());
            this.restoreMainWindow();
            if (this.m_gtpShell != null) {
                this.restoreSize(this.m_gtpShell, "window-gtpshell");
            }
            if (this.m_analyzeDialog != null) {
                this.restoreSize(this.m_analyzeDialog, "window-analyze");
                this.m_analyzeDialog.setBoardSize(n);
            }
            if (this.m_gameTreeViewer != null) {
                this.restoreSize(this.m_gameTreeViewer, "window-gametree");
            }
        }
        if ((arrayList = this.m_board.getHandicapStones(this.m_handicap)) == null) {
            this.showWarning("Handicap stone locations not\ndefined for this board size");
        }
        this.m_gameTree = new GameTree(n, this.m_prefs.getDouble("komi"), arrayList, this.m_prefs.getString("rules"), this.m_timeSettings);
        this.m_board.newGame();
        this.m_currentNode = this.m_gameTree.getRoot();
        this.m_currentNodeExecuted = 0;
        this.updateFromGoBoard();
        this.resetBoard();
        this.m_clock.reset();
        this.m_lostOnTimeShown = false;
        this.setNeedsSave(false);
        this.m_resigned = false;
        this.m_menuBar.enableFindNext(false);
    }

    private void initialize() {
        if (this.m_file == null) {
            this.newGame(this.m_boardSize);
        } else {
            this.newGameFile(this.m_boardSize, this.m_move);
        }
        if (!this.m_prefs.getBool("show-info-panel")) {
            this.m_menuBar.setShowInfoPanel(false);
            this.showInfoPanel();
        }
        if (this.m_prefs.getBool("show-toolbar")) {
            this.m_menuBar.setShowToolbar(true);
            this.showToolbar();
        }
        this.restoreMainWindow();
        this.getLayeredPane().setVisible(false);
        this.setVisible(true);
        this.m_bookmarks = Bookmark.load(this.getGoGuiFile("bookmarks"));
        this.m_menuBar.setBookmarks(this.m_bookmarks);
        this.m_toolBar.enableAll(true, this.m_currentNode);
        if (this.m_program != null) {
            this.attachProgram(this.m_program);
        }
        this.setTitle();
        if (this.m_commandThread == null || !this.m_computerBlack && !this.m_computerWhite) {
            this.computerNone();
        } else if (this.isComputerBoth()) {
            this.computerBoth();
        } else if (this.m_computerBlack) {
            this.computerBlack();
        } else {
            this.computerWhite();
        }
        this.updateGameInfo(true);
        this.registerSpecialMacHandler();
        if (this.m_gtpShell != null && this.m_prefs.getBool("show-gtpshell")) {
            this.m_menuBar.setShowShell(true);
            this.cbShowShell();
        }
        if (this.m_prefs.getBool("show-gametree")) {
            this.m_menuBar.setShowTree(true);
            this.cbShowTree();
        }
        if (this.m_prefs.getBool("show-analyze")) {
            this.m_menuBar.setShowAnalyze(true);
            this.cbAnalyze();
        }
        if (!this.m_initAnalyze.equals("")) {
            AnalyzeCommand analyzeCommand = AnalyzeCommand.get(this, this.m_initAnalyze);
            if (analyzeCommand == null) {
                this.showError("Unknown analyze command \"" + this.m_initAnalyze + "\"");
            } else {
                this.initAnalyzeCommand(analyzeCommand, true);
            }
        }
        this.setTitleFromProgram();
        this.getLayeredPane().setVisible(true);
        this.toFrontLater();
        this.checkComputerMove();
    }

    private void initProgramAnalyzeCommands() {
        this.m_programAnalyzeCommands = null;
        if (this.m_commandThread.isCommandSupported("gogui_analyze_commands")) {
            try {
                this.m_programAnalyzeCommands = this.m_commandThread.send("gogui_analyze_commands");
            }
            catch (GtpError gtpError) {
                // empty catch block
            }
        }
    }

    private void initScore(GoPoint[] goPointArray) {
        this.resetBoard();
        GuiBoardUtils.scoreBegin(this.m_guiBoard, this.m_board, goPointArray);
        this.m_scoreMode = true;
        if (this.m_scoreDialog == null) {
            this.m_scoreDialog = new ScoreDialog((Frame)this, this);
        }
        double d = this.m_gameTree.getGameInformation().m_komi;
        this.m_scoreDialog.showScore(this.m_board.scoreGet(d, this.getRules()));
        this.m_scoreDialog.setVisible(true);
        this.m_menuBar.setScoreMode();
        this.showStatus("Please mark dead groups");
    }

    private void invokeAndWait(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Thread interrupted");
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("InvocationTargetException");
        }
    }

    private boolean isComputerBoth() {
        return this.m_computerBlack && this.m_computerWhite;
    }

    private boolean isCommandInProgress() {
        if (this.m_commandThread == null) {
            return false;
        }
        return this.m_commandThread.isCommandInProgress();
    }

    private boolean isCurrentNodeExecuted() {
        int n = NodeUtils.getAllAsMoves(this.m_currentNode).size();
        return this.m_isRootExecuted && this.m_currentNodeExecuted == n;
    }

    private boolean loadFile(File file, int n) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            LoadFileRunnable loadFileRunnable = new LoadFileRunnable(fileInputStream, file);
            if (file.length() > 500000L) {
                this.newGame(this.m_boardSize);
                GuiUtils.runProgress(this, "Loading...", loadFileRunnable);
            } else {
                loadFileRunnable.run(null);
            }
            SgfReader sgfReader = loadFileRunnable.getReader();
            GameInformation gameInformation = sgfReader.getGameTree().getGameInformation();
            this.initGame(gameInformation.m_boardSize);
            this.m_menuBar.addRecent(file);
            this.m_gameTree = sgfReader.getGameTree();
            if (this.executeRoot() && n > 0) {
                this.forward(n);
            }
            this.m_loadedFile = file;
            this.setTitle();
            String string = sgfReader.getWarnings();
            if (string != null) {
                this.showWarning("File " + file.getName() + ":\n" + string);
            }
            SimpleDialogs.setLastFile(file);
            this.computerNone();
            this.createThumbnail(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.showError("File not found:\n" + file);
            return false;
        }
        catch (SgfReader.SgfError sgfError) {
            this.showError("Could not read file:", sgfError);
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return false;
        }
        return true;
    }

    public void mark(GoPoint goPoint, MarkType markType, boolean bl) {
        if (bl) {
            this.m_currentNode.addMarked(goPoint, markType);
        } else {
            this.m_currentNode.removeMarked(goPoint, markType);
        }
        if (markType == MarkType.MARK) {
            this.m_guiBoard.setMark(goPoint, bl);
        } else if (markType == MarkType.CIRCLE) {
            this.m_guiBoard.setMarkCircle(goPoint, bl);
        } else if (markType == MarkType.SQUARE) {
            this.m_guiBoard.setMarkSquare(goPoint, bl);
        } else if (markType == MarkType.TRIANGLE) {
            this.m_guiBoard.setMarkTriangle(goPoint, bl);
        }
        this.setNeedsSave(true);
        this.updateBoard();
    }

    private void newGame(int n) {
        this.initGame(n);
        this.executeRoot();
        this.updateGameInfo(true);
        this.updateFromGoBoard();
        this.m_toolBar.update(this.m_currentNode);
        this.updateMenuBar();
        this.m_menuBar.selectBoardSizeItem(this.m_board.getSize());
        this.setTitle();
        this.setTitleFromProgram();
        this.showToMove();
    }

    private void newGameFile(int n, int n2) {
        this.initGame(n);
        this.loadFile(this.m_file, n2);
        this.m_clock.reset();
        this.updateGameInfo(true);
        this.updateFromGoBoard();
        this.m_toolBar.update(this.m_currentNode);
        this.updateMenuBar();
        this.m_menuBar.selectBoardSizeItem(this.m_board.getSize());
    }

    private boolean play(Move move) throws GtpError {
        if (!this.checkCurrentNodeExecuted()) {
            return false;
        }
        boolean bl = false;
        Node node = NodeUtils.getChildWithMove(this.m_currentNode, move);
        if (node == null) {
            bl = true;
            node = this.createNode(move);
        }
        this.m_currentNode = node;
        try {
            this.executeCurrentNode();
        }
        catch (GtpError gtpError) {
            this.m_currentNode = node.getFather();
            this.m_currentNode.removeChild(node);
            this.m_currentNodeExecuted = NodeUtils.getAllAsMoves(this.m_currentNode).size();
            throw gtpError;
        }
        return bl;
    }

    private void registerSpecialMacHandler() {
        if (!Platform.isMac()) {
            return;
        }
        Platform.SpecialMacHandler specialMacHandler = new Platform.SpecialMacHandler(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public boolean handleAbout() {
                if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                    throw new AssertionError();
                }
                GoGui.this.cbAbout();
                return true;
            }

            public boolean handleOpenFile(String string) {
                if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                    throw new AssertionError();
                }
                if (!GoGui.this.checkSaveGame()) {
                    return true;
                }
                GoGui.this.loadFile(new File(string), -1);
                GoGui.this.boardChangedBegin(false, true);
                return true;
            }

            public boolean handleQuit() {
                if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                    throw new AssertionError();
                }
                GoGui.this.close();
                return false;
            }

            static {
                $assertionsDisabled = !(class$net$sf$gogui$gogui$GoGui == null ? (class$net$sf$gogui$gogui$GoGui = GoGui.class$("net.sf.gogui.gogui.GoGui")) : class$net$sf$gogui$gogui$GoGui).desiredAssertionStatus();
            }
        };
        Platform.registerSpecialMacHandler(specialMacHandler);
    }

    private void resetBoard() {
        this.clearStatus();
        this.m_guiBoard.clearAll();
        this.updateFromGoBoard();
        this.updateBoard();
    }

    private void restoreMainWindow() {
        this.setState(0);
        Session.restoreLocation(this, this.m_prefs, "window-gogui", this.m_boardSize);
        Dimension dimension = null;
        int n = -1;
        try {
            String[] stringArray;
            String string = "fieldsize-" + this.m_boardSize;
            if (this.m_prefs.contains(string)) {
                stringArray = this.m_prefs.getString(string);
                n = Integer.parseInt((String)stringArray);
                this.m_guiBoard.setPreferredFieldSize(new Dimension(n, n));
            }
            if (this.m_prefs.contains(string = "commentsize-" + this.m_boardSize)) {
                stringArray = StringUtils.splitArguments(this.m_prefs.getString(string));
                int n2 = Integer.parseInt(stringArray[0]);
                int n3 = Integer.parseInt(stringArray[1]);
                dimension = new Dimension(n2, n3);
                this.m_comment.setPreferredSize(dimension);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.m_splitPane.resetToPreferredSizes();
        this.pack();
        if (this.m_infoPanel.getHeight() - this.m_guiBoard.getHeight() < 2 * n && dimension != null && n > 0) {
            dimension.height -= 2 * n;
            this.m_comment.setPreferredSize(dimension);
            this.m_splitPane.resetToPreferredSizes();
            this.pack();
        }
    }

    private void restoreSize(Window window, String string) {
        Session.restoreSize(window, this.m_prefs, string, this.m_boardSize);
    }

    private void runLengthyCommand(String string, Runnable runnable) {
        if (!$assertionsDisabled && this.m_commandThread == null) {
            throw new AssertionError();
        }
        this.beginLengthyCommand();
        this.m_commandThread.send(string, runnable);
    }

    private boolean save(File file) {
        FileOutputStream fileOutputStream;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.showError("Saving file failed", fileNotFoundException);
            return false;
        }
        new SgfWriter((OutputStream)fileOutputStream, this.m_gameTree, "GoGui", Version.get());
        this.m_menuBar.addRecent(file);
        this.createThumbnail(file);
        this.m_loadedFile = file;
        this.setTitle();
        this.setNeedsSave(false);
        return true;
    }

    private boolean saveDialog() {
        File file = SimpleDialogs.showSaveSgf(this);
        if (file == null) {
            return false;
        }
        return this.save(file);
    }

    private void savePosition(File file) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        new SgfWriter((OutputStream)fileOutputStream, this.m_board, "GoGui", Version.get());
        this.m_menuBar.addRecent(file);
    }

    private void saveSession() {
        Bookmark.save(this.m_bookmarks, this.getGoGuiFile("bookmarks"));
        if (this.m_gtpShell != null) {
            this.m_gtpShell.saveHistory();
        }
        if (this.m_analyzeDialog != null) {
            this.m_analyzeDialog.saveRecent();
        }
        Session.saveLocation(this, this.m_prefs, "window-gogui", this.m_boardSize);
        if (this.m_help != null) {
            this.saveSize(this.m_help, "window-help");
        }
        this.saveSizeAndVisible(this.m_gameTreeViewer, "gametree");
        if (this.m_commandThread != null) {
            this.saveSizeAndVisible(this.m_gtpShell, "gtpshell");
            this.saveSizeAndVisible(this.m_analyzeDialog, "analyze");
        }
        if (GuiUtils.isNormalSizeMode(this)) {
            String string = "fieldsize-" + this.m_boardSize;
            this.m_prefs.setInt(string, this.m_guiBoard.getFieldSize().width);
            string = "commentsize-" + this.m_boardSize;
            String string2 = Integer.toString(this.m_comment.getWidth()) + " " + Integer.toString(this.m_comment.getHeight());
            this.m_prefs.setString(string, string2);
        }
    }

    private void saveSize(JDialog jDialog, String string) {
        Session.saveSize(jDialog, this.m_prefs, string, this.m_boardSize);
    }

    private void saveSizeAndVisible(JDialog jDialog, String string) {
        Session.saveSizeAndVisible(jDialog, this.m_prefs, string, this.m_boardSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendGtp(Reader reader) {
        if (this.m_commandThread == null) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            try {
                String string;
                do {
                    if ((string = bufferedReader.readLine()) != null) continue;
                    break;
                } while (this.m_gtpShell.send(string, this, true));
            }
            catch (IOException iOException) {
                this.showError("Error reading file");
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void sendGtpFile(File file) {
        try {
            this.sendGtp(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.showError("File not found: " + fileNotFoundException.getMessage());
        }
    }

    private void sendGtpString(String string) {
        string = string.replaceAll("\\\\n", "\n");
        this.sendGtp(new StringReader(string));
    }

    private void setBoardCursor(int n) {
        this.setCursor(this.m_guiBoard, n);
        this.setCursor(this.m_infoPanel, n);
    }

    private void setBoardCursorDefault() {
        this.setCursorDefault(this.m_guiBoard);
        this.setCursorDefault(this.m_infoPanel);
    }

    private void setCursor(Component component, int n) {
        Cursor cursor = Cursor.getPredefinedCursor(n);
        component.setCursor(cursor);
    }

    private void setCursorDefault(Component component) {
        component.setCursor(Cursor.getDefaultCursor());
    }

    private void setKomi(double d) {
        Utils.sendKomi(this, d, this.m_name, this.m_commandThread);
    }

    private void setNeedsSave(boolean bl) {
        if (this.m_needsSave == bl) {
            return;
        }
        this.m_needsSave = bl;
        this.getRootPane().putClientProperty("windowModified", bl);
        this.setTitle();
    }

    private void setResult(String string) {
        String string2 = this.m_gameTree.getGameInformation().m_result;
        if (!(string2 == null || string2.equals("") || string2.equals(string) || this.showQuestion("Overwrite old result " + string2 + "\n" + "with " + string + "?"))) {
            return;
        }
        this.m_gameTree.getGameInformation().m_result = string;
    }

    private void setRules() {
        Utils.sendRules(this.getRules(), this.m_commandThread);
    }

    private void setTimeSettings() {
        if (this.m_commandThread == null) {
            return;
        }
        TimeSettings timeSettings = this.m_gameTree.getGameInformation().m_timeSettings;
        if (timeSettings == null) {
            return;
        }
        if (!this.m_commandThread.isCommandSupported("time_settings")) {
            return;
        }
        this.m_clock.setTimeSettings(timeSettings);
        String string = GtpUtils.getTimeSettingsCommand(timeSettings);
        try {
            this.m_commandThread.send(string);
        }
        catch (GtpError gtpError) {
            this.showError(gtpError);
        }
    }

    private void setTitle() {
        String string;
        if (this.m_titleFromProgram != null) {
            this.setTitle(this.m_titleFromProgram);
            return;
        }
        String string2 = "GoGui";
        if (this.m_commandThread != null) {
            string2 = this.m_name;
        }
        String string3 = null;
        if (this.m_loadedFile != null) {
            string3 = this.m_loadedFile.getName();
            if (this.m_needsSave) {
                string3 = string3 + " [modified]";
            }
        }
        if ((string = this.m_gameTree.getGameInformation().suggestGameName()) != null) {
            if (string3 != null) {
                string = string3 + "  " + string;
            }
        } else if (string3 != null) {
            string = string3;
        }
        if (string == null) {
            this.setTitle(string2);
        } else {
            this.setTitle(string + " - " + string2);
        }
    }

    private void setTitleFromProgram() {
        this.m_titleFromProgram = null;
        if (this.m_commandThread == null) {
            return;
        }
        if (this.m_commandThread.isCommandSupported("gogui_title")) {
            try {
                this.m_titleFromProgram = this.m_commandThread.send("gogui_title");
                this.setTitle(this.m_titleFromProgram);
            }
            catch (GtpError gtpError) {
                // empty catch block
            }
        }
    }

    private void setupDone() {
        this.m_setupMode = false;
        this.m_showLastMove = this.m_menuBar.getShowLastMove();
        this.m_menuBar.setNormalMode();
        this.m_toolBar.enableAll(true, this.m_currentNode);
        int n = this.m_board.getSize();
        GoColor[][] goColorArray = new GoColor[n][n];
        for (int i = 0; i < this.m_board.getNumberPoints(); ++i) {
            GoPoint goPoint = this.m_board.getPoint(i);
            goColorArray[goPoint.getX()][goPoint.getY()] = this.m_board.getColor(goPoint);
        }
        GoColor goColor = this.m_board.getToMove();
        this.m_boardSize = n;
        this.m_board.newGame();
        this.m_gameTree = new GameTree(n, this.m_prefs.getDouble("komi"), null, this.m_prefs.getString("rules"), null);
        this.m_currentNode = this.m_gameTree.getRoot();
        for (int i = 0; i < this.m_board.getNumberPoints(); ++i) {
            int n2;
            GoPoint goPoint = this.m_board.getPoint(i);
            int n3 = goPoint.getX();
            GoColor goColor2 = goColorArray[n3][n2 = goPoint.getY()];
            if (goColor2 == GoColor.BLACK) {
                this.m_currentNode.addBlack(goPoint);
                continue;
            }
            if (goColor2 != GoColor.WHITE) continue;
            this.m_currentNode.addWhite(goPoint);
        }
        this.m_currentNode.setPlayer(goColor);
        this.executeRoot();
        this.fileInvalid();
        this.updateGameInfo(true);
        this.boardChangedBegin(false, false);
    }

    private void showAnalyzeTextOutput(int n, GoPoint goPoint, String string, String string2) {
        boolean bl = n == 5 || n == 6;
        TextViewer.Listener listener = null;
        if (n == 10 || n == 6) {
            listener = new TextViewer.Listener(){

                public void textSelected(String string) {
                    GoPoint[] goPointArray = GtpUtils.parsePointString(string, GoGui.this.m_boardSize);
                    GuiBoardUtils.showPointList(GoGui.this.m_guiBoard, goPointArray);
                }
            };
        }
        TextViewer textViewer = new TextViewer(this, string, string2, bl, listener, this.m_fastPaint);
        if (goPoint != null) {
            Point point = this.m_guiBoard.getLocationOnScreen(goPoint);
            textViewer.setLocation(point);
        } else {
            textViewer.setLocationRelativeTo(this);
        }
        textViewer.setVisible(true);
    }

    private void showError(String string, Exception exception) {
        SimpleDialogs.showError(this, string, exception);
    }

    private void showError(GtpError gtpError) {
        Utils.showError(this, this.m_name, gtpError);
    }

    private void showError(String string) {
        SimpleDialogs.showError(this, string);
    }

    private void showGameFinished() {
        if (this.m_gameFinishedMessage == null) {
            this.m_gameFinishedMessage = new OptionalMessage(this);
        }
        this.m_gameFinishedMessage.showMessage("Game finished");
    }

    private void showInfo(String string) {
        SimpleDialogs.showInfo(this, string);
    }

    private void showInfoPanel() {
        boolean bl = this.m_menuBar.getShowInfoPanel();
        if (bl == this.m_showInfoPanel) {
            return;
        }
        this.m_prefs.setBool("show-info-panel", bl);
        this.m_showInfoPanel = bl;
        if (bl) {
            this.m_innerPanel.remove(this.m_guiBoard);
            this.m_splitPane.add(this.m_guiBoard);
            this.m_innerPanel.add(this.m_splitPane);
        } else {
            this.m_splitPane.remove(this.m_guiBoard);
            this.m_innerPanel.remove(this.m_splitPane);
            this.m_innerPanel.add(this.m_guiBoard);
        }
        this.m_splitPane.resetToPreferredSizes();
        this.pack();
    }

    private boolean showQuestion(String string) {
        return SimpleDialogs.showQuestion(this, string);
    }

    private void showStatus(String string) {
        this.m_statusBar.setText(string);
    }

    private void showStatusSelectPointList() {
        this.showStatus("Select points for " + this.m_analyzeCommand.getLabel() + " (last point with right button or modifier key down)");
    }

    private void showStatusSelectTarget() {
        this.showStatus("Select a target for " + this.m_analyzeCommand.getResultTitle());
    }

    private void showToolbar() {
        boolean bl = this.m_menuBar.getShowToolbar();
        if (bl == this.m_showToolbar) {
            return;
        }
        this.m_prefs.setBool("show-toolbar", bl);
        this.m_showToolbar = bl;
        if (bl) {
            this.getContentPane().add((Component)this.m_toolBar, "North");
            this.m_menuBar.setHeaderStyleSingle(false);
        } else {
            this.getContentPane().remove(this.m_toolBar);
            this.m_menuBar.setHeaderStyleSingle(true);
        }
        this.m_splitPane.resetToPreferredSizes();
        this.pack();
    }

    private void showToMove() {
        if (this.m_showInfoPanel) {
            this.clearStatus();
            return;
        }
        GoColor goColor = this.m_board.getToMove();
        if (goColor == GoColor.WHITE) {
            this.showStatus("White to play");
        } else if (goColor == GoColor.BLACK) {
            this.showStatus("Black to play");
        }
    }

    private void showWarning(String string) {
        SimpleDialogs.showWarning(this, string);
    }

    private void toFrontLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GoGui.this.toFront();
            }
        });
    }

    private void undoCurrentNode() throws GtpError {
        if (this.m_commandThread != null && !this.m_commandThread.isCommandSupported("undo")) {
            throw new GtpError("Program does not support undo");
        }
        while (this.m_currentNodeExecuted > 0) {
            if (this.m_commandThread != null) {
                this.m_commandThread.send("undo");
            }
            this.m_board.undo();
            --this.m_currentNodeExecuted;
        }
        this.updateFromGoBoard();
    }

    private void updateBoard() {
        if (this.m_showVariations) {
            ArrayList arrayList = NodeUtils.getChildrenMoves(this.m_currentNode);
            GuiBoardUtils.showChildrenMoves(this.m_guiBoard, arrayList);
        }
        GuiBoardUtils.showMarkup(this.m_guiBoard, this.m_currentNode);
    }

    private void updateFromGoBoard() {
        GuiBoardUtils.updateFromGoBoard(this.m_guiBoard, this.m_board, this.m_showLastMove);
        if (this.m_currentNode.getMove() == null) {
            this.m_guiBoard.markLastMove(null);
        }
    }

    private void updateGameInfo(boolean bl) {
        this.m_gameInfo.update(this.m_currentNode, this.m_board);
        this.updateGameTree(bl);
        this.m_comment.setNode(this.m_currentNode);
        this.updateBoard();
        if (this.m_analyzeDialog != null) {
            this.m_analyzeDialog.setSelectedColor(this.m_board.getToMove());
        }
    }

    private void updateGameTree(boolean bl) {
        if (this.m_gameTreeViewer == null) {
            return;
        }
        if (!bl) {
            this.m_gameTreeViewer.update(this.m_currentNode);
            return;
        }
        this.m_gameTreeViewer.update(this.m_gameTree, this.m_currentNode);
    }

    private void updateMenuBar() {
        this.m_menuBar.update(this.m_gameTree, this.m_currentNode, this.m_clock);
    }

    static {
        $assertionsDisabled = !GoGui.class.desiredAssertionStatus();
    }

    private static class LoadFileRunnable
    implements GuiUtils.ProgressRunnable {
        private final File m_file;
        private final FileInputStream m_in;
        private SgfReader m_reader;

        LoadFileRunnable(FileInputStream fileInputStream, File file) {
            this.m_in = fileInputStream;
            this.m_file = file;
        }

        public SgfReader getReader() {
            return this.m_reader;
        }

        public void run(ProgressShow progressShow) throws Throwable {
            this.m_reader = new SgfReader(this.m_in, this.m_file.toString(), progressShow, this.m_file.length());
        }
    }

    private class ShowInvalidResponse
    implements Runnable {
        private final String m_line;

        public ShowInvalidResponse(String string) {
            this.m_line = string;
        }

        public void run() {
            if (this.m_line.trim().equals("")) {
                GoGui.this.showWarning("Invalid empty response line");
            } else {
                GoGui.this.showWarning("Invalid response:\n" + this.m_line);
            }
        }
    }

    private class AnalyzeContinue
    implements Runnable {
        private final boolean m_checkComputerMove;
        private final boolean m_resetBoard;

        public AnalyzeContinue(boolean bl, boolean bl2) {
            this.m_checkComputerMove = bl;
            this.m_resetBoard = bl2;
        }

        public void run() {
            GoGui.this.analyzeContinue(this.m_checkComputerMove, this.m_resetBoard);
        }
    }
}

