/*
 * Decompiled with CFR 0.152.
 */
package free.jin.console;

import free.jin.I18n;
import free.jin.Preferences;
import free.jin.console.Command;
import free.jin.console.ConsoleManager;
import free.jin.console.ConsoleTextField;
import free.jin.console.ConsoleTextPane;
import free.jin.console.Link;
import free.util.BrowserControl;
import free.util.PlatformUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class Console
extends JPanel
implements KeyListener,
ContainerListener {
    private final ConsoleManager consoleManager;
    protected final EventListenerList listenerList = new EventListenerList();
    private final ConsoleTextPane outputComponent;
    private final JScrollPane outputScrollPane;
    private final ConsoleTextField inputComponent;
    private final Preferences prefs;
    private Pattern[] linkREs;
    private String[] linkCommands;
    private int[] linkSubexpressionIndices;
    private static final Pattern URL_REGEX = Pattern.compile("((([Ff][Tt][Pp]|[Hh][Tt][Tt][Pp]([Ss])?)://)|([Ww][Ww][Ww]\\.))([^\\s()<>\"])*[^\\s.,()<>\"'!?]");
    private static final Pattern EMAIL_REGEX = Pattern.compile("[^\\s()<>\"']+@[^\\s()<>\"]+\\.[^\\s.,()<>\"'?]+");
    private final Hashtable attributesCache = new Hashtable();
    private final Vector tellers = new Vector();
    private int numAddToOutputCalls = 0;
    private boolean didScrollToBottom = true;
    private final ActionListener clearingActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            Console.this.clear();
        }
    };

    public Console(ConsoleManager consoleManager) {
        this.consoleManager = consoleManager;
        this.prefs = consoleManager.getPrefs();
        this.outputComponent = this.createOutputComponent();
        this.configureOutputComponent(this.outputComponent);
        this.outputScrollPane = this.createOutputScrollPane((JTextPane)((Object)this.outputComponent));
        this.inputComponent = this.createInputComponent();
        this.registerKeyboardAction(this.clearingActionListener, KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), 1);
        this.createUI();
        this.outputComponent.addKeyListener(this);
        this.inputComponent.addKeyListener(this);
        this.outputComponent.addContainerListener(this);
        this.init();
    }

    private void createUI() {
        JButton jButton = I18n.get((Class)Console.class).createButton("clearConsoleButton");
        jButton.addActionListener(this.clearingActionListener);
        jButton.setRequestFocusEnabled(false);
        this.inputComponent.setNextFocusableComponent((Component)((Object)this.inputComponent));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)((Object)this.inputComponent), "Center");
        jPanel.add((Component)jButton, "East");
        if (PlatformUtils.isMacOSX()) {
            jPanel.setBorder(BorderFactory.createEmptyBorder(1, 5, 2, 18));
        } else {
            jPanel.setBorder(BorderFactory.createEmptyBorder(1, 5, 2, 5));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.outputScrollPane, "Center");
        this.add((Component)jPanel, "South");
    }

    public Preferences getPrefs() {
        return this.prefs;
    }

    public ConsoleManager getConsoleManager() {
        return this.consoleManager;
    }

    protected ConsoleTextPane createOutputComponent() {
        return new ConsoleTextPane(this);
    }

    protected void configureOutputComponent(final ConsoleTextPane consoleTextPane) {
        DefaultCaret defaultCaret = new DefaultCaret(){
            private boolean dragging = false;

            public void focusGained(FocusEvent focusEvent) {
                super.focusGained(focusEvent);
                if (!this.dragging) {
                    Console.this.requestDefaultFocus();
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                this.setVisible(false);
            }

            protected void adjustVisibility(Rectangle rectangle) {
                if (!this.dragging) {
                    return;
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    consoleTextPane.scrollRectToVisible(rectangle);
                    if (rectangle.y + rectangle.height > consoleTextPane.getSize().height - rectangle.height / 2) {
                        BoundedRangeModel boundedRangeModel = Console.this.outputScrollPane.getVerticalScrollBar().getModel();
                        boundedRangeModel.setValue(boundedRangeModel.getMaximum());
                    }
                } else {
                    super.adjustVisibility(rectangle);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.dragging = true;
                super.mousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.dragging = false;
                super.mouseReleased(mouseEvent);
                if (Console.this.isCopyOnSelect()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Console.this.requestDefaultFocus();
                        }
                    });
                }
            }

            protected void moveCaret(MouseEvent mouseEvent) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                Position.Bias[] biasArray = new Position.Bias[1];
                int n = consoleTextPane.getUI().viewToModel((JTextComponent)((Object)consoleTextPane), point, biasArray);
                if (n >= 0) {
                    int n2 = consoleTextPane.getDocument().getEndPosition().getOffset();
                    if (n2 == n + 1 && n > 0) {
                        this.moveDot(--n);
                        if (this.dragging) {
                            BoundedRangeModel boundedRangeModel = Console.this.outputScrollPane.getVerticalScrollBar().getModel();
                            boundedRangeModel.setValue(boundedRangeModel.getMaximum());
                        }
                    } else {
                        this.moveDot(n);
                    }
                }
            }

            protected void positionCaret(MouseEvent mouseEvent) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                Position.Bias[] biasArray = new Position.Bias[1];
                int n = consoleTextPane.getUI().viewToModel((JTextComponent)((Object)consoleTextPane), point, biasArray);
                if (n >= 0) {
                    int n2 = consoleTextPane.getDocument().getEndPosition().getOffset();
                    if (n2 == n + 1 && n > 0) {
                        this.setDot(--n);
                        if (this.dragging) {
                            BoundedRangeModel boundedRangeModel = Console.this.outputScrollPane.getVerticalScrollBar().getModel();
                            boundedRangeModel.setValue(boundedRangeModel.getMaximum());
                        }
                    } else {
                        this.setDot(n);
                    }
                }
            }
        };
        defaultCaret.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (Console.this.isCopyOnSelect()) {
                    consoleTextPane.copy();
                }
            }
        });
        consoleTextPane.setCaret(defaultCaret);
    }

    protected JScrollPane createOutputScrollPane(JTextPane jTextPane) {
        OutputComponentViewport outputComponentViewport = new OutputComponentViewport();
        outputComponentViewport.setView(jTextPane);
        JScrollPane jScrollPane = new JScrollPane(22, 31);
        jScrollPane.setViewport(outputComponentViewport);
        outputComponentViewport.putClientProperty("EnableWindowBlit", Boolean.TRUE);
        return jScrollPane;
    }

    protected ConsoleTextField createInputComponent() {
        ConsoleTextField consoleTextField = new ConsoleTextField(this);
        return consoleTextField;
    }

    public boolean requestDefaultFocus() {
        this.inputComponent.requestFocus();
        return true;
    }

    private void init() {
        Color color;
        Color color2;
        Color color3;
        Color color4;
        Color color5;
        Color color6;
        this.attributesCache.clear();
        Color color7 = this.prefs.getColor("background", null);
        if (color7 != null) {
            this.outputComponent.setBackground(color7);
        }
        if ((color6 = this.prefs.getColor("output-selection", null)) != null) {
            this.outputComponent.setSelectionColor(color6);
        }
        if ((color5 = this.prefs.getColor("output-selected", null)) != null) {
            this.outputComponent.setSelectedTextColor(color5);
        }
        if ((color4 = this.prefs.getColor("input-background", null)) != null) {
            this.inputComponent.setBackground(color4);
        }
        if ((color3 = this.prefs.getColor("input-foreground", null)) != null) {
            this.inputComponent.setForeground(color3);
        }
        if ((color2 = this.prefs.getColor("input-selection", null)) != null) {
            this.inputComponent.setSelectionColor(color2);
        }
        if ((color = this.prefs.getColor("input-selected", null)) != null) {
            this.inputComponent.setSelectedTextColor(color);
        }
        int n = this.prefs.getInt("output-link.num-patterns", 0);
        this.linkREs = new Pattern[n];
        this.linkCommands = new String[n];
        this.linkSubexpressionIndices = new int[n];
        for (int i = 0; i < n; ++i) {
            try {
                Pattern pattern;
                int n2;
                String string = this.prefs.getString("output-link.pattern-" + i);
                String string2 = this.prefs.getString("output-link.command-" + i);
                this.linkSubexpressionIndices[i] = n2 = this.prefs.getInt("output-link.index-" + i);
                this.linkREs[i] = pattern = Pattern.compile(string);
                this.linkCommands[i] = string2;
                continue;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                patternSyntaxException.printStackTrace();
            }
        }
    }

    public void refreshFromProperties() {
        this.init();
        this.outputComponent.refreshFromProperties();
        this.inputComponent.refreshFromProperties();
    }

    protected boolean isCopyOnSelect() {
        return this.prefs.getBool("copyOnSelect", true);
    }

    protected final boolean prepareAdding() {
        ++this.numAddToOutputCalls;
        this.outputScrollPane.getViewport().putClientProperty("EnableWindowBlit", Boolean.FALSE);
        BoundedRangeModel boundedRangeModel = this.outputScrollPane.getVerticalScrollBar().getModel();
        return boundedRangeModel.getMaximum() <= boundedRangeModel.getValue() + boundedRangeModel.getExtent() + 5;
    }

    protected final void assureScrolling(boolean bl) {
        if (bl && this.didScrollToBottom && this.getPeer() != null) {
            this.didScrollToBottom = false;
            class BottomScroller
            implements Runnable {
                private int curNumCalls;

                BottomScroller(int n) {
                    this.curNumCalls = n;
                }

                public void run() {
                    if (Console.this.numAddToOutputCalls == this.curNumCalls) {
                        try {
                            int n = Console.this.outputComponent.getDocument().getEndPosition().getOffset();
                            Rectangle rectangle = Console.this.outputComponent.modelToView(n - 1);
                            Console.this.outputComponent.scrollRectToVisible(rectangle);
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                        Console.this.didScrollToBottom = true;
                        Console.this.outputScrollPane.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
                        Console.this.outputComponent.repaint();
                    } else {
                        this.curNumCalls = Console.this.numAddToOutputCalls;
                        SwingUtilities.invokeLater(this);
                    }
                }
            }
            SwingUtilities.invokeLater(new BottomScroller(this.numAddToOutputCalls));
        }
    }

    public void addToOutput(JComponent jComponent) {
        boolean bl = this.prepareAdding();
        boolean bl2 = this.outputComponent.isEditable();
        this.outputComponent.setEditable(true);
        this.outputComponent.setCaretPosition(this.outputComponent.getDocument().getLength());
        StyledDocument styledDocument = this.outputComponent.getStyledDocument();
        this.outputComponent.insertComponent(jComponent);
        LayoutManager layoutManager = jComponent.getParent().getLayout();
        if (layoutManager instanceof OverlayLayout) {
            ((OverlayLayout)layoutManager).invalidateLayout(jComponent.getParent());
        }
        try {
            styledDocument.insertString(styledDocument.getLength(), "\n", null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.outputComponent.setEditable(bl2);
        this.assureScrolling(bl);
    }

    public void addToOutput(String string, String string2) {
        try {
            boolean bl = this.prepareAdding();
            this.addToOutputImpl(string, string2);
            this.assureScrolling(bl);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    protected void addToOutputImpl(String string, String string2) throws BadLocationException {
        Object object;
        Object object2;
        Object object3;
        int n;
        StyledDocument styledDocument = this.outputComponent.getStyledDocument();
        int n2 = styledDocument.getLength();
        styledDocument.insertString(styledDocument.getLength(), string + "\n", this.attributesForTextType(string2));
        AttributeSet attributeSet = this.attributesForTextType("link.url");
        AttributeSet attributeSet2 = this.attributesForTextType("link.email");
        AttributeSet attributeSet3 = this.attributesForTextType("link.command");
        Matcher matcher = URL_REGEX.matcher(string);
        while (matcher.find()) {
            int n3 = matcher.start();
            n = matcher.end();
            Command command = new Command("url " + string.substring(n3, n), 3L);
            object3 = styledDocument.createPosition(n3 + n2);
            object2 = styledDocument.createPosition(n + n2);
            object = new Link((Position)object3, (Position)object2, command);
            styledDocument.setCharacterAttributes(n3 + n2, n - n3, attributeSet, false);
            this.outputComponent.addLink((Link)object);
        }
        Matcher matcher2 = EMAIL_REGEX.matcher(string);
        while (matcher2.find()) {
            n = matcher2.start();
            int n4 = matcher2.end();
            object3 = new Command("email " + string.substring(n, n4), 3L);
            object2 = styledDocument.createPosition(n + n2);
            object = styledDocument.createPosition(n4 + n2);
            Link link = new Link((Position)object2, (Position)object, (Command)object3);
            styledDocument.setCharacterAttributes(n + n2, n4 - n, attributeSet2, false);
            this.outputComponent.addLink(link);
        }
        for (n = 0; n < this.linkREs.length; ++n) {
            Pattern pattern = this.linkREs[n];
            if (pattern == null) continue;
            object3 = pattern.matcher(string);
            while (((Matcher)object3).find()) {
                int n5;
                object2 = this.linkCommands[n];
                int n6 = -1;
                while ((n6 = ((String)object2).indexOf("$", n6 + 1)) != -1) {
                    if (n6 >= ((String)object2).length() - 1 || !Character.isDigit(((String)object2).charAt(n6 + 1))) continue;
                    n5 = Character.digit(((String)object2).charAt(n6 + 1), 10);
                    object2 = ((String)object2).substring(0, n6) + ((Matcher)object3).group(n5) + ((String)object2).substring(n6 + 2);
                }
                n5 = this.linkSubexpressionIndices[n];
                int n7 = ((Matcher)object3).start(n5);
                int n8 = ((Matcher)object3).end(n5);
                styledDocument.setCharacterAttributes(n7 + n2, n8 - n7, attributeSet3, false);
                Position position = styledDocument.createPosition(n7 + n2);
                Position position2 = styledDocument.createPosition(n8 + n2);
                Link link = new Link(position, position2, new Command((String)object2, 0L));
                this.outputComponent.addLink(link);
            }
        }
    }

    public Dimension getOutputArea() {
        return this.outputScrollPane.getViewport().getSize();
    }

    protected void executeSpecialCommand(String string) {
        if ((string = string.trim()).equalsIgnoreCase("cls")) {
            this.clear();
        } else if (string.startsWith("url ")) {
            String string2 = string.substring("url ".length());
            if (string2.substring(0, Math.min(4, string2.length())).equalsIgnoreCase("www.")) {
                string2 = "http://" + string2;
            }
            if (!BrowserControl.displayURL((String)string2)) {
                BrowserControl.showDisplayBrowserFailedDialog((String)string2, (Component)this, (boolean)true);
            }
        } else if (string.startsWith("email ")) {
            String string3 = string.substring("email ".length());
            if (!BrowserControl.displayMailer((String)string3)) {
                BrowserControl.showDisplayMailerFailedDialog((String)string3, (Component)this, (boolean)true);
            }
        } else {
            String string4 = I18n.get((Class)Console.class).getFormattedString("unknownSpecialCommandMessage", new Object[]{string});
            this.addToOutput(string4, "system");
        }
    }

    public void issueCommand(Command command) {
        String string = command.getCommandString();
        if (!command.isBlanked()) {
            this.addToOutput(string, "user");
        }
        if (command.isSpecial()) {
            this.executeSpecialCommand(string);
        } else {
            this.consoleManager.sendUserCommand(string);
        }
    }

    public void clear() {
        this.outputComponent.setText("");
        this.outputComponent.removeAll();
        this.outputComponent.removeLinks();
    }

    public void tellReceived(String string) {
        this.tellers.removeElement(string);
        this.tellers.insertElementAt(string, 0);
        if (this.tellers.size() > this.getTellerRingSize()) {
            this.tellers.removeElementAt(this.tellers.size() - 1);
        }
    }

    public int getTellerRingSize() {
        return this.prefs.getInt("teller-ring-size", 5);
    }

    public String getTeller(int n) {
        if (n < 0 || n >= this.tellers.size()) {
            return null;
        }
        return (String)this.tellers.elementAt(n);
    }

    public int getTellerCount() {
        return this.tellers.size();
    }

    protected AttributeSet attributesForTextType(String string) {
        AttributeSet attributeSet = (AttributeSet)this.attributesCache.get(string);
        if (attributeSet != null) {
            return attributeSet;
        }
        String string2 = (String)this.prefs.lookup("font-family." + string, (Object)"Monospaced");
        Integer n = (Integer)this.prefs.lookup("font-size." + string, (Object)new Integer(14));
        Boolean bl = (Boolean)this.prefs.lookup("font-bold." + string, (Object)Boolean.FALSE);
        Boolean bl2 = (Boolean)this.prefs.lookup("font-italic." + string, (Object)Boolean.FALSE);
        Boolean bl3 = (Boolean)this.prefs.lookup("font-underlined." + string, (Object)Boolean.FALSE);
        Color color = (Color)this.prefs.lookup("foreground." + string, (Object)Color.white);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(StyleConstants.FontFamily, string2);
        simpleAttributeSet.addAttribute(StyleConstants.FontSize, n);
        simpleAttributeSet.addAttribute(StyleConstants.Bold, bl);
        simpleAttributeSet.addAttribute(StyleConstants.Italic, bl2);
        simpleAttributeSet.addAttribute(StyleConstants.Underline, bl3);
        simpleAttributeSet.addAttribute(StyleConstants.Foreground, color);
        this.attributesCache.put(string, simpleAttributeSet);
        return simpleAttributeSet;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = keyEvent.isControlDown();
        if (keyEvent.getSource() == this.inputComponent && keyEvent.getID() == 401) {
            JScrollBar jScrollBar = this.outputScrollPane.getVerticalScrollBar();
            Rectangle rectangle = this.outputScrollPane.getViewport().getViewRect();
            int n2 = jScrollBar.getValue();
            switch (n) {
                case 33: {
                    jScrollBar.setValue(n2 - this.outputComponent.getScrollableBlockIncrement(rectangle, 1, -1));
                    break;
                }
                case 34: {
                    jScrollBar.setValue(n2 + this.outputComponent.getScrollableBlockIncrement(rectangle, 1, 1));
                }
            }
            if (bl) {
                switch (n) {
                    case 38: {
                        jScrollBar.setValue(n2 - this.outputComponent.getScrollableUnitIncrement(rectangle, 1, -1));
                        break;
                    }
                    case 40: {
                        jScrollBar.setValue(n2 + this.outputComponent.getScrollableUnitIncrement(rectangle, 1, 1));
                        break;
                    }
                    case 36: {
                        jScrollBar.setValue(jScrollBar.getMinimum());
                        break;
                    }
                    case 35: {
                        jScrollBar.setValue(jScrollBar.getMaximum() - jScrollBar.getVisibleAmount());
                    }
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void componentAdded(ContainerEvent containerEvent) {
        Container container = containerEvent.getContainer();
        Component component = containerEvent.getChild();
        if (SwingUtilities.isDescendingFrom(container, (Component)((Object)this.outputComponent))) {
            this.registerAsListenerToHierarchy(component);
        }
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        Container container = containerEvent.getContainer();
        Component component = containerEvent.getChild();
        if (SwingUtilities.isDescendingFrom(container, (Component)((Object)this.outputComponent))) {
            this.unregisterAsListenerToHierarchy(component);
        }
    }

    private void registerAsListenerToHierarchy(Component component) {
        if (component.isFocusTraversable()) {
            component.addKeyListener(this);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            container.addContainerListener(this);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.registerAsListenerToHierarchy(container.getComponent(i));
            }
        }
    }

    private void unregisterAsListenerToHierarchy(Component component) {
        if (component.isFocusTraversable()) {
            component.removeKeyListener(this);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.unregisterAsListenerToHierarchy(container.getComponent(i));
            }
        }
    }

    protected class OutputComponentViewport
    extends JViewport {
        private boolean settingViewSize = false;

        protected OutputComponentViewport() {
        }

        public void reshape(int n, int n2, int n3, int n4) {
            Dimension dimension = this.getViewSize();
            Dimension dimension2 = this.getExtentSize();
            JTextComponent jTextComponent = (JTextComponent)this.getView();
            if (dimension.height <= dimension2.height || dimension2.height < 0 || this.settingViewSize || n3 == this.getWidth() && n4 == this.getHeight() || jTextComponent.getDocument().getLength() == 0) {
                super.reshape(n, n2, n3, n4);
                return;
            }
            Point point = this.getViewPosition();
            Point point2 = new Point(dimension2.width + point.x, dimension2.height + point.y);
            int n5 = jTextComponent.viewToModel(point2);
            super.reshape(n, n2, n3, n4);
            this.settingViewSize = true;
            this.doLayout();
            this.validate();
            this.settingViewSize = false;
            try {
                Dimension dimension3 = this.getExtentSize();
                Rectangle rectangle = jTextComponent.modelToView(n5);
                if (rectangle != null) {
                    this.setViewPosition(new Point(0, Math.max(0, rectangle.y + rectangle.height - 1 - dimension3.height)));
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

