#include "mtl/matrix.h"
#include "mtl/mtl.h"
#include "mtl/utils.h"  

/*
Sample output

3x3
[
[5,4,3],
[2.5,3,3.5],
[1,1.5,2]
]
3x3
[
[5,4,3],
[0,1,2],
[1,1.5,2]
]  
 */

using namespace mtl; 


int
main()
{
  //begin
  typedef matrix< double, 
                  rectangle<>, 
                  dense<>, 
                  row_major>::type Matrix; 
  Matrix A(3,3);
  //end
  A(0,0) = 5;   A(0,1) = 4;   A(0,2) = 3;
  A(1,0) = 2.5; A(1,1) = 3;   A(1,2) = 3.5;
  A(2,0) = 1;   A(2,1) = 1.5; A(2,2) = 2;
  print_all_matrix(A);
  //begin
  double SCALE = - A(2,1) / A(1,1);
  //end
  print_all_matrix(A);
  //begin
  add(scaled(A[0], SCALE), A[1], A[1]);  
  //end
  print_all_matrix(A);
}

