/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import java.io.File;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.network.SSLConnector;

public class OptionsParamCertificate
extends AbstractParam {
    private static final String ROOT = "certificate";
    private static final String USE_CLIENT_CERT = "certificate.use";
    private static final String CLIENT_CERT_LOCATION = "certificate.clientCertLocation";
    private int useClientCert = 0;
    private String clientCertLocation = "";

    protected void parse() {
        int n = 0;
        String string = "";
        n = this.getConfig().getInt(USE_CLIENT_CERT, 0);
        string = this.getConfig().getString(CLIENT_CERT_LOCATION, "");
        this.setUseClientCert(false);
        this.setClientCertLocation("");
    }

    public String getClientCertLocation() {
        return this.clientCertLocation;
    }

    public void setClientCertLocation(String string) {
        if (string != null && !string.equals("")) {
            File file = new File(string);
            if (!file.exists()) {
                this.setUseClientCert(false);
                return;
            }
        } else {
            this.setUseClientCert(false);
        }
        this.clientCertLocation = string;
        this.getConfig().setProperty(CLIENT_CERT_LOCATION, string);
    }

    public boolean isUseClientCert() {
        return this.useClientCert != 0;
    }

    public void setUseClientCert(boolean bl) {
        if (bl) {
            this.useClientCert = 1;
            this.getConfig().setProperty(USE_CLIENT_CERT, Integer.toString(this.useClientCert));
            return;
        }
        this.useClientCert = 0;
        this.getConfig().setProperty(USE_CLIENT_CERT, Integer.toString(this.useClientCert));
    }

    public void setCertificate(char[] cArray) throws Exception {
        ProtocolSocketFactory protocolSocketFactory = Protocol.getProtocol("https").getSocketFactory();
        SSLConnector sSLConnector = null;
        if (protocolSocketFactory instanceof SSLConnector) {
            sSLConnector = (SSLConnector)protocolSocketFactory;
            sSLConnector.setClientCert(new File(this.getClientCertLocation()), cArray);
        }
    }

    public void setEnableCertificate(boolean bl) {
        ProtocolSocketFactory protocolSocketFactory = Protocol.getProtocol("https").getSocketFactory();
        SSLConnector sSLConnector = null;
        if (protocolSocketFactory instanceof SSLConnector) {
            sSLConnector = (SSLConnector)protocolSocketFactory;
            sSLConnector.setEnableClientCert(bl);
        }
    }
}

