/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.ClassFile;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.ClassFilter;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.ClassPathLoader;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.DirectoryFilter;

final class DirectoryLoader
implements ClassPathLoader.FileLoader {
    private File directory;
    private static final FilenameFilter DIRECTORY_FILTER = new DirectoryFilter();
    private static final FilenameFilter CLASS_FILTER = new ClassFilter();

    DirectoryLoader(File dir) {
        this.directory = dir;
    }

    public File getFile() {
        return this.directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFile[] getClasses() throws IOException {
        Vector<ClassFile> v = new Vector<ClassFile>(127);
        Vector files = DirectoryLoader.listFiles(this.directory, CLASS_FILTER, true);
        int filesCount = files.size();
        for (int i = 0; i < filesCount; ++i) {
            IOException ignored2;
            Object var9_9;
            File file = (File)files.elementAt(i);
            InputStream is = null;
            try {
                is = ClassPathLoader.getCachedStream(new FileInputStream(file));
                ClassFile classFile = new ClassFile(is);
                is.close();
                is = null;
                v.addElement(classFile);
                var9_9 = null;
                if (is == null) continue;
            }
            catch (Throwable throwable) {
                var9_9 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ignored2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException ignored2) {}
        }
        Object[] classes = new ClassFile[v.size()];
        v.copyInto(classes);
        return classes;
    }

    public static Vector listFiles(File directory, FilenameFilter filter, boolean recurse) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " is not a directory");
        }
        Vector list = new Vector(512);
        DirectoryLoader.listFilesTo(list, directory, filter, recurse);
        return list;
    }

    private static Vector listFilesTo(Vector list, File directory, FilenameFilter filter, boolean recurse) {
        String[] files = directory.list(filter);
        for (int i = 0; i < files.length; ++i) {
            list.addElement(new File(directory, files[i]));
        }
        files = null;
        if (recurse) {
            String[] subdirs = directory.list(DIRECTORY_FILTER);
            for (int i = 0; i < subdirs.length; ++i) {
                DirectoryLoader.listFilesTo(list, new File(directory, subdirs[i]), filter, recurse);
            }
        }
        return list;
    }
}

