.TH FBCONV 1 03-Jun-93
.CM 3
.SH NAME
fbconv \- convert image format
.SH SYNOPSIS
.nf
fbconv [ -<type> ] [ -c ] <n> <k00> <k01> .. <kNN> < 8bit > 8bit
.sp
fbconv [ -<type> ] [ -s ] < 8bit > 8bit
.fi
.SH DESCRIPTION
.PP
A general convolution filter.  
.SH OPTIONS
.TP
.BR -s
.I Sobel,
Calculate the Sobel gradient instead of a simple convolution.
The
.B -s5
option calculates a 5x5 analog of the Sobel filter.
.SH EXAMPLE
.PP
To compute a simple area averaging, you could use:
.nf
% fbconv 3 0.1 0.1 0.1 0.1 0.2 0.1 0.1 0.1 0.1 < 8bit > 8bit
.fi
.sp
It's much easier to keep filters in a file, and then use the
csh's backquote mechanism to include them in the argument list.
For example, if
.B smooth.5x5
contains these numbers:
.sp
.nf
5
0.000  0.025  0.050  0.025  0.000
0.025  0.050  0.075  0.050  0.025
0.050  0.075  0.100  0.075  0.050
0.025  0.050  0.075  0.050  0.025
0.000  0.025  0.050  0.025  0.000
.fi
.sp
then this command will apply this filter to an image:
.sp
    % fbconv `cat smooth.5x5` < 8bit > 8bit
.sp
.SH SEE ALSO
fbm(1) for general discussion, fbsample(1) for 1bit to 8bit averaging.
.SH BUGS
None known.
.SH HISTORY
Copyright (C) 1993 by Michael Mauldin.  Permission is granted
to use this file in whole or in part for any purpose, educational,
recreational or commercial, provided that this copyright notice
is retained unchanged.  This software is available to all free of
charge by anonymous FTP and in the UUNET archives.
.TP
03-Jun-93  Michael Mauldin at Carnegie Mellon University
Created.
