.TH PBM2PS 1 25-Jun-90
.CM 3
.SH NAME
pbm2ps \- convert a PBM file to postscript (option for Scribe files)
.SH SYNOPSIS
.nf
pbm2ps [ -s ] [ scale ] < pbm > postscript
.fi
.SH DESCRIPTION
.PP
This is an enhanced version of Poskanzer's
.I pbmtops
command that includes an option to generate "bare" files for including
in documents (the
.B -s
or scribe option).  It also prints the title at the top, if there is
one attached to the image.
.sp
The
.I scale
if given must be an integer number which indicates how many output dots
(at 300 dpi) are used to render a single pixel.  The default is 1.
.SH EXAMPLE
.PP
Given a 480 by 600 pixel bitmap, create a postscript file with the
largest integral scaling factor that fits on a regular page:
.sp
    % pbm2ps < foo.1bit > foo.PS
.sp
Given the same bitmap, create a postscript file
with each input pixel represented by a 2x2
block of 300 dpi pixels on the output page (scaling factor 2):
.sp
    % pbm2ps 2 < foo.1bit > foo.PS
.sp
Note that the resulting image will be 3.2 inches wide and 4 inches tall
(pixels * scale / 300 dpi).
.sp
Create the same image, but don't include document structuring commands
(this allows the file to be included in other documents by formatters
such as Scribe and TeX).
.sp
    % pbm2ps -s 2 < foo.1bit > foo.PS
.SH SEE ALSO
fbm2ps(1) for converting grayscale files.
fbm(1) for general discussion, pbm(1) for PBM routines.
.SH BUGS
None known.
.SH HISTORY
Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
to use this file in whole or in part for any purpose, educational,
recreational or commercial, provided that this copyright notice
is retained unchanged.  This software is available to all free of
charge by anonymous FTP and in the UUNET archives.
.TP
25-Jun-90  Michael Mauldin at Carnegie Mellon University
Release 1.0 mlm@cs.cmu.edu
.TP
07-Mar-89  Michael L. Mauldin at Carnegie Mellon University
Beta release (version 0.9) mlm@cs.cmu.edu
