/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.nntp;

import gnu.inet.nntp.ActiveTimesIterator;
import gnu.inet.nntp.ArticleNumberIterator;
import gnu.inet.nntp.ArticleResponse;
import gnu.inet.nntp.ArticleStream;
import gnu.inet.nntp.GroupIterator;
import gnu.inet.nntp.GroupResponse;
import gnu.inet.nntp.HeaderIterator;
import gnu.inet.nntp.LineIterator;
import gnu.inet.nntp.NNTPConstants;
import gnu.inet.nntp.NNTPException;
import gnu.inet.nntp.OverviewIterator;
import gnu.inet.nntp.PairIterator;
import gnu.inet.nntp.PendingData;
import gnu.inet.nntp.PostStream;
import gnu.inet.nntp.Range;
import gnu.inet.nntp.StatusResponse;
import gnu.inet.util.CRLFInputStream;
import gnu.inet.util.CRLFOutputStream;
import gnu.inet.util.LineInputStream;
import gnu.inet.util.SaslCallbackHandler;
import gnu.inet.util.SaslInputStream;
import gnu.inet.util.SaslOutputStream;
import gnu.inet.util.TraceLevel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;

public class NNTPConnection
implements NNTPConstants {
    public static final Logger logger = Logger.getLogger("gnu.inet.nntp");
    public static final Level NNTP_TRACE = new TraceLevel("nntp");
    public static final int DEFAULT_PORT = 119;
    private static final String DOT = ".";
    private static final String US_ASCII = "US-ASCII";
    protected String hostname;
    protected int port;
    protected Socket socket;
    protected LineInputStream in;
    protected CRLFOutputStream out;
    protected boolean canPost;
    protected String welcome;
    protected PendingData pendingData;

    public String getWelcome() {
        return this.welcome;
    }

    String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMdd HHmmss 'GMT'");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        gregorianCalendar.setTimeZone(timeZone);
        simpleDateFormat.setCalendar(gregorianCalendar);
        gregorianCalendar.setTime(date);
        return simpleDateFormat.format(date);
    }

    Date parseDate(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMdd HHmmss 'GMT'");
        return simpleDateFormat.parse(string);
    }

    public ArticleResponse article(int n) throws IOException {
        return this.articleImpl("ARTICLE", Integer.toString(n));
    }

    public ArticleResponse article(String string) throws IOException {
        return this.articleImpl("ARTICLE", string);
    }

    public ArticleResponse head(int n) throws IOException {
        return this.articleImpl("HEAD", Integer.toString(n));
    }

    public ArticleResponse head(String string) throws IOException {
        return this.articleImpl("HEAD", string);
    }

    public ArticleResponse body(int n) throws IOException {
        return this.articleImpl("BODY", Integer.toString(n));
    }

    public ArticleResponse body(String string) throws IOException {
        return this.articleImpl("BODY", string);
    }

    public ArticleResponse stat(int n) throws IOException {
        return this.articleImpl("STAT", Integer.toString(n));
    }

    public ArticleResponse stat(String string) throws IOException {
        return this.articleImpl("STAT", string);
    }

    protected ArticleResponse articleImpl(String string, String string2) throws IOException {
        Object object;
        if (string2 != null) {
            object = new StringBuffer(string);
            ((StringBuffer)object).append(' ');
            ((StringBuffer)object).append(string2);
            this.send(((StringBuffer)object).toString());
        } else {
            this.send(string);
        }
        object = this.parseResponse(this.read());
        switch (((StatusResponse)object).status) {
            case 220: 
            case 221: 
            case 222: {
                ArticleResponse articleResponse = (ArticleResponse)object;
                ArticleStream articleStream = new ArticleStream(this.in);
                this.pendingData = articleStream;
                articleResponse.in = articleStream;
                return articleResponse;
            }
            case 223: {
                return (ArticleResponse)object;
            }
        }
        throw new NNTPException((StatusResponse)object);
    }

    public GroupResponse group(String string) throws IOException {
        this.send("GROUP " + string);
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 211: {
                return (GroupResponse)statusResponse;
            }
        }
        throw new NNTPException(statusResponse);
    }

    public LineIterator help() throws IOException {
        this.send("HELP");
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 100: {
                LineIterator lineIterator = new LineIterator(this);
                this.pendingData = lineIterator;
                return lineIterator;
            }
        }
        throw new NNTPException(statusResponse);
    }

    public PostStream ihave(String string) throws IOException {
        this.send("IHAVE " + string);
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 335: {
                return new PostStream(this, false);
            }
            case 435: {
                return null;
            }
        }
        throw new NNTPException(statusResponse);
    }

    public ArticleResponse last() throws IOException {
        return this.articleImpl("LAST", null);
    }

    public GroupIterator list() throws IOException {
        return this.listImpl("LIST");
    }

    GroupIterator listImpl(String string) throws IOException {
        this.send(string);
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 215: {
                GroupIterator groupIterator = new GroupIterator(this);
                this.pendingData = groupIterator;
                return groupIterator;
            }
        }
        throw new NNTPException(statusResponse);
    }

    public LineIterator newGroups(Date date, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("NEWGROUPS");
        stringBuffer.append(' ');
        stringBuffer.append(this.formatDate(date));
        if (stringArray != null) {
            stringBuffer.append(' ');
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
        }
        this.send(stringBuffer.toString());
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 231: {
                LineIterator lineIterator = new LineIterator(this);
                this.pendingData = lineIterator;
                return lineIterator;
            }
        }
        throw new NNTPException(statusResponse);
    }

    public LineIterator newNews(String string, Date date, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("NEWNEWS");
        stringBuffer.append(' ');
        stringBuffer.append(string);
        stringBuffer.append(' ');
        stringBuffer.append(this.formatDate(date));
        if (stringArray != null) {
            stringBuffer.append(' ');
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
        }
        this.send(stringBuffer.toString());
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 230: {
                LineIterator lineIterator = new LineIterator(this);
                this.pendingData = lineIterator;
                return lineIterator;
            }
        }
        throw new NNTPException(statusResponse);
    }

    public ArticleResponse next() throws IOException {
        return this.articleImpl("NEXT", null);
    }

    public OutputStream post() throws IOException {
        this.send("POST");
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 340: {
                return new PostStream(this, false);
            }
        }
        throw new NNTPException(statusResponse);
    }

    void postComplete() throws IOException {
        this.send(DOT);
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 235: 
            case 240: {
                return;
            }
        }
        throw new NNTPException(statusResponse);
    }

    public void quit() throws IOException {
        this.send("QUIT");
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 205: {
                this.socket.close();
                return;
            }
        }
        throw new NNTPException(statusResponse);
    }

    public void slave() throws IOException {
        this.send("SLAVE");
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 202: {
                break;
            }
            default: {
                throw new NNTPException(statusResponse);
            }
        }
    }

    public boolean check(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("CHECK");
        stringBuffer.append(' ');
        stringBuffer.append(string);
        this.send(stringBuffer.toString());
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 238: {
                return true;
            }
            case 438: {
                return false;
            }
        }
        throw new NNTPException(statusResponse);
    }

    public boolean modeStream() throws IOException {
        this.send("MODE STREAM");
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 203: {
                return true;
            }
        }
        return false;
    }

    public OutputStream takethis(String string) throws IOException {
        this.send("TAKETHIS " + string);
        return new PostStream(this, true);
    }

    void takethisComplete() throws IOException {
        this.send(DOT);
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 239: {
                return;
            }
        }
        throw new NNTPException(statusResponse);
    }

    public GroupIterator listActive(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("LIST ACTIVE");
        if (string != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        return this.listImpl(stringBuffer.toString());
    }

    public ActiveTimesIterator listActiveTimes() throws IOException {
        this.send("LIST ACTIVE.TIMES");
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 215: {
                return new ActiveTimesIterator(this);
            }
        }
        throw new NNTPException(statusResponse);
    }

    public PairIterator listNewsgroups(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("LIST NEWSGROUPS");
        if (string != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        this.send(stringBuffer.toString());
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 215: {
                PairIterator pairIterator = new PairIterator(this);
                this.pendingData = pairIterator;
                return pairIterator;
            }
        }
        throw new NNTPException(statusResponse);
    }

    public LineIterator listOverviewFmt() throws IOException {
        this.send("LIST OVERVIEW.FMT");
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 215: {
                LineIterator lineIterator = new LineIterator(this);
                this.pendingData = lineIterator;
                return lineIterator;
            }
        }
        throw new NNTPException(statusResponse);
    }

    public GroupIterator listSubscriptions() throws IOException {
        return this.listImpl("LIST SUBSCRIPTIONS");
    }

    public ArticleNumberIterator listGroup(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("LISTGROUP");
        if (string != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        this.send(stringBuffer.toString());
        StatusResponse statusResponse = this.parseResponse(this.read(), true);
        switch (statusResponse.status) {
            case 211: {
                ArticleNumberIterator articleNumberIterator = new ArticleNumberIterator(this);
                this.pendingData = articleNumberIterator;
                return articleNumberIterator;
            }
        }
        throw new NNTPException(statusResponse);
    }

    public boolean modeReader() throws IOException {
        this.send("MODE READER");
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 200: {
                this.canPost = true;
                return this.canPost;
            }
            case 440: {
                this.canPost = false;
                return this.canPost;
            }
        }
        throw new NNTPException(statusResponse);
    }

    public PairIterator xgtitle(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("XGTITLE");
        if (string != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        this.send(stringBuffer.toString());
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 481: {
                PairIterator pairIterator = new PairIterator(this);
                this.pendingData = pairIterator;
                return pairIterator;
            }
        }
        throw new NNTPException(statusResponse);
    }

    public HeaderIterator xhdr(String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("XHDR");
        stringBuffer.append(' ');
        stringBuffer.append(string);
        if (string2 != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string2);
        }
        this.send(stringBuffer.toString());
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 221: {
                HeaderIterator headerIterator = new HeaderIterator(this);
                this.pendingData = headerIterator;
                return headerIterator;
            }
        }
        throw new NNTPException(statusResponse);
    }

    public OverviewIterator xover(Range range) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("XOVER");
        if (range != null) {
            stringBuffer.append(' ');
            stringBuffer.append(range.toString());
        }
        this.send(stringBuffer.toString());
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 224: {
                OverviewIterator overviewIterator = new OverviewIterator(this);
                this.pendingData = overviewIterator;
                return overviewIterator;
            }
        }
        throw new NNTPException(statusResponse);
    }

    public boolean authinfo(String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("AUTHINFO USER");
        stringBuffer.append(' ');
        stringBuffer.append(string);
        this.send(stringBuffer.toString());
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 281: {
                return true;
            }
            case 381: {
                stringBuffer.setLength(0);
                stringBuffer.append("AUTHINFO PASS");
                stringBuffer.append(' ');
                stringBuffer.append(string2);
                this.send(stringBuffer.toString());
                statusResponse = this.parseResponse(this.read());
                switch (statusResponse.status) {
                    case 281: {
                        return true;
                    }
                    case 502: {
                        return false;
                    }
                }
                throw new NNTPException(statusResponse);
            }
        }
        throw new NNTPException(statusResponse);
    }

    public boolean authinfoSimple(String string, String string2) throws IOException {
        this.send("AUTHINFO SIMPLE");
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 350: {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.append(' ');
                stringBuffer.append(string2);
                this.send(stringBuffer.toString());
                statusResponse = this.parseResponse(this.read());
                switch (statusResponse.status) {
                    case 350: {
                        return true;
                    }
                    case 452: {
                        return false;
                    }
                }
                throw new NNTPException(statusResponse);
            }
        }
        throw new NNTPException(statusResponse);
    }

    public boolean authinfoGeneric(String string, String string2, String string3) throws IOException {
        Object object;
        String[] stringArray = new String[]{string};
        SaslCallbackHandler saslCallbackHandler = new SaslCallbackHandler(string2, string3);
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.sasl.username", string2);
        hashMap.put("gnu.crypto.sasl.password", string3);
        SaslClient saslClient = Sasl.createSaslClient(stringArray, null, "smtp", this.socket.getInetAddress().getHostName(), hashMap, saslCallbackHandler);
        if (saslClient == null) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer("AUTHINFO GENERIC");
        stringBuffer.append(' ');
        stringBuffer.append(string);
        if (saslClient.hasInitialResponse()) {
            stringBuffer.append(' ');
            object = saslClient.evaluateChallenge(new byte[0]);
            stringBuffer.append(new String((byte[])object, US_ASCII));
        }
        this.send(stringBuffer.toString());
        object = this.parseResponse(this.read());
        switch (object.status) {
            case 281: {
                String string4 = (String)saslClient.getNegotiatedProperty("javax.security.sasl.qop");
                if ("auth-int".equalsIgnoreCase(string4) || "auth-conf".equalsIgnoreCase(string4)) {
                    InputStream inputStream = this.socket.getInputStream();
                    inputStream = new BufferedInputStream(inputStream);
                    inputStream = new SaslInputStream(saslClient, inputStream);
                    inputStream = new CRLFInputStream(inputStream);
                    this.in = new LineInputStream(inputStream);
                    OutputStream outputStream = this.socket.getOutputStream();
                    outputStream = new BufferedOutputStream(outputStream);
                    outputStream = new SaslOutputStream(saslClient, outputStream);
                    this.out = new CRLFOutputStream(outputStream);
                }
                return true;
            }
            case 502: {
                return false;
            }
        }
        throw new NNTPException((StatusResponse)object);
    }

    public Date date() throws IOException {
        this.send("DATE");
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 111: {
                String string = statusResponse.getMessage();
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    return simpleDateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    throw new IOException("Invalid date: " + string);
                }
            }
        }
        throw new NNTPException(statusResponse);
    }

    protected StatusResponse parseResponse(String string) throws ProtocolException {
        return this.parseResponse(string, false);
    }

    protected StatusResponse parseResponse(String string, boolean bl) throws ProtocolException {
        StatusResponse statusResponse;
        if (string == null) {
            throw new ProtocolException(this.hostname + " closed connection");
        }
        int n = 0;
        short s = -1;
        String string2 = string;
        String string3 = null;
        int n2 = string.indexOf(32, n);
        if (n2 > n) {
            string2 = string.substring(n, n2);
            string3 = string.substring(n2 + 1);
        }
        try {
            s = Short.parseShort(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProtocolException(string);
        }
        switch (s) {
            case 211: 
            case 220: 
            case 221: 
            case 222: 
            case 223: {
                if (s != 211 || bl) {
                    try {
                        ArticleResponse articleResponse = new ArticleResponse(s, string3);
                        n = n2 + 1;
                        n2 = string.indexOf(32, n);
                        if (n2 > n) {
                            articleResponse.articleNumber = Integer.parseInt(string.substring(n, n2));
                        }
                        articleResponse.messageId = (n2 = string.indexOf(32, n = n2 + 1)) > n ? string.substring(n, n2) : string.substring(n);
                        statusResponse = articleResponse;
                    }
                    catch (NumberFormatException numberFormatException) {
                        statusResponse = new StatusResponse(s, string3);
                    }
                    break;
                }
                GroupResponse groupResponse = new GroupResponse(s, string3);
                try {
                    n = n2 + 1;
                    n2 = string.indexOf(32, n);
                    if (n2 > n) {
                        groupResponse.count = Integer.parseInt(string.substring(n, n2));
                    }
                    if ((n2 = string.indexOf(32, n = n2 + 1)) > n) {
                        groupResponse.first = Integer.parseInt(string.substring(n, n2));
                    }
                    if ((n2 = string.indexOf(32, n = n2 + 1)) > n) {
                        groupResponse.last = Integer.parseInt(string.substring(n, n2));
                    }
                    groupResponse.group = (n2 = string.indexOf(32, n = n2 + 1)) > n ? string.substring(n, n2) : string.substring(n);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ProtocolException(string);
                }
                statusResponse = groupResponse;
                break;
            }
            default: {
                statusResponse = new StatusResponse(s, string3);
            }
        }
        return statusResponse;
    }

    protected void send(String string) throws IOException {
        if (this.pendingData != null) {
            this.pendingData.readToEOF();
            this.pendingData = null;
        }
        logger.log(NNTP_TRACE, ">" + string);
        byte[] byArray = string.getBytes(US_ASCII);
        this.out.write(byArray);
        this.out.writeln();
        this.out.flush();
    }

    protected String read() throws IOException {
        String string = this.in.readLine();
        if (string == null) {
            logger.log(NNTP_TRACE, "<EOF");
        } else {
            logger.log(NNTP_TRACE, "<" + string);
        }
        return string;
    }

    public NNTPConnection(String string) throws IOException {
        this(string, 119, 0, 0);
    }

    public NNTPConnection(String string, int n) throws IOException {
        this(string, n, 0, 0);
    }

    public NNTPConnection(String string, int n, int n2, int n3) throws IOException {
        if (n < 0) {
            n = 119;
        }
        this.hostname = string;
        this.port = n;
        this.socket = new Socket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        if (n2 > 0) {
            this.socket.connect(inetSocketAddress, n2);
        } else {
            this.socket.connect(inetSocketAddress);
        }
        if (n3 > 0) {
            this.socket.setSoTimeout(n3);
        }
        InputStream inputStream = this.socket.getInputStream();
        inputStream = new CRLFInputStream(inputStream);
        this.in = new LineInputStream(inputStream);
        OutputStream outputStream = this.socket.getOutputStream();
        outputStream = new BufferedOutputStream(outputStream);
        this.out = new CRLFOutputStream(outputStream);
        StatusResponse statusResponse = this.parseResponse(this.read());
        switch (statusResponse.status) {
            case 200: {
                this.canPost = true;
            }
            case 201: {
                this.welcome = statusResponse.getMessage();
                break;
            }
            default: {
                throw new NNTPException(statusResponse);
            }
        }
    }
}

