/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.StyleConstants;
import javax.swing.text.ViewFactory;

public class LabelView
extends GlyphView {
    Color background;
    Color foreground;
    Font font;
    boolean strikeThrough;
    boolean underline;
    boolean subscript;
    boolean superscript;

    protected void setPropertiesFromAttributes() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        this.background = (Color)attributeSet.getAttribute(StyleConstants.Background);
        this.foreground = StyleConstants.getForeground(attributeSet);
        this.strikeThrough = StyleConstants.isStrikeThrough(attributeSet);
        this.subscript = StyleConstants.isSubscript(attributeSet);
        this.superscript = StyleConstants.isSuperscript(attributeSet);
        this.underline = StyleConstants.isUnderline(attributeSet);
        String string = StyleConstants.getFontFamily(attributeSet);
        int n = StyleConstants.getFontSize(attributeSet);
        int n2 = 0;
        if (StyleConstants.isBold(attributeSet)) {
            n2 |= 1;
        }
        if (StyleConstants.isItalic(attributeSet)) {
            n2 |= 2;
        }
        this.font = new Font(string, n2, n);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.setPropertiesFromAttributes();
    }

    public Color getBackground() {
        return this.background;
    }

    protected void setBackground(Color color) {
        this.background = color;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Font getFont() {
        return this.font;
    }

    protected FontMetrics getFontMetrics() {
        return this.getContainer().getGraphics().getFontMetrics(this.font);
    }

    public boolean isUnderline() {
        return this.underline;
    }

    protected void setUnderline(boolean bl) {
        this.underline = bl;
    }

    public boolean isSubscript() {
        return this.subscript;
    }

    protected void setSubscript(boolean bl) {
        this.subscript = bl;
    }

    public boolean isSuperscript() {
        return this.superscript;
    }

    protected void setSuperscript(boolean bl) {
        this.superscript = bl;
    }

    public boolean isStrikeThrough() {
        return this.strikeThrough;
    }

    protected void setStrikeThrough(boolean bl) {
        this.strikeThrough = bl;
    }

    public LabelView(Element element) {
        super(element);
        this.setPropertiesFromAttributes();
    }
}

