/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.io.IOException;
import org.openoffice.xmerge.converter.xml.EmbeddedObject;
import org.openoffice.xmerge.converter.xml.EmbeddedXMLObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.CSVList;
import writer2latex.util.Config;
import writer2latex.util.Misc;
import writer2latex.xhtml.ConverterHelper;
import writer2latex.xhtml.DocumentSerializerImpl;
import writer2latex.xhtml.XhtmlStyleMap;
import writer2latex.xmerge.BinaryGraphicsDocument;

public class DrawConverter
extends ConverterHelper {
    private String sScale;
    private boolean bConvertToPx;

    public DrawConverter(WriterStyleCollection wsc, Config config, DocumentSerializerImpl converter) {
        super(wsc, config, converter);
        this.sScale = config.getXhtmlScaling();
        this.bConvertToPx = config.xhtmlConvertToPx();
    }

    public void convertDrawContent(Element onode) {
        if (!onode.hasChildNodes()) {
            return;
        }
        NodeList nList = onode.getChildNodes();
        int nLen = nList.getLength();
        int i = 0;
        while (i < nLen) {
            String sNodeName;
            Node child = nList.item(i);
            if (child.getNodeType() == 1 && (sNodeName = child.getNodeName()).equals("draw:page")) {
                this.handleDrawPage((Element)child, this.converter.nextOutFile());
            }
            ++i;
        }
    }

    private void handleDrawPage(Element onode, Node hnode) {
        Element div = this.converter.createElement("div");
        hnode.appendChild(div);
        CSVList props = new CSVList(";");
        div.setAttribute("style", props.toString());
        if (!onode.hasChildNodes()) {
            return;
        }
        NodeList nList = onode.getChildNodes();
        int nLen = nList.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nList.item(i);
            if (child.getNodeType() == 1) {
                this.handleDrawElement(child, div);
            }
            ++i;
        }
    }

    public void handleDrawElement(Node onode, Node hnode) {
        String sName = onode.getNodeName();
        if (sName.equals("draw:object")) {
            this.handleDrawObject(onode, hnode);
        } else if (sName.equals("draw:image")) {
            this.handleDrawImage(onode, hnode);
        } else if (sName.equals("draw:text-box")) {
            this.handleDrawTextBox(onode, hnode);
        } else if (sName.equals("draw:a")) {
            this.getTextCv().handleAnchor(onode, hnode);
        }
    }

    private void handleDrawObject(Node onode, Node hnode) {
        String sHref = Misc.getAttribute(onode, "xlink:href");
        if (sHref != null) {
            if (sHref.startsWith("#")) {
                EmbeddedObject object = this.converter.getEmbeddedObject(sHref = sHref.substring(3));
                if ("application/vnd.sun.xml.math".equals(object.getType())) {
                    EmbeddedXMLObject xmlObject = (EmbeddedXMLObject)object;
                    try {
                        hnode.appendChild(this.converter.createTextNode(" "));
                        this.getMathCv().convert(xmlObject.getContentDOM().getDocumentElement(), hnode);
                        hnode.appendChild(this.converter.createTextNode(" "));
                    }
                    catch (SAXException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    hnode.appendChild(this.converter.createTextNode("[Warning: object ignored]"));
                }
            } else {
                hnode.appendChild(this.converter.createTextNode("[Warning: Linked object ignored]"));
            }
        } else {
            Element formula = Misc.getChildByTagName(onode, "math:math");
            if (formula != null) {
                hnode.appendChild(this.converter.createTextNode(" "));
                this.getMathCv().convert(formula, hnode);
                hnode.appendChild(this.converter.createTextNode(" "));
            }
        }
    }

    private void handleDrawImage(Node onode, Node hnode) {
        String sName = Misc.getAttribute(onode, "draw:name");
        String sFileName = null;
        String sHref = Misc.getAttribute(onode, "xlink:href");
        if (sHref != null && !sHref.startsWith("#")) {
            sFileName = sHref;
            String sExt = sHref.substring(sHref.lastIndexOf(".")).toLowerCase();
        } else {
            BinaryGraphicsDocument bgd = this.converter.getImageLoader().getImage(onode);
            if (bgd != null) {
                this.converter.addDocument(bgd);
                sFileName = bgd.getFileName();
            }
        }
        if (sFileName == null) {
            return;
        }
        String sWidth = Misc.getAttribute(onode, "svg:width");
        String sHeight = Misc.getAttribute(onode, "svg:height");
        String sAnchor = Misc.getAttribute(onode, "text:anchor-type");
        Element image = this.converter.createElement("img");
        this.converter.addTarget(image, sName + "%7Cgraphics");
        image.setAttribute("src", sFileName);
        if (sName == null) {
            sName = sFileName;
        }
        image.setAttribute("alt", sName);
        CSVList props = new CSVList(";");
        if (sWidth != null) {
            props.addValue("width", this.scale(sWidth));
        }
        if (sHeight != null) {
            props.addValue("height", this.scale(sHeight));
        }
        String sStyleName = Misc.getAttribute(onode, "draw:style-name");
        this.applyFrameStyle(sStyleName, image, props, !"as-char".equals(sAnchor));
        hnode.appendChild(image);
    }

    private void handleDrawTextBox(Node onode, Node hnode) {
        String sName = Misc.getAttribute(onode, "draw:name");
        Element container = this.converter.createElement("object");
        hnode.appendChild(container);
        Element textbox = this.converter.createElement("div");
        this.converter.addTarget(textbox, sName + "%7Cframe");
        container.appendChild(textbox);
        String sWidth = Misc.getAttribute(onode, "svg:width");
        String sAnchor = Misc.getAttribute(onode, "text:anchor-type");
        CSVList props = new CSVList(";");
        if (sWidth != null) {
            props.addValue("width", this.scale(sWidth));
        }
        String sStyleName = Misc.getAttribute(onode, "draw:style-name");
        this.applyFrameStyle(sStyleName, textbox, props, !"as-char".equals(sAnchor));
        this.getTextCv().traverseBlockText(onode, textbox);
    }

    private void applyFrameStyle(String sStyleName, Element element, CSVList props, boolean bFloating) {
        XhtmlStyleMap xframe = this.config.getXFrameStyleMap();
        if (xframe.contains(sStyleName)) {
            if (!"(none)".equals(xframe.getCss(sStyleName))) {
                element.setAttribute("class", xframe.getCss(sStyleName));
            }
            element.setAttribute("style", props.toString());
        } else {
            this.getStyleCv().applyFrameStyle(sStyleName, element, props, bFloating, !this.config.xhtmlIgnoreStyles());
        }
    }

    private void applySize(Element node, CSVList props, boolean bOnlyWidth) {
        String sWidth = node.getAttribute("svg:width");
        if (sWidth != null) {
            props.addValue("width", this.scale(sWidth));
        }
        if (bOnlyWidth) {
            return;
        }
        String sHeight = node.getAttribute("svg:height");
        if (sHeight != null) {
            props.addValue("height", this.scale(sHeight));
        }
    }

    private void applyPosition(Element node, CSVList props) {
        String sY;
        props.addValue("position", "absolute");
        String sX = node.getAttribute("svg:x");
        if (sX != null) {
            props.addValue("left", this.scale(sX));
        }
        if ((sY = node.getAttribute("svg:y")) != null) {
            props.addValue("top", this.scale(sY));
        }
    }

    private String scale(String s) {
        if (this.bConvertToPx) {
            return Misc.length2px(Misc.multiply(this.sScale, Misc.truncateLength(s)));
        }
        return Misc.multiply(this.sScale, Misc.truncateLength(s));
    }
}

