/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openoffice.xmerge.converter.dom.DOMDocument;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XhtmlDocument
extends DOMDocument {
    public static final int XHTML10 = 0;
    public static final int XHTML11 = 1;
    public static final int XHTML_MATHML = 2;
    public static final int XHTML_MATHML_XSL = 3;
    private static final String[] sExtension;
    private int nType;
    private boolean bNoDoctype = false;
    private static final String[] sEmpty;

    public static final String getExtension(int nType) {
        return sExtension[nType];
    }

    public XhtmlDocument(String name, int nType) {
        super(name, sExtension[nType]);
        this.nType = nType;
        String sPublicId = null;
        String sSystemId = null;
        switch (nType) {
            case 0: {
                sPublicId = "-//W3C//DTD XHTML 1.0 Strict//EN";
                sSystemId = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
                break;
            }
            case 1: {
                sPublicId = "-//W3C//DTD XHTML 1.1//EN";
                sSystemId = "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd";
                break;
            }
            case 2: 
            case 3: {
                sPublicId = "-//W3C//DTD XHTML 1.1 plus MathML 2.0//EN";
                sSystemId = "http://www.w3.org/Math/DTD/mathml2/xhtml-math11-f.dtd";
            }
        }
        Document contentDOM = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            DocumentType doctype = domImpl.createDocumentType("html", sPublicId, sSystemId);
            contentDOM = domImpl.createDocument("http://www.w3.org/1999/xhtml", "html", doctype);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        contentDOM.getDocumentElement().setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        this.setContentDOM(contentDOM);
    }

    public void setNoDoctype(boolean b) {
        this.bNoDoctype = b;
    }

    public String getFileExtension() {
        return super.getFileExtension();
    }

    public void write(OutputStream os) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
        if (this.nType == 2 || this.nType == 3) {
            osw.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        }
        if (this.nType == 3) {
            osw.write("<?xml-stylesheet type=\"text/xsl\" href=\"pmathml.xsl\"?>\n");
        } else if (!this.bNoDoctype) {
            osw.write("<!DOCTYPE html PUBLIC \"");
            osw.write(this.getContentDOM().getDoctype().getPublicId());
            osw.write("\" \"");
            osw.write(this.getContentDOM().getDoctype().getSystemId());
            osw.write("\">\n");
        }
        this.write(this.getContentDOM().getDocumentElement(), 0, osw);
        osw.flush();
        osw.close();
    }

    private boolean isEmpty(String sTagName) {
        int i = 0;
        while (i < sEmpty.length) {
            if (sEmpty[i].equals(sTagName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void write(Node node, int nLevel, OutputStreamWriter osw) throws IOException {
        short nType = node.getNodeType();
        switch (nType) {
            case 1: {
                if (this.isEmpty(node.getNodeName())) {
                    if (nLevel >= 0) {
                        this.writeSpaces(nLevel, osw);
                    }
                    osw.write("<" + node.getNodeName());
                    this.writeAttributes(node, osw);
                    osw.write(" />");
                    if (nLevel < 0) break;
                    osw.write("\n");
                    break;
                }
                if (node.hasChildNodes()) {
                    int i;
                    NodeList list = node.getChildNodes();
                    int nLen = list.getLength();
                    boolean bBlockPrettyPrint = false;
                    if (nLevel >= 0) {
                        i = 0;
                        while (i < nLen) {
                            bBlockPrettyPrint |= list.item(i).getNodeType() == 3;
                            ++i;
                        }
                    }
                    if (nLevel >= 0) {
                        this.writeSpaces(nLevel, osw);
                    }
                    osw.write("<" + node.getNodeName());
                    this.writeAttributes(node, osw);
                    osw.write(">");
                    if (nLevel >= 0 && !bBlockPrettyPrint) {
                        osw.write("\n");
                    }
                    i = 0;
                    while (i < nLen) {
                        int nNextLevel = bBlockPrettyPrint || nLevel < 0 ? -1 : nLevel + 1;
                        this.write(list.item(i), nNextLevel, osw);
                        ++i;
                    }
                    if (nLevel >= 0 && !bBlockPrettyPrint) {
                        this.writeSpaces(nLevel, osw);
                    }
                    osw.write("</" + node.getNodeName() + ">");
                    if (nLevel < 0) break;
                    osw.write("\n");
                    break;
                }
                if (nLevel >= 0) {
                    this.writeSpaces(nLevel, osw);
                }
                osw.write("<" + node.getNodeName());
                this.writeAttributes(node, osw);
                if (nType <= 1) {
                    osw.write("></" + node.getNodeName() + ">");
                } else {
                    osw.write(" />");
                }
                if (nLevel < 0) break;
                osw.write("\n");
                break;
            }
            case 3: {
                this.write(node.getNodeValue(), osw);
                break;
            }
            case 8: {
                if (nLevel >= 0) {
                    this.writeSpaces(nLevel, osw);
                }
                osw.write("<!-- ");
                this.write(node.getNodeValue(), osw);
                osw.write(" -->");
                if (nLevel < 0) break;
                osw.write("\n");
            }
        }
    }

    private void writeAttributes(Node node, OutputStreamWriter osw) throws IOException {
        NamedNodeMap attr = node.getAttributes();
        int nLen = attr.getLength();
        int i = 0;
        while (i < nLen) {
            Node item = attr.item(i);
            osw.write(" ");
            this.write(item.getNodeName(), osw);
            osw.write("=\"");
            this.write(item.getNodeValue(), osw);
            osw.write("\"");
            ++i;
        }
    }

    private void writeSpaces(int nCount, OutputStreamWriter osw) throws IOException {
        int i = 0;
        while (i < nCount) {
            osw.write("  ");
            ++i;
        }
    }

    private void write(String s, OutputStreamWriter osw) throws IOException {
        int nLen = s.length();
        int i = 0;
        while (i < nLen) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    osw.write("&lt;");
                    break;
                }
                case '>': {
                    osw.write("&gt;");
                    break;
                }
                case '&': {
                    osw.write("&amp;");
                    break;
                }
                case '\"': {
                    osw.write("&quot;");
                    break;
                }
                case '\'': {
                    osw.write(this.nType == 0 ? "&#39;" : "&apos;");
                    break;
                }
                default: {
                    osw.write(c);
                }
            }
            ++i;
        }
    }

    static {
        XHTML10 = 0;
        XHTML11 = 1;
        XHTML_MATHML = 2;
        XHTML_MATHML_XSL = 3;
        sExtension = new String[]{".html", ".html", ".xhtml", ".xml"};
        sEmpty = new String[]{"base", "meta", "link", "hr", "br", "param", "img", "area", "input", "col"};
    }
}

