package TDS::List::Url;
# $Id: Url.pm,v 1.6 2000/12/13 09:51:55 tom Exp $
################################################################

use strict;
use vars qw(@ISA
	    $LineTemplate $ContentTemplate
	    $SkeltonFilename $CacheFilename $DataFilename);

use Template;

use TDS;
use TDS::List::Base;

@ISA = qw(TDS::List::Base);

attributes qw();

# temlate for HTMLize
$LineTemplate = qq(<hr><h2>%char</h2>);
# $ContentTemplate is used for old format, this will be obsoluted.
$ContentTemplate = qq(<h3><a href="#%encoded_term" name="%encoded_term">%term</a>[%yomi]</h3><div style="margin-left: 2em">%explain</div>\n);

$SkeltonFilename = "url_skelton.html";
$CacheFilename = "url.html";
$DataFilename = "url.dat";

################################################################

sub Read ($)
{
    my $self = shift;

    if ($self->IsFresh){
	open(F, $self->GetCacheFilename);
	my $lines = join('', <F>);
	close F;
	$self->cache_html($lines);
    }
}    

sub SetMacros($)
{
    my $self = shift;

    $self->SetMacro("URL_CONTENT", sub {
	my $self = shift;

	my $html;
	open(F, $self->GetDataFilename) || return undef;

	while (<F>){
	    next if /^$/ || /^#/;
	    my $line = $_;
	    if ($line =~ /^\!(.*)/){                # ȥ
		my $title = $1;
		$html .= "</ul>\n\n"
		    if $html;
		$html .= "<h3>$title</h3>\n<ul>\n";
	    } else {                       # ִ
		my ($term, $replaced) = split(/\t+/, $line);
		chomp $replaced;
		$html .= qq(  <li><a href="$replaced">$term</a>\n);
	    }
	}
	$html .= "</ul>\n";
	close F;
	return $html;
    });
    $self->SUPER::SetMacros;
}

    
1;
