
(define-library (srfi 160 s16)
  (export
   make-s16vector
   s16?
   s16vector?
   s16vector-ref
   s16vector-set!
   s16vector-length
   (rename uvector-unfold s16vector-unfold)
   (rename uvector-unfold-right s16vector-unfold-right)
   (rename vector-copy s16vector-copy)
   (rename vector-reverse-copy s16vector-reverse-copy)
   (rename vector-append s16vector-append)
   (rename vector-concatenate s16vector-concatenate)
   (rename vector-append-subvectors s16vector-append-subvectors)
   (rename vector-empty? s16vector-empty?)
   (rename vector= s16vector=)
   (rename vector-take s16vector-take)
   (rename vector-take-right s16vector-take-right)
   (rename vector-drop s16vector-drop)
   (rename vector-drop-right s16vector-drop-right)
   (rename vector-segment s16vector-segment)
   (rename vector-fold s16vector-fold)
   (rename vector-fold-right s16vector-fold-right)
   (rename vector-map s16vector-map)
   (rename vector-map! s16vector-map!)
   (rename vector-for-each s16vector-for-each)
   (rename vector-count s16vector-count)
   (rename vector-cumulate s16vector-cumulate)
   (rename vector-take-while s16vector-take-while)
   (rename vector-take-while-right s16vector-take-while-right)
   (rename vector-drop-while s16vector-drop-while)
   (rename vector-drop-while-right s16vector-drop-while-right)
   (rename vector-index s16vector-index)
   (rename vector-index-right s16vector-index-right)
   (rename vector-skip s16vector-skip)
   (rename vector-skip-right s16vector-skip-right)
   (rename vector-binary-search s16vector-binary-search)
   (rename vector-any s16vector-any)
   (rename vector-every s16vector-every)
   (rename vector-partition s16vector-partition)
   (rename vector-filter s16vector-filter)
   (rename vector-remove s16vector-remove)
   (rename vector-swap! s16vector-swap!)
   (rename vector-fill! s16vector-fill!)
   (rename vector-reverse! s16vector-reverse!)
   (rename vector-copy! s16vector-copy!)
   (rename vector-reverse-copy! s16vector-reverse-copy!)
   (rename reverse-vector->list reverse-s16vector->list)
   (rename reverse-list->vector reverse-list->s16vector)
   (rename uvector->vector s16vector->vector)
   (rename vector->uvector vector->s16vector)
   (rename make-vector-generator make-s16vector-generator)
   (rename write-vector write-s16vector))
  (import (except (scheme base)
                  vector-append vector-copy vector-copy!
                  vector-map vector-for-each)
          (scheme write)
          (srfi 160 base))
  (begin
    (define uvector? s16vector?)
    (define make-uvector make-s16vector)
    (define vector s16vector)
    (define uvector->list s16vector->list)
    (define list->uvector list->s16vector)
    (define uvector-length s16vector-length)
    (define uvector-ref s16vector-ref)
    (define uvector-set! s16vector-set!))
  (include "uvector.scm"))
