/*
 *      STATUS CHANGE CODES
 */
#define ESC             '\033'
#define TO_2BCODE       '$'
#define TO_1BCODE       '('

#define TO_KANA         '\016'
#define TO_KANAOUT      '\017'

#define TO_KANJI        "\033$B"
#define TO_ASCII        "\033(B"

#define IS_SJIS_LO(lo)  ((0x40<=lo)&&(lo!=0x7F)&&(lo<=0xFC))
#define IS_SJIS_HI1(hi) ((0x81<=hi)&&(hi<=0x9F))        /* 1st lev. */
#define IS_SJIS_HI2(hi) ((0xE0<=hi)&&(hi<=0xEF))        /* 2nd lev. */
#define IS_SJIS(hi,lo,in_sjis)\
        (!IS_SJIS_LO(lo) ? 0:\
        IS_SJIS_HI1(hi) ? (in_sjis = 1):\
        in_sjis && IS_SJIS_HI2(hi))

#define IS_EUC_LOS(lo)  ((0x21<=lo)&&(lo<=0x7E))        /* standard */
#define IS_EUC_LOX(lo)  ((0xA1<=lo)&&(lo<=0xFE))        /* extended */
#define IS_EUC_HI(hi)   ((0xA1<=hi)&&(hi<=0xFE))
#define IS_EUC(hi,lo)\
        IS_EUC_HI(hi) && (IS_EUC_LOS(lo) || IS_EUC_LOX(lo))
