/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.util.WarningCounter;

public class GobyVersion {
    private static String[] versionPairs = new String[]{"1.9.5-", "20110101000000", "goby_1.9.6", "20110510111716", "goby_1.9.8.1", "20111217111716", "goby_1.9.8.2", "20120120000000", "3.0.0", "20160725144635"};
    private static WarningCounter versionWarning = new WarningCounter(1);
    private static final Log LOG = LogFactory.getLog(GobyVersion.class);

    private static String now() {
        Date d = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyymmddHHmmss");
        return formatter.format(d);
    }

    public static boolean isMoreRecent(String version, String toBeCompareTo) {
        return !GobyVersion.isOlder(version, toBeCompareTo);
    }

    public static boolean isOlder(String version, String toBeCompareTo) {
        long time2;
        if (version.equals(toBeCompareTo)) {
            return false;
        }
        long time1 = Long.parseLong(GobyVersion.reduce(version));
        return time1 < (time2 = Long.parseLong(GobyVersion.reduce(toBeCompareTo)));
    }

    private static String reduce(String version) {
        if (version.indexOf(40) >= 0 && version.indexOf(41) >= 0) {
            String[] tokens = version.split("[()]");
            String token = tokens[1];
            return token;
        }
        for (int i = 0; i < versionPairs.length; ++i) {
            if (!version.equals(versionPairs[i])) continue;
            return versionPairs[i + 1];
        }
        versionWarning.warn(LOG, String.format("Version number %s not recognized. Assuming this version is the most recent.", version), new Object[0]);
        return GobyVersion.now();
    }
}

