"""Generated client library for anthosevents version v1beta1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.anthosevents.v1beta1 import anthosevents_v1beta1_messages as messages


class AnthoseventsV1beta1(base_api.BaseApiClient):
  """Generated client library for service anthosevents version v1beta1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://anthosevents.googleapis.com/'
  MTLS_BASE_URL = 'https://anthosevents.mtls.googleapis.com/'

  _PACKAGE = 'anthosevents'
  _SCOPES = ['https://www.googleapis.com/auth/userinfo.email']
  _VERSION = 'v1beta1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'AnthoseventsV1beta1'
  _URL_VERSION = 'v1beta1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new anthosevents handle."""
    url = url or self.BASE_URL
    super(AnthoseventsV1beta1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.customresourcedefinitions = self.CustomresourcedefinitionsService(self)
    self.namespaces_apiserversources = self.NamespacesApiserversourcesService(self)
    self.namespaces_brokers = self.NamespacesBrokersService(self)
    self.namespaces_cloudauditlogssources = self.NamespacesCloudauditlogssourcesService(self)
    self.namespaces_cloudpubsubsources = self.NamespacesCloudpubsubsourcesService(self)
    self.namespaces_cloudschedulersources = self.NamespacesCloudschedulersourcesService(self)
    self.namespaces_cloudstoragesources = self.NamespacesCloudstoragesourcesService(self)
    self.namespaces_customresourcedefinitions = self.NamespacesCustomresourcedefinitionsService(self)
    self.namespaces_pingsources = self.NamespacesPingsourcesService(self)
    self.namespaces_triggers = self.NamespacesTriggersService(self)
    self.namespaces = self.NamespacesService(self)

  class CustomresourcedefinitionsService(base_api.BaseApiService):
    """Service class for the customresourcedefinitions resource."""

    _NAME = 'customresourcedefinitions'

    def __init__(self, client):
      super(AnthoseventsV1beta1.CustomresourcedefinitionsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Rpc to list custom resource definitions.

      Args:
        request: (AnthoseventsCustomresourcedefinitionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCustomResourceDefinitionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='anthosevents.customresourcedefinitions.list',
        ordered_params=[],
        path_params=[],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'parent', 'resourceVersion', 'watch'],
        relative_path='apis/apiextensions.k8s.io/v1beta1/customresourcedefinitions',
        request_field='',
        request_type_name='AnthoseventsCustomresourcedefinitionsListRequest',
        response_type_name='ListCustomResourceDefinitionsResponse',
        supports_download=False,
    )

  class NamespacesApiserversourcesService(base_api.BaseApiService):
    """Service class for the namespaces_apiserversources resource."""

    _NAME = 'namespaces_apiserversources'

    def __init__(self, client):
      super(AnthoseventsV1beta1.NamespacesApiserversourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new apiserversource.

      Args:
        request: (AnthoseventsNamespacesApiserversourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ApiServerSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/sources.knative.dev/v1beta1/namespaces/{namespacesId}/apiserversources',
        http_method='POST',
        method_id='anthosevents.namespaces.apiserversources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/sources.knative.dev/v1beta1/{+parent}/apiserversources',
        request_field='apiServerSource',
        request_type_name='AnthoseventsNamespacesApiserversourcesCreateRequest',
        response_type_name='ApiServerSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a apiserversource.

      Args:
        request: (AnthoseventsNamespacesApiserversourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/sources.knative.dev/v1beta1/namespaces/{namespacesId}/apiserversources/{apiserversourcesId}',
        http_method='DELETE',
        method_id='anthosevents.namespaces.apiserversources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='apis/sources.knative.dev/v1beta1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesApiserversourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a apiserversource.

      Args:
        request: (AnthoseventsNamespacesApiserversourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ApiServerSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/sources.knative.dev/v1beta1/namespaces/{namespacesId}/apiserversources/{apiserversourcesId}',
        http_method='GET',
        method_id='anthosevents.namespaces.apiserversources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['region'],
        relative_path='apis/sources.knative.dev/v1beta1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesApiserversourcesGetRequest',
        response_type_name='ApiServerSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list apiserversources.

      Args:
        request: (AnthoseventsNamespacesApiserversourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListApiServerSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/sources.knative.dev/v1beta1/namespaces/{namespacesId}/apiserversources',
        http_method='GET',
        method_id='anthosevents.namespaces.apiserversources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/sources.knative.dev/v1beta1/{+parent}/apiserversources',
        request_field='',
        request_type_name='AnthoseventsNamespacesApiserversourcesListRequest',
        response_type_name='ListApiServerSourcesResponse',
        supports_download=False,
    )

    def ReplaceApiServerSource(self, request, global_params=None):
      r"""Rpc to replace a apiserversource. Only the spec and metadata labels and annotations are modifiable. After the Update request, Cloud Run will work to make the 'status' match the requested 'spec'. May provide metadata.resourceVersion to enforce update from last read for optimistic concurrency control.

      Args:
        request: (AnthoseventsNamespacesApiserversourcesReplaceApiServerSourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ApiServerSource) The response message.
      """
      config = self.GetMethodConfig('ReplaceApiServerSource')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceApiServerSource.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/sources.knative.dev/v1beta1/namespaces/{namespacesId}/apiserversources/{apiserversourcesId}',
        http_method='PUT',
        method_id='anthosevents.namespaces.apiserversources.replaceApiServerSource',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['region'],
        relative_path='apis/sources.knative.dev/v1beta1/{+name}',
        request_field='apiServerSource',
        request_type_name='AnthoseventsNamespacesApiserversourcesReplaceApiServerSourceRequest',
        response_type_name='ApiServerSource',
        supports_download=False,
    )

  class NamespacesBrokersService(base_api.BaseApiService):
    """Service class for the namespaces_brokers resource."""

    _NAME = 'namespaces_brokers'

    def __init__(self, client):
      super(AnthoseventsV1beta1.NamespacesBrokersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Rpc to create a new broker.

      Args:
        request: (AnthoseventsNamespacesBrokersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Broker) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1beta1/namespaces/{namespacesId}/brokers',
        http_method='POST',
        method_id='anthosevents.namespaces.brokers.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/eventing.knative.dev/v1beta1/{+parent}/brokers',
        request_field='broker',
        request_type_name='AnthoseventsNamespacesBrokersCreateRequest',
        response_type_name='Broker',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a broker.

      Args:
        request: (AnthoseventsNamespacesBrokersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1beta1/namespaces/{namespacesId}/brokers/{brokersId}',
        http_method='DELETE',
        method_id='anthosevents.namespaces.brokers.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/eventing.knative.dev/v1beta1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesBrokersDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a Broker.

      Args:
        request: (AnthoseventsNamespacesBrokersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Broker) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1beta1/namespaces/{namespacesId}/brokers/{brokersId}',
        http_method='GET',
        method_id='anthosevents.namespaces.brokers.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/eventing.knative.dev/v1beta1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesBrokersGetRequest',
        response_type_name='Broker',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list brokers.

      Args:
        request: (AnthoseventsNamespacesBrokersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListBrokersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1beta1/namespaces/{namespacesId}/brokers',
        http_method='GET',
        method_id='anthosevents.namespaces.brokers.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/eventing.knative.dev/v1beta1/{+parent}/brokers',
        request_field='',
        request_type_name='AnthoseventsNamespacesBrokersListRequest',
        response_type_name='ListBrokersResponse',
        supports_download=False,
    )

  class NamespacesCloudauditlogssourcesService(base_api.BaseApiService):
    """Service class for the namespaces_cloudauditlogssources resource."""

    _NAME = 'namespaces_cloudauditlogssources'

    def __init__(self, client):
      super(AnthoseventsV1beta1.NamespacesCloudauditlogssourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new cloudauditlogssource.

      Args:
        request: (AnthoseventsNamespacesCloudauditlogssourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudAuditLogsSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudauditlogssources',
        http_method='POST',
        method_id='anthosevents.namespaces.cloudauditlogssources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1beta1/{+parent}/cloudauditlogssources',
        request_field='cloudAuditLogsSource',
        request_type_name='AnthoseventsNamespacesCloudauditlogssourcesCreateRequest',
        response_type_name='CloudAuditLogsSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a cloudauditlogssource.

      Args:
        request: (AnthoseventsNamespacesCloudauditlogssourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudauditlogssources/{cloudauditlogssourcesId}',
        http_method='DELETE',
        method_id='anthosevents.namespaces.cloudauditlogssources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='apis/events.cloud.google.com/v1beta1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudauditlogssourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a cloudauditlogssource.

      Args:
        request: (AnthoseventsNamespacesCloudauditlogssourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudAuditLogsSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudauditlogssources/{cloudauditlogssourcesId}',
        http_method='GET',
        method_id='anthosevents.namespaces.cloudauditlogssources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1beta1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudauditlogssourcesGetRequest',
        response_type_name='CloudAuditLogsSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list cloudauditlogssources.

      Args:
        request: (AnthoseventsNamespacesCloudauditlogssourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudAuditLogsSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudauditlogssources',
        http_method='GET',
        method_id='anthosevents.namespaces.cloudauditlogssources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/events.cloud.google.com/v1beta1/{+parent}/cloudauditlogssources',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudauditlogssourcesListRequest',
        response_type_name='ListCloudAuditLogsSourcesResponse',
        supports_download=False,
    )

    def ReplaceCloudAuditLogsSource(self, request, global_params=None):
      r"""Rpc to replace a cloudauditlogssource. Only the spec and metadata labels and annotations are modifiable. After the Update request, Cloud Run will work to make the 'status' match the requested 'spec'. May provide metadata.resourceVersion to enforce update from last read for optimistic concurrency control.

      Args:
        request: (AnthoseventsNamespacesCloudauditlogssourcesReplaceCloudAuditLogsSourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudAuditLogsSource) The response message.
      """
      config = self.GetMethodConfig('ReplaceCloudAuditLogsSource')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceCloudAuditLogsSource.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudauditlogssources/{cloudauditlogssourcesId}',
        http_method='PUT',
        method_id='anthosevents.namespaces.cloudauditlogssources.replaceCloudAuditLogsSource',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1beta1/{+name}',
        request_field='cloudAuditLogsSource',
        request_type_name='AnthoseventsNamespacesCloudauditlogssourcesReplaceCloudAuditLogsSourceRequest',
        response_type_name='CloudAuditLogsSource',
        supports_download=False,
    )

  class NamespacesCloudpubsubsourcesService(base_api.BaseApiService):
    """Service class for the namespaces_cloudpubsubsources resource."""

    _NAME = 'namespaces_cloudpubsubsources'

    def __init__(self, client):
      super(AnthoseventsV1beta1.NamespacesCloudpubsubsourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new cloudpubsubsource.

      Args:
        request: (AnthoseventsNamespacesCloudpubsubsourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudPubSubSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudpubsubsources',
        http_method='POST',
        method_id='anthosevents.namespaces.cloudpubsubsources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1beta1/{+parent}/cloudpubsubsources',
        request_field='cloudPubSubSource',
        request_type_name='AnthoseventsNamespacesCloudpubsubsourcesCreateRequest',
        response_type_name='CloudPubSubSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a cloudpubsubsource.

      Args:
        request: (AnthoseventsNamespacesCloudpubsubsourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudpubsubsources/{cloudpubsubsourcesId}',
        http_method='DELETE',
        method_id='anthosevents.namespaces.cloudpubsubsources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='apis/events.cloud.google.com/v1beta1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudpubsubsourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a cloudpubsubsource.

      Args:
        request: (AnthoseventsNamespacesCloudpubsubsourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudPubSubSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudpubsubsources/{cloudpubsubsourcesId}',
        http_method='GET',
        method_id='anthosevents.namespaces.cloudpubsubsources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1beta1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudpubsubsourcesGetRequest',
        response_type_name='CloudPubSubSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list cloudpubsubsources.

      Args:
        request: (AnthoseventsNamespacesCloudpubsubsourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudPubSubSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudpubsubsources',
        http_method='GET',
        method_id='anthosevents.namespaces.cloudpubsubsources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/events.cloud.google.com/v1beta1/{+parent}/cloudpubsubsources',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudpubsubsourcesListRequest',
        response_type_name='ListCloudPubSubSourcesResponse',
        supports_download=False,
    )

    def ReplaceCloudPubSubSource(self, request, global_params=None):
      r"""Rpc to replace a cloudpubsubsource. Only the spec and metadata labels and annotations are modifiable. After the Update request, Cloud Run will work to make the 'status' match the requested 'spec'. May provide metadata.resourceVersion to enforce update from last read for optimistic concurrency control.

      Args:
        request: (AnthoseventsNamespacesCloudpubsubsourcesReplaceCloudPubSubSourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudPubSubSource) The response message.
      """
      config = self.GetMethodConfig('ReplaceCloudPubSubSource')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceCloudPubSubSource.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudpubsubsources/{cloudpubsubsourcesId}',
        http_method='PUT',
        method_id='anthosevents.namespaces.cloudpubsubsources.replaceCloudPubSubSource',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1beta1/{+name}',
        request_field='cloudPubSubSource',
        request_type_name='AnthoseventsNamespacesCloudpubsubsourcesReplaceCloudPubSubSourceRequest',
        response_type_name='CloudPubSubSource',
        supports_download=False,
    )

  class NamespacesCloudschedulersourcesService(base_api.BaseApiService):
    """Service class for the namespaces_cloudschedulersources resource."""

    _NAME = 'namespaces_cloudschedulersources'

    def __init__(self, client):
      super(AnthoseventsV1beta1.NamespacesCloudschedulersourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new cloudschedulersource.

      Args:
        request: (AnthoseventsNamespacesCloudschedulersourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudSchedulerSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudschedulersources',
        http_method='POST',
        method_id='anthosevents.namespaces.cloudschedulersources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1beta1/{+parent}/cloudschedulersources',
        request_field='cloudSchedulerSource',
        request_type_name='AnthoseventsNamespacesCloudschedulersourcesCreateRequest',
        response_type_name='CloudSchedulerSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a cloudschedulersource.

      Args:
        request: (AnthoseventsNamespacesCloudschedulersourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudschedulersources/{cloudschedulersourcesId}',
        http_method='DELETE',
        method_id='anthosevents.namespaces.cloudschedulersources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='apis/events.cloud.google.com/v1beta1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudschedulersourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a cloudschedulersource.

      Args:
        request: (AnthoseventsNamespacesCloudschedulersourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudSchedulerSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudschedulersources/{cloudschedulersourcesId}',
        http_method='GET',
        method_id='anthosevents.namespaces.cloudschedulersources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1beta1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudschedulersourcesGetRequest',
        response_type_name='CloudSchedulerSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list cloudschedulersources.

      Args:
        request: (AnthoseventsNamespacesCloudschedulersourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudSchedulerSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudschedulersources',
        http_method='GET',
        method_id='anthosevents.namespaces.cloudschedulersources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/events.cloud.google.com/v1beta1/{+parent}/cloudschedulersources',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudschedulersourcesListRequest',
        response_type_name='ListCloudSchedulerSourcesResponse',
        supports_download=False,
    )

    def ReplaceCloudSchedulerSource(self, request, global_params=None):
      r"""Rpc to replace a cloudschedulersource. Only the spec and metadata labels and annotations are modifiable. After the Update request, Cloud Run will work to make the 'status' match the requested 'spec'. May provide metadata.resourceVersion to enforce update from last read for optimistic concurrency control.

      Args:
        request: (AnthoseventsNamespacesCloudschedulersourcesReplaceCloudSchedulerSourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudSchedulerSource) The response message.
      """
      config = self.GetMethodConfig('ReplaceCloudSchedulerSource')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceCloudSchedulerSource.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudschedulersources/{cloudschedulersourcesId}',
        http_method='PUT',
        method_id='anthosevents.namespaces.cloudschedulersources.replaceCloudSchedulerSource',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1beta1/{+name}',
        request_field='cloudSchedulerSource',
        request_type_name='AnthoseventsNamespacesCloudschedulersourcesReplaceCloudSchedulerSourceRequest',
        response_type_name='CloudSchedulerSource',
        supports_download=False,
    )

  class NamespacesCloudstoragesourcesService(base_api.BaseApiService):
    """Service class for the namespaces_cloudstoragesources resource."""

    _NAME = 'namespaces_cloudstoragesources'

    def __init__(self, client):
      super(AnthoseventsV1beta1.NamespacesCloudstoragesourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new cloudstoragesource.

      Args:
        request: (AnthoseventsNamespacesCloudstoragesourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudStorageSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudstoragesources',
        http_method='POST',
        method_id='anthosevents.namespaces.cloudstoragesources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1beta1/{+parent}/cloudstoragesources',
        request_field='cloudStorageSource',
        request_type_name='AnthoseventsNamespacesCloudstoragesourcesCreateRequest',
        response_type_name='CloudStorageSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a cloudstoragesource.

      Args:
        request: (AnthoseventsNamespacesCloudstoragesourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudstoragesources/{cloudstoragesourcesId}',
        http_method='DELETE',
        method_id='anthosevents.namespaces.cloudstoragesources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='apis/events.cloud.google.com/v1beta1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudstoragesourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a cloudstoragesource.

      Args:
        request: (AnthoseventsNamespacesCloudstoragesourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudStorageSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudstoragesources/{cloudstoragesourcesId}',
        http_method='GET',
        method_id='anthosevents.namespaces.cloudstoragesources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1beta1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudstoragesourcesGetRequest',
        response_type_name='CloudStorageSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list cloudstoragesources.

      Args:
        request: (AnthoseventsNamespacesCloudstoragesourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCloudStorageSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudstoragesources',
        http_method='GET',
        method_id='anthosevents.namespaces.cloudstoragesources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/events.cloud.google.com/v1beta1/{+parent}/cloudstoragesources',
        request_field='',
        request_type_name='AnthoseventsNamespacesCloudstoragesourcesListRequest',
        response_type_name='ListCloudStorageSourcesResponse',
        supports_download=False,
    )

    def ReplaceCloudStorageSource(self, request, global_params=None):
      r"""Rpc to replace a cloudstoragesource. Only the spec and metadata labels and annotations are modifiable. After the Update request, Cloud Run will work to make the 'status' match the requested 'spec'. May provide metadata.resourceVersion to enforce update from last read for optimistic concurrency control.

      Args:
        request: (AnthoseventsNamespacesCloudstoragesourcesReplaceCloudStorageSourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CloudStorageSource) The response message.
      """
      config = self.GetMethodConfig('ReplaceCloudStorageSource')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceCloudStorageSource.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/events.cloud.google.com/v1beta1/namespaces/{namespacesId}/cloudstoragesources/{cloudstoragesourcesId}',
        http_method='PUT',
        method_id='anthosevents.namespaces.cloudstoragesources.replaceCloudStorageSource',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/events.cloud.google.com/v1beta1/{+name}',
        request_field='cloudStorageSource',
        request_type_name='AnthoseventsNamespacesCloudstoragesourcesReplaceCloudStorageSourceRequest',
        response_type_name='CloudStorageSource',
        supports_download=False,
    )

  class NamespacesCustomresourcedefinitionsService(base_api.BaseApiService):
    """Service class for the namespaces_customresourcedefinitions resource."""

    _NAME = 'namespaces_customresourcedefinitions'

    def __init__(self, client):
      super(AnthoseventsV1beta1.NamespacesCustomresourcedefinitionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a CustomResourceDefinition.

      Args:
        request: (AnthoseventsNamespacesCustomresourcedefinitionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CustomResourceDefinition) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/apiextensions.k8s.io/v1beta1/namespaces/{namespacesId}/customresourcedefinitions/{customresourcedefinitionsId}',
        http_method='GET',
        method_id='anthosevents.namespaces.customresourcedefinitions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/apiextensions.k8s.io/v1beta1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesCustomresourcedefinitionsGetRequest',
        response_type_name='CustomResourceDefinition',
        supports_download=False,
    )

  class NamespacesPingsourcesService(base_api.BaseApiService):
    """Service class for the namespaces_pingsources resource."""

    _NAME = 'namespaces_pingsources'

    def __init__(self, client):
      super(AnthoseventsV1beta1.NamespacesPingsourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new pingsource.

      Args:
        request: (AnthoseventsNamespacesPingsourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PingSource) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/sources.knative.dev/v1beta1/namespaces/{namespacesId}/pingsources',
        http_method='POST',
        method_id='anthosevents.namespaces.pingsources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/sources.knative.dev/v1beta1/{+parent}/pingsources',
        request_field='pingSource',
        request_type_name='AnthoseventsNamespacesPingsourcesCreateRequest',
        response_type_name='PingSource',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a pingsource.

      Args:
        request: (AnthoseventsNamespacesPingsourcesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/sources.knative.dev/v1beta1/namespaces/{namespacesId}/pingsources/{pingsourcesId}',
        http_method='DELETE',
        method_id='anthosevents.namespaces.pingsources.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='apis/sources.knative.dev/v1beta1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesPingsourcesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a pingsource.

      Args:
        request: (AnthoseventsNamespacesPingsourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PingSource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/sources.knative.dev/v1beta1/namespaces/{namespacesId}/pingsources/{pingsourcesId}',
        http_method='GET',
        method_id='anthosevents.namespaces.pingsources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['region'],
        relative_path='apis/sources.knative.dev/v1beta1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesPingsourcesGetRequest',
        response_type_name='PingSource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list pingsources.

      Args:
        request: (AnthoseventsNamespacesPingsourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListPingSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/sources.knative.dev/v1beta1/namespaces/{namespacesId}/pingsources',
        http_method='GET',
        method_id='anthosevents.namespaces.pingsources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/sources.knative.dev/v1beta1/{+parent}/pingsources',
        request_field='',
        request_type_name='AnthoseventsNamespacesPingsourcesListRequest',
        response_type_name='ListPingSourcesResponse',
        supports_download=False,
    )

    def ReplacePingSource(self, request, global_params=None):
      r"""Rpc to replace a pingsource. Only the spec and metadata labels and annotations are modifiable. After the Update request, Cloud Run will work to make the 'status' match the requested 'spec'. May provide metadata.resourceVersion to enforce update from last read for optimistic concurrency control.

      Args:
        request: (AnthoseventsNamespacesPingsourcesReplacePingSourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PingSource) The response message.
      """
      config = self.GetMethodConfig('ReplacePingSource')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplacePingSource.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/sources.knative.dev/v1beta1/namespaces/{namespacesId}/pingsources/{pingsourcesId}',
        http_method='PUT',
        method_id='anthosevents.namespaces.pingsources.replacePingSource',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/sources.knative.dev/v1beta1/{+name}',
        request_field='pingSource',
        request_type_name='AnthoseventsNamespacesPingsourcesReplacePingSourceRequest',
        response_type_name='PingSource',
        supports_download=False,
    )

  class NamespacesTriggersService(base_api.BaseApiService):
    """Service class for the namespaces_triggers resource."""

    _NAME = 'namespaces_triggers'

    def __init__(self, client):
      super(AnthoseventsV1beta1.NamespacesTriggersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new trigger.

      Args:
        request: (AnthoseventsNamespacesTriggersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Trigger) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1beta1/namespaces/{namespacesId}/triggers',
        http_method='POST',
        method_id='anthosevents.namespaces.triggers.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='apis/eventing.knative.dev/v1beta1/{+parent}/triggers',
        request_field='trigger',
        request_type_name='AnthoseventsNamespacesTriggersCreateRequest',
        response_type_name='Trigger',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a trigger.

      Args:
        request: (AnthoseventsNamespacesTriggersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1beta1/namespaces/{namespacesId}/triggers/{triggersId}',
        http_method='DELETE',
        method_id='anthosevents.namespaces.triggers.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='apis/eventing.knative.dev/v1beta1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesTriggersDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a trigger.

      Args:
        request: (AnthoseventsNamespacesTriggersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Trigger) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1beta1/namespaces/{namespacesId}/triggers/{triggersId}',
        http_method='GET',
        method_id='anthosevents.namespaces.triggers.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/eventing.knative.dev/v1beta1/{+name}',
        request_field='',
        request_type_name='AnthoseventsNamespacesTriggersGetRequest',
        response_type_name='Trigger',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list triggers.

      Args:
        request: (AnthoseventsNamespacesTriggersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTriggersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1beta1/namespaces/{namespacesId}/triggers',
        http_method='GET',
        method_id='anthosevents.namespaces.triggers.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='apis/eventing.knative.dev/v1beta1/{+parent}/triggers',
        request_field='',
        request_type_name='AnthoseventsNamespacesTriggersListRequest',
        response_type_name='ListTriggersResponse',
        supports_download=False,
    )

    def ReplaceTrigger(self, request, global_params=None):
      r"""Rpc to replace a trigger. Only the spec and metadata labels and annotations are modifiable. After the Update request, Events for Cloud Run will work to make the 'status' match the requested 'spec'. May provide metadata.resourceVersion to enforce update from last read for optimistic concurrency control.

      Args:
        request: (AnthoseventsNamespacesTriggersReplaceTriggerRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Trigger) The response message.
      """
      config = self.GetMethodConfig('ReplaceTrigger')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceTrigger.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='apis/eventing.knative.dev/v1beta1/namespaces/{namespacesId}/triggers/{triggersId}',
        http_method='PUT',
        method_id='anthosevents.namespaces.triggers.replaceTrigger',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='apis/eventing.knative.dev/v1beta1/{+name}',
        request_field='trigger',
        request_type_name='AnthoseventsNamespacesTriggersReplaceTriggerRequest',
        response_type_name='Trigger',
        supports_download=False,
    )

  class NamespacesService(base_api.BaseApiService):
    """Service class for the namespaces resource."""

    _NAME = 'namespaces'

    def __init__(self, client):
      super(AnthoseventsV1beta1.NamespacesService, self).__init__(client)
      self._upload_configs = {
          }
