/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AlphaComposite
implements Composite {
    private static final LinkedHashMap cache = new LinkedHashMap(11, 0.75f, true){
        private static final int MAX_CACHE_SIZE = 2048;

        protected final boolean removeEldestEntry(Map.Entry eldest) {
            boolean bl = false;
            if (this.size() > 2048) {
                bl = true;
            }
            return bl;
        }
    };
    public static final int CLEAR = 1;
    public static final int SRC = 2;
    public static final int DST = 9;
    public static final int SRC_OVER = 3;
    public static final int DST_OVER = 4;
    public static final int SRC_IN = 5;
    public static final int DST_IN = 6;
    public static final int SRC_OUT = 7;
    public static final int DST_OUT = 8;
    public static final int SRC_ATOP = 10;
    public static final int DST_ATOP = 11;
    public static final int XOR = 12;
    public static final AlphaComposite Clear = AlphaComposite.getInstance(1);
    public static final AlphaComposite Src = AlphaComposite.getInstance(2);
    public static final AlphaComposite Dst = AlphaComposite.getInstance(9);
    public static final AlphaComposite SrcOver = AlphaComposite.getInstance(3);
    public static final AlphaComposite DstOver = AlphaComposite.getInstance(4);
    public static final AlphaComposite SrcIn = AlphaComposite.getInstance(5);
    public static final AlphaComposite DstIn = AlphaComposite.getInstance(6);
    public static final AlphaComposite SrcOut = AlphaComposite.getInstance(7);
    public static final AlphaComposite DstOut = AlphaComposite.getInstance(8);
    public static final AlphaComposite SrcAtop = AlphaComposite.getInstance(10);
    public static final AlphaComposite DstAtop = AlphaComposite.getInstance(11);
    public static final AlphaComposite Xor = AlphaComposite.getInstance(12);
    private final int rule;
    private final float alpha;

    public static final AlphaComposite getInstance(int rule) {
        return AlphaComposite.getInstance(rule, 1.0f);
    }

    public static final AlphaComposite getInstance(int rule, float alpha) {
        if (rule < 1 || rule > 12 || !(alpha >= 0.0f) || !(alpha <= 1.0f)) {
            throw new IllegalArgumentException();
        }
        Long l = new Long((long)rule + Double.doubleToLongBits(alpha));
        AlphaComposite a = (AlphaComposite)cache.get(l);
        if (a == null) {
            a = new AlphaComposite(rule, alpha);
            cache.put(l, a);
        }
        return a;
    }

    public final CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        throw new Error("not implemented");
    }

    public final float getAlpha() {
        return this.alpha;
    }

    public final int getRule() {
        return this.rule;
    }

    public final int hashCode() {
        return 31 * Float.floatToIntBits(this.alpha) + this.rule;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof AlphaComposite)) {
            return false;
        }
        AlphaComposite a = (AlphaComposite)o;
        boolean bl = false;
        if (this.rule == a.rule && this.alpha == a.alpha) {
            bl = true;
        }
        return bl;
    }

    private AlphaComposite(int rule, float alpha) {
        this.rule = rule;
        this.alpha = alpha;
    }
}

