require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_NETINET_TCP_VAR_H_)) {
    eval 'sub _NETINET_TCP_VAR_H_ () {1;}' unless defined(&_NETINET_TCP_VAR_H_);
    if(defined(&_KERNEL_OPT)) {
	require './netinet/opt_inet.ph';
	require './netinet/opt_mbuftrace.ph';
    }
    require 'sys/callout.ph';
    if(defined(&TCP_SIGNATURE)) {
	eval 'sub TCP_SIGLEN () {16;}' unless defined(&TCP_SIGLEN);
	eval 'sub TCP_KEYLEN_MIN () {1;}' unless defined(&TCP_KEYLEN_MIN);
	eval 'sub TCP_KEYLEN_MAX () {80;}' unless defined(&TCP_KEYLEN_MAX);
	eval 'sub TCP_SIG_SPI () {0x1000;}' unless defined(&TCP_SIG_SPI);
    }
    eval 'sub ti_x1 () { ($ti_i->{ih_x1});}' unless defined(&ti_x1);
    eval 'sub ti_pr () { ($ti_i->{ih_pr});}' unless defined(&ti_pr);
    eval 'sub ti_len () { ($ti_i->{ih_len});}' unless defined(&ti_len);
    eval 'sub ti_src () { ($ti_i->{ih_src});}' unless defined(&ti_src);
    eval 'sub ti_dst () { ($ti_i->{ih_dst});}' unless defined(&ti_dst);
    eval 'sub ti_sport () { ($ti_t->{th_sport});}' unless defined(&ti_sport);
    eval 'sub ti_dport () { ($ti_t->{th_dport});}' unless defined(&ti_dport);
    eval 'sub ti_seq () { ($ti_t->{th_seq});}' unless defined(&ti_seq);
    eval 'sub ti_ack () { ($ti_t->{th_ack});}' unless defined(&ti_ack);
    eval 'sub ti_x2 () { ($ti_t->{th_x2});}' unless defined(&ti_x2);
    eval 'sub ti_off () { ($ti_t->{th_off});}' unless defined(&ti_off);
    eval 'sub ti_flags () { ($ti_t->{th_flags});}' unless defined(&ti_flags);
    eval 'sub ti_win () { ($ti_t->{th_win});}' unless defined(&ti_win);
    eval 'sub ti_sum () { ($ti_t->{th_sum});}' unless defined(&ti_sum);
    eval 'sub ti_urp () { ($ti_t->{th_urp});}' unless defined(&ti_urp);
    eval 'sub TF_ACKNOW () {0x1;}' unless defined(&TF_ACKNOW);
    eval 'sub TF_DELACK () {0x2;}' unless defined(&TF_DELACK);
    eval 'sub TF_NODELAY () {0x4;}' unless defined(&TF_NODELAY);
    eval 'sub TF_NOOPT () {0x8;}' unless defined(&TF_NOOPT);
    eval 'sub TF_REQ_SCALE () {0x20;}' unless defined(&TF_REQ_SCALE);
    eval 'sub TF_RCVD_SCALE () {0x40;}' unless defined(&TF_RCVD_SCALE);
    eval 'sub TF_REQ_TSTMP () {0x80;}' unless defined(&TF_REQ_TSTMP);
    eval 'sub TF_RCVD_TSTMP () {0x100;}' unless defined(&TF_RCVD_TSTMP);
    eval 'sub TF_SACK_PERMIT () {0x200;}' unless defined(&TF_SACK_PERMIT);
    eval 'sub TF_SYN_REXMT () {0x400;}' unless defined(&TF_SYN_REXMT);
    eval 'sub TF_WILL_SACK () {0x800;}' unless defined(&TF_WILL_SACK);
    eval 'sub TF_REASSEMBLING () {0x1000;}' unless defined(&TF_REASSEMBLING);
    eval 'sub TF_DEAD () {0x2000;}' unless defined(&TF_DEAD);
    eval 'sub TF_PMTUD_PEND () {0x4000;}' unless defined(&TF_PMTUD_PEND);
    eval 'sub TF_ECN_PERMIT () {0x10000;}' unless defined(&TF_ECN_PERMIT);
    eval 'sub TF_ECN_SND_CWR () {0x20000;}' unless defined(&TF_ECN_SND_CWR);
    eval 'sub TF_ECN_SND_ECE () {0x40000;}' unless defined(&TF_ECN_SND_ECE);
    eval 'sub TF_SIGNATURE () {0x400000;}' unless defined(&TF_SIGNATURE);
    eval 'sub TCPOOB_HAVEDATA () {0x1;}' unless defined(&TCPOOB_HAVEDATA);
    eval 'sub TCPOOB_HADDATA () {0x2;}' unless defined(&TCPOOB_HADDATA);
    eval 'sub TCP_SACK_MAX () {3;}' unless defined(&TCP_SACK_MAX);
    eval 'sub TCPSACK_NONE () {0;}' unless defined(&TCPSACK_NONE);
    eval 'sub TCPSACK_HAVED () {1;}' unless defined(&TCPSACK_HAVED);
    eval 'sub TCP_ECN_ALLOWED {
        my($tp) = @_;
	    eval q(( ($tp->{t_flags}) &  &TF_ECN_PERMIT));
    }' unless defined(&TCP_ECN_ALLOWED);
    eval 'sub TCP_SACK_ENABLED {
        my($tp) = @_;
	    eval q(( ($tp->{t_flags}) &  &TF_WILL_SACK));
    }' unless defined(&TCP_SACK_ENABLED);
    eval 'sub TCP_FACK_FASTRECOV {
        my($tp) = @_;
	    eval q(( &TCP_SACK_ENABLED($tp)  && ( &SEQ_GT( ($tp->{snd_fack}),  ($tp->{snd_una}) +  &tcprexmtthresh *  ($tp->{t_segsz})))));
    }' unless defined(&TCP_FACK_FASTRECOV);
    if(defined(&_KERNEL)) {
	eval 'sub tcp_reass_unlock {
	    my($tp) = @_;
    	    eval q({ \'int\'  &s;  &s =  &splvm();  &KASSERT(( ($tp->{t_flags}) &  &TF_REASSEMBLING) != 0);  ($tp->{t_flags}) &= ~ &TF_REASSEMBLING;  &splx( &s); });
	}' unless defined(&tcp_reass_unlock);
	if(defined(&DIAGNOSTIC)) {
	    eval 'sub TCP_REASS_LOCK {
	        my($tp) = @_;
    		eval q( &do {  &if ( &tcp_reass_lock_try($tp) == 0) {  &printf(\\"%s:%d: tcpcb %p reass already locked\\\\n\\",  &__FILE__,  &__LINE__, $tp);  &panic(\\"tcp_reass_lock\\"); } }  &while ( 0));
	    }' unless defined(&TCP_REASS_LOCK);
	    eval 'sub TCP_REASS_LOCK_CHECK {
	        my($tp) = @_;
    		eval q( &do {  &if ((($tp)-> &t_flags &  &TF_REASSEMBLING) == 0) {  &printf(\\"%s:%d: tcpcb %p reass lock not held\\\\n\\",  &__FILE__,  &__LINE__, $tp);  &panic(\\"tcp reass lock check\\"); } }  &while ( 0));
	    }' unless defined(&TCP_REASS_LOCK_CHECK);
	} else {
	    eval 'sub TCP_REASS_LOCK {
	        my($tp) = @_;
    		eval q(( &void)  &tcp_reass_lock_try(($tp)));
	    }' unless defined(&TCP_REASS_LOCK);
	    eval 'sub TCP_REASS_LOCK_CHECK {
	        my($tp) = @_;
    		eval q();
	    }' unless defined(&TCP_REASS_LOCK_CHECK);
	}
	eval 'sub TCP_REASS_UNLOCK {
	    my($tp) = @_;
    	    eval q( &tcp_reass_unlock(($tp)));
	}' unless defined(&TCP_REASS_UNLOCK);
    }
    if(defined(&_KERNEL)) {
	eval 'sub TCP_RESTART_DELACK {
	    my($tp) = @_;
    	    eval q( &callout_reset(($tp)-> &t_delack_ch,  &tcp_delack_ticks,  &tcp_delack, $tp));
	}' unless defined(&TCP_RESTART_DELACK);
	eval 'sub TCP_SET_DELACK {
	    my($tp) = @_;
    	    eval q( &do {  &if ((($tp)-> &t_flags &  &TF_DELACK) == 0) { ($tp)-> &t_flags |=  &TF_DELACK;  &TCP_RESTART_DELACK($tp); } }  &while ( 0));
	}' unless defined(&TCP_SET_DELACK);
	eval 'sub TCP_CLEAR_DELACK {
	    my($tp) = @_;
    	    eval q( &do {  &if (($tp)-> &t_flags &  &TF_DELACK) { ($tp)-> &t_flags &= ~ &TF_DELACK;  &callout_stop(($tp)-> &t_delack_ch); } }  &while ( 0));
	}' unless defined(&TCP_CLEAR_DELACK);
    }
    eval 'sub TCP_TIMESTAMP {
        my($tp) = @_;
	    eval q(( &tcp_now - ($tp)-> &ts_timebase));
    }' unless defined(&TCP_TIMESTAMP);
    eval 'sub TOF_SIGNATURE () {0x40;}' unless defined(&TOF_SIGNATURE);
    eval 'sub TOF_SIGLEN () {0x80;}' unless defined(&TOF_SIGLEN);
    if(1) {
    }
    eval 'sub SCF_UNREACH () {0x1;}' unless defined(&SCF_UNREACH);
    eval 'sub SCF_TIMESTAMP () {0x2;}' unless defined(&SCF_TIMESTAMP);
    eval 'sub SCF_DEAD () {0x4;}' unless defined(&SCF_DEAD);
    eval 'sub SCF_SACK_PERMIT () {0x8;}' unless defined(&SCF_SACK_PERMIT);
    eval 'sub SCF_ECN_PERMIT () {0x10;}' unless defined(&SCF_ECN_PERMIT);
    eval 'sub SCF_SIGNATURE () {0x40;}' unless defined(&SCF_SIGNATURE);
    eval 'sub intotcpcb {
        my($ip) = @_;
	    eval q((($ip)-> &inp_ppcb));
    }' unless defined(&intotcpcb);
    if(defined(&INET6)) {
	eval 'sub in6totcpcb {
	    my($ip) = @_;
    	    eval q((($ip)-> &in6p_ppcb));
	}' unless defined(&in6totcpcb);
    }
    unless(defined(&INET6)) {
	eval 'sub sototcpcb {
	    my($so) = @_;
    	    eval q(( &intotcpcb( &sotoinpcb($so))));
	}' unless defined(&sototcpcb);
    } else {
	eval 'sub sototcpcb {
	    my($so) = @_;
    	    eval q(((($so)-> ($so_proto->{pr_domain}->{dom_family}) ==  &AF_INET) ?  &intotcpcb( &sotoinpcb($so)) :  &in6totcpcb( &sotoin6pcb($so))));
	}' unless defined(&sototcpcb);
    }
    eval 'sub TCP_RTT_SHIFT () {3;}' unless defined(&TCP_RTT_SHIFT);
    eval 'sub TCP_RTTVAR_SHIFT () {2;}' unless defined(&TCP_RTTVAR_SHIFT);
    eval 'sub TCP_REXMTVAL {
        my($tp) = @_;
	    eval q((((($tp)-> &t_srtt >>  &TCP_RTT_SHIFT) + ($tp)-> &t_rttvar) >> 2));
    }' unless defined(&TCP_REXMTVAL);
    eval 'sub TCP_INITIAL_WINDOW {
        my($iw, $segsz) = @_;
	    eval q( &uimin(($iw) * ($segsz),  &uimax(2* ($segsz),  $tcp_init_win_max[($iw)])));
    }' unless defined(&TCP_INITIAL_WINDOW);
    eval 'sub TCP_STAT_CONNATTEMPT () {0;}' unless defined(&TCP_STAT_CONNATTEMPT);
    eval 'sub TCP_STAT_ACCEPTS () {1;}' unless defined(&TCP_STAT_ACCEPTS);
    eval 'sub TCP_STAT_CONNECTS () {2;}' unless defined(&TCP_STAT_CONNECTS);
    eval 'sub TCP_STAT_DROPS () {3;}' unless defined(&TCP_STAT_DROPS);
    eval 'sub TCP_STAT_CONNDROPS () {4;}' unless defined(&TCP_STAT_CONNDROPS);
    eval 'sub TCP_STAT_CLOSED () {5;}' unless defined(&TCP_STAT_CLOSED);
    eval 'sub TCP_STAT_SEGSTIMED () {6;}' unless defined(&TCP_STAT_SEGSTIMED);
    eval 'sub TCP_STAT_RTTUPDATED () {7;}' unless defined(&TCP_STAT_RTTUPDATED);
    eval 'sub TCP_STAT_DELACK () {8;}' unless defined(&TCP_STAT_DELACK);
    eval 'sub TCP_STAT_TIMEOUTDROP () {9;}' unless defined(&TCP_STAT_TIMEOUTDROP);
    eval 'sub TCP_STAT_REXMTTIMEO () {10;}' unless defined(&TCP_STAT_REXMTTIMEO);
    eval 'sub TCP_STAT_PERSISTTIMEO () {11;}' unless defined(&TCP_STAT_PERSISTTIMEO);
    eval 'sub TCP_STAT_KEEPTIMEO () {12;}' unless defined(&TCP_STAT_KEEPTIMEO);
    eval 'sub TCP_STAT_KEEPPROBE () {13;}' unless defined(&TCP_STAT_KEEPPROBE);
    eval 'sub TCP_STAT_KEEPDROPS () {14;}' unless defined(&TCP_STAT_KEEPDROPS);
    eval 'sub TCP_STAT_PERSISTDROPS () {15;}' unless defined(&TCP_STAT_PERSISTDROPS);
    eval 'sub TCP_STAT_CONNSDRAINED () {16;}' unless defined(&TCP_STAT_CONNSDRAINED);
    eval 'sub TCP_STAT_PMTUBLACKHOLE () {17;}' unless defined(&TCP_STAT_PMTUBLACKHOLE);
    eval 'sub TCP_STAT_SNDTOTAL () {18;}' unless defined(&TCP_STAT_SNDTOTAL);
    eval 'sub TCP_STAT_SNDPACK () {19;}' unless defined(&TCP_STAT_SNDPACK);
    eval 'sub TCP_STAT_SNDBYTE () {20;}' unless defined(&TCP_STAT_SNDBYTE);
    eval 'sub TCP_STAT_SNDREXMITPACK () {21;}' unless defined(&TCP_STAT_SNDREXMITPACK);
    eval 'sub TCP_STAT_SNDREXMITBYTE () {22;}' unless defined(&TCP_STAT_SNDREXMITBYTE);
    eval 'sub TCP_STAT_SNDACKS () {23;}' unless defined(&TCP_STAT_SNDACKS);
    eval 'sub TCP_STAT_SNDPROBE () {24;}' unless defined(&TCP_STAT_SNDPROBE);
    eval 'sub TCP_STAT_SNDURG () {25;}' unless defined(&TCP_STAT_SNDURG);
    eval 'sub TCP_STAT_SNDWINUP () {26;}' unless defined(&TCP_STAT_SNDWINUP);
    eval 'sub TCP_STAT_SNDCTRL () {27;}' unless defined(&TCP_STAT_SNDCTRL);
    eval 'sub TCP_STAT_RCVTOTAL () {28;}' unless defined(&TCP_STAT_RCVTOTAL);
    eval 'sub TCP_STAT_RCVPACK () {29;}' unless defined(&TCP_STAT_RCVPACK);
    eval 'sub TCP_STAT_RCVBYTE () {30;}' unless defined(&TCP_STAT_RCVBYTE);
    eval 'sub TCP_STAT_RCVBADSUM () {31;}' unless defined(&TCP_STAT_RCVBADSUM);
    eval 'sub TCP_STAT_RCVBADOFF () {32;}' unless defined(&TCP_STAT_RCVBADOFF);
    eval 'sub TCP_STAT_RCVMEMDROP () {33;}' unless defined(&TCP_STAT_RCVMEMDROP);
    eval 'sub TCP_STAT_RCVSHORT () {34;}' unless defined(&TCP_STAT_RCVSHORT);
    eval 'sub TCP_STAT_RCVDUPPACK () {35;}' unless defined(&TCP_STAT_RCVDUPPACK);
    eval 'sub TCP_STAT_RCVDUPBYTE () {36;}' unless defined(&TCP_STAT_RCVDUPBYTE);
    eval 'sub TCP_STAT_RCVPARTDUPPACK () {37;}' unless defined(&TCP_STAT_RCVPARTDUPPACK);
    eval 'sub TCP_STAT_RCVPARTDUPBYTE () {38;}' unless defined(&TCP_STAT_RCVPARTDUPBYTE);
    eval 'sub TCP_STAT_RCVOOPACK () {39;}' unless defined(&TCP_STAT_RCVOOPACK);
    eval 'sub TCP_STAT_RCVOOBYTE () {40;}' unless defined(&TCP_STAT_RCVOOBYTE);
    eval 'sub TCP_STAT_RCVPACKAFTERWIN () {41;}' unless defined(&TCP_STAT_RCVPACKAFTERWIN);
    eval 'sub TCP_STAT_RCVBYTEAFTERWIN () {42;}' unless defined(&TCP_STAT_RCVBYTEAFTERWIN);
    eval 'sub TCP_STAT_RCVAFTERCLOSE () {43;}' unless defined(&TCP_STAT_RCVAFTERCLOSE);
    eval 'sub TCP_STAT_RCVWINPROBE () {44;}' unless defined(&TCP_STAT_RCVWINPROBE);
    eval 'sub TCP_STAT_RCVDUPACK () {45;}' unless defined(&TCP_STAT_RCVDUPACK);
    eval 'sub TCP_STAT_RCVACKTOOMUCH () {46;}' unless defined(&TCP_STAT_RCVACKTOOMUCH);
    eval 'sub TCP_STAT_RCVACKPACK () {47;}' unless defined(&TCP_STAT_RCVACKPACK);
    eval 'sub TCP_STAT_RCVACKBYTE () {48;}' unless defined(&TCP_STAT_RCVACKBYTE);
    eval 'sub TCP_STAT_RCVWINUPD () {49;}' unless defined(&TCP_STAT_RCVWINUPD);
    eval 'sub TCP_STAT_PAWSDROP () {50;}' unless defined(&TCP_STAT_PAWSDROP);
    eval 'sub TCP_STAT_PREDACK () {51;}' unless defined(&TCP_STAT_PREDACK);
    eval 'sub TCP_STAT_PREDDAT () {52;}' unless defined(&TCP_STAT_PREDDAT);
    eval 'sub TCP_STAT_PCBHASHMISS () {53;}' unless defined(&TCP_STAT_PCBHASHMISS);
    eval 'sub TCP_STAT_NOPORT () {54;}' unless defined(&TCP_STAT_NOPORT);
    eval 'sub TCP_STAT_BADSYN () {55;}' unless defined(&TCP_STAT_BADSYN);
    eval 'sub TCP_STAT_DELAYED_FREE () {56;}' unless defined(&TCP_STAT_DELAYED_FREE);
    eval 'sub TCP_STAT_SC_ADDED () {57;}' unless defined(&TCP_STAT_SC_ADDED);
    eval 'sub TCP_STAT_SC_COMPLETED () {58;}' unless defined(&TCP_STAT_SC_COMPLETED);
    eval 'sub TCP_STAT_SC_TIMED_OUT () {59;}' unless defined(&TCP_STAT_SC_TIMED_OUT);
    eval 'sub TCP_STAT_SC_OVERFLOWED () {60;}' unless defined(&TCP_STAT_SC_OVERFLOWED);
    eval 'sub TCP_STAT_SC_RESET () {61;}' unless defined(&TCP_STAT_SC_RESET);
    eval 'sub TCP_STAT_SC_UNREACH () {62;}' unless defined(&TCP_STAT_SC_UNREACH);
    eval 'sub TCP_STAT_SC_BUCKETOVERFLOW () {63;}' unless defined(&TCP_STAT_SC_BUCKETOVERFLOW);
    eval 'sub TCP_STAT_SC_ABORTED () {64;}' unless defined(&TCP_STAT_SC_ABORTED);
    eval 'sub TCP_STAT_SC_DUPESYN () {65;}' unless defined(&TCP_STAT_SC_DUPESYN);
    eval 'sub TCP_STAT_SC_DROPPED () {66;}' unless defined(&TCP_STAT_SC_DROPPED);
    eval 'sub TCP_STAT_SC_COLLISIONS () {67;}' unless defined(&TCP_STAT_SC_COLLISIONS);
    eval 'sub TCP_STAT_SC_RETRANSMITTED () {68;}' unless defined(&TCP_STAT_SC_RETRANSMITTED);
    eval 'sub TCP_STAT_SC_DELAYED_FREE () {69;}' unless defined(&TCP_STAT_SC_DELAYED_FREE);
    eval 'sub TCP_STAT_SELFQUENCH () {70;}' unless defined(&TCP_STAT_SELFQUENCH);
    eval 'sub TCP_STAT_BADSIG () {71;}' unless defined(&TCP_STAT_BADSIG);
    eval 'sub TCP_STAT_GOODSIG () {72;}' unless defined(&TCP_STAT_GOODSIG);
    eval 'sub TCP_STAT_ECN_SHS () {73;}' unless defined(&TCP_STAT_ECN_SHS);
    eval 'sub TCP_STAT_ECN_CE () {74;}' unless defined(&TCP_STAT_ECN_CE);
    eval 'sub TCP_STAT_ECN_ECT () {75;}' unless defined(&TCP_STAT_ECN_ECT);
    eval 'sub TCP_NSTATS () {76;}' unless defined(&TCP_NSTATS);
    eval 'sub TCPCTL_RFC1323 () {1;}' unless defined(&TCPCTL_RFC1323);
    eval 'sub TCPCTL_SENDSPACE () {2;}' unless defined(&TCPCTL_SENDSPACE);
    eval 'sub TCPCTL_RECVSPACE () {3;}' unless defined(&TCPCTL_RECVSPACE);
    eval 'sub TCPCTL_MSSDFLT () {4;}' unless defined(&TCPCTL_MSSDFLT);
    eval 'sub TCPCTL_SYN_CACHE_LIMIT () {5;}' unless defined(&TCPCTL_SYN_CACHE_LIMIT);
    eval 'sub TCPCTL_SYN_BUCKET_LIMIT () {6;}' unless defined(&TCPCTL_SYN_BUCKET_LIMIT);
    if(0) {
	eval 'sub TCPCTL_SYN_CACHE_INTER () {7;}' unless defined(&TCPCTL_SYN_CACHE_INTER);
    }
    eval 'sub TCPCTL_INIT_WIN () {8;}' unless defined(&TCPCTL_INIT_WIN);
    eval 'sub TCPCTL_MSS_IFMTU () {9;}' unless defined(&TCPCTL_MSS_IFMTU);
    eval 'sub TCPCTL_SACK () {10;}' unless defined(&TCPCTL_SACK);
    eval 'sub TCPCTL_WSCALE () {11;}' unless defined(&TCPCTL_WSCALE);
    eval 'sub TCPCTL_TSTAMP () {12;}' unless defined(&TCPCTL_TSTAMP);
    if(0) {
	eval 'sub TCPCTL_COMPAT_42 () {13;}' unless defined(&TCPCTL_COMPAT_42);
    }
    eval 'sub TCPCTL_CWM () {14;}' unless defined(&TCPCTL_CWM);
    eval 'sub TCPCTL_CWM_BURSTSIZE () {15;}' unless defined(&TCPCTL_CWM_BURSTSIZE);
    eval 'sub TCPCTL_ACK_ON_PUSH () {16;}' unless defined(&TCPCTL_ACK_ON_PUSH);
    eval 'sub TCPCTL_KEEPIDLE () {17;}' unless defined(&TCPCTL_KEEPIDLE);
    eval 'sub TCPCTL_KEEPINTVL () {18;}' unless defined(&TCPCTL_KEEPINTVL);
    eval 'sub TCPCTL_KEEPCNT () {19;}' unless defined(&TCPCTL_KEEPCNT);
    eval 'sub TCPCTL_SLOWHZ () {20;}' unless defined(&TCPCTL_SLOWHZ);
    eval 'sub TCPCTL_NEWRENO () {21;}' unless defined(&TCPCTL_NEWRENO);
    eval 'sub TCPCTL_LOG_REFUSED () {22;}' unless defined(&TCPCTL_LOG_REFUSED);
    if(0) {
	eval 'sub TCPCTL_RSTRATELIMIT () {23;}' unless defined(&TCPCTL_RSTRATELIMIT);
    }
    eval 'sub TCPCTL_RSTPPSLIMIT () {24;}' unless defined(&TCPCTL_RSTPPSLIMIT);
    eval 'sub TCPCTL_DELACK_TICKS () {25;}' unless defined(&TCPCTL_DELACK_TICKS);
    eval 'sub TCPCTL_INIT_WIN_LOCAL () {26;}' unless defined(&TCPCTL_INIT_WIN_LOCAL);
    eval 'sub TCPCTL_IDENT () {27;}' unless defined(&TCPCTL_IDENT);
    eval 'sub TCPCTL_ACKDROPRATELIMIT () {28;}' unless defined(&TCPCTL_ACKDROPRATELIMIT);
    eval 'sub TCPCTL_LOOPBACKCKSUM () {29;}' unless defined(&TCPCTL_LOOPBACKCKSUM);
    eval 'sub TCPCTL_STATS () {30;}' unless defined(&TCPCTL_STATS);
    eval 'sub TCPCTL_DEBUG () {31;}' unless defined(&TCPCTL_DEBUG);
    eval 'sub TCPCTL_DEBX () {32;}' unless defined(&TCPCTL_DEBX);
    eval 'sub TCPCTL_DROP () {33;}' unless defined(&TCPCTL_DROP);
    eval 'sub TCPCTL_MSL () {34;}' unless defined(&TCPCTL_MSL);
    if(defined(&_KERNEL)) {
	if(defined(&MBUFTRACE)) {
	}
	if(defined(&INET6)) {
	}
	if(defined(&TCP_SIGNATURE)) {
	}
	if(defined(&INET6)) {
	}
	if(defined(&INET6)) {
	}
	if(defined(&INET6)) {
	}
	if(defined(&INET6)) {
	}
	if(defined(&TCP_SIGNATURE)) {
	}
	eval 'sub TCP_SACK_OPTLEN {
	    my($nblks) = @_;
    	    eval q((($nblks) * 8+ 2+ 2));
	}' unless defined(&TCP_SACK_OPTLEN);
    }
}
1;
