require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UVM_UVM_H_)) {
    eval 'sub _UVM_UVM_H_ () {1;}' unless defined(&_UVM_UVM_H_);
    if(defined(&_KERNEL_OPT)) {
	require './uvm/opt_lockdebug.ph';
	require './uvm/opt_multiprocessor.ph';
	require './uvm/opt_uvmhist.ph';
	require './uvm/opt_uvm_page_trkown.ph';
    }
    require 'uvm/uvm_extern.ph';
    if(defined(&_KERNEL)) {
	require 'uvm/uvm_stat.ph';
    }
    require 'uvm/uvm_amap.ph';
    require 'uvm/uvm_aobj.ph';
    require 'uvm/uvm_fault.ph';
    require 'uvm/uvm_glue.ph';
    require 'uvm/uvm_km.ph';
    require 'uvm/uvm_loan.ph';
    require 'uvm/uvm_map.ph';
    require 'uvm/uvm_object.ph';
    require 'uvm/uvm_page.ph';
    require 'uvm/uvm_pager.ph';
    require 'uvm/uvm_pdaemon.ph';
    require 'uvm/uvm_swap.ph';
    if(defined(&_KERNEL)) {
	require 'uvm/uvm_physseg.ph';
	require 'sys/rndsource.ph';
	require 'machine/vmparam.ph';
    }
    eval 'sub UVM_ET_OBJ () {0x1;}' unless defined(&UVM_ET_OBJ);
    eval 'sub UVM_ET_SUBMAP () {0x2;}' unless defined(&UVM_ET_SUBMAP);
    eval 'sub UVM_ET_COPYONWRITE () {0x4;}' unless defined(&UVM_ET_COPYONWRITE);
    eval 'sub UVM_ET_NEEDSCOPY () {0x8;}' unless defined(&UVM_ET_NEEDSCOPY);
    eval 'sub UVM_ET_ISOBJ {
        my($E) = @_;
	    eval q(((($E)-> &etype &  &UVM_ET_OBJ) != 0));
    }' unless defined(&UVM_ET_ISOBJ);
    eval 'sub UVM_ET_ISSUBMAP {
        my($E) = @_;
	    eval q(((($E)-> &etype &  &UVM_ET_SUBMAP) != 0));
    }' unless defined(&UVM_ET_ISSUBMAP);
    eval 'sub UVM_ET_ISCOPYONWRITE {
        my($E) = @_;
	    eval q(((($E)-> &etype &  &UVM_ET_COPYONWRITE) != 0));
    }' unless defined(&UVM_ET_ISCOPYONWRITE);
    eval 'sub UVM_ET_ISNEEDSCOPY {
        my($E) = @_;
	    eval q(((($E)-> &etype &  &UVM_ET_NEEDSCOPY) != 0));
    }' unless defined(&UVM_ET_ISNEEDSCOPY);
    if(defined(&_KERNEL)) {
	if(defined(&UVMHIST)) {
	}
	eval 'sub UVM_UNLOCK_AND_WAIT {
	    my($event, $slock, $intr, $msg, $timo) = @_;
    	    eval q( &do { ( &void)  &mtsleep($event,  &PVM |  &PNORELOCK | ($intr ?  &PCATCH : 0), $msg, $timo, $slock); }  &while ( 0));
	}' unless defined(&UVM_UNLOCK_AND_WAIT);
	if(defined(&UVM_PAGE_TRKOWN)) {
	    eval 'sub UVM_PAGE_OWN {
	        my($PG, $TAG) = @_;
    		eval q( &uvm_page_own($PG, $TAG));
	    }' unless defined(&UVM_PAGE_OWN);
	} else {
	    eval 'sub UVM_PAGE_OWN {
	        my($PG, $TAG) = @_;
    		eval q();
	    }' unless defined(&UVM_PAGE_OWN);
	}
	require 'uvm/uvm_fault_i.ph';
    }
}
1;
