#############################################################################
##
#W  compat42.g          GAP character table library             Thomas Breuer
##
#H  @(#)$Id: compat42.g,v 1.5 2001/11/27 09:20:16 gap Exp $
##
#Y  Copyright (C)  2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file contains the statements needed to replace the functions used in
##  the ``old'' character table library (located in the `tbl' directory)
##  by those in the ``new'' character library (located in `pkg/ctbllib').
##
Revision.( "ctbllib/gap/compat42_g" ) :=
    "@(#)$Id: compat42.g,v 1.5 2001/11/27 09:20:16 gap Exp $";


#############################################################################
##
##  Unassign variables that are assigned when the library functions are read.
##
for name in [
    # ctadmin.tbd
    "LIBTABLE", "SET_TABLEFILENAME", "GALOIS", "TENSOR", "EvalChars", "ALF",
    "ACM", "ARC", "NotifyNameOfCharacterTable", "NotifyCharacterTable",
    "MBT", "MOT", "GEN_Q_P", "PrimeBase", "LibInfoCharacterTable",
    "LibraryTables", "PartsBrauerTableName",
    "BasicSetBrauerTree", "DecMatBrauerTree", "BrauerTree",
    "BrauerTableFromLibrary", "CharacterTableSpecialized",
    "TransferComponentsToLibraryTableRecord", "TABLE_CONSTRUCTORS",
    "DeclareTableConstructor", "ConstructMixed", "ConstructMixedInfo",
    "ConstructProj", "ConstructProjInfo", "ConstructDirectProduct",
    "ConstructSubdirect", "ConstructIsoclinic", "ConstructV4G",
    "InducedLibraryCharacters", "ConstructGS3", "ConstructGS3Info",
    "ConstructPermuted", "ConstructFactor", "ConstructClifford",
    "UnpackedCll", "CllToClf", "OfThose", "IsSporadicSimple",
    "AllCharacterTableNames", "ShrinkClifford", "TextString",
    "BlanklessPrintTo", "ShrinkChars", "ClfToCll", "LibraryFusion",
    "PrintToLib", "PrintClmsToLib", "OrbitsResidueClass", "CASInfo",
    "SetCASInfo", "HasCASInfo", "Maxes", "SetMaxes", "HasMaxes",
    "GaloisPartnersOfIrreducibles", "AtlasLabelsOfIrreducibles",
    "IsLibTomRep",

    # ctadmin.tbi
    "ReadTbl", "RereadTbl", "ConsiderFactorBlocks", "PrintToLibOrdinary",
    "PrintToLibBrauer" ] do

  MakeReadWriteGlobal( name );
  UNBIND_GLOBAL( name );

od;

for name in [
    "ALN", "NotifyCharTable", "CharTableSpecialized", "AllCharTableNames",
    "CharTableLibrary", "FirstNameCharTable", "FileNameCharTable",
    "TOM_TBL_INFO" ] do

  UNBIND_GLOBAL( name );

od;


#############################################################################
##
##  Add improved methods needed in the table constructions.
##

#############################################################################
##
#M  CharacterTableIsoclinic( <ordtbl> ) . . . . . . . . for an ordinary table
##
InstallMethod( CharacterTableIsoclinic,
    "for an ordinary character table",
    [ IsOrdinaryTable ],
    function( tbl )
    local classes, half, kernel, orders, centre;

    # Identify the unique normal subgroup of index 2.
    half:= Size( tbl ) / 2;
    classes:= SizesConjugacyClasses( tbl );
    kernel:= Filtered( List( Filtered( Irr( tbl ),
                                       chi -> DegreeOfCharacter( chi ) = 1 ),
                             ClassPositionsOfKernel ),
                       ker -> Sum( classes{ ker }, 0 ) = half );

    # If there is more than one index 2 subgroup
    # and if there is a unique central subgroup $Z$ of order 2
    # then consider only those index 2 subgroups containing $Z$.
    if 1 < Length( kernel ) then
      orders:= OrdersClassRepresentatives( tbl );
      centre:= Filtered( [ 1 .. Length( classes ) ],
                         x -> classes[x] = 1 and orders[x] = 2 );
      if Length( centre ) = 1 then
        centre:= centre[1];
        kernel:= Filtered( kernel, ker -> centre in ker );
      fi;
    fi;
    if IsEmpty( kernel ) or 1 < Length( kernel ) then
      Error( "normal subgroup of index 2 not uniquely determined,\n",
             "use CharacterTableIsoclinic( <tbl>, <classes_of_nsg> )" );
    fi;

    # Delegate to the two-argument version.
    return CharacterTableIsoclinic( tbl, kernel[1] );
    end );


#############################################################################
##
#E

