/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.util.ArrayList;

public class GnuDSAPublicKey
implements DSAPublicKey {
    private byte[] encodedKey;
    BigInteger y;
    BigInteger p;
    BigInteger q;
    BigInteger g;

    public String getAlgorithm() {
        return "DSA";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        if (this.encodedKey != null) {
            return (byte[])this.encodedKey.clone();
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ArrayList spki = new ArrayList(2);
            ArrayList alg = new ArrayList(2);
            alg.add(new DERValue(6, new OID("1.2.840.113549.1.1.1")));
            ArrayList params = new ArrayList(3);
            params.add(new DERValue(2, this.p));
            params.add(new DERValue(2, this.q));
            params.add(new DERValue(2, this.g));
            alg.add(new DERValue(48, params));
            spki.add(new DERValue(48, alg));
            spki.add(new DERValue(3, new BitString(this.y.toByteArray())));
            DERWriter.write(out, new DERValue(48, spki));
            this.encodedKey = out.toByteArray();
            return (byte[])this.encodedKey.clone();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public DSAParams getParams() {
        if (this.p == null || this.q == null || this.g == null) {
            return null;
        }
        return new DSAParameterSpec(this.p, this.q, this.g);
    }

    public BigInteger getY() {
        return this.y;
    }

    public String toString() {
        return "GnuDSAPublicKey: y=" + (this.y != null ? this.y.toString(16) : "(null)") + " p=" + (this.p != null ? this.p.toString(16) : "(null)") + " q=" + (this.q != null ? this.q.toString(16) : "(null)") + " g=" + (this.g != null ? this.g.toString(16) : "(null)");
    }

    public GnuDSAPublicKey(BigInteger y, BigInteger p, BigInteger q, BigInteger g) {
        this.y = y;
        this.p = p;
        this.q = q;
        this.g = g;
    }
}

