/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;

public class SecretKeyFactory {
    private static final String SERVICE = "SecretKeyFactory";
    private SecretKeyFactorySpi skfSpi;
    private Provider provider;
    private String algorithm;

    public static final SecretKeyFactory getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] provs = Security.getProviders();
        int i = 0;
        while (i < provs.length) {
            try {
                return SecretKeyFactory.getInstance(algorithm, provs[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++i;
            }
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static final SecretKeyFactory getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return SecretKeyFactory.getInstance(algorithm, p);
    }

    public static final SecretKeyFactory getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        try {
            return new SecretKeyFactory((SecretKeyFactorySpi)Engine.getInstance(SERVICE, algorithm, provider), provider, algorithm);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() == null) {
                throw new NoSuchAlgorithmException(algorithm);
            }
            if (ite.getCause() instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ite.getCause();
            }
            throw new NoSuchAlgorithmException(algorithm);
        }
        catch (ClassCastException cce) {
            throw new NoSuchAlgorithmException(algorithm);
        }
    }

    public final SecretKey generateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.skfSpi.engineGenerateSecret(keySpec);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final KeySpec getKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        return this.skfSpi.engineGetKeySpec(key, keySpec);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final SecretKey translateKey(SecretKey key) throws InvalidKeyException {
        return this.skfSpi.engineTranslateKey(key);
    }

    protected SecretKeyFactory(SecretKeyFactorySpi skfSpi, Provider provider, String algorithm) {
        this.skfSpi = skfSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }
}

