;Generates place names in Swedish. Created and maintained by Erik
;Sigra (sigra@home.se).
;
;This would benefit a lot from a replace rule!

(game-module "ng-swedish"
  (blurb "Random Swedish place name synthesizer")
  )

(namer swedish-place-names
  (grammar root 100
    (root (reject name   krakra lvlv
		       bergberg borgborg by
		       daldal
		       fltflt forsfors
		       hemhem
		       hemhus
		       hemlsa ;Means "homeless" (plural)
		       hemstad ;Means "homecity
		       hghg
		       hghus  ;Means "highouse"
		       hushem
		       hushg  ;Means "pile of houses"
		       hultshult hushus
		       karlekarle kullakulla
		       laxlax leklek
		       markmark markamarka
		       sandsand sjsj slttsltt smjl stensten
		       strmstrm strmstrm sundsund
		       vivi vikvik
		       rrr ;Norrryd
		       ttt ;Sltttuna
	  )
    )    
    (name (or 16 mainpart
	      1 (preword " " (capitalize mainpart))
	  )
    )
    (mainpart (or 8 (prefix suffix)
                    (prefix middle suffix)
	          2 (complete)
              )
    )
    (prefix (or ;Color
		svart bl grn gul rd brun vit
	        
		;Age
		ny gammel
		
		;Preposition
  	        ver ;Capitalized because automatic capitalization
                     ;doesn't work for this letter.
		neder
		
		;Size
		stor lill
		
		;Direction
	        nord nordan norr
		st stan ster
		sder syd sydan vst
	        vstan vster vest ;Vestfjrd

		;Personal firstname
		adolfs bengts everts fredriks karls oskars tyres
		
		;Other
		 kers alings lv ar s
		b back berg bjr bjrne bjurs bjus bor borg brahe
		brm brunns
		dal djurs
		eke em en
		fgel flt fin finn fogd fors fr furu
		gr gte glimminge gran	grnges	gryt
		halls halm han haninge helsing hem hg horn hults hus
		jn
		karle ki klags kol kors krono kulla kvarn kyrk
		lapp lax lek lem lin ling lule lycke
		malm mr marie mark marka mjl morgon mln mrt munk
		myckel
		nck nden
		ockel d om on re ox oxel
		p pite
		rfs rg rtt ronne ro run
		sg salt sand sibb side sig simris sj skattung sltt
		sol sollefte sollen stll sten strm stock sund sve
		svine
		tll tammer tand tv tran troll
		udde ule ulvs ume unn upp
		vm var vr vet vikar vin ving vir
		ytter
            )
    )
    (suffix (or  ker kra lv s
		bck bcka backe baden berg berga bjrka borg bo ble
		bro bruk by byn
		dal dala dalen
		flt fjrd fors fred
		grd grden grde grdet grda gva ;Morgongva
		haga hamn httan hed heden hem hg hult hus hyttan
		kalix kping kulla kvarn kvarna kyrka
		landa lax lsa lycke
		mark marka mo myra
		ns nset
		
		ryd
		sala sand stra sj sltt slott sta stad sten stig
		strm sund
		tjrn torp trsk tuna vattnet
		valla vi vik
	    )
    )
    (middle (or  kra ;Fyll p!
		by
		fors
		karle
		lek lycke
		mjl
		ns
		sj strm
	    )
    )
    (complete (or alfta lvho nge artsj
		  bcka bjus bjuv bomarsund borlnge
		  dals-ed dsjebro
		  falun floda fgl
		  gagnef glimminge gustavs
		  habo hamra haninge hede hr huddinge
		  idre
		  jakobstad jrna
		  kalix kalmar kvlinge kkar kvidinge
		  lima los lund
		  malung mora mrkret motala
		  nacka nora
		  ore orsa
		  slen srna skanr skvde solv svalv sveg
		  tierp tuna
		  vasa vxj vendel
 	      )
    )
    (preword (or ;Color
		 svarta bla grna gula rda bruna vita
		 
		 ;Age
		 16 nya 16 gamla
		 
		 ;Preposition
		 16 vre 16 nedre

		 ;Size
		 16 stora 16 lilla
		 
		 ;Direction
		 16 norra 16 stra 16 sdra 16 vstra
	     )
    )
  )
)

#| uncomment to test

(set see-all true)

(unit-type city
  (name "city")
  (image-name "city20")
  (help "A city")
  (namer "swedish-place-names")
  (acp-per-turn 1)
  (vision-range 100)
  (start-with 100)
)

(terrain-type default (image-name "black"))

(set sides-min 1)
(set sides-max 1)
(set country-radius-min 20)
|#
