/* example3.c -- Demonstration of 3-D graphics.
 * This program presents a picture of a three-dimensional
 * wire frame model of the outside of a simulated thunderstorm.
 * The storm may be viewed from various perspectives.
 * The program calls a portable graphics program specified
 * by the first command line argument and alternates between
 * asking for a perspective position and drawing the resulting
 * view of the cloud.  Exit with a ^C.
 */
#include <stdio.h>
#include <math.h>
#include "pgraf.h"
#define NX 20
#define NY 20
#define NZ 10
int ix,iy,iz,i;
float ref[NX][NY][NZ],plane[NX][NY],xp,yp,zp,zoom,xloc,yloc,
  xdiam,ydiam,x,y,z,bx[5],by[5],bz[5],orig[3],xa[3],ya[3];
main(argc,argv)
int argc;
char *argv[];
{
/* check argument */
  if (argc != 2) {
    fprintf(stderr,"Usage: radar pg_program\n");
    fprintf(stderr,"     Suggested initial perspective point and zoom:\n");
    fprintf(stderr,"          -10 -40 20 3\n");
    exit(0);
  }
/* define cloud reflectivity */
  for (iz = 0; iz < NZ; iz++) {
    z = iz/10.;
    xloc = 6. - 2.*z + 10.*z*z*z;
    yloc = 10. + z;
    xdiam = 3. + 8.*z*z;
    ydiam = 6.;
    for (ix = 0; ix < NX; ix++) {
      for (iy = 0; iy < NY; iy++) {
        x = ix;
        y = iy;
        x = (x - xloc)/xdiam;
        y = (y - yloc)/ydiam;
        ref[ix][iy][iz] = exp(-x*x - y*y);
      }
    }
  }
/* define base plate */
  for (i = 0; i < 5; i++) bx[i] = by[i] = bz[i] = 0.;
  bx[2] = bx[3] = 20.;
  by[1] = by[2] = 20.;
/* loop forever */
  xp = yp = zp = zoom = 0.;
  while (1) {
/* get perspective point and zoom */
    printf("type xp,yp,zp,zoom (%.1f %.1f %.1f %.1f last used): ",
      xp,yp,zp,zoom);
    scanf("%f%f%f%f",&xp,&yp,&zp,&zoom);
/* do graphics */
    gopen();
    gclear();
    window(1,0.,15.,0.,10.);
/* set up perspective and view points and set the zoom */
    pview(1,xp,yp,zp,10.,10.,5.,zoom);
/* base plate and labels */
/* storm is contained in box 0-20 in x and y and 0-10 in z */
    pline(1,1,5,bx,by,bz);
    plabel(1,10.,-2.,0.,"x");
    plabel(1,-2.,10.,0.,"y");
/* reflectivity = 0.5 contour drawn at each level */
    for (i = 0; i < 3; i++) xa[i] = ya[i] = orig[i] = 0.;
    xa[0] = ya[1] = 20.;
    for (iz = 0; iz < NZ; iz++) {
      for (ix = 0; ix < NX; ix++) {
        for (iy = 0; iy < NY; iy++) {
          plane[ix][iy] = ref[ix][iy][iz];
        }
      }
      orig[2] = iz;
      pconto(1,1,NX,NY,.5,plane,orig,xa,ya);
    }
    gpause();
    gclose();
    system(argv[1]);
  }
}
