/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import java.util.ArrayList;
import java.util.List;

public class CommandLineTokenizer {
    private CommandLineTokenizer() {
    }

    private static void appendToBuffer(List resultBuffer, StringBuffer buf) {
        if (buf.length() > 0) {
            resultBuffer.add(buf.toString());
            buf.setLength(0);
        }
    }

    public static String[] tokenize(String commandLine) {
        ArrayList resultBuffer = new ArrayList();
        if (commandLine != null) {
            int z = commandLine.length();
            boolean insideQuotes = false;
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < z; ++i) {
                char c = commandLine.charAt(i);
                if (c == '\"') {
                    CommandLineTokenizer.appendToBuffer(resultBuffer, buf);
                    insideQuotes = !insideQuotes;
                    continue;
                }
                if (c == '\\') {
                    if (z > i + 1 && (commandLine.charAt(i + 1) == '\"' || commandLine.charAt(i + 1) == '\\')) {
                        buf.append(commandLine.charAt(i + 1));
                        ++i;
                        continue;
                    }
                    buf.append("\\");
                    continue;
                }
                if (insideQuotes) {
                    buf.append(c);
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    CommandLineTokenizer.appendToBuffer(resultBuffer, buf);
                    continue;
                }
                buf.append(c);
            }
            CommandLineTokenizer.appendToBuffer(resultBuffer, buf);
        }
        String[] result = new String[resultBuffer.size()];
        return resultBuffer.toArray(result);
    }
}

