/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Date
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 7523967970034938905L;
    private static final String[] weekNames = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] monthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private transient long time;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public static long UTC(int year, int month, int date, int hrs, int min, int sec) {
        GregorianCalendar cal = new GregorianCalendar(year + 1900, month, date, hrs, min, sec);
        cal.set(15, 0);
        cal.set(16, 0);
        return cal.getTimeInMillis();
    }

    public long getTime() {
        return this.time;
    }

    public int getTimezoneOffset() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        return -(cal.get(15) + cal.get(16)) / 60000;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public boolean after(Date when) {
        boolean bl = false;
        if (this.time > when.time) {
            bl = true;
        }
        return bl;
    }

    public boolean before(Date when) {
        boolean bl = false;
        if (this.time < when.time) {
            bl = true;
        }
        return bl;
    }

    public boolean equals(Object obj) {
        boolean bl = false;
        if (obj instanceof Date && this.time == ((Date)obj).time) {
            bl = true;
        }
        return bl;
    }

    public int compareTo(Date when) {
        int n;
        if (this.time < when.time) {
            n = -1;
        } else {
            int n2 = 0;
            if (this.time == when.time) {
                n2 = 1;
            }
            n = 1 - n2;
        }
        return n;
    }

    public int compareTo(Object obj) {
        return this.compareTo((Date)obj);
    }

    public int hashCode() {
        return (int)this.time ^ (int)(this.time >>> 32);
    }

    public String toString() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        String day = "0" + cal.get(5);
        String hour = "0" + cal.get(11);
        String min = "0" + cal.get(12);
        String sec = "0" + cal.get(13);
        String year = "000" + cal.get(1);
        return weekNames[cal.get(7) - 1] + ' ' + monthNames[cal.get(2)] + ' ' + day.substring(day.length() - 2) + ' ' + hour.substring(hour.length() - 2) + ':' + min.substring(min.length() - 2) + ':' + sec.substring(sec.length() - 2) + ' ' + cal.getTimeZone().getDisplayName(cal.getTimeZone().inDaylightTime(this), 0) + ' ' + year.substring(year.length() - 4);
    }

    public String toLocaleString() {
        return DateFormat.getInstance().format(this);
    }

    public String toGMTString() {
        DateFormat format = DateFormat.getInstance();
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(this);
    }

    private static final int parseTz(String tok, char sign) throws IllegalArgumentException {
        int num;
        try {
            num = Integer.parseInt(tok.substring(1));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(tok);
        }
        num = num < 24 ? (num *= 60) : num / 100 * 60 + num % 100;
        return sign == '-' ? -num : num;
    }

    private static final int parseMonth(String tok) {
        String[] months = new String[]{"JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"};
        int i = 0;
        while (i < 12) {
            if (months[i].startsWith(tok)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static final boolean parseDayOfWeek(String tok) {
        String[] daysOfWeek = new String[]{"SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY"};
        int i = 0;
        while (i < 7) {
            if (daysOfWeek[i].startsWith(tok)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static long parse(String string) {
        int year = -1;
        int month = -1;
        int day = -1;
        int hour = -1;
        int minute = -1;
        int second = -1;
        int timezone = 0;
        boolean localTimezone = true;
        StringBuffer buf = new StringBuffer();
        int parenNesting = 0;
        int len = string.length();
        int i = 0;
        while (i < len) {
            char ch = string.charAt(i);
            if (ch >= 'a' && ch <= 'z') {
                ch = (char)(ch - 32);
            }
            if (ch == '(') {
                ++parenNesting;
            } else if (parenNesting == 0) {
                buf.append(ch);
            } else if (ch == ')') {
                --parenNesting;
            }
            ++i;
        }
        StringTokenizer strtok = new StringTokenizer(buf.toString(), " \t\n\r,");
        while (strtok.hasMoreTokens()) {
            String tok = strtok.nextToken();
            char firstch = tok.charAt(0);
            if ((firstch == '+' || firstch == '-') && year >= 0) {
                timezone = Date.parseTz(tok, firstch);
                localTimezone = false;
                continue;
            }
            if (firstch >= '0' && firstch <= '9') {
                while (tok != null && tok.length() > 0) {
                    int punct;
                    int punctOffset = tok.length();
                    int num = 0;
                    int i2 = 0;
                    while (true) {
                        if (i2 >= punctOffset) {
                            punct = -1;
                            break;
                        }
                        punct = tok.charAt(i2);
                        if (punct < 48 || punct > 57) {
                            punctOffset = i2;
                            break;
                        }
                        if (num > 999999999) {
                            throw new IllegalArgumentException(tok);
                        }
                        num = 10 * num + (punct - 48);
                        ++i2;
                    }
                    if (punct == 58) {
                        if (hour < 0) {
                            hour = num;
                        } else {
                            minute = num;
                        }
                    } else if (num >= 70 && (punct == 32 || punct == 44 || punct == 47 || punct < 0) || num < 70 && day >= 0 && month >= 0 && year < 0) {
                        if (num >= 100) {
                            year = num;
                        } else {
                            int curYear = 1900 + new Date().getYear();
                            int firstYear = curYear - 80;
                            year = firstYear / 100 * 100 + num;
                            if (year < firstYear) {
                                year += 100;
                            }
                        }
                    } else if (punct == 47) {
                        if (month < 0) {
                            month = num - 1;
                        } else {
                            day = num;
                        }
                    } else if (hour >= 0 && minute < 0) {
                        minute = num;
                    } else if (minute >= 0 && second < 0) {
                        second = num;
                    } else if (day < 0) {
                        day = num;
                    } else {
                        throw new IllegalArgumentException(tok);
                    }
                    tok = punct < 0 || punctOffset + 1 >= tok.length() ? null : tok.substring(punctOffset + 1);
                }
                continue;
            }
            if (firstch >= 'A' && firstch <= 'Z') {
                if (tok.equals("AM")) {
                    if (hour < 1 || hour > 12) {
                        throw new IllegalArgumentException(tok);
                    }
                    if (hour != 12) continue;
                    hour = 0;
                    continue;
                }
                if (tok.equals("PM")) {
                    if (hour < 1 || hour > 12) {
                        throw new IllegalArgumentException(tok);
                    }
                    if (hour >= 12) continue;
                    hour += 12;
                    continue;
                }
                if (Date.parseDayOfWeek(tok)) continue;
                if (tok.equals("UT") || tok.equals("UTC") || tok.equals("GMT")) {
                    localTimezone = false;
                    continue;
                }
                if (tok.startsWith("UT") || tok.startsWith("GMT")) {
                    char sign;
                    int signOffset = 3;
                    if (tok.charAt(1) == 'T' && tok.charAt(2) != 'C') {
                        signOffset = 2;
                    }
                    if ((sign = tok.charAt(signOffset)) != '+' && sign != '-') {
                        throw new IllegalArgumentException(tok);
                    }
                    timezone = Date.parseTz(tok.substring(signOffset), sign);
                    localTimezone = false;
                    continue;
                }
                int tmpMonth = Date.parseMonth(tok);
                if (tmpMonth >= 0) {
                    month = tmpMonth;
                    continue;
                }
                if (tok.length() == 3 && tok.charAt(2) == 'T') {
                    char ch = tok.charAt(0);
                    if (ch == 'E') {
                        timezone = -300;
                    } else if (ch == 'C') {
                        timezone = -360;
                    } else if (ch == 'M') {
                        timezone = -420;
                    } else if (ch == 'P') {
                        timezone = -480;
                    } else {
                        throw new IllegalArgumentException(tok);
                    }
                    if (tok.charAt(1) == 'D') {
                        timezone += 60;
                    } else if (tok.charAt(1) != 'S') {
                        throw new IllegalArgumentException(tok);
                    }
                    localTimezone = false;
                    continue;
                }
                throw new IllegalArgumentException(tok);
            }
            throw new IllegalArgumentException(tok);
        }
        if (hour < 0) {
            hour = 0;
        }
        if (minute < 0) {
            minute = 0;
        }
        if (second < 0) {
            second = 0;
        }
        if (year < 0 || month < 0 || day < 0) {
            throw new IllegalArgumentException("Missing field");
        }
        GregorianCalendar cal = new GregorianCalendar(year, month, day, hour, minute, second);
        if (!localTimezone) {
            cal.set(15, timezone * 60 * 1000);
            cal.set(16, 0);
        }
        return cal.getTimeInMillis();
    }

    public int getYear() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        return cal.get(1) - 1900;
    }

    public void setYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        cal.set(1, 1900 + year);
        this.time = cal.getTimeInMillis();
    }

    public int getMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        return cal.get(2);
    }

    public void setMonth(int month) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        cal.set(2, month);
        this.time = cal.getTimeInMillis();
    }

    public int getDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        return cal.get(5);
    }

    public void setDate(int date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        cal.set(5, date);
        this.time = cal.getTimeInMillis();
    }

    public int getDay() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        return cal.get(7) - 1;
    }

    public int getHours() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        return cal.get(11);
    }

    public void setHours(int hours) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        cal.set(11, hours);
        this.time = cal.getTimeInMillis();
    }

    public int getMinutes() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        return cal.get(12);
    }

    public void setMinutes(int minutes) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        cal.set(12, minutes);
        this.time = cal.getTimeInMillis();
    }

    public int getSeconds() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        return cal.get(13);
    }

    public void setSeconds(int seconds) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.time);
        cal.set(13, seconds);
        this.time = cal.getTimeInMillis();
    }

    private final void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.time = input.readLong();
    }

    private final void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        output.writeLong(this.time);
    }

    public Date() {
        this.time = System.currentTimeMillis();
    }

    public Date(long time) {
        this.time = time;
    }

    public Date(int year, int month, int day) {
        this(year, month, day, 0, 0, 0);
    }

    public Date(int year, int month, int day, int hour, int min) {
        this(year, month, day, hour, min, 0);
    }

    public Date(int year, int month, int day, int hour, int min, int sec) {
        GregorianCalendar cal = new GregorianCalendar(year + 1900, month, day, hour, min, sec);
        this.time = cal.getTimeInMillis();
    }

    public Date(String s) {
        this.time = Date.parse(s);
    }
}

