/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc.dialects;

import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.intermediate.DBExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateSession;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.util.ReflectionUtilRt;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class BigQueryIntermediateFacade
extends JdbcIntermediateFacade {
    private static final Logger LOG = Logger.getLogger(BigQueryIntermediateFacade.class.getName());
    private static final String CONNECTION_INFO_QUERY = "select catalog_name from INFORMATION_SCHEMA.SCHEMATA limit 1;";

    public BigQueryIntermediateFacade(@NotNull JdbcConnectionProvider dataSource, @NotNull DBExceptionRecognizer exceptionRecognizer, @NotNull JdbcHelperImpl helper) {
        if (dataSource == null) {
            BigQueryIntermediateFacade.$$$reportNull$$$0(0);
        }
        if (exceptionRecognizer == null) {
            BigQueryIntermediateFacade.$$$reportNull$$$0(1);
        }
        if (helper == null) {
            BigQueryIntermediateFacade.$$$reportNull$$$0(2);
        }
        super(dataSource, exceptionRecognizer, helper);
    }

    @Override
    public ConnectionInfo obtainConnectionInfoNatively() {
        JdbcIntermediateSession session = this.openSession();
        try {
            ConnectionInfo connectionInfo = new ConnectionInfo(BigQueryIntermediateFacade.getDatabase(session), BigQueryIntermediateFacade.getSchema(session), null);
            return connectionInfo;
        }
        finally {
            session.close();
        }
    }

    private static String getDatabase(JdbcIntermediateSession session) {
        String database = BigQueryIntermediateFacade.getDatabaseViaQuery(session);
        if (database != null) {
            return database;
        }
        return BigQueryIntermediateFacade.getDatabaseViaReflection(session);
    }

    private static String getDatabaseViaQuery(JdbcIntermediateSession session) {
        String[] env = session.queryOneRow(CONNECTION_INFO_QUERY, 1, String.class);
        if (env == null) {
            LOG.warning("Session info should not be null");
            return null;
        }
        return env[0];
    }

    private static String getDatabaseViaReflection(JdbcIntermediateSession session) {
        return BigQueryIntermediateFacade.getConnectionSetting(session, "m_projectId");
    }

    private static String getSchema(JdbcIntermediateSession session) {
        return BigQueryIntermediateFacade.getConnectionSetting(session, "m_defaultDataSet");
    }

    private static String getConnectionSetting(JdbcIntermediateSession session, @NotNull String name) {
        if (name == null) {
            BigQueryIntermediateFacade.$$$reportNull$$$0(3);
        }
        Object bqConnection = ReflectionHelper.tryInvokeMethod(session.getConnection(), "getConnection", null, null);
        Object settings = ReflectionHelper.tryInvokeMethod(bqConnection, "getSettings", null, null);
        return (String)ReflectionUtilRt.getField(settings.getClass(), (Object)settings, String.class, (String)name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionRecognizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/dialects/BigQueryIntermediateFacade";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getConnectionSetting";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

