/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VertJdbcHelper
extends JdbcHelperImpl {
    public VertJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("VERTICA", version, connection);
    }

    public VertJdbcHelper() {
        this(null, null);
    }

    @Override
    public boolean isZonedTimestampColumn(@Nullable String typeName, int jdbcType) {
        if ("timestamptz".equalsIgnoreCase(typeName)) {
            return true;
        }
        return super.isZonedTimestampColumn(typeName, jdbcType);
    }

    @Override
    public boolean isZonedTimeColumn(@Nullable String typeName) {
        if ("timetz".equalsIgnoreCase(typeName)) {
            return true;
        }
        return super.isZonedTimeColumn(typeName);
    }

    @Override
    public int fixScale(int type, int precision, int scale) {
        if (type == 92) {
            return precision - 9;
        }
        return super.fixScale(type, precision, scale);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return VertJdbcHelper.extractVersion(version);
    }

    @Nullable
    public static String extractVersion(@Nullable String version) {
        return JdbcNativeUtil.findVersion(version, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) {
        if (!JdbcNativeUtil.detectString(product, "vertica")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return VertJdbcHelper.create(delegate, productVer);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            VertJdbcHelper.$$$reportNull$$$0(0);
        }
        return VertJdbcHelper.classNameContains(driver, "com.vertica.");
    }

    @Override
    protected void setDriverLogLevel(Driver driver, Properties properties, @Nullable Level level, @Nullable String logPath) {
        super.setDriverLogLevel(driver, properties, level, logPath);
        VertJdbcHelper.setIfEmpty(properties, "LogNameSpace", "com.vertica");
        if (level != null) {
            VertJdbcHelper.setIfEmpty(properties, "LogLevel", level.intValue() >= Level.OFF.intValue() ? "OFF" : (level.intValue() >= Level.SEVERE.intValue() ? "ERROR" : (level.intValue() >= Level.WARNING.intValue() ? "WARNING" : (level.intValue() >= Level.INFO.intValue() ? "INFO" : (level.intValue() >= Level.FINE.intValue() ? "DEBUG" : "TRACE")))));
        }
        if (logPath != null) {
            VertJdbcHelper.setIfEmpty(properties, "LogPath", logPath);
        }
    }

    @NotNull
    static VertJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new VertJdbcHelper(VertJdbcHelper.extractVersion(productVer), delegate);
    }

    @Override
    public boolean supportsIlike() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/remote/jdbc/helpers/VertJdbcHelper", "detect"));
    }
}

