/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.framework;

import com.jetbrains.rd.framework.AbstractBuffer;
import com.jetbrains.rd.framework.PlatformDependentKt;
import com.jetbrains.rd.framework.RdId;
import com.jetbrains.rd.framework.SocketWire;
import com.jetbrains.rd.framework.SocketWireKt;
import com.jetbrains.rd.framework.UnsafeBuffer;
import com.jetbrains.rd.framework.base.WireBase;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.AddRemove;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.IViewableSet;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rd.util.reactive.ViewableSet;
import com.jetbrains.rd.util.threading.ByteBufferAsyncProcessor;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.CharsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000 \u00052\u00020\u0001:\u0006\u0003\u0004\u0005\u0006\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rd/framework/SocketWire;", "", "()V", "Base", "Client", "Companion", "Server", "ServerFactory", "WireParameters", "rd-framework"})
public final class SocketWire {
    @NotNull
    private static final Duration timeout;
    private static final int ack_msg_len = -1;
    private static final int ping_len = -2;
    private static final int pkg_header_len = 12;
    @NotNull
    public static final String disconnectedPauseReason = "Socket not connected";
    public static final int maximumHeartbeatDelay = 3;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        Duration duration = Duration.ofMillis(500L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ofMillis(500)");
        timeout = duration;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001HB\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u0002072\u0006\u0010;\u001a\u00020-H\u0002J$\u0010<\u001a\u0002072\u0006\u0010\u0002\u001a\u00020=2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002070?H\u0016J\u0010\u0010@\u001a\u0002072\u0006\u0010A\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u0002072\u0006\u0010D\u001a\u00020\u001eH\u0002J\u0010\u0010E\u001a\u0002072\u0006\u0010D\u001a\u00020\u001eH\u0002J\b\u0010F\u001a\u00020GH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u00102\u001a&\u0012\f\u0012\n 5*\u0004\u0018\u00010404 5*\u0012\u0012\f\u0012\n 5*\u0004\u0018\u00010404\u0018\u00010303X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/jetbrains/rd/framework/SocketWire$Base;", "Lcom/jetbrains/rd/framework/base/WireBase;", "id", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "(Ljava/lang/String;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/reactive/IScheduler;)V", "ackPkgHeader", "Lcom/jetbrains/rd/framework/AbstractBuffer;", "acktor", "Ljava/util/concurrent/ExecutorService;", "getAcktor", "()Ljava/util/concurrent/ExecutorService;", "counterpartNotionTimestamp", "", "counterpartTimestamp", "currentTimeStamp", "getId", "()Ljava/lang/String;", "lock", "Ljava/lang/Object;", "getLock", "()Ljava/lang/Object;", "logger", "Lcom/jetbrains/rd/util/Logger;", "getLogger", "()Lcom/jetbrains/rd/util/Logger;", "maxReceivedSeqn", "", "output", "Ljava/io/OutputStream;", "pkgInput", "Ljava/io/InputStream;", "sendBuffer", "Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor;", "getSendBuffer", "()Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor;", "sendPingPkgHeader", "sendPkgHeader", "sentSeqn", "socketInput", "socketProvider", "Lcom/jetbrains/rd/util/reactive/OptProperty;", "Ljava/net/Socket;", "getSocketProvider", "()Lcom/jetbrains/rd/util/reactive/OptProperty;", "socketSendLock", "", "threadLocalBufferArray", "Ljava/lang/ThreadLocal;", "Lcom/jetbrains/rd/framework/UnsafeBuffer;", "kotlin.jvm.PlatformType", "ping", "", "readMsg", "", "receiverProc", "socket", "send", "Lcom/jetbrains/rd/framework/RdId;", "writer", "Lkotlin/Function1;", "send0", "chunk", "Lcom/jetbrains/rd/util/threading/ByteBufferAsyncProcessor$Chunk;", "sendAck", "seqn", "sendAck0", "startHeartbeat", "Lkotlinx/coroutines/Job;", "PkgInputStream", "rd-framework"})
    public static abstract class Base
    extends WireBase {
        @NotNull
        private final Logger logger;
        @NotNull
        private final OptProperty<Socket> socketProvider;
        private OutputStream output;
        private InputStream socketInput;
        private InputStream pkgInput;
        @NotNull
        private final ByteBufferAsyncProcessor sendBuffer;
        private final ThreadLocal<UnsafeBuffer> threadLocalBufferArray;
        @NotNull
        private final ExecutorService acktor;
        @NotNull
        private final Object lock;
        private long maxReceivedSeqn;
        private long sentSeqn;
        private final Object socketSendLock;
        private final AbstractBuffer sendPkgHeader;
        private final AbstractBuffer ackPkgHeader;
        private int currentTimeStamp;
        private int counterpartTimestamp;
        private int counterpartNotionTimestamp;
        private final AbstractBuffer sendPingPkgHeader;
        @NotNull
        private final String id;
        private final Lifetime lifetime;

        @NotNull
        protected final Logger getLogger() {
            return this.logger;
        }

        @NotNull
        public final OptProperty<Socket> getSocketProvider() {
            return this.socketProvider;
        }

        @NotNull
        protected final ByteBufferAsyncProcessor getSendBuffer() {
            return this.sendBuffer;
        }

        @NotNull
        public final ExecutorService getAcktor() {
            return this.acktor;
        }

        private final void sendAck(long seqn) {
            boolean $i$f$catchAndDrop = false;
            try {
                boolean bl = false;
                this.acktor.execute(new Runnable(this, seqn){
                    final /* synthetic */ Base this$0;
                    final /* synthetic */ long $seqn$inlined;
                    {
                        this.this$0 = base;
                        this.$seqn$inlined = l;
                    }

                    public final void run() {
                        Base.access$sendAck0(this.this$0, this.$seqn$inlined);
                    }
                });
            }
            catch (Throwable throwable) {
            }
        }

        @NotNull
        protected final Object getLock() {
            return this.lock;
        }

        private final Job startHeartbeat() {
            return BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ Base this$0;

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $this$launch = this.p$;
lbl7:
                            // 2 sources

                            while (true) {
                                this.L$0 = $this$launch;
                                this.label = 1;
                                v0 = DelayKt.delay((long)this.this$0.getHeartbeatIntervalMs(), (Continuation)this);
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl18
                                break;
                            }
                        }
                        case 1: {
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl18:
                            // 2 sources

                            Base.access$ping(this.this$0);
                            ** continue;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = base;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value2;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void ping() {
            boolean $i$f$catchAndDrop = false;
            try {
                boolean bl = false;
                if (!Companion.connectionEstablished(this.currentTimeStamp, this.counterpartNotionTimestamp)) {
                    if (((Boolean)this.getHeartbeatAlive().getValue()).booleanValue()) {
                        void $this$log$iv$iv;
                        Logger $this$trace$iv = this.logger;
                        boolean $i$f$trace = false;
                        Logger logger = $this$trace$iv;
                        LogLevel level$iv$iv = LogLevel.Trace;
                        boolean $i$f$log = false;
                        if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                            LogLevel logLevel = level$iv$iv;
                            void var9_13 = $this$log$iv$iv;
                            boolean bl2 = false;
                            String string = "Disconnect detected while sending PING " + this.id + ": " + "currentTimeStamp: " + this.currentTimeStamp + ", " + "counterpartTimestamp: " + this.counterpartTimestamp + ", " + "counterpartNotionTimestamp: " + this.counterpartNotionTimestamp;
                            var9_13.log(logLevel, (Object)string, null);
                        }
                    }
                    this.getHeartbeatAlive().setValue((Object)false);
                }
                Object object = this.socketSendLock;
                boolean bl3 = false;
                boolean bl4 = false;
                synchronized (object) {
                    boolean bl5 = false;
                    this.sendPingPkgHeader.reset();
                    this.sendPingPkgHeader.writeInt(-2);
                    this.sendPingPkgHeader.writeInt(this.currentTimeStamp);
                    this.sendPingPkgHeader.writeInt(this.counterpartTimestamp);
                    OutputStream outputStream = this.output;
                    if (outputStream == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                    }
                    outputStream.write(this.sendPingPkgHeader.getArray());
                    Unit unit = Unit.INSTANCE;
                }
                Base base = this;
                ++base.currentTimeStamp;
                int cfr_ignored_0 = base.currentTimeStamp;
            }
            catch (Throwable throwable) {
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void receiverProc(Socket socket) {
            while (RLifetimeKt.isAlive((Lifetime)this.lifetime)) {
                try {
                    if (!socket.isConnected()) {
                        void $this$log$iv$iv;
                        Logger $this$debug$iv = this.logger;
                        boolean $i$f$debug = false;
                        Logger logger = $this$debug$iv;
                        LogLevel level$iv$iv = LogLevel.Debug;
                        boolean $i$f$log = false;
                        if (!$this$log$iv$iv.isEnabled(level$iv$iv)) break;
                        LogLevel logLevel = level$iv$iv;
                        void var10_20 = $this$log$iv$iv;
                        boolean bl = false;
                        String string = "Stop receive messages because socket disconnected";
                        var10_20.log(logLevel, (Object)string, null);
                        break;
                    }
                    if (this.readMsg()) continue;
                    Logger $this$debug$iv = this.logger;
                    boolean $i$f$debug = false;
                    Logger $this$log$iv$iv = $this$debug$iv;
                    LogLevel level$iv$iv = LogLevel.Debug;
                    boolean $i$f$log = false;
                    if (!$this$log$iv$iv.isEnabled(level$iv$iv)) break;
                    LogLevel logLevel = level$iv$iv;
                    Logger logger = $this$log$iv$iv;
                    boolean bl = false;
                    String string = this.id + ": Connection was gracefully shutdown";
                    logger.log(logLevel, (Object)string, null);
                }
                catch (Throwable ex) {
                    Throwable throwable = ex;
                    if (throwable instanceof SocketException || throwable instanceof EOFException || throwable instanceof IOException) {
                        void $this$log$iv$iv;
                        Logger $this$debug$iv = this.logger;
                        boolean $i$f$debug = false;
                        Logger $i$f$log = $this$debug$iv;
                        LogLevel level$iv$iv = LogLevel.Debug;
                        boolean $i$f$log2 = false;
                        if (!$this$log$iv$iv.isEnabled(level$iv$iv)) break;
                        LogLevel logLevel = level$iv$iv;
                        void var10_22 = $this$log$iv$iv;
                        boolean bl = false;
                        String string = "Exception in SocketWire.Receive:  " + this.id + ": " + ex;
                        var10_22.log(logLevel, (Object)string, null);
                        break;
                    }
                    LoggerKt.error((Logger)this.logger, (String)(this.id + " caught processing"), (Throwable)ex);
                }
                break;
            }
        }

        private final boolean readMsg() {
            long seqnAtStart = this.maxReceivedSeqn;
            InputStream inputStream = this.pkgInput;
            if (inputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pkgInput");
            }
            Integer n = SocketWireKt.access$readInt32(inputStream);
            if (n == null) {
                return false;
            }
            int len = n;
            boolean bl = len > 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "len > 0: " + len;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = len < 300000000;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Possible OOM: array_len=").append(len).append("(0x");
                int n2 = len;
                int n3 = 16;
                boolean bl6 = false;
                String string = Integer.toString(n2, CharsKt.checkRadix((int)n3));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
                String string2 = stringBuilder.append(string).append(')').toString();
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            byte[] data = new byte[len];
            InputStream inputStream2 = this.pkgInput;
            if (inputStream2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pkgInput");
            }
            if (!SocketWireKt.access$readByteArray(inputStream2, data)) {
                return false;
            }
            if (this.maxReceivedSeqn > seqnAtStart) {
                long responseSeqn = this.maxReceivedSeqn;
                this.sendAck(responseSeqn);
            }
            UnsafeBuffer unsafeBuffer = new UnsafeBuffer(data);
            RdId id = RdId.Companion.read(unsafeBuffer);
            this.getMessageBroker().dispatch(id, unsafeBuffer);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void sendAck0(long seqn) {
            block6: {
                try {
                    this.ackPkgHeader.reset();
                    this.ackPkgHeader.writeInt(-1);
                    this.ackPkgHeader.writeLong(seqn);
                    Object object = this.socketSendLock;
                    boolean bl = false;
                    boolean bl2 = false;
                    synchronized (object) {
                        boolean bl3 = false;
                        OutputStream outputStream = this.output;
                        if (outputStream == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                        }
                        outputStream.write(this.ackPkgHeader.getArray(), 0, 12);
                        Unit unit = Unit.INSTANCE;
                    }
                }
                catch (SocketException ex) {
                    void $this$log$iv$iv;
                    Logger $this$warn$iv = this.logger;
                    boolean $i$f$warn = false;
                    Logger bl3 = $this$warn$iv;
                    LogLevel level$iv$iv = LogLevel.Warn;
                    boolean $i$f$log = false;
                    if (!$this$log$iv$iv.isEnabled(level$iv$iv)) break block6;
                    LogLevel logLevel = level$iv$iv;
                    void var10_15 = $this$log$iv$iv;
                    boolean bl = false;
                    String string = this.id + ": Exception raised during ACK, seqn = " + seqn;
                    var10_15.log(logLevel, (Object)string, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void send0(ByteBufferAsyncProcessor.Chunk chunk) {
            try {
                if (chunk.isNotProcessed()) {
                    Base base = this;
                    ++base.sentSeqn;
                    chunk.setSeqn(base.sentSeqn);
                }
                this.sendPkgHeader.reset();
                this.sendPkgHeader.writeInt(chunk.getPtr());
                this.sendPkgHeader.writeLong(chunk.getSeqn());
                Object object = this.socketSendLock;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    void $this$log$iv$iv;
                    boolean bl3 = false;
                    Logger $this$trace$iv = this.logger;
                    boolean $i$f$trace = false;
                    Logger logger = $this$trace$iv;
                    LogLevel level$iv$iv = LogLevel.Trace;
                    boolean $i$f$log = false;
                    if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                        LogLevel logLevel = level$iv$iv;
                        void var12_15 = $this$log$iv$iv;
                        boolean bl4 = false;
                        String string = "Send package with seqn " + chunk.getSeqn();
                        var12_15.log(logLevel, (Object)string, null);
                    }
                    OutputStream outputStream = this.output;
                    if (outputStream == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                    }
                    outputStream.write(this.sendPkgHeader.getArray(), 0, 12);
                    OutputStream outputStream2 = this.output;
                    if (outputStream2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                    }
                    outputStream2.write(chunk.getData(), 0, chunk.getPtr());
                    Unit unit = Unit.INSTANCE;
                }
            }
            catch (SocketException ex) {
                this.sendBuffer.pause(SocketWire.disconnectedPauseReason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(@NotNull RdId id, @NotNull Function1<? super AbstractBuffer, Unit> writer) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(writer, (String)"writer");
            boolean bl = !id.isNull();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "id mustn't be null";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            UnsafeBuffer unsafeBuffer = this.threadLocalBufferArray.get();
            int initialPosition = unsafeBuffer.getPosition();
            try {
                unsafeBuffer.writeInt(0);
                UnsafeBuffer unsafeBuffer2 = unsafeBuffer;
                Intrinsics.checkNotNullExpressionValue((Object)unsafeBuffer2, (String)"unsafeBuffer");
                id.write(unsafeBuffer2);
                this.getContexts().writeCurrentMessageContext(unsafeBuffer);
                writer.invoke((Object)unsafeBuffer);
                int len = unsafeBuffer.getPosition() - initialPosition;
                unsafeBuffer.setPosition(initialPosition);
                unsafeBuffer.writeInt(len - 4);
                byte[] bytes = unsafeBuffer.getArray();
                this.sendBuffer.put(bytes, initialPosition, len);
            }
            finally {
                if (initialPosition == 0) {
                    unsafeBuffer.reset();
                } else {
                    unsafeBuffer.setPosition(initialPosition);
                }
            }
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        protected Base(@NotNull String id, @NotNull Lifetime lifetime, final @NotNull IScheduler scheduler) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
            super(scheduler);
            this.id = id;
            this.lifetime = lifetime;
            this.logger = LoggerKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(this.getClass()));
            this.socketProvider = new OptProperty();
            this.sendBuffer = new ByteBufferAsyncProcessor(this.id + "/Sender", 0, (Function1)new Function1<ByteBufferAsyncProcessor.Chunk, Unit>(this){

                public final void invoke(@NotNull ByteBufferAsyncProcessor.Chunk p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Base.access$send0((Base)this.receiver, p1);
                }
            }, 2, null);
            this.threadLocalBufferArray = ThreadLocal.withInitial(threadLocalBufferArray.1.INSTANCE);
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"Executors.newSingleThreadExecutor()");
            this.acktor = executorService;
            this.lock = new Object();
            this.sendBuffer.pause(SocketWire.disconnectedPauseReason);
            this.sendBuffer.start();
            this.getConnected().advise(this.lifetime, (Function1)new Function1<Boolean, Unit>(){

                public final void invoke(boolean it) {
                    this.getHeartbeatAlive().setValue((Object)it);
                }
            });
            this.socketProvider.advise(this.lifetime, (Function1)new Function1<Socket, Unit>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull Socket socket) {
                    void $this$log$iv$iv22;
                    Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
                    Object $this$debug$iv = this.getLogger();
                    int $i$f$debug = 0;
                    Logger logger = $this$debug$iv;
                    LogLevel level$iv$iv22 = LogLevel.Debug;
                    boolean $i$f$log = false;
                    if ($this$log$iv$iv22.isEnabled(level$iv$iv22)) {
                        LogLevel logLevel = level$iv$iv22;
                        void var8_13 = $this$log$iv$iv22;
                        boolean bl = false;
                        String string = this.getId() + " : connected";
                        var8_13.log(logLevel, (Object)string, null);
                    }
                    OutputStream outputStream = socket.getOutputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"socket.outputStream");
                    output = outputStream;
                    InputStream inputStream = socket.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"socket.inputStream");
                    $this$debug$iv = inputStream;
                    $i$f$debug = 8192;
                    boolean $this$log$iv$iv22 = false;
                    socketInput = $this$debug$iv instanceof BufferedInputStream ? (BufferedInputStream)$this$debug$iv : new BufferedInputStream((InputStream)$this$debug$iv, $i$f$debug);
                    pkgInput = new PkgInputStream(Base.access$getSocketInput$p(this));
                    this.getSendBuffer().reprocessUnacknowledged();
                    this.getSendBuffer().resume(SocketWire.disconnectedPauseReason);
                    Job heartbeatJob = this.startHeartbeat();
                    scheduler.queue((Function0)new Function0<Unit>(){

                        public final void invoke() {
                            this.getConnected().setValue((Object)true);
                        }
                    });
                    try {
                        this.receiverProc(socket);
                    }
                    catch (Throwable throwable) {
                        scheduler.queue((Function0)new Function0<Unit>(this){
                            final /* synthetic */ 2 this$0;

                            public final void invoke() {
                                this.this$0.this.getConnected().setValue((Object)false);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                        Job.DefaultImpls.cancel$default((Job)heartbeatJob, null, (int)1, null);
                        this.getSendBuffer().pause(SocketWire.disconnectedPauseReason);
                        boolean $i$f$catchAndDrop = false;
                        try {
                            boolean bl = false;
                            socket.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    scheduler.queue((Function0)new /* invalid duplicate definition of identical inner class */);
                    Job.DefaultImpls.cancel$default((Job)heartbeatJob, null, (int)1, null);
                    this.getSendBuffer().pause(SocketWire.disconnectedPauseReason);
                    boolean $i$f$catchAndDrop = false;
                    try {
                        boolean bl = false;
                        socket.close();
                    }
                    catch (Throwable level$iv$iv22) {
                    }
                }
            });
            this.socketSendLock = new Object();
            this.sendPkgHeader = PlatformDependentKt.createAbstractBuffer();
            this.ackPkgHeader = PlatformDependentKt.createAbstractBuffer();
            this.sendPingPkgHeader = PlatformDependentKt.createAbstractBuffer();
        }

        public static final /* synthetic */ void access$setCurrentTimeStamp$p(Base $this, int n) {
            $this.currentTimeStamp = n;
        }

        public static final /* synthetic */ void access$sendAck0(Base $this, long seqn) {
            $this.sendAck0(seqn);
        }

        public static final /* synthetic */ void access$ping(Base $this) {
            $this.ping();
        }

        public static final /* synthetic */ void access$send0(Base $this, ByteBufferAsyncProcessor.Chunk chunk) {
            $this.send0(chunk);
        }

        public static final /* synthetic */ OutputStream access$getOutput$p(Base $this) {
            OutputStream outputStream = $this.output;
            if (outputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"output");
            }
            return outputStream;
        }

        public static final /* synthetic */ InputStream access$getSocketInput$p(Base $this) {
            InputStream inputStream = $this.socketInput;
            if (inputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"socketInput");
            }
            return inputStream;
        }

        public static final /* synthetic */ InputStream access$getPkgInput$p(Base $this) {
            InputStream inputStream = $this.pkgInput;
            if (inputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pkgInput");
            }
            return inputStream;
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u000bH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rd/framework/SocketWire$Base$PkgInputStream;", "Ljava/io/InputStream;", "stream", "(Lcom/jetbrains/rd/framework/SocketWire$Base;Ljava/io/InputStream;)V", "pkg", "", "getPkg", "()[B", "setPkg", "([B)V", "pos", "", "getPos", "()I", "setPos", "(I)V", "read", "rd-framework"})
        public final class PkgInputStream
        extends InputStream {
            @NotNull
            private byte[] pkg;
            private int pos;
            private final InputStream stream;

            @NotNull
            public final byte[] getPkg() {
                return this.pkg;
            }

            public final void setPkg(@NotNull byte[] byArray) {
                Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
                this.pkg = byArray;
            }

            public final int getPos() {
                return this.pos;
            }

            public final void setPos(int n) {
                this.pos = n;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int read() {
                if (this.pos < this.pkg.length) {
                    int n = this.pos;
                    this.pos = n + 1;
                    return this.pkg[n] & 0xFF;
                }
                while (true) {
                    Integer n = SocketWireKt.access$readInt32(this.stream);
                    if (n == null) {
                        return -1;
                    }
                    int len = n;
                    if (len == -2) {
                        Integer n2 = SocketWireKt.access$readInt32(this.stream);
                        if (n2 == null) {
                            return -1;
                        }
                        int receivedTimestamp = n2;
                        Integer n3 = SocketWireKt.access$readInt32(this.stream);
                        if (n3 == null) {
                            return -1;
                        }
                        int receivedCounterpartTimestamp = n3;
                        Base.this.counterpartTimestamp = receivedTimestamp;
                        Base.this.counterpartNotionTimestamp = receivedCounterpartTimestamp;
                        if (!Companion.connectionEstablished(Base.this.currentTimeStamp, Base.this.counterpartNotionTimestamp)) continue;
                        if (!((Boolean)Base.this.getHeartbeatAlive().getValue()).booleanValue()) {
                            void $this$log$iv$iv;
                            Logger $this$trace$iv = Base.this.getLogger();
                            boolean $i$f$trace = false;
                            Logger logger = $this$trace$iv;
                            LogLevel level$iv$iv = LogLevel.Trace;
                            boolean $i$f$log = false;
                            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                                LogLevel logLevel = level$iv$iv;
                                void var11_18 = $this$log$iv$iv;
                                boolean bl = false;
                                String string = "Connection is alive after receiving PING " + Base.this.getId() + ": " + "receivedTimestamp: " + receivedTimestamp + ", " + "receivedCounterpartTimestamp: " + receivedCounterpartTimestamp + "currentTimeStamp: " + Base.this.currentTimeStamp + ", " + "counterpartTimestamp: " + Base.this.counterpartTimestamp + ", " + "counterpartNotionTimestamp: " + Base.this.counterpartNotionTimestamp;
                                var11_18.log(logLevel, (Object)string, null);
                            }
                        }
                        Base.this.getHeartbeatAlive().setValue((Object)true);
                        continue;
                    }
                    Long l = SocketWireKt.access$readInt64(this.stream);
                    if (l == null) {
                        return -1;
                    }
                    long seqn = l;
                    if (len == -1) {
                        Base.this.getSendBuffer().acknowledge(seqn);
                        continue;
                    }
                    int n4 = len > 0 ? 1 : 0;
                    boolean bl = false;
                    boolean bl2 = false;
                    if (n4 == 0) {
                        boolean bl3 = false;
                        String string = "len > 0: " + len;
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    n4 = len < 300000000 ? 1 : 0;
                    bl = false;
                    bl2 = false;
                    if (n4 == 0) {
                        boolean bl4 = false;
                        StringBuilder stringBuilder = new StringBuilder().append("Possible OOM: array_len=").append(len).append("(0x");
                        int n5 = len;
                        int n6 = 16;
                        boolean bl5 = false;
                        String string = Integer.toString(n5, CharsKt.checkRadix((int)n6));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
                        String string2 = stringBuilder.append(string).append(')').toString();
                        throw (Throwable)new IllegalArgumentException(string2.toString());
                    }
                    this.pkg = new byte[len];
                    this.pos = 0;
                    SocketWireKt.access$readByteArray(this.stream, this.pkg);
                    if (seqn > Base.this.maxReceivedSeqn) {
                        Base.this.maxReceivedSeqn = seqn;
                        n4 = this.pos;
                        this.pos = n4 + 1;
                        return this.pkg[n4] & 0xFF;
                    }
                    Base.this.sendAck(seqn);
                }
            }

            public PkgInputStream(InputStream stream) {
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                this.stream = stream;
                this.pkg = new byte[0];
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rd/framework/SocketWire$Client;", "Lcom/jetbrains/rd/framework/SocketWire$Base;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "port", "", "optId", "", "hostAddress", "Ljava/net/InetAddress;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/reactive/IScheduler;ILjava/lang/String;Ljava/net/InetAddress;)V", "rd-framework"})
    public static final class Client
    extends Base {
        /*
         * WARNING - void declaration
         */
        public Client(@NotNull Lifetime lifetime, @NotNull IScheduler scheduler, int port, @Nullable String optId, @NotNull InetAddress hostAddress) {
            void socket;
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
            Intrinsics.checkNotNullParameter((Object)hostAddress, (String)"hostAddress");
            String string = optId;
            if (string == null) {
                string = "ClientSocket";
            }
            super(string, lifetime, scheduler);
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            Function0 function0 = (Function0)new Function0<Unit>(this, lifetime, hostAddress, port, (Ref.ObjectRef)socket){
                final /* synthetic */ Client this$0;
                final /* synthetic */ Lifetime $lifetime;
                final /* synthetic */ InetAddress $hostAddress;
                final /* synthetic */ int $port;
                final /* synthetic */ Ref.ObjectRef $socket;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final void invoke() {
                    try {
                        while (RLifetimeKt.isAlive((Lifetime)this.$lifetime)) {
                            try {
                                Unit $this$log$iv$iv222;
                                String string;
                                Unit unit;
                                LogLevel logLevel;
                                void $this$log$iv$iv222;
                                Socket s = new Socket();
                                s.setTcpNoDelay(true);
                                Logger logger = this.this$0.getLogger();
                                boolean $i$f$debug = false;
                                Logger logger2 = logger;
                                LogLevel level$iv$iv = LogLevel.Debug;
                                boolean $i$f$log = false;
                                if ($this$log$iv$iv222.isEnabled(level$iv$iv)) {
                                    logLevel = level$iv$iv;
                                    unit = $this$log$iv$iv222;
                                    boolean bl = false;
                                    string = this.this$0.getId() + " : connecting to " + this.$hostAddress + ':' + this.$port;
                                    unit.log(logLevel, (Object)string, null);
                                }
                                s.connect(new InetSocketAddress(this.$hostAddress, this.$port));
                                Object object = this.this$0.getLock();
                                $i$f$debug = false;
                                boolean $this$log$iv$iv222 = false;
                                synchronized (object) {
                                    boolean bl = false;
                                    if (!RLifetimeKt.isAlive((Lifetime)this.$lifetime)) {
                                        void $this$log$iv$iv;
                                        Logger $this$debug$iv = this.this$0.getLogger();
                                        boolean $i$f$debug2 = false;
                                        Logger logger3 = $this$debug$iv;
                                        LogLevel level$iv$iv2 = LogLevel.Debug;
                                        boolean $i$f$log2 = false;
                                        if ($this$log$iv$iv.isEnabled(level$iv$iv2)) {
                                            LogLevel logLevel2 = level$iv$iv2;
                                            void var12_41 = $this$log$iv$iv;
                                            boolean bl2 = false;
                                            String string2 = this.this$0.getId() + " : connected, but lifetime is already canceled, closing socket";
                                            var12_41.log(logLevel2, (Object)string2, null);
                                        }
                                        boolean $i$f$catchAndDrop = false;
                                        try {
                                            boolean bl3 = false;
                                            s.close();
                                        }
                                        catch (Throwable throwable) {
                                        }
                                        return;
                                    }
                                    this.$socket.element = s;
                                    $this$log$iv$iv222 = Unit.INSTANCE;
                                }
                                this.this$0.getSocketProvider().set((Object)s);
                                Logger logger4 = this.this$0.getLogger();
                                $i$f$debug = false;
                                $this$log$iv$iv222 = logger4;
                                level$iv$iv = LogLevel.Debug;
                                $i$f$log = false;
                                if (!$this$log$iv$iv222.isEnabled(level$iv$iv)) continue;
                                logLevel = level$iv$iv;
                                unit = $this$log$iv$iv222;
                                boolean bl = false;
                                string = this.this$0.getId() + ": receiverProc finished ";
                                unit.log(logLevel, (Object)string, null);
                            }
                            catch (ConnectException e) {
                                Object $i$f$debug = this.this$0.getLock();
                                boolean $this$log$iv$iv = false;
                                boolean level$iv$iv = false;
                                synchronized ($i$f$debug) {
                                    boolean bl = false;
                                    if (!RLifetimeKt.isAlive((Lifetime)this.$lifetime)) return;
                                    this.this$0.getLock().wait(SocketWire.Companion.getTimeout().toMillis());
                                    boolean bl4 = RLifetimeKt.isAlive((Lifetime)this.$lifetime);
                                    level$iv$iv = bl4;
                                }
                                boolean bl = level$iv$iv;
                                if (!bl) return;
                            }
                        }
                        return;
                    }
                    catch (SocketException ex) {
                        Logger logger = this.this$0.getLogger();
                        boolean $i$f$info = false;
                        Logger $this$log$iv$iv = logger;
                        LogLevel level$iv$iv = LogLevel.Info;
                        boolean $i$f$log = false;
                        if (!$this$log$iv$iv.isEnabled(level$iv$iv)) return;
                        LogLevel logLevel = level$iv$iv;
                        Logger logger5 = $this$log$iv$iv;
                        boolean bl = false;
                        String string = this.this$0.getId() + ": closed with exception: " + ex;
                        logger5.log(logLevel, (Object)string, null);
                    }
                }
                {
                    this.this$0 = client;
                    this.$lifetime = lifetime;
                    this.$hostAddress = inetAddress;
                    this.$port = n;
                    this.$socket = objectRef;
                    super(0);
                }
            };
            int n = 0;
            boolean bl = true;
            ClassLoader classLoader = null;
            String string2 = this.getId();
            Thread thread2 = ThreadsKt.thread$default((boolean)false, (boolean)bl, classLoader, (String)string2, (int)n, (Function0)function0, (int)21, null);
            RLifetimeKt.plusAssign((Lifetime)lifetime, (Function0)((Function0)new Function0<Unit>((Ref.ObjectRef)socket, thread2){
                final /* synthetic */ Ref.ObjectRef $socket;
                final /* synthetic */ Thread $thread;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$log$iv$iv;
                    Unit $this$log$iv$iv222;
                    void $this$log$iv$iv222;
                    String string;
                    Logger logger;
                    LogLevel logLevel;
                    Logger $this$log$iv$iv3;
                    Logger $this$info$iv = this.getLogger();
                    boolean $i$f$info = false;
                    Logger logger2 = $this$info$iv;
                    LogLevel level$iv$iv = LogLevel.Info;
                    boolean $i$f$log = false;
                    if ($this$log$iv$iv3.isEnabled(level$iv$iv)) {
                        logLevel = level$iv$iv;
                        logger = $this$log$iv$iv3;
                        boolean bl = false;
                        string = this.getId() + ": start terminating lifetime";
                        logger.log(logLevel, (Object)string, null);
                    }
                    Logger $this$debug$iv = this.getLogger();
                    boolean $i$f$debug = false;
                    $this$log$iv$iv3 = $this$debug$iv;
                    level$iv$iv = LogLevel.Debug;
                    $i$f$log = false;
                    if ($this$log$iv$iv3.isEnabled(level$iv$iv)) {
                        logLevel = level$iv$iv;
                        logger = $this$log$iv$iv3;
                        boolean bl = false;
                        string = this.getId() + ": shutting down ack sending executor";
                        logger.log(logLevel, (Object)string, null);
                    }
                    this.getAcktor().shutdown();
                    boolean sendBufferStopped = this.getSendBuffer().stop(Companion.getTimeout());
                    Object $this$debug$iv2 = this.getLogger();
                    boolean $i$f$debug2 = false;
                    level$iv$iv = $this$debug$iv2;
                    LogLevel level$iv$iv2 = LogLevel.Debug;
                    boolean $i$f$log2 = false;
                    if ($this$log$iv$iv222.isEnabled(level$iv$iv2)) {
                        logLevel = level$iv$iv2;
                        logger = $this$log$iv$iv222;
                        boolean bl = false;
                        string = this.getId() + ": send buffer stopped, success: " + sendBufferStopped;
                        logger.log(logLevel, (Object)string, null);
                    }
                    $this$debug$iv2 = this.getLock();
                    $i$f$debug2 = false;
                    boolean $this$log$iv$iv222 = false;
                    synchronized ($this$debug$iv2) {
                        void $this$log$iv$iv4;
                        boolean bl = false;
                        Logger $this$debug$iv3 = this.getLogger();
                        boolean $i$f$debug3 = false;
                        Logger logger3 = $this$debug$iv3;
                        LogLevel level$iv$iv3 = LogLevel.Debug;
                        boolean $i$f$log3 = false;
                        if ($this$log$iv$iv4.isEnabled(level$iv$iv3)) {
                            LogLevel logLevel2 = level$iv$iv3;
                            void var12_44 = $this$log$iv$iv4;
                            boolean bl2 = false;
                            String string2 = this.getId() + ": closing socket";
                            var12_44.log(logLevel2, (Object)string2, null);
                        }
                        boolean $i$f$catch = false;
                        Object comment$iv$iv = null;
                        boolean $i$f$catch2 = false;
                        try {
                            boolean bl3 = false;
                            Socket socket = (Socket)this.$socket.element;
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        catch (Throwable e$iv$iv) {
                            CharSequence bl3 = comment$iv$iv;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            String sfx$iv$iv = "";
                            LoggerKt.getLogger((String)"Default-Error-Logger").log(LogLevel.Error, (Object)("Catch" + sfx$iv$iv), e$iv$iv);
                        }
                        this.getLock().notifyAll();
                        $this$log$iv$iv222 = Unit.INSTANCE;
                    }
                    $this$debug$iv2 = this.getLogger();
                    $i$f$debug2 = false;
                    $this$log$iv$iv222 = $this$debug$iv2;
                    level$iv$iv = LogLevel.Debug;
                    $i$f$log = false;
                    if ($this$log$iv$iv222.isEnabled(level$iv$iv)) {
                        logLevel = level$iv$iv;
                        logger = $this$log$iv$iv222;
                        boolean bl6 = false;
                        string = this.getId() + ": waiting for receiver thread";
                        logger.log(logLevel, (Object)string, null);
                    }
                    boolean $i$f$catch = false;
                    Object comment$iv$iv = null;
                    boolean $i$f$catch22 = false;
                    try {
                        boolean bl = false;
                        this.$thread.join(Companion.getTimeout().toMillis());
                    }
                    catch (Throwable e$iv$iv) {
                        CharSequence bl = comment$iv$iv;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        String sfx$iv$iv = "";
                        LoggerKt.getLogger((String)"Default-Error-Logger").log(LogLevel.Error, (Object)("Catch" + sfx$iv$iv), e$iv$iv);
                    }
                    Logger $this$info$iv2 = this.getLogger();
                    boolean $i$f$info2 = false;
                    Logger $i$f$catch22 = $this$info$iv2;
                    level$iv$iv = LogLevel.Info;
                    $i$f$log = false;
                    if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                        logLevel = level$iv$iv;
                        logger = $this$log$iv$iv;
                        boolean bl = false;
                        string = this.getId() + ": termination finished";
                        logger.log(logLevel, (Object)string, null);
                    }
                }
                {
                    this.$socket = objectRef;
                    this.$thread = thread2;
                    super(0);
                }
            }));
        }

        public /* synthetic */ Client(Lifetime lifetime, IScheduler iScheduler, int n, String string, InetAddress inetAddress, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                string = null;
            }
            if ((n2 & 0x10) != 0) {
                InetAddress inetAddress2 = InetAddress.getLoopbackAddress();
                Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"InetAddress.getLoopbackAddress()");
                inetAddress = inetAddress2;
            }
            this(lifetime, iScheduler, n, string, inetAddress);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB3\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/framework/SocketWire$Server;", "Lcom/jetbrains/rd/framework/SocketWire$Base;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "port", "", "optId", "", "allowRemoteConnections", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/reactive/IScheduler;Ljava/lang/Integer;Ljava/lang/String;Z)V", "ss", "Ljava/net/ServerSocket;", "allowReconnect", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/reactive/IScheduler;Ljava/net/ServerSocket;Ljava/lang/String;Z)V", "getPort", "()I", "Companion", "rd-framework"})
    public static final class Server
    extends Base {
        private final int port;
        public static final Companion Companion = new Companion(null);

        public final int getPort() {
            return this.port;
        }

        /*
         * WARNING - void declaration
         */
        public Server(@NotNull Lifetime lifetime, @NotNull IScheduler scheduler, @NotNull ServerSocket ss, @Nullable String optId, boolean allowReconnect) {
            void socket;
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
            Intrinsics.checkNotNullParameter((Object)ss, (String)"ss");
            String string = optId;
            if (string == null) {
                string = "ServerSocket";
            }
            super(string, lifetime, scheduler);
            this.port = ss.getLocalPort();
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            Function0 function0 = (Function0)new Function0<Unit>(this, lifetime, ss, (Ref.ObjectRef)socket, allowReconnect){
                final /* synthetic */ Server this$0;
                final /* synthetic */ Lifetime $lifetime;
                final /* synthetic */ ServerSocket $ss;
                final /* synthetic */ Ref.ObjectRef $socket;
                final /* synthetic */ boolean $allowReconnect;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    while (RLifetimeKt.isAlive((Lifetime)this.$lifetime)) {
                        String string;
                        void var17_4;
                        Logger logger;
                        Logger level$iv$iv22;
                        try {
                            Socket s;
                            void $this$log$iv$iv22;
                            Logger $this$debug$iv = this.this$0.getLogger();
                            boolean $i$f$debug22 = false;
                            Logger logger2 = $this$debug$iv;
                            level$iv$iv22 = LogLevel.Debug;
                            boolean $i$f$log = false;
                            if ($this$log$iv$iv22.isEnabled((LogLevel)level$iv$iv22)) {
                                logger = level$iv$iv22;
                                var17_4 = $this$log$iv$iv22;
                                boolean bl = false;
                                string = this.this$0.getId() + ": listening " + this.$ss.getLocalSocketAddress();
                                var17_4.log((LogLevel)logger, (Object)string, null);
                            }
                            Socket socket = s = this.$ss.accept();
                            Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"s");
                            socket.setTcpNoDelay(true);
                            Object $i$f$debug22 = this.this$0.getLock();
                            boolean $this$log$iv$iv22 = false;
                            boolean level$iv$iv22 = false;
                            synchronized ($i$f$debug22) {
                                boolean bl = false;
                                if (!RLifetimeKt.isAlive((Lifetime)this.$lifetime)) {
                                    void $this$log$iv$iv;
                                    Logger $this$debug$iv2 = this.this$0.getLogger();
                                    boolean $i$f$debug = false;
                                    Logger logger3 = $this$debug$iv2;
                                    LogLevel level$iv$iv = LogLevel.Debug;
                                    boolean $i$f$log2 = false;
                                    if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                                        LogLevel logLevel = level$iv$iv;
                                        void var12_28 = $this$log$iv$iv;
                                        boolean bl2 = false;
                                        String string2 = this.this$0.getId() + " : connected, but lifetime is already canceled, closing socket";
                                        var12_28.log(logLevel, (Object)string2, null);
                                    }
                                    boolean $i$f$catch = false;
                                    Object comment$iv$iv = null;
                                    boolean $i$f$catch2 = false;
                                    try {
                                        boolean bl3 = false;
                                        s.close();
                                    }
                                    catch (Throwable e$iv$iv) {
                                        CharSequence charSequence = comment$iv$iv;
                                        boolean bl4 = false;
                                        boolean bl5 = false;
                                        String sfx$iv$iv = "";
                                        LoggerKt.getLogger((String)"Default-Error-Logger").log(LogLevel.Error, (Object)("Catch" + sfx$iv$iv), e$iv$iv);
                                    }
                                    return;
                                }
                                this.$socket.element = s;
                                level$iv$iv22 = Unit.INSTANCE;
                            }
                            this.this$0.getSocketProvider().set((Object)s);
                        }
                        catch (SocketException ex) {
                            void $this$log$iv$iv;
                            Logger $this$debug$iv = this.this$0.getLogger();
                            boolean $i$f$debug = false;
                            level$iv$iv22 = $this$debug$iv;
                            LogLevel level$iv$iv = LogLevel.Debug;
                            boolean $i$f$log = false;
                            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                                logger = level$iv$iv;
                                var17_4 = $this$log$iv$iv;
                                boolean bl = false;
                                string = this.this$0.getId() + " closed with exception: " + ex;
                                var17_4.log((LogLevel)logger, (Object)string, null);
                            }
                        }
                        catch (Exception ex) {
                            LoggerKt.error((Logger)this.this$0.getLogger(), (String)(this.this$0.getId() + " closed with exception"), (Throwable)ex);
                        }
                        if (this.$allowReconnect) continue;
                        break;
                    }
                }
                {
                    this.this$0 = server;
                    this.$lifetime = lifetime;
                    this.$ss = serverSocket;
                    this.$socket = objectRef;
                    this.$allowReconnect = bl;
                    super(0);
                }
            };
            int n = 0;
            boolean bl = true;
            ClassLoader classLoader = null;
            String string2 = this.getId();
            Thread thread2 = ThreadsKt.thread$default((boolean)false, (boolean)bl, classLoader, (String)string2, (int)n, (Function0)function0, (int)21, null);
            lifetime.onTerminationIfAlive((Function0)new Function0<Unit>((Ref.ObjectRef)socket, thread2){
                final /* synthetic */ Ref.ObjectRef $socket;
                final /* synthetic */ Thread $thread;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    boolean bl;
                    void $this$log$iv$iv;
                    String string;
                    Logger logger;
                    LogLevel logLevel;
                    Logger $this$log$iv$iv2;
                    Logger $this$info$iv = this.getLogger();
                    boolean $i$f$info = false;
                    Logger logger2 = $this$info$iv;
                    LogLevel level$iv$iv = LogLevel.Info;
                    boolean $i$f$log = false;
                    if ($this$log$iv$iv2.isEnabled(level$iv$iv)) {
                        logLevel = level$iv$iv;
                        logger = $this$log$iv$iv2;
                        boolean bl2 = false;
                        string = this.getId() + ": start terminating lifetime";
                        logger.log(logLevel, (Object)string, null);
                    }
                    Logger $this$debug$iv = this.getLogger();
                    boolean $i$f$debug = false;
                    $this$log$iv$iv2 = $this$debug$iv;
                    level$iv$iv = LogLevel.Debug;
                    $i$f$log = false;
                    if ($this$log$iv$iv2.isEnabled(level$iv$iv)) {
                        logLevel = level$iv$iv;
                        logger = $this$log$iv$iv2;
                        boolean bl3 = false;
                        string = this.getId() + ": shutting down ack sending executor";
                        logger.log(logLevel, (Object)string, null);
                    }
                    this.getAcktor().shutdown();
                    boolean sendBufferStopped = this.getSendBuffer().stop(SocketWire.Companion.getTimeout());
                    Logger $this$debug$iv2 = this.getLogger();
                    boolean $i$f$debug2 = false;
                    level$iv$iv = $this$debug$iv2;
                    LogLevel level$iv$iv2 = LogLevel.Debug;
                    boolean $i$f$log22 = false;
                    if ($this$log$iv$iv.isEnabled(level$iv$iv2)) {
                        logLevel = level$iv$iv2;
                        logger = $this$log$iv$iv;
                        bl = false;
                        string = this.getId() + ": send buffer stopped, success: " + sendBufferStopped;
                        logger.log(logLevel, (Object)string, null);
                    }
                    boolean $i$f$catch = false;
                    Object comment$iv$iv = null;
                    boolean $i$f$catch2 = false;
                    try {
                        boolean bl4 = false;
                        Object $i$f$log22 = this.getLock();
                        bl = false;
                        boolean bl5 = false;
                        synchronized ($i$f$log22) {
                            void $this$log$iv$iv3;
                            boolean bl6 = false;
                            Logger $this$debug$iv3 = this.getLogger();
                            boolean $i$f$debug3 = false;
                            Logger logger3 = $this$debug$iv3;
                            LogLevel level$iv$iv3 = LogLevel.Debug;
                            boolean $i$f$log3 = false;
                            if ($this$log$iv$iv3.isEnabled(level$iv$iv3)) {
                                LogLevel logLevel2 = level$iv$iv3;
                                void var16_41 = $this$log$iv$iv3;
                                boolean bl7 = false;
                                String string2 = this.getId() + ": closing socket";
                                var16_41.log(logLevel2, (Object)string2, null);
                            }
                            Socket socket = (Socket)this.$socket.element;
                            if (socket != null) {
                                socket.close();
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                    catch (Throwable e$iv$iv) {
                        CharSequence bl4 = comment$iv$iv;
                        $i$f$log22 = false;
                        bl = false;
                        String sfx$iv$iv = "";
                        LoggerKt.getLogger((String)"Default-Error-Logger").log(LogLevel.Error, (Object)("Catch" + sfx$iv$iv), e$iv$iv);
                    }
                    $i$f$catch = false;
                    comment$iv$iv = null;
                    $i$f$catch2 = false;
                    try {
                        boolean bl8 = false;
                        this.$thread.join(SocketWire.Companion.getTimeout().toMillis());
                    }
                    catch (Throwable e$iv$iv) {
                        CharSequence bl8 = comment$iv$iv;
                        bl = false;
                        boolean bl9 = false;
                        String sfx$iv$iv = "";
                        LoggerKt.getLogger((String)"Default-Error-Logger").log(LogLevel.Error, (Object)("Catch" + sfx$iv$iv), e$iv$iv);
                    }
                    Logger $this$info$iv2 = this.getLogger();
                    boolean $i$f$info2 = false;
                    Logger $i$f$catch22 = $this$info$iv2;
                    level$iv$iv = LogLevel.Info;
                    boolean $i$f$log4 = false;
                    if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                        logLevel = level$iv$iv;
                        logger = $this$log$iv$iv;
                        boolean bl10 = false;
                        string = this.getId() + ": termination finished";
                        logger.log(logLevel, (Object)string, null);
                    }
                }
                {
                    this.$socket = objectRef;
                    this.$thread = thread2;
                    super(0);
                }
            });
        }

        public /* synthetic */ Server(Lifetime lifetime, IScheduler iScheduler, ServerSocket serverSocket, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string = null;
            }
            this(lifetime, iScheduler, serverSocket, string, bl);
        }

        public Server(@NotNull Lifetime lifetime, @NotNull IScheduler scheduler, @Nullable Integer port, @Nullable String optId, boolean allowRemoteConnections) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
            this(lifetime, scheduler, Companion.createServerSocket$rd_framework(lifetime, port, allowRemoteConnections), optId, true);
        }

        public /* synthetic */ Server(Lifetime lifetime, IScheduler iScheduler, Integer n, String string, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                string = null;
            }
            if ((n2 & 0x10) != 0) {
                bl = false;
            }
            this(lifetime, iScheduler, n, string, bl);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rd/framework/SocketWire$Server$Companion;", "", "()V", "createServerSocket", "Ljava/net/ServerSocket;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "port", "", "allowRemoteConnections", "", "createServerSocket$rd_framework", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/Integer;Z)Ljava/net/ServerSocket;", "rd-framework"})
        public static final class Companion {
            @NotNull
            public final ServerSocket createServerSocket$rd_framework(@NotNull Lifetime lifetime, @Nullable Integer port, boolean allowRemoteConnections) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                InetAddress address = allowRemoteConnections ? null : InetAddress.getByName("127.0.0.1");
                Integer n = port;
                ServerSocket res = new ServerSocket(n != null ? n : 0, 0, address);
                RLifetimeKt.onTermination((Lifetime)lifetime, (Function0)((Function0)new Function0<Unit>(res){
                    final /* synthetic */ ServerSocket $res;

                    public final void invoke() {
                        this.$res.close();
                    }
                    {
                        this.$res = serverSocket;
                        super(0);
                    }
                }));
                return res;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/framework/SocketWire$WireParameters;", "", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "id", "", "(Lcom/jetbrains/rd/util/reactive/IScheduler;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getScheduler", "()Lcom/jetbrains/rd/util/reactive/IScheduler;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "rd-framework"})
    public static final class WireParameters {
        @NotNull
        private final IScheduler scheduler;
        @Nullable
        private final String id;

        @NotNull
        public final IScheduler getScheduler() {
            return this.scheduler;
        }

        @Nullable
        public final String getId() {
            return this.id;
        }

        public WireParameters(@NotNull IScheduler scheduler, @Nullable String id) {
            Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
            this.scheduler = scheduler;
            this.id = id;
        }

        @NotNull
        public final IScheduler component1() {
            return this.scheduler;
        }

        @Nullable
        public final String component2() {
            return this.id;
        }

        @NotNull
        public final WireParameters copy(@NotNull IScheduler scheduler, @Nullable String id) {
            Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
            return new WireParameters(scheduler, id);
        }

        public static /* synthetic */ WireParameters copy$default(WireParameters wireParameters, IScheduler iScheduler, String string, int n, Object object) {
            if ((n & 1) != 0) {
                iScheduler = wireParameters.scheduler;
            }
            if ((n & 2) != 0) {
                string = wireParameters.id;
            }
            return wireParameters.copy(iScheduler, string);
        }

        @NotNull
        public String toString() {
            return "WireParameters(scheduler=" + this.scheduler + ", id=" + this.id + ")";
        }

        public int hashCode() {
            IScheduler iScheduler = this.scheduler;
            String string = this.id;
            return (iScheduler != null ? iScheduler.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof WireParameters)) break block3;
                    WireParameters wireParameters = (WireParameters)object;
                    if (!Intrinsics.areEqual((Object)this.scheduler, (Object)wireParameters.scheduler) || !Intrinsics.areEqual((Object)this.id, (Object)wireParameters.id)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB+\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fB=\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J+\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001e0 H\u0096\u0001J+\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u001f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0015\u0012\u0004\u0012\u00020\u001e0\"H\u0096\u0001J\u0011\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u0002H\u0096\u0003J\u0017\u0010%\u001a\u00020\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'H\u0096\u0001J\t\u0010(\u001a\u00020\u000bH\u0096\u0001J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020*H\u0096\u0003J+\u0010+\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001e0 H\u0096\u0001R\u001e\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00150\u0014X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006,"}, d2={"Lcom/jetbrains/rd/framework/SocketWire$ServerFactory;", "Lcom/jetbrains/rd/util/reactive/IViewableSet;", "Lcom/jetbrains/rd/framework/SocketWire$Server;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "wireParametersFactory", "Lkotlin/Function0;", "Lcom/jetbrains/rd/framework/SocketWire$WireParameters;", "port", "", "allowRemoteConnections", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/jvm/functions/Function0;Ljava/lang/Integer;Z)V", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/reactive/IScheduler;Ljava/lang/Integer;Z)V", "set", "Lcom/jetbrains/rd/util/reactive/ViewableSet;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/jvm/functions/Function0;Ljava/lang/Integer;ZLcom/jetbrains/rd/util/reactive/ViewableSet;)V", "change", "Lcom/jetbrains/rd/util/reactive/ISource;", "Lcom/jetbrains/rd/util/reactive/IViewableSet$Event;", "getChange", "()Lcom/jetbrains/rd/util/reactive/ISource;", "localPort", "getLocalPort", "()I", "size", "getSize", "advise", "", "handler", "Lkotlin/Function2;", "Lcom/jetbrains/rd/util/reactive/AddRemove;", "Lkotlin/Function1;", "contains", "element", "containsAll", "elements", "", "isEmpty", "iterator", "", "view", "rd-framework"})
    public static final class ServerFactory
    implements IViewableSet<Server> {
        private final int localPort;
        private final /* synthetic */ ViewableSet<Server> $$delegate_0;

        public final int getLocalPort() {
            return this.localPort;
        }

        private ServerFactory(final Lifetime lifetime, final Function0<WireParameters> wireParametersFactory, Integer port, boolean allowRemoteConnections, final ViewableSet<Server> set2) {
            this.$$delegate_0 = set2;
            final ServerSocket ss = Server.Companion.createServerSocket$rd_framework(lifetime, port, allowRemoteConnections);
            this.localPort = ss.getLocalPort();
            Function0<Unit> $fun$rec$2 = new Function0<Unit>(){

                public final void invoke() {
                    lifetime.executeIfAlive((Function0)new Function0<Unit>(){

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            void scheduler;
                            WireParameters wireParameters = (WireParameters)wireParametersFactory.invoke();
                            IScheduler iScheduler = wireParameters.component1();
                            String optId = wireParameters.component2();
                            final Server s = new Server(lifetime, (IScheduler)scheduler, ss, optId, false);
                            BoolPropertyExKt.whenTrue((IViewable)((IViewable)s.getConnected()), (Lifetime)lifetime, (Function1)((Function1)new Function1<Lifetime, Unit>(){

                                public final void invoke(@NotNull Lifetime lt) {
                                    Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                                    CollectionExKt.addUnique((Collection)((Collection)set2), (Lifetime)lt, (Object)s);
                                    this.invoke();
                                }
                            }));
                        }
                    });
                }
            };
            $fun$rec$2.invoke();
        }

        public ServerFactory(@NotNull Lifetime lifetime, @NotNull Function0<WireParameters> wireParametersFactory, @Nullable Integer port, boolean allowRemoteConnections) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(wireParametersFactory, (String)"wireParametersFactory");
            this(lifetime, wireParametersFactory, port, allowRemoteConnections, (ViewableSet<Server>)new ViewableSet(null, 1, null));
        }

        public /* synthetic */ ServerFactory(Lifetime lifetime, Function0 function0, Integer n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                bl = false;
            }
            this(lifetime, (Function0<WireParameters>)function0, n, bl);
        }

        public ServerFactory(@NotNull Lifetime lifetime, final @NotNull IScheduler scheduler, @Nullable Integer port, boolean allowRemoteConnections) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
            this(lifetime, (Function0<WireParameters>)((Function0)new Function0<WireParameters>(){

                @NotNull
                public final WireParameters invoke() {
                    return new WireParameters(scheduler, null);
                }
            }), port, allowRemoteConnections, (ViewableSet<Server>)new ViewableSet(null, 1, null));
        }

        public /* synthetic */ ServerFactory(Lifetime lifetime, IScheduler iScheduler, Integer n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                bl = false;
            }
            this(lifetime, iScheduler, n, bl);
        }

        @NotNull
        public ISource<IViewableSet.Event<Server>> getChange() {
            return (ISource)this.$$delegate_0.getChange();
        }

        public int getSize() {
            return this.$$delegate_0.size();
        }

        public void advise(@NotNull Lifetime lifetime, @NotNull Function2<? super AddRemove, ? super Server, Unit> handler) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.$$delegate_0.advise(lifetime, handler);
        }

        public void advise(@NotNull Lifetime lifetime, @NotNull Function1<? super IViewableSet.Event<Server>, Unit> handler) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.$$delegate_0.advise(lifetime, handler);
        }

        public boolean contains(@NotNull Server element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this.$$delegate_0.contains((Object)element);
        }

        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.$$delegate_0.containsAll(elements);
        }

        public boolean isEmpty() {
            return this.$$delegate_0.isEmpty();
        }

        @NotNull
        public Iterator<Server> iterator() {
            return this.$$delegate_0.iterator();
        }

        public void view(@NotNull Lifetime lifetime, @NotNull Function2<? super Lifetime, ? super Server, Unit> handler) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.$$delegate_0.view(lifetime, handler);
        }

        public boolean add(Server server) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        public boolean addAll(Collection<? extends Server> collection) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        public void clear() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        public boolean removeAll(Collection<? extends Object> collection) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        public boolean retainAll(Collection<? extends Object> collection) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        public /* synthetic */ boolean add(Object object) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)((Object)this));
        }

        public <T> T[] toArray(T[] TArray) {
            return CollectionToArray.toArray((Collection)((Object)this), (Object[])TArray);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rd/framework/SocketWire$Companion;", "", "()V", "ack_msg_len", "", "disconnectedPauseReason", "", "maximumHeartbeatDelay", "ping_len", "pkg_header_len", "timeout", "Ljava/time/Duration;", "getTimeout", "()Ljava/time/Duration;", "connectionEstablished", "", "timeStamp", "notionTimestamp", "rd-framework"})
    public static final class Companion {
        @NotNull
        public final Duration getTimeout() {
            return timeout;
        }

        private final boolean connectionEstablished(int timeStamp, int notionTimestamp) {
            return timeStamp - notionTimestamp <= 3;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

