/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.cloudConfig.CloudConfigBundle;
import com.intellij.cloudConfig.CloudConfigDisableSyncAction;
import com.intellij.cloudConfig.CloudConfigManager;
import com.intellij.cloudConfig.CloudConfigSyncPluginsAction;
import com.intellij.cloudConfig.CloudConfigSyncPluginsSilentlyAction;
import com.intellij.cloudConfig.CloudConfigSyncSettingsAction;
import com.intellij.cloudConfig.CloudConfigUi;
import com.intellij.cloudConfig.CloudConfigUpdateApiAction;
import com.intellij.cloudConfig.StatusBarInfoManager;
import com.intellij.cloudConfig.StatusInfo;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.popup.PopupState;
import com.intellij.util.Consumer;
import com.intellij.util.ui.EmptyIcon;
import icons.CloudConfigIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CloudConfigWidget
implements StatusBarWidget,
StatusBarWidget.IconPresentation,
DumbAware {
    @NonNls
    static final String ID = "CloudConfig";
    private final PopupState<JBPopup> myPopupState = PopupState.forPopup();
    private StatusBar myStatusBar;
    private Icon myIcon = EmptyIcon.ICON_16;
    private @NlsContexts.Tooltip String myTooltip;
    private DefaultActionGroup myActions;
    private @NlsContexts.PopupTitle String myPopupTitle;
    private @NlsContexts.PopupAdvertisement String myPopupBottomTitle;

    CloudConfigWidget() {
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            CloudConfigWidget.$$$reportNull$$$0(0);
        }
        this.myStatusBar = statusBar;
        this.update();
    }

    public void update() {
        this.myActions = null;
        this.myTooltip = null;
        this.myPopupBottomTitle = null;
        this.myPopupTitle = null;
        CloudConfigManager manager = CloudConfigManager.getInstance();
        switch (manager.getStatusInfo()) {
            case JBA_NOT_FOUND: {
                if (manager.isLocalConnected()) {
                    this.myIcon = CloudConfigIcons.Not_connected;
                    this.myTooltip = CloudConfigBundle.message("login.message", new Object[0]);
                    break;
                }
            }
            case OFFLINE: {
                if (manager.isOfflineWithJBA()) {
                    this.myIcon = CloudConfigIcons.Not_connected;
                    this.myTooltip = CloudConfigBundle.message("offline.message", new Object[0]);
                    break;
                }
            }
            case DISABLED: {
                this.myStatusBar.removeWidget(ID);
                return;
            }
            case JBA_IO_ERROR: {
                this.myIcon = CloudConfigIcons.Io_error;
                if (manager.getErrorMessage() == null) {
                    this.myTooltip = CloudConfigBundle.message("error.connected.message", new Object[0]);
                    break;
                }
                if ("401".equals(manager.getErrorMessage())) {
                    this.myTooltip = CloudConfigBundle.message("error.401.message", new Object[0]);
                    break;
                }
                this.myTooltip = CloudConfigBundle.message("error.connected.full.message", manager.getErrorMessage());
                break;
            }
            case JBA_NOT_ACCEPTED: {
                this.myIcon = CloudConfigIcons.Not_connected;
                this.myTooltip = CloudConfigBundle.message("not.accepted.message", new Object[0]);
                this.createNotAcceptedActions();
                break;
            }
            case JBA_IO_OPERATION: {
                this.myIcon = CloudConfigIcons.Io_operation;
                this.myTooltip = CloudConfigBundle.message("io.operation.message", new Object[0]);
                break;
            }
            case JBA_NOT_CONNECTED: 
            case JBA_THIS_NOT_CONNECTED: {
                this.myIcon = CloudConfigIcons.Not_connected;
                this.myTooltip = CloudConfigBundle.message("not.connected.message", new Object[0]);
                this.createNotConnectedActions();
                break;
            }
            case JBA_CONNECTED: {
                if (manager.hasPluginsUpdate() || manager.hasUpdateApi()) {
                    this.myIcon = CloudConfigIcons.Update;
                    this.myTooltip = CloudConfigBundle.message(manager.hasUpdateApi() ? "update.api.message" : "update.plugins.message", new Object[0]);
                } else {
                    this.myIcon = CloudConfigIcons.Connected;
                    this.myTooltip = CloudConfigBundle.message("connected.message", new Object[0]);
                }
                this.createConnectedActions();
            }
        }
        this.myStatusBar.updateWidget(ID);
    }

    private void createNotConnectedActions() {
        this.myActions = new DefaultActionGroup();
        this.myPopupTitle = CloudConfigBundle.message("not.connected.popup.title", new Object[0]);
        this.myActions.addAction((AnAction)new DumbAwareAction(CloudConfigBundle.message("enable.cloud.action", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                StatusBarInfoManager.connectInstance(e.getProject(), EmptyRunnable.INSTANCE);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cloudConfig/CloudConfigWidget$1", "actionPerformed"));
            }
        });
        this.myActions.addSeparator();
        this.myActions.addAction((AnAction)new DumbAwareAction(CloudConfigBundle.message("change.account.action", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                CloudConfigUi.showLoginDialog();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cloudConfig/CloudConfigWidget$2", "actionPerformed"));
            }
        });
        this.createHideAction();
    }

    private void createHideAction() {
        this.myActions.addSeparator();
        this.myActions.addAction((AnAction)new DumbAwareAction(CloudConfigBundle.message("hide.cloud.action", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                CloudConfigManager.getInstance().disable();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cloudConfig/CloudConfigWidget$3", "actionPerformed"));
            }
        });
    }

    private void createConnectedActions() {
        this.myActions = new DefaultActionGroup();
        this.myPopupBottomTitle = CloudConfigBundle.message("connected.popup.bottom.title", StatusBarInfoManager.getUserLogin());
        CloudConfigManager manager = CloudConfigManager.getInstance();
        this.myPopupTitle = CloudConfigBundle.message(manager.hasPluginsUpdate() ? "plugins.popup.title" : "connected.popup.title", new Object[0]);
        if (manager.hasUpdateApi()) {
            this.myActions.add((AnAction)new CloudConfigUpdateApiAction());
        }
        this.myActions.addAction((AnAction)new CloudConfigSyncSettingsAction());
        if (manager.hasPluginsUpdate() || manager.hasPluginsAnyUpdate()) {
            this.myActions.addAction((AnAction)new CloudConfigSyncPluginsAction());
        }
        this.myActions.add((AnAction)new CloudConfigSyncPluginsSilentlyAction());
        this.myActions.addSeparator();
        this.myActions.addAction((AnAction)new CloudConfigDisableSyncAction());
    }

    private void createNotAcceptedActions() {
        this.myActions = new DefaultActionGroup();
        this.myPopupTitle = CloudConfigBundle.message("not.connected.popup.title", new Object[0]);
        this.createHideAction();
    }

    public void dispose() {
        this.myStatusBar = null;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myIcon;
        if (icon == null) {
            CloudConfigWidget.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NlsContexts.Tooltip
    @Nullable
    public String getTooltipText() {
        return this.myTooltip;
    }

    @Nullable
    public Consumer<MouseEvent> getClickConsumer() {
        return event -> {
            CloudConfigManager manager = CloudConfigManager.getInstance();
            StatusInfo state = manager.getStatusInfo();
            if (this.myActions == null) {
                if (state == StatusInfo.JBA_IO_ERROR) {
                    if ("401".equals(manager.getErrorMessage())) {
                        CloudConfigUi.showLoginDialog();
                    } else {
                        manager.updateIO(StatusBarInfoManager.showPopupMessage(this.myStatusBar.getProject()));
                    }
                } else if (state == StatusInfo.OFFLINE) {
                    CloudConfigUi.showOfflineMessage();
                } else if (state == StatusInfo.JBA_NOT_FOUND) {
                    CloudConfigUi.showLoginDialog();
                }
            } else if (!this.myPopupState.isRecentlyHidden()) {
                final Component component = event.getComponent();
                final ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("  " + this.myPopupTitle + "  ", (ActionGroup)this.myActions, DataManager.getInstance().getDataContext(component), false, null, this.myActions.getChildrenCount());
                if (this.myPopupBottomTitle != null) {
                    popup.setAdText(this.myPopupBottomTitle, 0);
                }
                this.myPopupState.prepareToShow((Object)popup);
                popup.addListener(new JBPopupListener(){
                    @NlsContexts.Tooltip String myIconTooltip;

                    public void beforeShown(@NotNull LightweightWindowEvent event) {
                        if (event == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        this.myIconTooltip = CloudConfigWidget.this.myTooltip;
                        CloudConfigWidget.this.myTooltip = null;
                        Point location = component.getLocationOnScreen();
                        Dimension size = popup.getSize();
                        popup.setLocation(new Point(location.x + component.getWidth() - size.width, location.y - size.height));
                    }

                    public void onClosed(@NotNull LightweightWindowEvent event) {
                        if (event == null) {
                            4.$$$reportNull$$$0(1);
                        }
                        CloudConfigWidget.this.myTooltip = this.myIconTooltip;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "event";
                        objectArray2[1] = "com/intellij/cloudConfig/CloudConfigWidget$4";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "beforeShown";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onClosed";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                popup.show(component);
            }
        };
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return this;
    }

    @NotNull
    public String ID() {
        return ID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cloudConfig/CloudConfigWidget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cloudConfig/CloudConfigWidget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

