/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.impl.SilentChangeVetoer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/codeInsight/daemon/VcsSilentChangeVetoer;", "Lcom/intellij/codeInsight/daemon/impl/SilentChangeVetoer;", "()V", "canChangeFileSilently", "Lcom/intellij/util/ThreeState;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.vcs.impl"})
public final class VcsSilentChangeVetoer
implements SilentChangeVetoer {
    @Override
    @NotNull
    public ThreeState canChangeFileSilently(@NotNull Project project, @NotNull VirtualFile virtualFile2) {
        boolean vcsIsThinking;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        if (ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(virtualFile2) == null) {
            return ThreeState.UNSURE;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)virtualFile2);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"VcsUtil.getFilePath(virtualFile)");
        FilePath path2 = filePath;
        boolean bl = vcsIsThinking = !VcsDirtyScopeManager.getInstance((Project)project).whatFilesDirty((Collection)CollectionsKt.listOf((Object)path2)).isEmpty();
        if (vcsIsThinking) {
            return ThreeState.UNSURE;
        }
        FileStatus status = FileStatusManager.getInstance((Project)project).getStatus(virtualFile2);
        if (status == FileStatus.UNKNOWN) {
            return ThreeState.UNSURE;
        }
        if (status == FileStatus.MERGE || status == FileStatus.MERGED_WITH_CONFLICTS || status == FileStatus.MERGED_WITH_BOTH_CONFLICTS || status == FileStatus.MERGED_WITH_PROPERTY_CONFLICTS) {
            return ThreeState.NO;
        }
        ThreeState threeState = ThreeState.fromBoolean((status != FileStatus.NOT_CHANGED ? 1 : 0) != 0);
        Intrinsics.checkNotNullExpressionValue((Object)threeState, (String)"ThreeState.fromBoolean(s\u2026= FileStatus.NOT_CHANGED)");
        return threeState;
    }
}

