/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.ErrorStripeUpdateManager;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPassFactory;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultHighlightInfoProcessor
extends HighlightInfoProcessor {
    private final Alarm repaintIconAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

    @Override
    public void highlightsInsideVisiblePartAreProduced(@NotNull HighlightingSession session2, @Nullable Editor editor, @NotNull List<? extends HighlightInfo> infos, @NotNull TextRange priorityRange, @NotNull TextRange restrictRange, int groupId2) {
        PsiFile psiFile;
        Project project;
        Document document;
        if (session2 == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(0);
        }
        if (infos == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(1);
        }
        if (priorityRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(2);
        }
        if (restrictRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(3);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = (psiFile = session2.getPsiFile()).getProject())).getDocument(psiFile)) == null) {
            return;
        }
        long modificationStamp = document.getModificationStamp();
        TextRange priorityIntersection = priorityRange.intersection(restrictRange);
        ArrayList<? extends HighlightInfo> infoCopy = new ArrayList<HighlightInfo>(infos);
        ((HighlightingSessionImpl)session2).applyInEDT(() -> {
            if (modificationStamp != document.getModificationStamp()) {
                return;
            }
            if (priorityIntersection != null) {
                MarkupModel markupModel = DocumentMarkupModel.forDocument(document, project, true);
                EditorColorsScheme scheme2 = session2.getColorsScheme();
                UpdateHighlightersUtil.setHighlightersInRange(project, document, priorityIntersection, scheme2, infoCopy, (MarkupModelEx)markupModel, groupId2);
            }
            if (editor != null && !editor.isDisposed()) {
                ShowAutoImportPassFactory siFactory;
                TextEditorHighlightingPass highlightingPass;
                if (!DumbService.isDumb((Project)project) && (highlightingPass = (siFactory = (ShowAutoImportPassFactory)TextEditorHighlightingPassRegistrarImpl.EP_NAME.findExtensionOrFail(ShowAutoImportPassFactory.class)).createHighlightingPass(psiFile, editor)) != null) {
                    highlightingPass.doApplyInformationToEditor();
                }
                DefaultHighlightInfoProcessor.repaintErrorStripeAndIcon(editor, project);
            }
        });
    }

    static void repaintErrorStripeAndIcon(@NotNull Editor editor, @NotNull Project project) {
        MarkupModel markup;
        if (editor == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(4);
        }
        if (project == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(5);
        }
        if ((markup = editor.getMarkupModel()) instanceof EditorMarkupModelImpl) {
            ((EditorMarkupModelImpl)markup).repaintTrafficLightIcon();
        }
        ErrorStripeUpdateManager.getInstance(project).repaintErrorStripePanel(editor);
    }

    @Override
    public void highlightsOutsideVisiblePartAreProduced(@NotNull HighlightingSession session2, @Nullable Editor editor, @NotNull List<? extends HighlightInfo> infos, @NotNull TextRange priorityRange, @NotNull TextRange restrictedRange, int groupId2) {
        PsiFile psiFile;
        Project project;
        Document document;
        if (session2 == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(6);
        }
        if (infos == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(7);
        }
        if (priorityRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(8);
        }
        if (restrictedRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(9);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = (psiFile = session2.getPsiFile()).getProject())).getDocument(psiFile)) == null) {
            return;
        }
        long modificationStamp = document.getModificationStamp();
        ((HighlightingSessionImpl)session2).applyInEDT(() -> {
            if (project.isDisposed() || modificationStamp != document.getModificationStamp()) {
                return;
            }
            EditorColorsScheme scheme2 = session2.getColorsScheme();
            UpdateHighlightersUtil.setHighlightersOutsideRange(project, document, psiFile, infos, scheme2, restrictedRange.getStartOffset(), restrictedRange.getEndOffset(), ProperTextRange.create((Segment)priorityRange), groupId2);
            if (editor != null) {
                DefaultHighlightInfoProcessor.repaintErrorStripeAndIcon(editor, project);
            }
        });
    }

    @Override
    public void allHighlightsForRangeAreProduced(@NotNull HighlightingSession session2, @NotNull TextRange elementRange, @Nullable List<? extends HighlightInfo> infos) {
        if (session2 == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(10);
        }
        if (elementRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(11);
        }
        DefaultHighlightInfoProcessor.killAbandonedHighlightsUnder(session2.getProject(), session2.getDocument(), elementRange, infos, session2);
    }

    private static void killAbandonedHighlightsUnder(@NotNull Project project, @NotNull Document document, @NotNull TextRange range2, @Nullable List<? extends HighlightInfo> infos, @NotNull HighlightingSession highlightingSession) {
        if (project == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(12);
        }
        if (document == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(13);
        }
        if (range2 == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(14);
        }
        if (highlightingSession == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(15);
        }
        DaemonCodeAnalyzerEx.processHighlights(document, project, null, range2.getStartOffset(), range2.getEndOffset(), (Processor<? super HighlightInfo>)((Processor)existing -> {
            if (existing.isBijective() && existing.getGroup() == 4 && range2.equalsToRange(existing.getActualStartOffset(), existing.getActualEndOffset())) {
                if (infos != null) {
                    for (HighlightInfo created : infos) {
                        if (!existing.equalsByActualOffset(created)) continue;
                        return true;
                    }
                }
                ((HighlightingSessionImpl)highlightingSession).queueDisposeHighlighterFor((HighlightInfo)existing);
            }
            return true;
        }));
    }

    @Override
    public void infoIsAvailable(@NotNull HighlightingSession session2, @NotNull HighlightInfo info2, @NotNull TextRange priorityRange, @NotNull TextRange restrictedRange, int groupId2) {
        if (session2 == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(16);
        }
        if (info2 == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(17);
        }
        if (priorityRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(18);
        }
        if (restrictedRange == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(19);
        }
        ((HighlightingSessionImpl)session2).queueHighlightInfo(info2, restrictedRange, groupId2);
    }

    @Override
    public void progressIsAdvanced(@NotNull HighlightingSession highlightingSession, @Nullable Editor editor, double progress2) {
        if (highlightingSession == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(20);
        }
        PsiFile file2 = highlightingSession.getPsiFile();
        this.repaintTrafficIcon(file2, editor, progress2);
    }

    private void repaintTrafficIcon(@NotNull PsiFile file2, @Nullable Editor editor, double progress2) {
        if (file2 == null) {
            DefaultHighlightInfoProcessor.$$$reportNull$$$0(21);
        }
        if (ApplicationManager.getApplication().isCommandLine()) {
            return;
        }
        if (this.repaintIconAlarm.isEmpty() || progress2 >= 1.0) {
            this.repaintIconAlarm.addRequest(() -> {
                Project myProject = file2.getProject();
                if (myProject.isDisposed()) {
                    return;
                }
                Editor myeditor = editor;
                if (myeditor == null) {
                    myeditor = PsiEditorUtil.findEditor((PsiElement)file2);
                }
                if (myeditor != null && !myeditor.isDisposed()) {
                    DefaultHighlightInfoProcessor.repaintErrorStripeAndIcon(myeditor, myProject);
                }
            }, 50, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 2: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictedRange";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementRange";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingSession";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightsInsideVisiblePartAreProduced";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "repaintErrorStripeAndIcon";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightsOutsideVisiblePartAreProduced";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "allHighlightsForRangeAreProduced";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "killAbandonedHighlightsUnder";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "infoIsAvailable";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "progressIsAdvanced";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "repaintTrafficIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

