/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.psi.XmlPsiBundle;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InsertRequiredAttributeFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private final String myAttrName;
    private final String[] myValues;
    @NonNls
    private static final String NAME_TEMPLATE_VARIABLE = "name";

    public InsertRequiredAttributeFix(@NotNull XmlTag tag2, @NotNull String attrName, String ... values2) {
        if (tag2 == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(0);
        }
        if (attrName == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(1);
        }
        if (values2 == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(2);
        }
        super((PsiElement)tag2);
        this.myAttrName = attrName;
        this.myValues = values2;
    }

    @NotNull
    public String getText() {
        String string = XmlPsiBundle.message((String)"xml.quickfix.insert.required.attribute.text", (Object[])new Object[]{this.myAttrName});
        if (string == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlPsiBundle.message((String)"xml.quickfix.insert.required.attribute.family", (Object[])new Object[0]);
        if (string == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        boolean anchorIsEmptyTag;
        if (project == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(8);
        }
        XmlTag myTag = (XmlTag)startElement;
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)myTag);
        XmlElementDescriptor descriptor2 = myTag.getDescriptor();
        if (descriptor2 == null) {
            return;
        }
        XmlAttributeDescriptor attrDescriptor = descriptor2.getAttributeDescriptor(this.myAttrName, myTag);
        boolean indirectSyntax = XmlExtension.getExtension(myTag.getContainingFile()).isIndirectSyntax(attrDescriptor);
        boolean insertShorthand = myTag instanceof HtmlTag && attrDescriptor != null && HtmlUtil.isBooleanAttribute(attrDescriptor, (PsiElement)myTag);
        PsiElement anchor2 = SourceTreeToPsiMap.treeElementToPsi(XmlChildRole.EMPTY_TAG_END_FINDER.findChild(treeElement));
        boolean bl = anchorIsEmptyTag = anchor2 != null;
        if (anchor2 == null) {
            anchor2 = SourceTreeToPsiMap.treeElementToPsi(XmlChildRole.START_TAG_END_FINDER.findChild(treeElement));
        }
        if (anchor2 == null) {
            return;
        }
        Template template = TemplateManager.getInstance(project).createTemplate("", "");
        String valuePostfix = "\"";
        if (indirectSyntax) {
            if (anchorIsEmptyTag) {
                template.addTextSegment(">");
            }
            template.addTextSegment("<jsp:attribute name=\"" + this.myAttrName + "\">");
        } else {
            template.addTextSegment(" " + this.myAttrName);
            if (!insertShorthand) {
                String quote = XmlEditUtil.getAttributeQuote(file2);
                XmlExtension.AttributeValuePresentation presentation2 = XmlExtension.getExtension(file2).getAttributeValuePresentation(myTag, this.myAttrName, quote);
                valuePostfix = presentation2.getPostfix();
                template.addTextSegment("=" + presentation2.getPrefix());
            }
        }
        ConstantNode expression = new ConstantNode("").withLookupStrings(this.myValues);
        if (!insertShorthand) {
            template.addVariable(NAME_TEMPLATE_VARIABLE, (Expression)expression, (Expression)expression, true);
        }
        if (indirectSyntax) {
            template.addTextSegment("</jsp:attribute>");
            template.addEndVariable();
            if (anchorIsEmptyTag) {
                template.addTextSegment("</" + myTag.getName() + ">");
            }
        } else if (!insertShorthand) {
            template.addTextSegment(valuePostfix);
        }
        PsiElement anchor1 = anchor2;
        ApplicationManager.getApplication().invokeLater(() -> WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getText(), (String)this.getFamilyName(), () -> {
            int textOffset = anchor1.getTextOffset();
            if (!anchorIsEmptyTag && indirectSyntax) {
                ++textOffset;
            }
            editor.getCaretModel().moveToOffset(textOffset);
            if (anchorIsEmptyTag && indirectSyntax) {
                editor.getDocument().deleteString(textOffset, textOffset + 2);
            }
            TemplateManager.getInstance(project).startTemplate(editor, template);
        }, (PsiFile[])new PsiFile[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

