/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.diagnostic.VMOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;

abstract class AbstractDocRenderMemoryManager<T> {
    private static final Logger LOG = Logger.getInstance(AbstractDocRenderMemoryManager.class);
    private final LinkedHashMap<T, Integer> myNotPaintedCache;
    private final LinkedHashMap<T, Integer> myPaintedCache;
    private final int myCacheSizeLimitKb;
    private int myTotalSize;

    AbstractDocRenderMemoryManager(@NotNull String sizeRegistryKey) {
        if (sizeRegistryKey == null) {
            AbstractDocRenderMemoryManager.$$$reportNull$$$0(0);
        }
        this.myNotPaintedCache = new LinkedHashMap();
        this.myPaintedCache = new LinkedHashMap();
        int memorySizeMb = 750;
        try {
            memorySizeMb = VMOptions.readOption(VMOptions.MemoryKind.HEAP, true);
        }
        catch (Throwable e) {
            LOG.error("Failed to get Xmx", e);
        }
        int cacheSize = 10000;
        try {
            cacheSize = Math.max(cacheSize, (int)((double)(memorySizeMb * 1024) * Registry.get((String)sizeRegistryKey).asDouble()));
        }
        catch (Throwable e) {
            LOG.error("Error calculating cache size limit", e);
        }
        this.myCacheSizeLimitKb = cacheSize;
        LOG.debug("Cache size: " + this.myCacheSizeLimitKb + "kB");
    }

    synchronized void register(@NotNull T object, int sizeKb) {
        T toRemove2;
        if (object == null) {
            AbstractDocRenderMemoryManager.$$$reportNull$$$0(1);
        }
        this.unregister(object);
        this.myNotPaintedCache.put(object, sizeKb);
        this.myTotalSize += sizeKb;
        while (this.myNotPaintedCache.size() > 1 && this.myTotalSize > this.myCacheSizeLimitKb) {
            toRemove2 = this.myNotPaintedCache.keySet().iterator().next();
            this.destroy(toRemove2);
            assert (!this.myNotPaintedCache.containsKey(toRemove2));
        }
        while (!this.myPaintedCache.isEmpty() && this.myTotalSize > this.myCacheSizeLimitKb) {
            toRemove2 = this.myPaintedCache.keySet().iterator().next();
            this.destroy(toRemove2);
            assert (!this.myPaintedCache.containsKey(toRemove2));
        }
    }

    synchronized void unregister(@NotNull T object) {
        Integer oldSize;
        if (object == null) {
            AbstractDocRenderMemoryManager.$$$reportNull$$$0(2);
        }
        if ((oldSize = (Integer)this.myNotPaintedCache.remove(object)) != null) {
            this.myTotalSize -= oldSize.intValue();
        }
        if ((oldSize = (Integer)this.myPaintedCache.remove(object)) != null) {
            this.myTotalSize -= oldSize.intValue();
        }
    }

    synchronized void notifyPainted(@NotNull T object) {
        Integer size2;
        if (object == null) {
            AbstractDocRenderMemoryManager.$$$reportNull$$$0(3);
        }
        if ((size2 = (Integer)this.myNotPaintedCache.remove(object)) == null) {
            size2 = (Integer)this.myPaintedCache.remove(object);
        }
        if (size2 != null) {
            this.myPaintedCache.put(object, size2);
        }
    }

    abstract void destroy(@NotNull T var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sizeRegistryKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/render/AbstractDocRenderMemoryManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unregister";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyPainted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

