/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CodeDocumentationUtil;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.text.CharArrayUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnterAfterJavadocTagHandler
extends EnterHandlerDelegateAdapter {
    private static final Context NOT_MATCHED_CONTEXT = new Context();

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file2 == null) {
            EnterAfterJavadocTagHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            EnterAfterJavadocTagHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            EnterAfterJavadocTagHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            EnterAfterJavadocTagHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            EnterAfterJavadocTagHandler.$$$reportNull$$$0(4);
        }
        if (!CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        CharSequence text2 = document.getCharsSequence();
        int line = document.getLineNumber(((Integer)caretOffset.get()).intValue());
        int start2 = document.getLineStartOffset(line);
        int end = document.getLineEndOffset(line);
        CodeDocumentationUtil.CommentContext commentContext = CodeDocumentationUtil.tryParseCommentContext(file2, text2, (Integer)caretOffset.get(), start2);
        if (!commentContext.docAsterisk) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Context context2 = EnterAfterJavadocTagHandler.parse(text2, start2, end, (Integer)caretOffset.get());
        if (!context2.shouldGenerateLine()) {
            return context2.shouldIndent() ? EnterHandlerDelegate.Result.DefaultForceIndent : EnterHandlerDelegate.Result.Continue;
        }
        String indentInsideJavadoc = CodeDocumentationUtil.getIndentInsideJavadoc(document, (Integer)caretOffset.get());
        boolean restoreCaret = false;
        if ((Integer)caretOffset.get() != context2.endTagStartOffset) {
            editor.getCaretModel().moveToOffset(context2.endTagStartOffset);
            restoreCaret = true;
        }
        originalHandler.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
        Project project = editor.getProject();
        if (indentInsideJavadoc != null && project != null && CodeStyleManager.getInstance((Project)project).getDocCommentSettings(file2).isLeadingAsteriskEnabled()) {
            document.insertString(editor.getCaretModel().getOffset(), (CharSequence)("*" + indentInsideJavadoc));
        }
        if (restoreCaret) {
            editor.getCaretModel().moveToOffset(((Integer)caretOffset.get()).intValue());
        }
        return EnterHandlerDelegate.Result.DefaultForceIndent;
    }

    @NotNull
    static Context parse(@NotNull CharSequence text2, int startOffset, int endOffset, int offset) {
        int asteriskOffset;
        if (text2 == null) {
            EnterAfterJavadocTagHandler.$$$reportNull$$$0(5);
        }
        if ((asteriskOffset = StringUtil.indexOf((CharSequence)text2, (char)'*', (int)startOffset, (int)endOffset)) < 0) {
            Context context2 = NOT_MATCHED_CONTEXT;
            if (context2 == null) {
                EnterAfterJavadocTagHandler.$$$reportNull$$$0(6);
            }
            return context2;
        }
        startOffset = asteriskOffset + 1;
        int startTagStartOffset = -1;
        int startTagEndOffset = -1;
        HashSet<CharSequence> closedTags = new HashSet<CharSequence>();
        CharSequence startTag = null;
        for (int i2 = offset - 1; i2 >= startOffset; --i2) {
            CharSequence tag2;
            char c = text2.charAt(i2);
            if (c == ' ' || c == '\t') continue;
            if (c == '>' && startTagEndOffset < 0) {
                if (i2 > startOffset && text2.charAt(i2 - 1) == '/') break;
                startTagEndOffset = i2;
                continue;
            }
            if (c != '<') continue;
            if (startTagEndOffset < 0 || i2 >= endOffset) break;
            if (text2.charAt(i2 + 1) == '/') {
                tag2 = text2.subSequence(i2 + 2, startTagEndOffset);
                closedTags.add(tag2);
                startTagEndOffset = -1;
                continue;
            }
            tag2 = text2.subSequence(i2 + 1, startTagEndOffset);
            if (closedTags.remove(tag2)) {
                startTagEndOffset = -1;
                continue;
            }
            startTagStartOffset = i2;
            startTag = text2.subSequence(i2 + 1, startTagEndOffset + 1);
            break;
        }
        if (startTagStartOffset < 0) {
            Context context3 = NOT_MATCHED_CONTEXT;
            if (context3 == null) {
                EnterAfterJavadocTagHandler.$$$reportNull$$$0(7);
            }
            return context3;
        }
        int endTagStartOffset = -1;
        for (int i3 = offset; i3 < endOffset; ++i3) {
            char c = text2.charAt(i3);
            if (c != '<' || i3 >= endOffset - 2 || text2.charAt(i3 + 1) != '/' || startTag == null || !CharArrayUtil.regionMatches((CharSequence)text2, (int)(i3 + 2), (int)endOffset, startTag)) continue;
            endTagStartOffset = i3;
            break;
        }
        return new Context(text2, startTagEndOffset, endTagStartOffset, startTag, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/enter/EnterAfterJavadocTagHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/enter/EnterAfterJavadocTagHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Context {
        public final int startTagEndOffset;
        public final int endTagStartOffset;
        @Nullable
        public final String startTag;
        @Nullable
        private final CharSequence myText;
        private final int myOffset;

        Context() {
            this(null, -1, -1, null, -1);
        }

        Context(@Nullable CharSequence text2, int startTagEndOffset, int endTagStartOffset, @Nullable CharSequence tag2, int offset) {
            this.myText = text2;
            this.startTagEndOffset = startTagEndOffset;
            this.endTagStartOffset = endTagStartOffset;
            this.startTag = tag2 != null ? tag2.toString() : null;
            this.myOffset = offset;
        }

        public boolean shouldGenerateLine() {
            return this.endTagStartOffset >= 0 && this.shouldIndent();
        }

        public boolean shouldIndent() {
            if (this.startTagEndOffset < 0 || this.myText == null || "br".equals(Context.getTagName(this.startTag))) {
                return false;
            }
            for (int i2 = this.startTagEndOffset + 1; i2 < this.myOffset; ++i2) {
                char c = this.myText.charAt(i2);
                if (c == ' ' || c == '\t') continue;
                return false;
            }
            return true;
        }

        private static String getTagName(@Nullable String tag2) {
            if (tag2 == null) {
                return null;
            }
            int start2 = -1;
            for (int i2 = 0; i2 < tag2.length(); ++i2) {
                char c = tag2.charAt(i2);
                if (Character.isAlphabetic(c)) {
                    if (start2 >= 0) continue;
                    start2 = i2;
                    continue;
                }
                if (start2 < 0) continue;
                return tag2.substring(start2, i2);
            }
            return start2 >= 0 ? tag2.substring(start2) : null;
        }
    }
}

