/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoComponent;
import com.intellij.codeInsight.hint.ParameterInfoControllerBase;
import com.intellij.codeInsight.hint.ParameterInfoControllerData;
import com.intellij.codeInsight.hint.ParameterInfoListener;
import com.intellij.codeInsight.hint.ParameterInfoTaskRunnerUtil;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeTooltip;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ParameterInfoController
extends ParameterInfoControllerBase {
    private LightweightHint myHint;
    private final ParameterInfoComponent myComponent;
    private boolean myKeepOnHintHidden;
    private final MyBestLocationPointProvider myProvider;

    @Override
    protected boolean canBeDisposed() {
        return !this.myHint.isVisible() && !this.myKeepOnHintHidden && !ApplicationManager.getApplication().isHeadlessEnvironment() || this.myEditor instanceof EditorWindow && !((EditorWindow)this.myEditor).isValid();
    }

    @Override
    public boolean isHintShown(boolean anyType) {
        return this.myHint.isVisible() && (!this.mySingleParameterInfo || anyType);
    }

    public ParameterInfoController(@NotNull Project project, @NotNull Editor editor, int lbraceOffset, Object[] descriptors2, Object highlighted, PsiElement parameterOwner, @NotNull ParameterInfoHandler handler2, boolean showHint2, boolean requestFocus) {
        if (project == null) {
            ParameterInfoController.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ParameterInfoController.$$$reportNull$$$0(1);
        }
        if (handler2 == null) {
            ParameterInfoController.$$$reportNull$$$0(2);
        }
        super(project, editor, lbraceOffset, descriptors2, highlighted, parameterOwner, handler2, showHint2);
        this.myProvider = new MyBestLocationPointProvider(editor);
        this.myComponent = new ParameterInfoComponent(this.myParameterInfoControllerData, editor, requestFocus, true);
        this.myHint = this.createHint();
        this.myKeepOnHintHidden = !showHint2;
        this.myHint.setSelectingHint(true);
        this.myParameterInfoControllerData.setParameterOwner(parameterOwner);
        this.myParameterInfoControllerData.setHighlighted(highlighted);
        this.registerSelf();
        this.setupListeners();
        LookupListener lookupListener = new LookupListener(){
            LookupImpl activeLookup = null;
            final MergingUpdateQueue queue;
            {
                this.queue = new MergingUpdateQueue("Update parameter info position", 200, true, (JComponent)ParameterInfoController.this.myComponent);
            }

            public void lookupShown(@NotNull LookupEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.activeLookup = (LookupImpl)event.getLookup();
            }

            public void uiRefreshed() {
                this.queue.queue(new Update("PI update"){

                    public void run() {
                        if (activeLookup != null) {
                            ParameterInfoController.this.updateComponent();
                        }
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/hint/ParameterInfoController$1", "lookupShown"));
            }
        };
        LookupManagerListener lookupManagerListener = (oldLookup, newLookup) -> {
            if (newLookup != null && ClientId.isCurrentlyUnderLocalId()) {
                newLookup.addLookupListener(lookupListener);
            }
        };
        project.getMessageBus().connect((Disposable)this).subscribe(LookupManagerListener.TOPIC, (Object)lookupManagerListener);
        if (showHint2) {
            this.showHint(requestFocus, this.mySingleParameterInfo);
        } else {
            this.updateComponent();
        }
    }

    @Override
    public void setDescriptors(Object[] descriptors2) {
        super.setDescriptors(descriptors2);
        this.myComponent.fireDescriptorsWereSet();
    }

    @Override
    @NotNull
    protected ParameterInfoControllerData createParameterInfoControllerData(@NotNull ParameterInfoHandler<PsiElement, Object> handler2) {
        if (handler2 == null) {
            ParameterInfoController.$$$reportNull$$$0(3);
        }
        return new ParameterInfoControllerData(handler2){

            @Override
            public boolean isDescriptorEnabled(int descriptorIndex) {
                return ParameterInfoController.this.myComponent.isEnabled(descriptorIndex);
            }

            @Override
            public void setDescriptorEnabled(int descriptorIndex, boolean enabled) {
                ParameterInfoController.this.myComponent.setEnabled(descriptorIndex, enabled);
            }
        };
    }

    private LightweightHint createHint() {
        WrapperPanel wrapper2 = new WrapperPanel();
        wrapper2.add(this.myComponent);
        return new LightweightHint(wrapper2);
    }

    @Override
    public void showHint(boolean requestFocus, boolean singleParameterInfo) {
        if (this.myHint.isVisible()) {
            JComponent myHintComponent = this.myHint.getComponent();
            myHintComponent.removeAll();
            this.hideHint();
            this.myHint = this.createHint();
        }
        this.mySingleParameterInfo = singleParameterInfo && this.myKeepOnHintHidden;
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        Pair<Point, Short> pos = this.myProvider.getBestPointPosition(this.myHint, this.myParameterInfoControllerData.getParameterOwner(), caretOffset, null, (short)1);
        HintHint hintHint = HintManagerImpl.createHintHint(this.myEditor, (Point)pos.getFirst(), this.myHint, (Short)pos.getSecond());
        hintHint.setExplicitClose(true);
        hintHint.setRequestFocus(requestFocus);
        hintHint.setShowImmediately(true);
        hintHint.setBorderColor(ParameterInfoComponent.BORDER_COLOR);
        hintHint.setBorderInsets((Insets)JBUI.insets((int)4, (int)1, (int)4, (int)1));
        hintHint.setComponentBorder((Border)JBUI.Borders.empty());
        int flags = 129;
        if (!singleParameterInfo && this.myKeepOnHintHidden) {
            flags |= 8;
        }
        Editor editorToShow = this.myEditor instanceof EditorWindow ? ((EditorWindow)this.myEditor).getDelegate() : this.myEditor;
        this.myComponent.update(this.mySingleParameterInfo);
        HintManagerImpl.getInstanceImpl().showEditorHint(this.myHint, editorToShow, (Point)pos.getFirst(), flags, 0, false, hintHint);
        this.updateComponent();
    }

    @Override
    public void updateComponent() {
        if (this.canBeDisposed()) {
            Disposer.dispose((Disposable)this);
            return;
        }
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)this.myEditor, (Project)this.myProject);
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        int offset = this.getCurrentOffset();
        ParameterInfoControllerBase.UpdateParameterInfoContextBase context2 = new ParameterInfoControllerBase.UpdateParameterInfoContextBase(this, offset, file2);
        this.executeFindElementForUpdatingParameterInfo(context2, elementForUpdating -> {
            this.myParameterInfoControllerData.getHandler().processFoundElementForUpdatingParameterInfo(elementForUpdating, (UpdateParameterInfoContext)context2);
            if (elementForUpdating != null) {
                this.executeUpdateParameterInfo((PsiElement)elementForUpdating, context2, () -> {
                    boolean knownParameter;
                    boolean bl = knownParameter = (this.myParameterInfoControllerData.getDescriptors().length == 1 || this.myParameterInfoControllerData.getHighlighted() != null) && this.myParameterInfoControllerData.getCurrentParameterIndex() != -1;
                    if (this.mySingleParameterInfo && !knownParameter && this.myHint.isVisible()) {
                        this.hideHint();
                    }
                    if (this.myKeepOnHintHidden && knownParameter && !this.myHint.isVisible()) {
                        AutoPopupController.getInstance(this.myProject).autoPopupParameterInfo(this.myEditor, null);
                    }
                    if (!this.myDisposed && (this.myHint.isVisible() && !this.myEditor.isDisposed() && (this.myEditor.getComponent().getRootPane() != null || ApplicationManager.getApplication().isUnitTestMode()) || ApplicationManager.getApplication().isHeadlessEnvironment())) {
                        ParameterInfoControllerBase.Model result2 = this.myComponent.update(this.mySingleParameterInfo);
                        result2.project = this.myProject;
                        result2.range = this.myParameterInfoControllerData.getParameterOwner().getTextRange();
                        result2.editor = this.myEditor;
                        for (ParameterInfoListener listener2 : ParameterInfoListener.EP_NAME.getExtensionList()) {
                            listener2.hintUpdated(result2);
                        }
                        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                            return;
                        }
                        IdeTooltip tooltip2 = this.myHint.getCurrentIdeTooltip();
                        short position = tooltip2 != null ? ParameterInfoController.toShort(tooltip2.getPreferredPosition()) : (short)1;
                        Pair<Point, Short> pos = this.myProvider.getBestPointPosition(this.myHint, (PsiElement)elementForUpdating, caretOffset, this.myEditor.getCaretModel().getVisualPosition(), position);
                        HintManagerImpl.adjustEditorHintPosition(this.myHint, this.myEditor, (Point)pos.getFirst(), (Short)pos.getSecond());
                    }
                });
            } else {
                this.hideHint();
                if (!this.myKeepOnHintHidden) {
                    Disposer.dispose((Disposable)this);
                }
            }
        });
    }

    private void executeUpdateParameterInfo(PsiElement elementForUpdating, ParameterInfoControllerBase.UpdateParameterInfoContextBase context2, Runnable continuation) {
        PsiElement parameterOwner = context2.getParameterOwner();
        if (parameterOwner != null && !parameterOwner.equals(elementForUpdating)) {
            context2.removeHint();
            return;
        }
        ParameterInfoTaskRunnerUtil.runTask(this.myProject, ReadAction.nonBlocking(() -> {
            DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> this.myParameterInfoControllerData.getHandler().updateParameterInfo((Object)elementForUpdating, (UpdateParameterInfoContext)context2));
            return elementForUpdating;
        }).withDocumentsCommitted(this.myProject).expireWhen(() -> !this.myKeepOnHintHidden && !this.myHint.isVisible() && !ApplicationManager.getApplication().isHeadlessEnvironment() || this.getCurrentOffset() != context2.getOffset() || !elementForUpdating.isValid()).expireWith((Disposable)this), element2 -> {
            if (element2 != null && continuation != null) {
                context2.applyUIChanges();
                continuation.run();
            }
        }, null, this.myEditor);
    }

    @HintManager.PositionFlags
    private static short toShort(Balloon.Position position) {
        switch (position) {
            case above: {
                return 1;
            }
            case atLeft: {
                return 3;
            }
            case atRight: {
                return 4;
            }
        }
        return 2;
    }

    @Override
    protected void moveToParameterAtOffset(int offset) {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        Object argsList = ParameterInfoController.findArgumentList(file2, offset, -1);
        if (argsList == null && !CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION) {
            return;
        }
        if (!this.myHint.isVisible()) {
            AutoPopupController.getInstance(this.myProject).autoPopupParameterInfo(this.myEditor, null);
        }
        offset = this.adjustOffsetToInlay(offset);
        this.myEditor.getCaretModel().moveToOffset(offset);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        this.myEditor.getSelectionModel().removeSelection();
        if (argsList != null) {
            this.executeUpdateParameterInfo((PsiElement)argsList, new ParameterInfoControllerBase.UpdateParameterInfoContextBase(this, offset, file2), null);
        }
    }

    private int adjustOffsetToInlay(int offset) {
        CharSequence text2 = this.myEditor.getDocument().getImmutableCharSequence();
        int hostWhitespaceStart = CharArrayUtil.shiftBackward((CharSequence)text2, (int)offset, (String)" \t") + 1;
        int hostWhitespaceEnd = CharArrayUtil.shiftForward((CharSequence)text2, (int)offset, (String)" \t");
        Editor hostEditor = this.myEditor;
        if (this.myEditor instanceof EditorWindow) {
            hostEditor = ((EditorWindow)this.myEditor).getDelegate();
            hostWhitespaceStart = ((EditorWindow)this.myEditor).getDocument().injectedToHost(hostWhitespaceStart);
            hostWhitespaceEnd = ((EditorWindow)this.myEditor).getDocument().injectedToHost(hostWhitespaceEnd);
        }
        List<Inlay> inlays = ParameterHintsPresentationManager.getInstance().getParameterHintsInRange(hostEditor, hostWhitespaceStart, hostWhitespaceEnd);
        for (Inlay inlay : inlays) {
            int inlayOffset = inlay.getOffset();
            if (this.myEditor instanceof EditorWindow) {
                if (((EditorWindow)this.myEditor).getDocument().getHostRange(inlayOffset) == null) continue;
                inlayOffset = ((EditorWindow)this.myEditor).getDocument().hostToInjected(inlayOffset);
            }
            return inlayOffset;
        }
        return offset;
    }

    @Override
    public void setPreservedOnHintHidden(boolean value2) {
        this.myKeepOnHintHidden = value2;
    }

    @Override
    public boolean isPreservedOnHintHidden() {
        return this.myKeepOnHintHidden;
    }

    static Pair<Point, Short> chooseBestHintPosition(Editor editor, VisualPosition pos, LightweightHint hint, LookupImpl activeLookup, short preferredPosition, boolean showLookupHint) {
        boolean p2Ok;
        boolean p1Ok;
        Point p2;
        Point p1;
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return Pair.pair((Object)new Point(), (Object)6);
        }
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        Dimension hintSize = hint.getComponent().getPreferredSize();
        JComponent editorComponent = editor.getComponent();
        JLayeredPane layeredPane2 = editorComponent.getRootPane().getLayeredPane();
        if (showLookupHint) {
            p1 = hintManager.getHintPosition(hint, editor, (short)2);
            p2 = hintManager.getHintPosition(hint, editor, (short)1);
        } else {
            p1 = HintManagerImpl.getHintPosition(hint, editor, pos, (short)2);
            p2 = HintManagerImpl.getHintPosition(hint, editor, pos, (short)1);
        }
        boolean isRealPopup = hint.isRealPopup();
        if (!showLookupHint && activeLookup != null && activeLookup.isShown()) {
            Rectangle lookupBounds = activeLookup.getBounds();
            p1Ok = p1.y + hintSize.height + 50 < layeredPane2.getHeight() && !ParameterInfoController.isHintIntersectWithLookup(p1, hintSize, lookupBounds, isRealPopup, (short)2);
            boolean bl = p2Ok = p2.y - hintSize.height - 70 >= 0 && !ParameterInfoController.isHintIntersectWithLookup(p2, hintSize, lookupBounds, isRealPopup, (short)1);
            if (activeLookup.isPositionedAboveCaret()) {
                if (!p1Ok) {
                    Point abovePoint = new Point(lookupBounds.x, lookupBounds.y - hintSize.height - 10);
                    SwingUtilities.convertPointToScreen(abovePoint, layeredPane2);
                    abovePoint.move(lookupBounds.x, lookupBounds.y - hintSize.height - 10);
                    hint.setForceShowAsPopup(true);
                    return new Pair((Object)abovePoint, (Object)6);
                }
            } else if (!p2Ok) {
                Point underPoint = new Point(lookupBounds.x, lookupBounds.y + lookupBounds.height + 10);
                SwingUtilities.convertPointToScreen(underPoint, layeredPane2);
                Rectangle screenRectangle = new Rectangle(underPoint, hintSize);
                if (ParameterInfoController.isFitTheScreen(screenRectangle)) {
                    underPoint.move(lookupBounds.x, lookupBounds.y + lookupBounds.height + 10);
                    hint.setForceShowAsPopup(true);
                    return new Pair((Object)underPoint, (Object)6);
                }
                hint.setForceShowAsPopup(true);
                Point abovePoint = new Point(p2.x - hintSize.width / 2, p2.y - hintSize.height);
                return new Pair((Object)abovePoint, (Object)1);
            }
        } else {
            p1Ok = p1.y + hintSize.height < layeredPane2.getHeight();
            boolean bl = p2Ok = p2.y >= 0;
        }
        if (isRealPopup) {
            hint.setForceShowAsPopup(false);
        }
        if (!showLookupHint && preferredPosition != 6) {
            if (preferredPosition == 1) {
                if (p2Ok) {
                    return new Pair((Object)p2, (Object)1);
                }
            } else if (preferredPosition == 2 && p1Ok) {
                return new Pair((Object)p1, (Object)2);
            }
        }
        if (p1Ok) {
            return new Pair((Object)p1, (Object)2);
        }
        if (p2Ok) {
            return new Pair((Object)p2, (Object)1);
        }
        int aboveSpace = p2.y;
        int underSpace = layeredPane2.getHeight() - p1.y;
        return aboveSpace > underSpace ? new Pair((Object)new Point(p2.x, 0), (Object)2) : new Pair((Object)p1, (Object)1);
    }

    private static boolean isFitTheScreen(Rectangle aRectangle) {
        int screenX = aRectangle.x + aRectangle.width / 2;
        int screenY = aRectangle.y + aRectangle.height / 2;
        Rectangle screen = ScreenUtil.getScreenRectangle((int)screenX, (int)screenY);
        return screen.contains(aRectangle);
    }

    private static boolean isHintIntersectWithLookup(Point hintPoint, Dimension hintSize, Rectangle lookupBounds, boolean isRealPopup, short hintPosition) {
        Point leftTopPoint = isRealPopup ? hintPoint : (hintPosition == 1 ? new Point(hintPoint.x - hintSize.width / 2, hintPoint.y - hintSize.height) : new Point(hintPoint.x - hintSize.width / 2, hintPoint.y));
        return lookupBounds.intersects(new Rectangle(leftTopPoint, hintSize));
    }

    @Override
    protected void hideHint() {
        this.myHint.hide();
        for (ParameterInfoListener listener2 : ParameterInfoListener.EP_NAME.getExtensionList()) {
            listener2.hintHidden(this.myProject);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/hint/ParameterInfoController";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createParameterInfoControllerData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class WrapperPanel
    extends JPanel {
        WrapperPanel() {
            super(new BorderLayout());
            this.setBorder((Border)JBUI.Borders.empty());
        }

        @Override
        public Color getForeground() {
            return this.getComponentCount() == 0 ? super.getForeground() : this.getComponent(0).getForeground();
        }

        @Override
        public Color getBackground() {
            return this.getComponentCount() == 0 ? super.getBackground() : this.getComponent(0).getBackground();
        }

        @Override
        public Font getFont() {
            return this.getComponentCount() == 0 ? super.getFont() : this.getComponent(0).getFont();
        }

        @Override
        public String toString() {
            return this.getComponentCount() == 0 ? "<empty>" : this.getComponent(0).toString();
        }
    }

    private static class MyBestLocationPointProvider {
        private final Editor myEditor;
        private int previousOffset = -1;
        private Rectangle previousLookupBounds;
        private Dimension previousHintSize;
        private Point previousBestPoint;
        private Short previousBestPosition;

        MyBestLocationPointProvider(Editor editor) {
            this.myEditor = editor;
        }

        @NotNull
        private Pair<Point, Short> getBestPointPosition(LightweightHint hint, PsiElement list2, int offset, VisualPosition pos, short preferredPosition) {
            Pair position;
            boolean isMultiline;
            boolean hintSizeChanged;
            TextRange range2;
            TextRange rangeWithoutParens;
            if (list2 != null && !(rangeWithoutParens = TextRange.from((int)((range2 = list2.getTextRange()).getStartOffset() + 1), (int)Math.max(range2.getLength() - 2, 0))).contains(offset)) {
                offset = offset < rangeWithoutParens.getStartOffset() ? rangeWithoutParens.getStartOffset() : rangeWithoutParens.getEndOffset();
                pos = null;
            }
            LookupImpl activeLookup = (LookupImpl)LookupManager.getActiveLookup(this.myEditor);
            Rectangle lookupBounds = !ApplicationManager.getApplication().isUnitTestMode() && activeLookup != null && activeLookup.isShown() ? activeLookup.getBounds() : null;
            Dimension hintSize = hint.getSize();
            boolean lookupPositionChanged = lookupBounds != null && !lookupBounds.equals(this.previousLookupBounds);
            boolean bl = hintSizeChanged = !hintSize.equals(this.previousHintSize);
            if (this.previousOffset == offset && !lookupPositionChanged && !hintSizeChanged) {
                Pair pair = Pair.create((Object)this.previousBestPoint, (Object)this.previousBestPosition);
                if (pair == null) {
                    MyBestLocationPointProvider.$$$reportNull$$$0(0);
                }
                return pair;
            }
            boolean bl2 = isMultiline = list2 != null && StringUtil.containsAnyChar((String)list2.getText(), (String)"\n\r");
            if (pos == null) {
                pos = EditorUtil.inlayAwareOffsetToVisualPosition(this.myEditor, offset);
            }
            if (!isMultiline) {
                position = ParameterInfoController.chooseBestHintPosition(this.myEditor, pos, hint, activeLookup, preferredPosition, false);
            } else {
                Point p = HintManagerImpl.getHintPosition(hint, this.myEditor, pos, (short)1);
                position = new Pair((Object)p, (Object)1);
            }
            this.previousBestPoint = (Point)position.getFirst();
            this.previousBestPosition = (Short)position.getSecond();
            this.previousOffset = offset;
            this.previousLookupBounds = lookupBounds;
            this.previousHintSize = hintSize;
            Pair pair = position;
            if (pair == null) {
                MyBestLocationPointProvider.$$$reportNull$$$0(1);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ParameterInfoController$MyBestLocationPointProvider", "getBestPointPosition"));
        }
    }
}

