/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.actions;

import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.codeInsight.hint.ImplementationViewElement;
import com.intellij.codeInsight.hint.ImplementationViewSession;
import com.intellij.codeInsight.hint.ImplementationViewSessionFactory;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTaskBase;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.searcheverywhere.PSIPresentationBgRendererWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GenericListComponentUpdater;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.reference.SoftReference;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageView;
import com.intellij.util.Processor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public abstract class ShowRelatedElementsActionBase
extends DumbAwareAction
implements PopupAction {
    private Reference<JBPopup> myPopupRef;
    private Reference<ImplementationsUpdaterTask> myTaskRef;

    public ShowRelatedElementsActionBase() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(0);
        }
        this.performForContext(e.getDataContext(), true);
    }

    @TestOnly
    public void performForContext(DataContext dataContext) {
        this.performForContext(dataContext, true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        e.getPresentation().setEnabled(project != null);
    }

    public void performForContext(@NotNull DataContext dataContext, boolean invokedByShortcut) {
        Project project;
        if (dataContext == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(2);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        boolean isInvokedFromEditor = CommonDataKeys.EDITOR.getData(dataContext) != null;
        try {
            for (ImplementationViewSessionFactory factory2 : this.getSessionFactories()) {
                ImplementationViewSession session2 = factory2.createSession(dataContext, project, this.isSearchDeep(), this.isIncludeAlwaysSelf());
                if (session2 == null) continue;
                this.showImplementations(session2, isInvokedFromEditor, invokedByShortcut);
            }
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)project).showDumbModeNotification(this.getIndexNotReadyMessage());
        }
    }

    @NotNull
    protected abstract List<ImplementationViewSessionFactory> getSessionFactories();

    @NotNull
    @NlsContexts.PopupContent
    protected abstract String getIndexNotReadyMessage();

    private void updateElementImplementations(Object lookupItemObject, ImplementationViewSession session2) {
        ImplementationViewSessionFactory currentFactory;
        ImplementationViewSession newSession;
        if (lookupItemObject instanceof PSIPresentationBgRendererWrapper.PsiItemWithPresentation) {
            lookupItemObject = ((PSIPresentationBgRendererWrapper.PsiItemWithPresentation)((Object)lookupItemObject)).getItem();
        }
        if ((newSession = this.createNewSession(currentFactory = session2.getFactory(), session2, lookupItemObject)) == null) {
            for (ImplementationViewSessionFactory factory2 : this.getSessionFactories()) {
                if (currentFactory != factory2 && (newSession = this.createNewSession(factory2, session2, lookupItemObject)) != null) break;
            }
        }
        if (newSession != null) {
            Disposer.dispose((Disposable)session2);
            this.showImplementations(newSession, false, false);
        }
    }

    private ImplementationViewSession createNewSession(ImplementationViewSessionFactory factory2, ImplementationViewSession session2, Object lookupItemObject) {
        return factory2.createSessionForLookupElement(session2.getProject(), session2.getEditor(), session2.getFile(), lookupItemObject, this.isSearchDeep(), this.isIncludeAlwaysSelf());
    }

    protected void showImplementations(final @NotNull ImplementationViewSession session2, boolean invokedFromEditor, boolean invokedByShortcut) {
        ImplementationViewComponent component3;
        VirtualFile secondContainingFile;
        VirtualFile containingFile;
        List<ImplementationViewElement> impls;
        if (session2 == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(3);
        }
        if ((impls = session2.getImplementationElements()).size() == 0) {
            return;
        }
        Project project = session2.getProject();
        this.triggerFeatureUsed(project);
        VirtualFile virtualFile2 = session2.getFile();
        int index2 = 0;
        if (invokedFromEditor && virtualFile2 != null && impls.size() > 1 && virtualFile2.equals(containingFile = impls.get(0).getContainingFile()) && (secondContainingFile = impls.get(1).getContainingFile()) != null && !secondContainingFile.equals(containingFile)) {
            index2 = 1;
        }
        Ref usageView = new Ref();
        String title2 = this.getPopupTitle(session2);
        JBPopup popup2 = (JBPopup)SoftReference.dereference(this.myPopupRef);
        if (popup2 != null && popup2.isVisible() && popup2 instanceof AbstractPopup && (component3 = (ImplementationViewComponent)((AbstractPopup)popup2).getComponent()) != null) {
            component3.update(impls, index2);
            this.updateInBackground(session2, component3, (AbstractPopup)popup2, (Ref<? extends UsageView>)usageView);
            if (invokedByShortcut) {
                ((AbstractPopup)popup2).focusPreferredComponent();
            }
            return;
        }
        Consumer<ImplementationViewComponent> processor2 = this.couldPinPopup() ? component2 -> {
            usageView.set((Object)component2.showInUsageView());
            this.myTaskRef = null;
        } : null;
        final ImplementationViewComponent component4 = new ImplementationViewComponent(impls, index2, processor2);
        if (component4.hasElementsToShow()) {
            PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(project){

                public void updatePopup(Object lookupItemObject) {
                    ShowRelatedElementsActionBase.this.updateElementImplementations(lookupItemObject, session2);
                }
            };
            ComponentPopupBuilder popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component4, component4.getPreferredFocusableComponent()).setProject(project).addListener((JBPopupListener)updateProcessor).addUserData((Object)updateProcessor).setDimensionServiceKey(project, "javadoc.popup", false).setResizable(true).setMovable(true).setRequestFocus(invokedFromEditor && LookupManager.getActiveLookup(session2.getEditor()) == null).setCancelCallback(() -> {
                ImplementationsUpdaterTask task2 = (ImplementationsUpdaterTask)((Object)((Object)SoftReference.dereference(this.myTaskRef)));
                if (task2 != null) {
                    task2.cancelTask();
                }
                Disposer.dispose((Disposable)session2);
                return Boolean.TRUE;
            });
            final WindowMoveListener listener2 = new WindowMoveListener();
            listener2.installTo(component4);
            Disposer.register((Disposable)session2, (Disposable)new Disposable(){

                public void dispose() {
                    listener2.uninstallFrom(component4);
                }
            });
            popup2 = popupBuilder.createPopup();
            this.updateInBackground(session2, component4, (AbstractPopup)popup2, (Ref<? extends UsageView>)usageView);
            PopupPositionManager.positionPopupInBestPosition(popup2, session2.getEditor(), DataManager.getInstance().getDataContext());
            component4.setHint(popup2, title2);
            this.myPopupRef = new WeakReference<JBPopup>(popup2);
        }
    }

    protected abstract void triggerFeatureUsed(@NotNull Project var1);

    protected static void triggerFeatureUsed(@NotNull Project project, @NotNull String key, @NotNull String keyForLookup) {
        if (project == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(4);
        }
        if (key == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(5);
        }
        if (keyForLookup == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(6);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed(key);
        if (LookupManager.getInstance(project).getActiveLookup() != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(keyForLookup);
        }
    }

    @NotNull
    @NlsContexts.PopupTitle
    protected abstract String getPopupTitle(@NotNull ImplementationViewSession var1);

    protected abstract boolean couldPinPopup();

    private void updateInBackground(@NotNull ImplementationViewSession session2, @NotNull ImplementationViewComponent component2, @NotNull AbstractPopup popup2, @NotNull Ref<? extends UsageView> usageView) {
        ImplementationsUpdaterTask updaterTask;
        if (session2 == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(7);
        }
        if (component2 == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(8);
        }
        if (popup2 == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(9);
        }
        if (usageView == null) {
            ShowRelatedElementsActionBase.$$$reportNull$$$0(10);
        }
        if ((updaterTask = (ImplementationsUpdaterTask)((Object)SoftReference.dereference(this.myTaskRef))) != null) {
            updaterTask.cancelTask();
        }
        if (!session2.needUpdateInBackground()) {
            return;
        }
        ImplementationsUpdaterTask task2 = new ImplementationsUpdaterTask(session2, component2);
        task2.init(popup2, new ImplementationViewComponentUpdater(component2, session2.elementRequiresIncludeSelf() ? 1 : 0), usageView);
        this.myTaskRef = new WeakReference<ImplementationsUpdaterTask>(task2);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
    }

    protected boolean isIncludeAlwaysSelf() {
        return true;
    }

    protected boolean isSearchDeep() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyForLookup";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/hint/actions/ShowRelatedElementsActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "performForContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showImplementations";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerFeatureUsed";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "updateInBackground";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ImplementationsUpdaterTask
    extends BackgroundUpdaterTaskBase<ImplementationViewElement> {
        private final ImplementationViewSession mySession;
        private final ImplementationViewComponent myComponent;
        private List<ImplementationViewElement> myElements;

        private ImplementationsUpdaterTask(ImplementationViewSession session2, ImplementationViewComponent component2) {
            super(session2.getProject(), ImplementationSearcher.getSearchingForImplementations(), null);
            this.mySession = session2;
            this.myComponent = component2;
        }

        @Override
        public String getCaption(int size2) {
            return null;
        }

        @Override
        protected Usage createUsage(ImplementationViewElement element2) {
            return element2.getUsage();
        }

        @Override
        public void run(@NotNull ProgressIndicator indicator2) {
            if (indicator2 == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(0);
            }
            super.run(indicator2);
            this.myElements = this.mySession.searchImplementationsInBackground(indicator2, (Processor<? super ImplementationViewElement>)((Processor)this::updateComponent));
        }

        @Override
        public int getCurrentSize() {
            if (this.myElements != null) {
                return this.myElements.size();
            }
            return super.getCurrentSize();
        }

        @Override
        public void onSuccess() {
            if (!this.cancelTask()) {
                this.myComponent.update(this.myElements, this.myComponent.getIndex());
            }
            super.onSuccess();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/hint/actions/ShowRelatedElementsActionBase$ImplementationsUpdaterTask", "run"));
        }
    }

    private static class ImplementationViewComponentUpdater
    implements GenericListComponentUpdater<ImplementationViewElement> {
        private final ImplementationViewComponent myComponent;
        private final int myIncludeSelfIdx;

        ImplementationViewComponentUpdater(ImplementationViewComponent component2, int includeSelfIdx) {
            this.myComponent = component2;
            this.myIncludeSelfIdx = includeSelfIdx;
        }

        public void paintBusy(boolean paintBusy) {
        }

        public void replaceModel(@NotNull List<? extends ImplementationViewElement> data2) {
            if (data2 == null) {
                ImplementationViewComponentUpdater.$$$reportNull$$$0(0);
            }
            ImplementationViewElement[] elements = this.myComponent.getElements();
            int startIdx = elements.length - this.myIncludeSelfIdx;
            ArrayList<? extends ImplementationViewElement> result2 = new ArrayList<ImplementationViewElement>();
            Collections.addAll(result2, elements);
            result2.addAll(data2.subList(startIdx, data2.size()));
            this.myComponent.update(result2, this.myComponent.getIndex());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/codeInsight/hint/actions/ShowRelatedElementsActionBase$ImplementationViewComponentUpdater", "replaceModel"));
        }
    }
}

