/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.api.impls;

import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Function;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlParameterInfoHandler
implements ParameterInfoHandler<XmlTag, XmlElementDescriptor> {
    private static final Comparator<XmlAttributeDescriptor> COMPARATOR = Comparator.comparing(PsiMetaData::getName);

    public static XmlAttributeDescriptor[] getSortedDescriptors(XmlElementDescriptor p) {
        XmlAttributeDescriptor[] xmlAttributeDescriptors = p.getAttributesDescriptors(null);
        Arrays.sort(xmlAttributeDescriptors, COMPARATOR);
        return xmlAttributeDescriptors;
    }

    public XmlTag findElementForParameterInfo(@NotNull CreateParameterInfoContext context2) {
        XmlTag tag2;
        XmlElementDescriptor descriptor2;
        if (context2 == null) {
            XmlParameterInfoHandler.$$$reportNull$$$0(0);
        }
        XmlElementDescriptor xmlElementDescriptor = descriptor2 = (tag2 = XmlParameterInfoHandler.findXmlTag(context2.getFile(), context2.getOffset())) != null ? tag2.getDescriptor() : null;
        if (descriptor2 == null) {
            return null;
        }
        context2.setItemsToShow(new Object[]{descriptor2});
        return tag2;
    }

    public void showParameterInfo(@NotNull XmlTag element2, @NotNull CreateParameterInfoContext context2) {
        if (element2 == null) {
            XmlParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            XmlParameterInfoHandler.$$$reportNull$$$0(2);
        }
        context2.showHint((PsiElement)element2, element2.getTextRange().getStartOffset() + 1, (ParameterInfoHandler)this);
    }

    public XmlTag findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context2) {
        PsiElement currentXmlTag;
        XmlTag tag2;
        if (context2 == null) {
            XmlParameterInfoHandler.$$$reportNull$$$0(3);
        }
        if ((tag2 = XmlParameterInfoHandler.findXmlTag(context2.getFile(), context2.getOffset())) != null && ((currentXmlTag = context2.getParameterOwner()) == null || currentXmlTag == tag2)) {
            return tag2;
        }
        return null;
    }

    public void updateParameterInfo(@NotNull XmlTag parameterOwner, @NotNull UpdateParameterInfoContext context2) {
        if (parameterOwner == null) {
            XmlParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            XmlParameterInfoHandler.$$$reportNull$$$0(5);
        }
        context2.setParameterOwner((PsiElement)parameterOwner);
    }

    @Nullable
    private static XmlTag findXmlTag(PsiFile file2, int offset) {
        if (!(file2 instanceof XmlFile)) {
            return null;
        }
        PsiElement element2 = file2.findElementAt(offset);
        if (element2 == null) {
            return null;
        }
        for (element2 = element2.getParent(); element2 != null; element2 = element2.getParent()) {
            if (!(element2 instanceof XmlTag)) continue;
            XmlTag tag2 = (XmlTag)element2;
            PsiElement[] children2 = tag2.getChildren();
            if (offset <= children2[0].getTextRange().getStartOffset()) {
                return null;
            }
            for (PsiElement child2 : children2) {
                XmlToken token2;
                TextRange range2 = child2.getTextRange();
                if (range2.getStartOffset() <= offset && range2.getEndOffset() > offset) {
                    return tag2;
                }
                if (!(child2 instanceof XmlToken) || (token2 = (XmlToken)child2).getTokenType() != XmlTokenType.XML_TAG_END) continue;
                return null;
            }
            return null;
        }
        return null;
    }

    public void updateUI(XmlElementDescriptor o, @NotNull ParameterInfoUIContext context2) {
        if (context2 == null) {
            XmlParameterInfoHandler.$$$reportNull$$$0(6);
        }
        XmlTag parameterOwner = (XmlTag)context2.getParameterOwner();
        XmlParameterInfoHandler.updateElementDescriptor(o, context2, (Function<? super String, Boolean>)((Function)s -> parameterOwner != null && parameterOwner.getAttributeValue(s) != null));
    }

    public static void updateElementDescriptor(XmlElementDescriptor descriptor2, ParameterInfoUIContext context2, Function<? super String, Boolean> attributePresentFun) {
        XmlAttributeDescriptor[] attributes2 = descriptor2 != null ? XmlParameterInfoHandler.getSortedDescriptors(descriptor2) : XmlAttributeDescriptor.EMPTY;
        StringBuilder buffer = new StringBuilder();
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (attributes2.length == 0) {
            buffer.append(XmlBundle.message((String)"xml.tag.info.no.attributes", (Object[])new Object[0]));
        } else {
            StringBuilder text1 = new StringBuilder(" ");
            StringBuilder text2 = new StringBuilder(" ");
            StringBuilder text3 = new StringBuilder(" ");
            for (XmlAttributeDescriptor attribute : attributes2) {
                if (Boolean.TRUE.equals(attributePresentFun.fun((Object)attribute.getName()))) {
                    if (!text1.toString().equals(" ")) {
                        text1.append(", ");
                    }
                    text1.append(attribute.getName());
                    continue;
                }
                if (attribute.isRequired()) {
                    if (!text2.toString().equals(" ")) {
                        text2.append(", ");
                    }
                    text2.append(attribute.getName());
                    continue;
                }
                if (!text3.toString().equals(" ")) {
                    text3.append(", ");
                }
                text3.append(attribute.getName());
            }
            if (!text1.toString().equals(" ") && !text2.toString().equals(" ")) {
                text1.append(", ");
            }
            if (!text2.toString().equals(" ") && !text3.toString().equals(" ")) {
                text2.append(", ");
            }
            if (!text1.toString().equals(" ") && !text3.toString().equals(" ") && text2.toString().equals(" ")) {
                text1.append(", ");
            }
            buffer.append((CharSequence)text1);
            highlightStartOffset = buffer.length();
            buffer.append((CharSequence)text2);
            highlightEndOffset = buffer.length();
            buffer.append((CharSequence)text3);
        }
        context2.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, false, false, true, context2.getDefaultParameterColor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterOwner";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/hint/api/impls/XmlParameterInfoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForParameterInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateParameterInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUI";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

