/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.completion;

import com.intellij.application.options.emmet.EmmetCompositeConfigurable;
import com.intellij.application.options.emmet.XmlEmmetConfigurable;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import com.intellij.xml.XmlBundle;

public class EmmetLookupActionProvider
implements LookupActionProvider {
    @Override
    public void fillActions(LookupElement element2, final Lookup lookup2, Consumer<LookupElementAction> consumer) {
        if (element2 instanceof CustomLiveTemplateLookupElement && ((CustomLiveTemplateLookupElement)element2).getCustomLiveTemplate() instanceof ZenCodingTemplate) {
            PsiFile file2 = lookup2.getPsiFile();
            if (file2 == null) {
                return;
            }
            CustomTemplateCallback callback2 = new CustomTemplateCallback(lookup2.getEditor(), file2);
            final ZenCodingGenerator generator2 = ZenCodingTemplate.findApplicableDefaultGenerator(callback2, false);
            if (generator2 != null) {
                consumer.consume((Object)new LookupElementAction(PlatformIcons.EDIT, XmlBundle.message((String)"edit.emmet.settings", (Object[])new Object[0])){

                    @Override
                    public LookupElementAction.Result performLookupAction() {
                        Project project = lookup2.getProject();
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (project.isDisposed()) {
                                return;
                            }
                            Configurable generatorSpecificConfigurable = generator2.createConfigurable();
                            Object configurable2 = generatorSpecificConfigurable != null ? generatorSpecificConfigurable : new XmlEmmetConfigurable();
                            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new EmmetCompositeConfigurable(new Configurable[]{configurable2}));
                        });
                        return LookupElementAction.Result.HIDE_LOOKUP;
                    }
                });
                consumer.consume((Object)new LookupElementAction(AllIcons.Actions.Cancel, XmlBundle.message((String)"disable.emmet", (Object[])new Object[0])){

                    @Override
                    public LookupElementAction.Result performLookupAction() {
                        ApplicationManager.getApplication().invokeLater(generator2::disableEmmet);
                        return LookupElementAction.Result.HIDE_LOOKUP;
                    }
                });
            }
        }
    }
}

