/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.util.SequentialTask;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PerformFixesModalTask
implements SequentialTask {
    @NotNull
    protected final Project myProject;
    private final List<CommonProblemDescriptor[]> myDescriptorPacks;
    private final PsiDocumentManager myDocumentManager;
    private final PostprocessReformattingAspect myReformattingAspect;
    private final int myLength;
    private int myProcessed;
    private int myPackIdx;
    private int myDescriptorIdx;

    protected PerformFixesModalTask(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors2) {
        if (project == null) {
            PerformFixesModalTask.$$$reportNull$$$0(0);
        }
        if (descriptors2 == null) {
            PerformFixesModalTask.$$$reportNull$$$0(1);
        }
        this(project, Collections.singletonList(descriptors2));
    }

    protected PerformFixesModalTask(@NotNull Project project, @NotNull List<CommonProblemDescriptor[]> descriptorPacks) {
        if (project == null) {
            PerformFixesModalTask.$$$reportNull$$$0(2);
        }
        if (descriptorPacks == null) {
            PerformFixesModalTask.$$$reportNull$$$0(3);
        }
        this.myProcessed = 0;
        this.myPackIdx = 0;
        this.myDescriptorIdx = 0;
        this.myProject = project;
        this.myDescriptorPacks = descriptorPacks;
        this.myLength = descriptorPacks.stream().mapToInt(ds -> ((CommonProblemDescriptor[])ds).length).sum();
        this.myDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        this.myReformattingAspect = PostprocessReformattingAspect.getInstance(this.myProject);
    }

    @Override
    public boolean isDone() {
        return this.myPackIdx > this.myDescriptorPacks.size() - 1;
    }

    @Override
    public boolean iteration() {
        return true;
    }

    public void doRun(ProgressIndicator indicator2) {
        indicator2.setIndeterminate(false);
        while (!this.isDone() && !indicator2.isCanceled()) {
            this.iteration(indicator2);
        }
    }

    @Override
    public boolean iteration(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            PerformFixesModalTask.$$$reportNull$$$0(4);
        }
        Pair<CommonProblemDescriptor, Boolean> pair = this.nextDescriptor();
        CommonProblemDescriptor descriptor2 = (CommonProblemDescriptor)pair.getFirst();
        boolean shouldDoPostponedOperations = (Boolean)pair.getSecond();
        this.beforeProcessing(descriptor2);
        indicator2.setFraction((double)this.myProcessed++ / (double)this.myLength);
        String presentableText2 = StringUtil.notNullize((String)this.getPresentableText(descriptor2), (String)"usages");
        indicator2.setText(InspectionsBundle.message((String)"processing.progress.text", (Object[])new Object[]{presentableText2}));
        boolean[] runInReadAction = new boolean[]{false};
        QuickFix[] fixes = descriptor2.getFixes();
        if (fixes != null) {
            for (QuickFix fix : fixes) {
                if (fix.startInWriteAction()) {
                    runInReadAction[0] = false;
                    break;
                }
                runInReadAction[0] = true;
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.myDocumentManager.commitAllDocuments();
            if (!runInReadAction[0]) {
                this.applyFix(this.myProject, descriptor2);
                if (shouldDoPostponedOperations) {
                    this.myReformattingAspect.doPostponedFormatting();
                }
            }
        });
        if (runInReadAction[0]) {
            this.applyFix(this.myProject, descriptor2);
        }
        return this.isDone();
    }

    protected abstract void applyFix(Project var1, CommonProblemDescriptor var2);

    protected void beforeProcessing(@NotNull CommonProblemDescriptor descriptor2) {
        if (descriptor2 == null) {
            PerformFixesModalTask.$$$reportNull$$$0(5);
        }
    }

    @Nullable
    @NlsSafe
    protected String getPresentableText(@NotNull CommonProblemDescriptor descriptor2) {
        if (descriptor2 == null) {
            PerformFixesModalTask.$$$reportNull$$$0(6);
        }
        if (!(descriptor2 instanceof ProblemDescriptor)) {
            return null;
        }
        PsiElement psiElement = ((ProblemDescriptor)descriptor2).getPsiElement();
        return psiElement != null ? StringUtil.notNullize((String)SymbolPresentationUtil.getSymbolPresentableText(psiElement)) : null;
    }

    private Pair<CommonProblemDescriptor, Boolean> nextDescriptor() {
        CommonProblemDescriptor[] descriptors2 = this.myDescriptorPacks.get(this.myPackIdx);
        CommonProblemDescriptor descriptor2 = descriptors2[this.myDescriptorIdx++];
        boolean shouldDoPostponedOperations = false;
        if (this.myDescriptorIdx == descriptors2.length) {
            shouldDoPostponedOperations = true;
            ++this.myPackIdx;
            this.myDescriptorIdx = 0;
        }
        return Pair.create((Object)descriptor2, (Object)shouldDoPostponedOperations);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorPacks";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ex/PerformFixesModalTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "iteration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeProcessing";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getPresentableText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

