/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.htmlInspections.AddCustomHtmlElementIntentionAction;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownElementInspection;
import com.intellij.codeInspection.htmlInspections.SwitchToHtml5WithHighPriorityAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.impl.XmlElementDescriptorEx;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlUnknownTagInspectionBase
extends HtmlUnknownElementInspection {
    public static final Key<HtmlUnknownElementInspection> TAG_KEY = Key.create((String)"HtmlUnknownTag");
    private static final Logger LOG = Logger.getInstance(HtmlUnknownTagInspectionBase.class);

    public HtmlUnknownTagInspectionBase(@NotNull String defaultValues) {
        if (defaultValues == null) {
            HtmlUnknownTagInspectionBase.$$$reportNull$$$0(0);
        }
        super(defaultValues);
    }

    public HtmlUnknownTagInspectionBase() {
        this("nobr,noembed,comment,noscript,embed,script");
    }

    private static boolean isAbstractDescriptor(XmlElementDescriptor descriptor2) {
        return descriptor2 == null || descriptor2 instanceof AnyXmlElementDescriptor;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "HtmlUnknownTag";
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            HtmlUnknownTagInspectionBase.$$$reportNull$$$0(1);
        }
        return logger;
    }

    @Override
    protected String getCheckboxTitle() {
        return XmlAnalysisBundle.message((String)"html.inspections.unknown.tag.checkbox.title", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected String getPanelTitle() {
        String string = XmlAnalysisBundle.message((String)"html.inspections.unknown.tag.title", (Object[])new Object[0]);
        if (string == null) {
            HtmlUnknownTagInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected void checkTag(@NotNull XmlTag tag2, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        XmlElementDescriptor ownDescriptor;
        if (tag2 == null) {
            HtmlUnknownTagInspectionBase.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            HtmlUnknownTagInspectionBase.$$$reportNull$$$0(4);
        }
        if (!(tag2 instanceof HtmlTag) || !XmlHighlightVisitor.shouldBeValidated(tag2)) {
            return;
        }
        XmlElementDescriptor descriptorFromContext = XmlUtil.getDescriptorFromContext(tag2);
        PsiElement parent = tag2.getParent();
        XmlElementDescriptor parentDescriptor = parent instanceof XmlTag ? ((XmlTag)parent).getDescriptor() : null;
        XmlElementDescriptor xmlElementDescriptor = ownDescriptor = HtmlUnknownTagInspectionBase.isAbstractDescriptor(descriptorFromContext) ? tag2.getDescriptor() : descriptorFromContext;
        if (ownDescriptor instanceof XmlElementDescriptorEx) {
            ((XmlElementDescriptorEx)ownDescriptor).validateTagName(tag2, holder, isOnTheFly);
            return;
        }
        if (descriptorFromContext instanceof XmlElementDescriptorEx) {
            ((XmlElementDescriptorEx)descriptorFromContext).validateTagName(tag2, holder, isOnTheFly);
            return;
        }
        if (HtmlUnknownTagInspectionBase.isAbstractDescriptor(ownDescriptor) || parentDescriptor instanceof HtmlElementDescriptorImpl && ownDescriptor instanceof HtmlElementDescriptorImpl && HtmlUnknownTagInspectionBase.isAbstractDescriptor(descriptorFromContext)) {
            String name = tag2.getName();
            if (!this.isCustomValuesEnabled() || !this.isCustomValue(name)) {
                ProblemHighlightType highlightType;
                AddCustomHtmlElementIntentionAction action2 = new AddCustomHtmlElementIntentionAction(TAG_KEY, name, XmlAnalysisBundle.message((String)"html.quickfix.add.custom.html.tag", (Object[])new Object[]{name}));
                String message2 = HtmlUnknownTagInspectionBase.isAbstractDescriptor(ownDescriptor) ? XmlAnalysisBundle.message((String)"xml.inspections.unknown.html.tag", (Object[])new Object[]{name}) : XmlAnalysisBundle.message((String)"xml.inspections.element.is.not.allowed.here", (Object[])new Object[]{name});
                XmlToken startTagName = XmlTagUtil.getStartTagNameElement((XmlTag)tag2);
                assert (startTagName != null);
                XmlToken endTagName = XmlTagUtil.getEndTagNameElement((XmlTag)tag2);
                ArrayList<LocalQuickFix> quickfixes = new ArrayList<LocalQuickFix>();
                quickfixes.add(action2);
                if (isOnTheFly) {
                    PsiFile file2 = startTagName.getContainingFile();
                    if (file2 instanceof XmlFile) {
                        quickfixes.add(XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix((PsiElement)startTagName, "", null));
                    }
                    ContainerUtil.addIfNotNull(quickfixes, (Object)this.createChangeTemplateDataFix(file2));
                }
                if (HtmlUtil.isHtml5Tag(name) && !HtmlUtil.hasNonHtml5Doctype((XmlElement)tag2)) {
                    quickfixes.add(new SwitchToHtml5WithHighPriorityAction());
                }
                ProblemHighlightType problemHighlightType = highlightType = tag2.getContainingFile().getContext() == null ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                if (startTagName.getTextLength() > 0) {
                    holder.registerProblem((PsiElement)startTagName, message2, highlightType, quickfixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
                if (endTagName != null) {
                    holder.registerProblem((PsiElement)endTagName, message2, highlightType, quickfixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            }
        }
    }

    @Nullable
    protected LocalQuickFix createChangeTemplateDataFix(PsiFile file2) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValues";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanelTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

