/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefElement;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefDirectoryImpl
extends RefElementImpl
implements RefDirectory {
    private volatile RefModule myRefModule;

    protected RefDirectoryImpl(PsiDirectory psiElement, RefManager refManager) {
        super(psiElement.getName(), (PsiElement)psiElement, refManager);
    }

    @Override
    protected void initialize() {
        WritableRefElement refElement;
        PsiDirectory parentDirectory;
        PsiDirectory psiElement = (PsiDirectory)ObjectUtils.tryCast((Object)this.getPsiElement(), PsiDirectory.class);
        LOG.assertTrue(psiElement != null);
        if (!ProjectRootsUtil.isSourceRoot(psiElement) && (parentDirectory = psiElement.getParentDirectory()) != null && ProjectFileIndex.getInstance((Project)psiElement.getProject()).isInSourceContent(parentDirectory.getVirtualFile()) && (refElement = (WritableRefElement)this.getRefManager().getReference((PsiElement)parentDirectory)) != null) {
            refElement.add(this);
            return;
        }
        this.myRefModule = this.getRefManager().getRefModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement));
        if (this.myRefModule != null) {
            ((WritableRefEntity)this.myRefModule).add(this);
            return;
        }
        ((WritableRefEntity)this.myManager.getRefProject()).add(this);
    }

    @Override
    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            RefDirectoryImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().runReadAction(() -> visitor.visitDirectory((RefDirectory)this));
    }

    @Override
    public boolean isValid() {
        if (this.isDeleted()) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            if (this.getRefManager().getProject().isDisposed()) {
                return false;
            }
            VirtualFile directory = this.getVirtualFile();
            return directory != null && directory.isValid();
        });
    }

    @Override
    @Nullable
    public RefModule getModule() {
        return this.myRefModule != null ? this.myRefModule : super.getModule();
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String string = this.getName();
        if (string == null) {
            RefDirectoryImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String getExternalName() {
        PsiElement element2 = this.getPsiElement();
        assert (element2 != null);
        return ((PsiDirectory)element2).getVirtualFile().getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefDirectoryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefDirectoryImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

