/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.ConstantValueCreator;
import com.intellij.credentialStore.kdbx.DateValueCreator;
import com.intellij.credentialStore.kdbx.KdbxGroup;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.kdbx.KeePassDatabaseKt;
import com.intellij.credentialStore.kdbx.UuidValueCreator;
import com.intellij.credentialStore.kdbx.ValueCreator;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u001a\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0000\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0002\" \u0010\u0000\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"mandatoryGroupElements", "", "", "", "Lcom/intellij/credentialStore/kdbx/ValueCreator;", "createGroup", "Lcom/intellij/credentialStore/kdbx/KdbxGroup;", "db", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "parent", "parseTime", "", "value", "intellij.platform.credentialStore"})
public final class KdbxGroupKt {
    private static final Map<String[], ValueCreator> mandatoryGroupElements = MapsKt.linkedMapOf((Pair[])new Pair[]{TuplesKt.to((Object)KeePassDatabaseKt.getUUID_ELEMENT_NAME(), (Object)new UuidValueCreator()), TuplesKt.to((Object)new String[]{"Notes"}, (Object)new ConstantValueCreator("")), TuplesKt.to((Object)KeePassDatabaseKt.getICON_ELEMENT_NAME(), (Object)new ConstantValueCreator("0")), TuplesKt.to((Object)KeePassDatabaseKt.getCREATION_TIME_ELEMENT_NAME(), (Object)new DateValueCreator()), TuplesKt.to((Object)KeePassDatabaseKt.getLAST_MODIFICATION_TIME_ELEMENT_NAME(), (Object)new DateValueCreator()), TuplesKt.to((Object)KeePassDatabaseKt.getLAST_ACCESS_TIME_ELEMENT_NAME(), (Object)new DateValueCreator()), TuplesKt.to((Object)KeePassDatabaseKt.getEXPIRY_TIME_ELEMENT_NAME(), (Object)new DateValueCreator()), TuplesKt.to((Object)KeePassDatabaseKt.getEXPIRES_ELEMENT_NAME(), (Object)new ConstantValueCreator("False")), TuplesKt.to((Object)KeePassDatabaseKt.getUSAGE_COUNT_ELEMENT_NAME(), (Object)new ConstantValueCreator("0")), TuplesKt.to((Object)KeePassDatabaseKt.getLOCATION_CHANGED(), (Object)new DateValueCreator())});

    @NotNull
    public static final KdbxGroup createGroup(@NotNull KeePassDatabase db, @Nullable KdbxGroup parent) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Element element2 = new Element("Group");
        KeePassDatabaseKt.ensureElements(element2, mandatoryGroupElements);
        return new KdbxGroup(element2, db, parent);
    }

    private static final long parseTime(String value2) {
        long l;
        try {
            l = ZonedDateTime.parse(value2).toEpochSecond();
        }
        catch (DateTimeParseException e) {
            l = 0L;
        }
        return l;
    }

    public static final /* synthetic */ long access$parseTime(String value2) {
        return KdbxGroupKt.parseTime(value2);
    }
}

