/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.VMOptions;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.system.CpuArch;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class EditMemorySettingsDialog
extends DialogWrapper {
    private static final int MIN_VALUE = 256;
    private static final int HEAP_INC = 512;
    private final VMOptions.MemoryKind myOption;
    private final boolean myMemoryLow;
    private final int myLowerBound;
    private JTextField myNewValueField;
    private Action mySaveAndExitAction;
    private Action mySaveAction;

    public EditMemorySettingsDialog() {
        this(VMOptions.MemoryKind.HEAP, false);
    }

    EditMemorySettingsDialog(@NotNull VMOptions.MemoryKind option2) {
        if (option2 == null) {
            EditMemorySettingsDialog.$$$reportNull$$$0(0);
        }
        this(option2, true);
    }

    private EditMemorySettingsDialog(VMOptions.MemoryKind option2, boolean memoryLow) {
        super(false);
        this.myOption = option2;
        this.myMemoryLow = memoryLow;
        this.myLowerBound = Math.max(option2 == VMOptions.MemoryKind.HEAP ? VMOptions.readOption(VMOptions.MemoryKind.MIN_HEAP, false) : 0, 256);
        this.setTitle(DiagnosticBundle.message("change.memory.title", new Object[0]));
        this.init();
        this.initValidation();
    }

    protected JComponent createCenterPanel() {
        int suggested;
        int current2 = VMOptions.readOption(this.myOption, true);
        if (this.myMemoryLow && this.myOption == VMOptions.MemoryKind.HEAP) {
            int cap;
            int n = cap = CpuArch.isIntel32() ? 800 : Registry.intValue((String)"max.suggested.heap.size");
            if (current2 > 0) {
                suggested = current2 + 512;
                if (suggested > cap) {
                    suggested = Math.max(cap, current2);
                }
            } else {
                suggested = cap;
            }
        } else {
            suggested = VMOptions.readOption(this.myOption, false);
            if (suggested <= 0) {
                suggested = current2;
            }
            if (suggested <= 0) {
                suggested = 256;
            }
        }
        Path file2 = VMOptions.getWriteFile();
        assert (file2 != null);
        JPanel panel2 = new JPanel(new GridBagLayout());
        if (this.myMemoryLow) {
            String text2;
            if (this.myOption == VMOptions.MemoryKind.HEAP) {
                long free = Runtime.getRuntime().freeMemory() >> 20;
                long max = Runtime.getRuntime().maxMemory() >> 20;
                text2 = DiagnosticBundle.message("change.memory.usage", String.valueOf(free), String.valueOf(max));
            } else {
                text2 = DiagnosticBundle.message("change.memory.message", new Object[0]);
            }
            panel2.add((Component)new JBLabel(text2), new GridBagConstraints(0, 0, 5, 1, 1.0, 1.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        }
        panel2.add((Component)new JBLabel(DiagnosticBundle.message("change.memory.act", new Object[0])), new GridBagConstraints(0, 1, 5, 1, 1.0, 1.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        JBLabel prompt = new JBLabel(this.myOption.label() + ":", 4);
        prompt.setToolTipText("-" + this.myOption.optionName);
        panel2.add((Component)prompt, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 13, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myNewValueField = new JTextField(5);
        this.myNewValueField.setText(String.valueOf(suggested));
        panel2.add((Component)this.myNewValueField, new GridBagConstraints(2, 2, 1, 1, 0.0, 1.0, 10, 0, (Insets)JBUI.insets((int)10, (int)10, (int)10, (int)2), 0, 0));
        panel2.add((Component)new JBLabel(DiagnosticBundle.message("change.memory.units", new Object[0])), new GridBagConstraints(3, 2, 1, 1, 0.0, 1.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        String formatted = current2 == -1 ? DiagnosticBundle.message("change.memory.unknown", new Object[0]) : String.valueOf(current2);
        panel2.add((Component)new JBLabel(DiagnosticBundle.message("change.memory.current", formatted), 4).withFont(JBFont.label().asItalic()), new GridBagConstraints(4, 2, 1, 1, 0.0, 1.0, 17, 0, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        panel2.add((Component)new JBLabel(AllIcons.General.Information), new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 17, 0, (Insets)JBUI.insetsRight((int)2), 0, 0));
        panel2.add((Component)new JBLabel(DiagnosticBundle.message("change.memory.file", new Object[0]), 2).withFont(JBFont.label().asBold()), new GridBagConstraints(1, 3, 4, 1, 1.0, 1.0, 17, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        panel2.add((Component)new JBLabel(file2.toString(), 2), new GridBagConstraints(1, 4, 4, 1, 1.0, 1.0, 17, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel2;
    }

    protected Action @NotNull [] createActions() {
        boolean canRestart = ApplicationManager.getApplication().isRestartCapable();
        this.mySaveAndExitAction = new DialogWrapper.DialogWrapperAction(DiagnosticBundle.message(canRestart ? "change.memory.apply" : "change.memory.exit", new Object[0])){

            protected void doAction(ActionEvent e) {
                if (EditMemorySettingsDialog.this.save()) {
                    ((ApplicationEx)ApplicationManager.getApplication()).restart(true);
                }
            }
        };
        this.mySaveAction = new DialogWrapper.DialogWrapperAction(IdeBundle.message((String)"button.save", (Object[])new Object[0])){

            protected void doAction(ActionEvent e) {
                if (EditMemorySettingsDialog.this.save()) {
                    EditMemorySettingsDialog.this.close(0);
                }
            }
        };
        Action[] actionArray = new Action[]{this.mySaveAndExitAction, this.mySaveAction, this.getCancelAction()};
        if (actionArray == null) {
            EditMemorySettingsDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNewValueField;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo info2 = null;
        try {
            int value2 = Integer.parseInt(this.myNewValueField.getText());
            if (value2 <= this.myLowerBound) {
                info2 = new ValidationInfo(DiagnosticBundle.message("change.memory.low", this.myLowerBound), (JComponent)this.myNewValueField);
            }
            if (value2 > 800 && CpuArch.isIntel32()) {
                info2 = new ValidationInfo(DiagnosticBundle.message("change.memory.large", new Object[0]), (JComponent)this.myNewValueField);
            }
        }
        catch (NumberFormatException e) {
            info2 = new ValidationInfo(DiagnosticBundle.message("change.memory.integer", new Object[0]), (JComponent)this.myNewValueField);
        }
        this.mySaveAndExitAction.setEnabled(info2 == null);
        this.mySaveAction.setEnabled(info2 == null);
        return info2;
    }

    private boolean save() {
        try {
            int value2 = Integer.parseInt(this.myNewValueField.getText());
            VMOptions.writeOption(this.myOption, value2);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/EditMemorySettingsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/EditMemorySettingsDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

