/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.EditMemorySettingsDialog;
import com.intellij.diagnostic.VMOptions;
import com.intellij.diagnostic.hprof.action.HeapDumpSnapshotRunnable;
import com.intellij.diagnostic.report.MemoryReportReason;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.LowMemoryWatcher;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

final class LowMemoryNotifier
implements Disposable {
    private final LowMemoryWatcher myWatcher = LowMemoryWatcher.register(this::onLowMemorySignalReceived, (LowMemoryWatcher.LowMemoryWatcherType)LowMemoryWatcher.LowMemoryWatcherType.ONLY_AFTER_GC);
    private final AtomicBoolean myNotificationShown = new AtomicBoolean();

    LowMemoryNotifier() {
    }

    private void onLowMemorySignalReceived() {
        if (this.myNotificationShown.compareAndSet(false, true)) {
            LowMemoryNotifier.showNotification(VMOptions.MemoryKind.HEAP, false);
        }
    }

    public void dispose() {
        this.myWatcher.stop();
    }

    static void showNotification(final @NotNull VMOptions.MemoryKind kind, boolean error2) {
        if (kind == null) {
            LowMemoryNotifier.$$$reportNull$$$0(0);
        }
        String title2 = IdeBundle.message((String)"low.memory.notification.title", (Object[])new Object[0]);
        String message2 = IdeBundle.message((String)"low.memory.notification.content", (Object[])new Object[0]);
        NotificationType type = error2 ? NotificationType.ERROR : NotificationType.WARNING;
        Notification notification = new Notification(NotificationGroup.createIdWithTitle((String)"Low Memory", (String)title2), title2, message2, type);
        notification.addAction((AnAction)new NotificationAction(IdeBundle.message((String)"low.memory.notification.analyze.action", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    1.$$$reportNull$$$0(1);
                }
                new HeapDumpSnapshotRunnable(MemoryReportReason.UserInvoked, HeapDumpSnapshotRunnable.AnalysisOption.SCHEDULE_ON_NEXT_START).run();
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/diagnostic/LowMemoryNotifier$1";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (VMOptions.canWriteOptions()) {
            notification.addAction((AnAction)new NotificationAction(IdeBundle.message((String)"low.memory.notification.action", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    new EditMemorySettingsDialog(kind).show();
                    notification.expire();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/diagnostic/LowMemoryNotifier$2";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        Notifications.Bus.notify((Notification)notification);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/diagnostic/LowMemoryNotifier", "showNotification"));
    }
}

