/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.startUpPerformanceReporter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.ThreadNameManager;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u001a(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a.\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\" \u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"packageNameReplacements", "", "Lkotlin/Pair;", "", "activityNameToJsonFieldName", "name", "compactName", "writeCommonFields", "", "event", "Lcom/intellij/diagnostic/ActivityImpl;", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "timeOffset", "", "threadNameManager", "Lcom/intellij/diagnostic/ThreadNameManager;", "writeInstantEvents", "instantEvents", "intellij.platform.diagnostic"})
public final class IdeaFormatWriterKt {
    private static final List<Pair<String, String>> packageNameReplacements = CollectionsKt.listOf((Object[])new Pair[]{TuplesKt.to((Object)"com.intellij.", (Object)"c.i."), TuplesKt.to((Object)"org.jetbrains.", (Object)"o.j.")});

    private static final String activityNameToJsonFieldName(String name) {
        String string;
        switch (StringsKt.last((CharSequence)name)) {
            case 'y': {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = name;
                int n = 0;
                int n2 = name.length() - 1;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string = stringBuilder.append(string4).append("ies").toString();
                break;
            }
            case 's': {
                string = name;
                break;
            }
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                String string5 = name;
                int n = 0;
                boolean bl = false;
                String string6 = string5;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                string = stringBuilder.append(string7).append('s').toString();
            }
        }
        return string;
    }

    private static final String compactName(String name) {
        for (Pair<String, String> replacement : packageNameReplacements) {
            if (!StringsKt.startsWith$default((String)name, (String)((String)replacement.getFirst()), (boolean)false, (int)2, null)) continue;
            StringBuilder stringBuilder = new StringBuilder().append((String)replacement.getSecond());
            String string = name;
            int n = ((String)replacement.getFirst()).length();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return stringBuilder.append(string3).toString();
        }
        return name;
    }

    private static final void writeInstantEvents(JsonGenerator writer, List<ActivityImpl> instantEvents, long timeOffset, ThreadNameManager threadNameManager) {
        for (ActivityImpl event : instantEvents) {
            JsonGenerator $this$obj$iv = writer;
            String fieldName$iv = null;
            boolean $i$f$obj = false;
            $this$obj$iv.writeStartObject();
            boolean bl = false;
            IdeaFormatWriterKt.writeCommonFields(event, writer, timeOffset, threadNameManager);
            writer.writeStringField("ph", "i");
            writer.writeStringField("s", "g");
            $this$obj$iv.writeEndObject();
        }
    }

    private static final void writeCommonFields(ActivityImpl event, JsonGenerator writer, long timeOffset, ThreadNameManager threadNameManager) {
        block0: {
            writer.writeStringField("name", event.getName());
            writer.writeNumberField("ts", TimeUnit.NANOSECONDS.toMicros(event.getStart() - timeOffset));
            writer.writeNumberField("pid", 1);
            writer.writeStringField("tid", threadNameManager.getThreadName(event));
            ActivityCategory activityCategory = event.getCategory();
            if (activityCategory == null) break block0;
            ActivityCategory activityCategory2 = activityCategory;
            boolean bl = false;
            boolean bl2 = false;
            ActivityCategory it = activityCategory2;
            boolean bl3 = false;
            ActivityCategory activityCategory3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)activityCategory3, (String)"it");
            writer.writeStringField("cat", activityCategory3.getJsonName());
        }
    }

    public static final /* synthetic */ void access$writeInstantEvents(JsonGenerator writer, List instantEvents, long timeOffset, ThreadNameManager threadNameManager) {
        IdeaFormatWriterKt.writeInstantEvents(writer, instantEvents, timeOffset, threadNameManager);
    }

    public static final /* synthetic */ String access$activityNameToJsonFieldName(String name) {
        return IdeaFormatWriterKt.activityNameToJsonFieldName(name);
    }

    public static final /* synthetic */ String access$compactName(String name) {
        return IdeaFormatWriterKt.compactName(name);
    }
}

