/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.merge.TextMergeViewer;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMergeChange
extends ThreesideDiffChangeBase {
    @NotNull
    private final TextMergeViewer myMergeViewer;
    @NotNull
    private final TextMergeViewer.MyThreesideViewer myViewer;
    private final int myIndex;
    @NotNull
    private final MergeLineFragment myFragment;
    private final boolean[] myResolved;
    private boolean myOnesideAppliedConflict;
    @Nullable
    private MergeInnerDifferences myInnerFragments;

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public TextMergeChange(int n, @NotNull MergeLineFragment mergeLineFragment, @NotNull MergeConflictType mergeConflictType, @NotNull TextMergeViewer textMergeViewer) {
        void index2;
        void viewer;
        void conflictType;
        void fragment2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (fragment2 == null) {
            TextMergeChange.$$$reportNull$$$0(0);
        }
        if (conflictType == null) {
            TextMergeChange.$$$reportNull$$$0(1);
        }
        if (viewer == null) {
            TextMergeChange.$$$reportNull$$$0(2);
        }
        super((MergeConflictType)conflictType);
        this.myResolved = new boolean[2];
        this.myMergeViewer = viewer;
        this.myViewer = viewer.getViewer();
        this.myIndex = index2;
        this.myFragment = fragment2;
        this.reinstallHighlighters();
    }

    @RequiresEdt
    public void reinstallHighlighters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.destroyHighlighters();
        this.installHighlighters();
        this.destroyOperations();
        this.installOperations();
        this.myViewer.repaintDividers();
    }

    public int getIndex() {
        return this.myIndex;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    void setResolved(@NotNull Side side, boolean bl) {
        void value2;
        void side2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (side2 == null) {
            TextMergeChange.$$$reportNull$$$0(3);
        }
        this.myResolved[side2.getIndex()] = value2;
        if (this.isResolved()) {
            this.destroyInnerHighlighters();
        } else {
            DocumentEx document = this.myViewer.getEditor((ThreeSide)side2.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT)).getDocument();
            for (RangeHighlighter highlighter : this.myInnerHighlighters) {
                if (!document.equals(highlighter.getDocument())) continue;
                highlighter.dispose();
            }
        }
    }

    public boolean isResolved() {
        return this.myResolved[0] && this.myResolved[1];
    }

    public boolean isResolved(@NotNull Side side) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(4);
        }
        return side.select(this.myResolved);
    }

    public boolean isOnesideAppliedConflict() {
        return this.myOnesideAppliedConflict;
    }

    public void markOnesideAppliedConflict() {
        this.myOnesideAppliedConflict = true;
    }

    @Override
    public boolean isResolved(@NotNull ThreeSide side) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(5);
        }
        switch (side) {
            case LEFT: {
                return this.isResolved(Side.LEFT);
            }
            case BASE: {
                return this.isResolved();
            }
            case RIGHT: {
                return this.isResolved(Side.RIGHT);
            }
        }
        throw new IllegalArgumentException(side.toString());
    }

    public int getStartLine() {
        return this.myViewer.getModel().getLineStart(this.myIndex);
    }

    public int getEndLine() {
        return this.myViewer.getModel().getLineEnd(this.myIndex);
    }

    @Override
    public int getStartLine(@NotNull ThreeSide side) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(6);
        }
        if (side == ThreeSide.BASE) {
            return this.getStartLine();
        }
        return this.myFragment.getStartLine(side);
    }

    @Override
    public int getEndLine(@NotNull ThreeSide side) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(7);
        }
        if (side == ThreeSide.BASE) {
            return this.getEndLine();
        }
        return this.myFragment.getEndLine(side);
    }

    @Override
    @NotNull
    protected Editor getEditor(@NotNull ThreeSide side) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(8);
        }
        EditorEx editorEx = this.myViewer.getEditor(side);
        if (editorEx == null) {
            TextMergeChange.$$$reportNull$$$0(9);
        }
        return editorEx;
    }

    @Override
    @Nullable
    protected MergeInnerDifferences getInnerFragments() {
        return this.myInnerFragments;
    }

    @NotNull
    public MergeLineFragment getFragment() {
        MergeLineFragment mergeLineFragment = this.myFragment;
        if (mergeLineFragment == null) {
            TextMergeChange.$$$reportNull$$$0(10);
        }
        return mergeLineFragment;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setInnerFragments(@Nullable MergeInnerDifferences mergeInnerDifferences) {
        void innerFragments;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myInnerFragments == null && innerFragments == null) {
            return;
        }
        this.myInnerFragments = innerFragments;
        this.reinstallHighlighters();
        this.destroyInnerHighlighters();
        this.installInnerHighlighters();
    }

    @Override
    @RequiresEdt
    protected void installOperations() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createResolveOperation());
        ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createAcceptOperation(Side.LEFT, OperationType.APPLY));
        ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createAcceptOperation(Side.LEFT, OperationType.IGNORE));
        ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createAcceptOperation(Side.RIGHT, OperationType.APPLY));
        ContainerUtil.addIfNotNull((Collection)this.myOperations, (Object)this.createAcceptOperation(Side.RIGHT, OperationType.IGNORE));
    }

    @Nullable
    private DiffGutterOperation createOperation(@NotNull ThreeSide side, @NotNull DiffGutterOperation.ModifiersRendererBuilder builder2) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(11);
        }
        if (builder2 == null) {
            TextMergeChange.$$$reportNull$$$0(12);
        }
        if (this.isResolved(side)) {
            return null;
        }
        EditorEx editor = this.myViewer.getEditor(side);
        int offset = DiffGutterOperation.lineToOffset(editor, this.getStartLine(side));
        return new DiffGutterOperation.WithModifiers(editor, offset, this.myViewer.getModifierProvider(), builder2);
    }

    @Nullable
    private DiffGutterOperation createResolveOperation() {
        return this.createOperation(ThreeSide.BASE, (ctrlPressed, shiftPressed, altPressed) -> this.createResolveRenderer());
    }

    @Nullable
    private DiffGutterOperation createAcceptOperation(@NotNull Side versionSide, @NotNull OperationType type) {
        if (versionSide == null) {
            TextMergeChange.$$$reportNull$$$0(13);
        }
        if (type == null) {
            TextMergeChange.$$$reportNull$$$0(14);
        }
        ThreeSide side = (ThreeSide)versionSide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
        return this.createOperation(side, (ctrlPressed, shiftPressed, altPressed) -> {
            if (!this.isChange(versionSide)) {
                return null;
            }
            if (type == OperationType.APPLY) {
                return this.createApplyRenderer(versionSide, ctrlPressed);
            }
            return this.createIgnoreRenderer(versionSide, ctrlPressed);
        });
    }

    @Nullable
    private GutterIconRenderer createApplyRenderer(@NotNull Side side, boolean modifier) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(15);
        }
        if (this.isResolved(side)) {
            return null;
        }
        Icon icon2 = this.isOnesideAppliedConflict() ? DiffUtil.getArrowDownIcon(side) : DiffUtil.getArrowIcon(side);
        return TextMergeChange.createIconRenderer(DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]), icon2, this.isConflict(), () -> this.myViewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.accept.change.command", (Object[])new Object[0]), Collections.singletonList(this), () -> this.myViewer.replaceChange(this, side, modifier)));
    }

    @Nullable
    private GutterIconRenderer createIgnoreRenderer(@NotNull Side side, boolean modifier) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(16);
        }
        if (this.isResolved(side)) {
            return null;
        }
        return TextMergeChange.createIconRenderer(DiffBundle.message((String)"action.presentation.merge.ignore.text", (Object[])new Object[0]), AllIcons.Diff.Remove, this.isConflict(), () -> this.myViewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.ignore.change.command", (Object[])new Object[0]), Collections.singletonList(this), () -> this.myViewer.ignoreChange(this, side, modifier)));
    }

    @Nullable
    private GutterIconRenderer createResolveRenderer() {
        if (!this.isConflict() || !this.myViewer.canResolveChangeAutomatically(this, ThreeSide.BASE)) {
            return null;
        }
        return TextMergeChange.createIconRenderer(DiffBundle.message((String)"action.presentation.merge.resolve.text", (Object[])new Object[0]), AllIcons.Diff.MagicResolve, false, () -> this.myViewer.executeMergeCommand(DiffBundle.message((String)"merge.dialog.resolve.conflict.command", (Object[])new Object[0]), Collections.singletonList(this), () -> this.myViewer.resolveChangeAutomatically(this, ThreeSide.BASE)));
    }

    @NotNull
    private static GutterIconRenderer createIconRenderer(@NotNull @NlsContexts.Tooltip String text2, @NotNull Icon icon2, boolean ctrlClickVisible, final @NotNull Runnable perform2) {
        if (text2 == null) {
            TextMergeChange.$$$reportNull$$$0(17);
        }
        if (icon2 == null) {
            TextMergeChange.$$$reportNull$$$0(18);
        }
        if (perform2 == null) {
            TextMergeChange.$$$reportNull$$$0(19);
        }
        String appendix = ctrlClickVisible ? DiffBundle.message((String)"tooltip.merge.ctrl.click.to.resolve.conflict", (Object[])new Object[0]) : null;
        String tooltipText = DiffUtil.createTooltipText(text2, appendix);
        return new DiffGutterRenderer(icon2, tooltipText){

            @Override
            protected void handleMouseClick() {
                perform2.run();
            }
        };
    }

    @NotNull
    State storeState() {
        return new State(this.myIndex, this.getStartLine(), this.getEndLine(), this.myResolved[0], this.myResolved[1], this.myOnesideAppliedConflict);
    }

    void restoreState(@NotNull State state) {
        if (state == null) {
            TextMergeChange.$$$reportNull$$$0(20);
        }
        this.myResolved[0] = state.myResolved1;
        this.myResolved[1] = state.myResolved2;
        this.myOnesideAppliedConflict = state.myOnesideAppliedConflict;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/merge/TextMergeChange";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionSide";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "perform";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/merge/TextMergeChange";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setResolved";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isResolved";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStartLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEndLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createOperation";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createAcceptOperation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createApplyRenderer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createIgnoreRenderer";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createIconRenderer";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "restoreState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State
    extends MergeModelBase.State {
        private final boolean myResolved1;
        private final boolean myResolved2;
        private final boolean myOnesideAppliedConflict;

        public State(int index2, int startLine, int endLine, boolean resolved1, boolean resolved2, boolean onesideAppliedConflict) {
            super(index2, startLine, endLine);
            this.myResolved1 = resolved1;
            this.myResolved2 = resolved2;
            this.myOnesideAppliedConflict = onesideAppliedConflict;
        }
    }

    private static enum OperationType {
        APPLY,
        IGNORE;

    }
}

