/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.ThreeDiffSplitter;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.breadcrumbs.DiffBreadcrumbsPanel;
import com.intellij.diff.tools.util.side.DiffContentPanel;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreesideContentPanel
extends JPanel {
    @NotNull
    private final ThreeDiffSplitter mySplitter;
    @NotNull
    private final List<DiffContentPanel> myPanels;

    public ThreesideContentPanel(@NotNull List<? extends JComponent> contents) {
        if (contents == null) {
            ThreesideContentPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        assert (contents.size() == 3);
        this.myPanels = ContainerUtil.map(contents, it -> new DiffContentPanel((JComponent)it));
        DiffContentPanel.syncTitleHeights(this.myPanels);
        this.mySplitter = new ThreeDiffSplitter(this.myPanels);
        this.add((Component)this.mySplitter, "Center");
    }

    public void setTitles(@NotNull List<JComponent> titleComponents) {
        if (titleComponents == null) {
            ThreesideContentPanel.$$$reportNull$$$0(1);
        }
        for (ThreeSide side : ThreeSide.values()) {
            DiffContentPanel panel2 = (DiffContentPanel)side.select(this.myPanels);
            JComponent title2 = (JComponent)side.select(titleComponents);
            panel2.setTitle(title2);
        }
    }

    public void setBreadcrumbs(@NotNull ThreeSide side, @Nullable DiffBreadcrumbsPanel breadcrumbs, final @NotNull TextDiffSettingsHolder.TextDiffSettings settings2) {
        if (side == null) {
            ThreesideContentPanel.$$$reportNull$$$0(2);
        }
        if (settings2 == null) {
            ThreesideContentPanel.$$$reportNull$$$0(3);
        }
        if (breadcrumbs != null) {
            final DiffContentPanel panel2 = (DiffContentPanel)side.select(this.myPanels);
            panel2.setBreadcrumbs(breadcrumbs);
            panel2.updateBreadcrumbsPlacement(settings2.getBreadcrumbsPlacement());
            settings2.addListener(new TextDiffSettingsHolder.TextDiffSettings.Listener.Adapter(){

                @Override
                public void breadcrumbsPlacementChanged() {
                    panel2.updateBreadcrumbsPlacement(settings2.getBreadcrumbsPlacement());
                    ThreesideContentPanel.this.repaintDividers();
                }
            }, breadcrumbs);
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setPainter(@Nullable DiffSplitter.Painter painter, @NotNull Side side) {
        void painter2;
        void side2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (side2 == null) {
            ThreesideContentPanel.$$$reportNull$$$0(4);
        }
        this.mySplitter.setPainter((DiffSplitter.Painter)painter2, (Side)side2);
    }

    public void repaintDividers() {
        this.repaintDivider(Side.LEFT);
        this.repaintDivider(Side.RIGHT);
    }

    public void repaintDivider(@NotNull Side side) {
        if (side == null) {
            ThreesideContentPanel.$$$reportNull$$$0(5);
        }
        this.mySplitter.repaintDivider(side);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleComponents";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/util/side/ThreesideContentPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setTitles";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setBreadcrumbs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setPainter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "repaintDivider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Holders
    extends ThreesideContentPanel {
        @Nullable
        private final EditorEx myBaseEditor;

        public Holders(@NotNull List<? extends EditorHolder> holders) {
            if (holders == null) {
                Holders.$$$reportNull$$$0(0);
            }
            super(ContainerUtil.map(holders, holder -> holder.getComponent()));
            EditorHolder baseHolder = (EditorHolder)ThreeSide.BASE.select(holders);
            this.myBaseEditor = baseHolder instanceof TextEditorHolder ? ((TextEditorHolder)baseHolder).getEditor() : null;
        }

        @Override
        public void repaintDivider(@NotNull Side side) {
            if (side == null) {
                Holders.$$$reportNull$$$0(1);
            }
            if (side == Side.RIGHT && this.myBaseEditor != null) {
                this.myBaseEditor.getScrollPane().getVerticalScrollBar().repaint();
            }
            super.repaintDivider(side);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holders";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/side/ThreesideContentPanel$Holders";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "repaintDivider";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

