/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffLineSeparatorRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.Interval;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiffDividerDrawUtil {
    public static final BasicStroke BOLD_DOTTED_STROKE = new BasicStroke(2.3f, 0, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);

    @NotNull
    public static Graphics2D getDividerGraphics(@NotNull Graphics g, @NotNull Component divider, @NotNull Component base) {
        if (g == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(0);
        }
        if (divider == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(1);
        }
        if (base == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(2);
        }
        int width = divider.getWidth();
        int editorHeight = base.getHeight();
        int dividerOffset = divider.getLocationOnScreen().y;
        int editorOffset = base.getLocationOnScreen().y;
        Graphics2D graphics2D = (Graphics2D)g.create(0, editorOffset - dividerOffset, width, editorHeight);
        if (graphics2D == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(3);
        }
        return graphics2D;
    }

    public static void paintSeparators(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerSeparatorPaintable paintable) {
        if (gg == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(4);
        }
        if (editor1 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(6);
        }
        if (paintable == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(7);
        }
        List<DividerSeparator> polygons = DiffDividerDrawUtil.createVisibleSeparators(editor1, editor2, paintable);
        GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DividerSeparator polygon : polygons) {
            polygon.paint(gg, width);
        }
        config2.restore();
    }

    public static void paintPolygons(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        if (gg == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(8);
        }
        if (editor1 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(9);
        }
        if (editor2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(10);
        }
        if (paintable == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(11);
        }
        DiffDividerDrawUtil.paintPolygons(gg, width, true, editor1, editor2, paintable);
    }

    public static void paintPolygons(@NotNull Graphics2D gg, int width, boolean curved, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        if (gg == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(12);
        }
        if (editor1 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(13);
        }
        if (editor2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(14);
        }
        if (paintable == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(15);
        }
        List<DividerPolygon> polygons = DiffDividerDrawUtil.createVisiblePolygons(editor1, editor2, paintable);
        GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DividerPolygon polygon : polygons) {
            polygon.paint(gg, width, curved);
        }
        config2.restore();
    }

    @NotNull
    public static List<DividerPolygon> createVisiblePolygons(@NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        if (editor1 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(16);
        }
        if (editor2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(17);
        }
        if (paintable == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(18);
        }
        DividerPaintableHandlerImpl handler2 = new DividerPaintableHandlerImpl(editor1, editor2);
        paintable.process(handler2);
        List<DividerPolygon> list2 = handler2.getPolygons();
        if (list2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(19);
        }
        return list2;
    }

    private static boolean isIntervalFolded(@NotNull Editor editor, int startLine, int endLine) {
        if (editor == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(20);
        }
        TextRange range2 = DiffUtil.getLinesRange(editor.getDocument(), startLine, endLine);
        return FoldingUtil.isTextRangeFolded(editor, range2);
    }

    @NotNull
    public static List<DividerSeparator> createVisibleSeparators(@NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerSeparatorPaintable paintable) {
        if (editor1 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(21);
        }
        if (editor2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(22);
        }
        if (paintable == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(23);
        }
        ArrayList<DividerSeparator> separators = new ArrayList<DividerSeparator>();
        LineRange leftInterval = DiffDividerDrawUtil.getVisibleInterval(editor1);
        LineRange rightInterval = DiffDividerDrawUtil.getVisibleInterval(editor2);
        int height1 = editor1.getLineHeight();
        int height2 = editor2.getLineHeight();
        EditorColorsScheme scheme2 = editor1.getColorsScheme();
        paintable.process((line1, line2) -> {
            if (leftInterval.start > line1 + 1 && rightInterval.start > line2 + 1) {
                return true;
            }
            if (leftInterval.end < line1 && rightInterval.end < line2) {
                return false;
            }
            separators.add(DiffDividerDrawUtil.createSeparator(editor1, editor2, line1, line2, height1, height2, scheme2));
            return true;
        });
        ArrayList<DividerSeparator> arrayList = separators;
        if (arrayList == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    private static int getEditorTopOffset(@NotNull Editor editor) {
        JComponent header2;
        if (editor == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(25);
        }
        int headerOffset = (header2 = editor.getHeaderComponent()) == null ? 0 : header2.getHeight();
        return -editor.getScrollingModel().getVerticalScrollOffset() + headerOffset;
    }

    private static DiffDrawUtil.MarkerRange getDividerMarkerPaintRange(@NotNull Editor editor, int startLine, int endLine) {
        if (editor == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(26);
        }
        Pair<@NotNull Interval, @Nullable Interval> pair1 = EditorUtil.logicalLineToYRange(editor, startLine);
        Pair<@NotNull Interval, @Nullable Interval> pair2 = startLine == endLine ? pair1 : EditorUtil.logicalLineToYRange(editor, endLine - 1);
        int startOffset = ((Interval)pair1.first).intervalStart();
        int endOffset = ((Interval)pair2.first).intervalEnd();
        return new DiffDrawUtil.MarkerRange(startOffset, endOffset);
    }

    @NotNull
    private static DividerSeparator createSeparator(@NotNull Editor editor1, @NotNull Editor editor2, int line1, int line2, int height1, int height2, @Nullable EditorColorsScheme scheme2) {
        if (editor1 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(27);
        }
        if (editor2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(28);
        }
        int topOffset1 = DiffDividerDrawUtil.getEditorTopOffset(editor1);
        int topOffset2 = DiffDividerDrawUtil.getEditorTopOffset(editor2);
        int start1 = DiffDrawUtil.lineToY(editor1, line1) + topOffset1;
        int start2 = DiffDrawUtil.lineToY(editor2, line2) + topOffset2;
        return new DividerSeparator(start1, start2, start1 + height1, start2 + height2, scheme2);
    }

    @NotNull
    private static LineRange getVisibleInterval(Editor editor) {
        Rectangle area = editor.getScrollingModel().getVisibleArea();
        if (area.height < 0) {
            return new LineRange(0, 0);
        }
        LogicalPosition position1 = editor.xyToLogicalPosition(new Point(0, area.y));
        LogicalPosition position2 = editor.xyToLogicalPosition(new Point(0, area.y + area.height));
        return new LineRange(position1.line, position2.line);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 19: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 19: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "divider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 3: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/DiffDividerDrawUtil";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gg";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 16: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor1";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 17: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor2";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paintable";
                break;
            }
            case 20: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/DiffDividerDrawUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDividerGraphics";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisiblePolygons";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisibleSeparators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDividerGraphics";
                break;
            }
            case 3: 
            case 19: 
            case 24: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "paintSeparators";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "paintPolygons";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createVisiblePolygons";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isIntervalFolded";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createVisibleSeparators";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTopOffset";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDividerMarkerPaintRange";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createSeparator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 19: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DividerSeparator {
        private final int myStart1;
        private final int myStart2;
        private final int myEnd1;
        private final int myEnd2;
        @Nullable
        private final EditorColorsScheme myScheme;

        public DividerSeparator(int start1, int start2, int end1, int end2, @Nullable EditorColorsScheme scheme2) {
            this.myStart1 = start1;
            this.myStart2 = start2;
            this.myEnd1 = end1;
            this.myEnd2 = end2;
            this.myScheme = scheme2;
        }

        public void paint(Graphics2D g, int width) {
            DiffLineSeparatorRenderer.drawConnectorLine(g, 0, width, this.myStart1, this.myStart2, this.myEnd1 - this.myStart1, this.myScheme);
        }

        public String toString() {
            return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> ";
        }
    }

    public static class DividerPolygon {
        private final int myStart1;
        private final int myStart2;
        private final int myEnd1;
        private final int myEnd2;
        @Nullable
        private final Color myFillColor;
        @Nullable
        private final Color myBorderColor;
        private final boolean myDottedBorder;

        public DividerPolygon(int start1, int start2, int end1, int end2, @Nullable Color fillColor, @Nullable Color borderColor, boolean dottedBorder) {
            this.myStart1 = start1;
            this.myStart2 = start2;
            this.myEnd1 = end1;
            this.myEnd2 = end2;
            this.myFillColor = fillColor;
            this.myBorderColor = borderColor;
            this.myDottedBorder = dottedBorder;
        }

        public void paint(Graphics2D g, int width, boolean curve) {
            int endY2;
            int startY2;
            int endY1;
            int startY1;
            if (this.myEnd1 - this.myStart1 < 2) {
                startY1 = this.myStart1 - 1;
                endY1 = this.myStart1;
            } else {
                startY1 = this.myStart1;
                endY1 = this.myEnd1 - 1;
            }
            if (this.myEnd2 - this.myStart2 < 2) {
                startY2 = this.myStart2 - 1;
                endY2 = this.myStart2;
            } else {
                startY2 = this.myStart2;
                endY2 = this.myEnd2 - 1;
            }
            Stroke oldStroke = g.getStroke();
            if (this.myDottedBorder) {
                g.setStroke(BOLD_DOTTED_STROKE);
            }
            if (curve) {
                DiffDrawUtil.drawCurveTrapezium(g, 0, width, startY1, endY1, startY2, endY2, this.myFillColor, this.myBorderColor);
            } else {
                DiffDrawUtil.drawTrapezium(g, 0, width, startY1, endY1, startY2, endY2, this.myFillColor, this.myBorderColor);
            }
            g.setStroke(oldStroke);
        }

        public String toString() {
            return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> " + this.myFillColor + ", " + this.myBorderColor;
        }
    }

    public static interface DividerSeparatorPaintable {
        public void process(@NotNull Handler var1);

        public static interface Handler {
            public boolean process(int var1, int var2);
        }
    }

    private static class DividerPaintableHandlerImpl
    implements DividerPaintable.Handler {
        private final Editor myEditor1;
        private final Editor myEditor2;
        private final LineRange myLeftInterval;
        private final LineRange myRightInterval;
        private final List<DividerPolygon> myPolygons;

        private DividerPaintableHandlerImpl(@NotNull Editor editor1, @NotNull Editor editor2) {
            if (editor1 == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(1);
            }
            this.myPolygons = new ArrayList<DividerPolygon>();
            this.myEditor1 = editor1;
            this.myEditor2 = editor2;
            this.myLeftInterval = DiffDividerDrawUtil.getVisibleInterval(editor1);
            this.myRightInterval = DiffDividerDrawUtil.getVisibleInterval(editor2);
        }

        @NotNull
        public List<DividerPolygon> getPolygons() {
            List<DividerPolygon> list2 = this.myPolygons;
            if (list2 == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        public boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull TextDiffType type) {
            if (type == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(3);
            }
            return this.process(startLine1, endLine1, startLine2, endLine2, new DefaultPainter(type));
        }

        @Override
        public boolean processResolvable(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull TextDiffType type, boolean resolved2) {
            if (type == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(4);
            }
            return this.process(startLine1, endLine1, startLine2, endLine2, new ResolvablePainter(type, resolved2));
        }

        @Override
        public boolean processExcludable(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull TextDiffType type, boolean excluded, boolean skipped) {
            if (type == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(5);
            }
            return this.process(startLine1, endLine1, startLine2, endLine2, new ExcludablePainter(type, excluded, skipped));
        }

        private boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Painter painter) {
            if (painter == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(6);
            }
            if (this.myLeftInterval.start > endLine1 && this.myRightInterval.start > endLine2) {
                return true;
            }
            if (this.myLeftInterval.end < startLine1 && this.myRightInterval.end < startLine2) {
                return false;
            }
            ContainerUtil.addIfNotNull(this.myPolygons, (Object)DividerPaintableHandlerImpl.createPolygon(this.myEditor1, this.myEditor2, startLine1, endLine1, startLine2, endLine2, painter));
            return true;
        }

        @Nullable
        private static DividerPolygon createPolygon(@NotNull Editor editor1, @NotNull Editor editor2, int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Painter painter) {
            boolean isFolded;
            if (editor1 == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(7);
            }
            if (editor2 == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(8);
            }
            if (painter == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(9);
            }
            int topOffset1 = DiffDividerDrawUtil.getEditorTopOffset(editor1);
            int topOffset2 = DiffDividerDrawUtil.getEditorTopOffset(editor2);
            boolean isFolded1 = DiffDividerDrawUtil.isIntervalFolded(editor1, startLine1, endLine1);
            boolean isFolded2 = DiffDividerDrawUtil.isIntervalFolded(editor2, startLine2, endLine2);
            boolean bl = isFolded = isFolded1 && isFolded2;
            if (isFolded && !painter.isAlwaysVisible()) {
                return null;
            }
            DiffDrawUtil.MarkerRange range1 = isFolded1 ? DiffDividerDrawUtil.getDividerMarkerPaintRange(editor1, startLine1, endLine1) : DiffDrawUtil.getGutterMarkerPaintRange(editor1, startLine1, endLine1);
            DiffDrawUtil.MarkerRange range2 = isFolded2 ? DiffDividerDrawUtil.getDividerMarkerPaintRange(editor2, startLine2, endLine2) : DiffDrawUtil.getGutterMarkerPaintRange(editor2, startLine2, endLine2);
            return new DividerPolygon(range1.y1 + topOffset1, range2.y1 + topOffset2, range1.y2 + topOffset1, range2.y2 + topOffset2, painter.getFillColor(editor2, isFolded), painter.getBorderColor(editor2, isFolded), painter.isDottedBorder());
        }

        @NotNull
        private static TextDiffType correctType(@NotNull TextDiffType type, boolean isFolded) {
            if (type == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(10);
            }
            if (isFolded && (type == TextDiffType.DELETED || type == TextDiffType.INSERTED)) {
                TextDiffType textDiffType = TextDiffType.MODIFIED;
                if (textDiffType == null) {
                    DividerPaintableHandlerImpl.$$$reportNull$$$0(11);
                }
                return textDiffType;
            }
            TextDiffType textDiffType = type;
            if (textDiffType == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(12);
            }
            return textDiffType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor1";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor2";
                    break;
                }
                case 2: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/util/DiffDividerDrawUtil$DividerPaintableHandlerImpl";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "painter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/util/DiffDividerDrawUtil$DividerPaintableHandlerImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPolygons";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "correctType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 11: 
                case 12: {
                    break;
                }
                case 3: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processResolvable";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "processExcludable";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createPolygon";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "correctType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static interface Painter {
            @Nullable
            public Color getFillColor(@NotNull Editor var1, boolean var2);

            @Nullable
            public Color getBorderColor(@NotNull Editor var1, boolean var2);

            public boolean isDottedBorder();

            public boolean isAlwaysVisible();
        }

        private static class ExcludablePainter
        implements Painter {
            private final TextDiffType myType;
            private final boolean myExcluded;
            private final boolean mySkipped;

            private ExcludablePainter(@NotNull TextDiffType type, boolean excluded, boolean skipped) {
                if (type == null) {
                    ExcludablePainter.$$$reportNull$$$0(0);
                }
                this.myType = type;
                this.myExcluded = excluded;
                this.mySkipped = skipped;
            }

            @Override
            @Nullable
            public Color getFillColor(@NotNull Editor editor, boolean isFolded) {
                if (editor == null) {
                    ExcludablePainter.$$$reportNull$$$0(1);
                }
                return this.myExcluded ? DividerPaintableHandlerImpl.correctType(this.myType, isFolded).getIgnoredColor(editor) : DividerPaintableHandlerImpl.correctType(this.myType, isFolded).getColor(editor);
            }

            @Override
            @Nullable
            public Color getBorderColor(@NotNull Editor editor, boolean isFolded) {
                if (editor == null) {
                    ExcludablePainter.$$$reportNull$$$0(2);
                }
                return this.myExcluded ? DividerPaintableHandlerImpl.correctType(this.myType, isFolded).getColor(editor) : null;
            }

            @Override
            public boolean isDottedBorder() {
                return false;
            }

            @Override
            public boolean isAlwaysVisible() {
                return !this.mySkipped;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/util/DiffDividerDrawUtil$DividerPaintableHandlerImpl$ExcludablePainter";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getFillColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getBorderColor";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class ResolvablePainter
        implements Painter {
            private final TextDiffType myType;
            private final boolean myResolved;

            private ResolvablePainter(@NotNull TextDiffType type, boolean resolved2) {
                if (type == null) {
                    ResolvablePainter.$$$reportNull$$$0(0);
                }
                this.myType = type;
                this.myResolved = resolved2;
            }

            @Override
            @Nullable
            public Color getFillColor(@NotNull Editor editor, boolean isFolded) {
                if (editor == null) {
                    ResolvablePainter.$$$reportNull$$$0(1);
                }
                return !this.myResolved ? DividerPaintableHandlerImpl.correctType(this.myType, isFolded).getColor(editor) : null;
            }

            @Override
            @Nullable
            public Color getBorderColor(@NotNull Editor editor, boolean isFolded) {
                if (editor == null) {
                    ResolvablePainter.$$$reportNull$$$0(2);
                }
                return this.myResolved ? DividerPaintableHandlerImpl.correctType(this.myType, isFolded).getColor(editor) : null;
            }

            @Override
            public boolean isDottedBorder() {
                return this.myResolved;
            }

            @Override
            public boolean isAlwaysVisible() {
                return !this.myResolved;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/util/DiffDividerDrawUtil$DividerPaintableHandlerImpl$ResolvablePainter";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getFillColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getBorderColor";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class DefaultPainter
        implements Painter {
            private final TextDiffType myType;

            private DefaultPainter(@NotNull TextDiffType type) {
                if (type == null) {
                    DefaultPainter.$$$reportNull$$$0(0);
                }
                this.myType = type;
            }

            @Override
            @Nullable
            public Color getFillColor(@NotNull Editor editor, boolean isFolded) {
                if (editor == null) {
                    DefaultPainter.$$$reportNull$$$0(1);
                }
                return DividerPaintableHandlerImpl.correctType(this.myType, isFolded).getColor(editor);
            }

            @Override
            @Nullable
            public Color getBorderColor(@NotNull Editor editor, boolean isFolded) {
                if (editor == null) {
                    DefaultPainter.$$$reportNull$$$0(2);
                }
                return null;
            }

            @Override
            public boolean isDottedBorder() {
                return false;
            }

            @Override
            public boolean isAlwaysVisible() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/util/DiffDividerDrawUtil$DividerPaintableHandlerImpl$DefaultPainter";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getFillColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getBorderColor";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static interface DividerPaintable {
        public void process(@NotNull Handler var1);

        public static interface Handler {
            public boolean process(int var1, int var2, int var3, int var4, @NotNull TextDiffType var5);

            public boolean processResolvable(int var1, int var2, int var3, int var4, @NotNull TextDiffType var5, boolean var6);

            public boolean processExcludable(int var1, int var2, int var3, int var4, @NotNull TextDiffType var5, boolean var6, boolean var7);
        }
    }
}

