/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.PsiElementRole;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptorProvider;
import com.intellij.dupLocator.equivalence.MultiChildDescriptor;
import com.intellij.dupLocator.equivalence.SingleChildDescriptor;
import com.intellij.dupLocator.treeHash.AbstractTreeHasher;
import com.intellij.dupLocator.treeHash.DuplicatesProfileBase;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.NodeSpecificHasherBase;
import com.intellij.dupLocator.treeHash.TreeHashResult;
import com.intellij.dupLocator.treeHash.TreeHashingUtils;
import com.intellij.dupLocator.treeHash.TreePsiFragment;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TreeHasherBase
extends AbstractTreeHasher {
    private final FragmentsCollector myCallback;
    private final int myDiscardCost;
    private final DuplicatesProfile myProfile;

    TreeHasherBase(@Nullable FragmentsCollector callback2, @NotNull DuplicatesProfile profile, int discardCost, boolean forIndexing) {
        if (profile == null) {
            TreeHasherBase.$$$reportNull$$$0(0);
        }
        super(callback2, forIndexing);
        this.myCallback = callback2;
        this.myDiscardCost = discardCost;
        this.myProfile = profile;
    }

    @Override
    protected int getDiscardCost(PsiElement root) {
        if (this.myDiscardCost >= 0) {
            return this.myDiscardCost;
        }
        return this.myProfile.getDuplocatorState(this.myProfile.getLanguage(root)).getDiscardCost();
    }

    @Override
    protected TreeHashResult hash(@NotNull PsiElement root, PsiFragment upper, @NotNull NodeSpecificHasher hasher) {
        if (root == null) {
            TreeHasherBase.$$$reportNull$$$0(1);
        }
        if (hasher == null) {
            TreeHasherBase.$$$reportNull$$$0(2);
        }
        TreeHashResult result2 = this.computeHash(root, upper, hasher);
        int discardCost = this.getDiscardCost(root);
        if (result2.getCost() < discardCost) {
            return new TreeHashResult(0, result2.getCost(), result2.getFragment());
        }
        return result2;
    }

    private TreeHashResult computeHash(PsiElement root, PsiFragment upper, NodeSpecificHasher hasher) {
        List<PsiElement> children2;
        EquivalenceDescriptor descriptor2;
        EquivalenceDescriptorProvider descriptorProvider = EquivalenceDescriptorProvider.getInstance(root);
        if (descriptorProvider != null && (descriptor2 = descriptorProvider.buildDescriptor(root)) != null) {
            return this.computeHash(root, upper, descriptor2, hasher);
        }
        if (root instanceof PsiFile && (children2 = hasher.getNodeChildren(root)).size() <= 20) {
            return this.hashCodeBlock(children2, upper, hasher, true);
        }
        NodeSpecificHasherBase ssrNodeSpecificHasher = (NodeSpecificHasherBase)hasher;
        if (TreeHasherBase.shouldBeAnonymized(root, ssrNodeSpecificHasher)) {
            return this.computeElementHash(root, upper, hasher);
        }
        if (this.myForIndexing) {
            return this.computeElementHash(root, upper, hasher);
        }
        PsiElement element2 = DuplocatorUtil.getOnlyChild(root, ssrNodeSpecificHasher.getNodeFilter());
        if (element2 != root) {
            TreeHashResult result2 = this.hash(element2, upper, hasher);
            int cost = hasher.getNodeCost(root);
            return new TreeHashResult(result2.getHash(), result2.getCost() + cost, result2.getFragment());
        }
        return this.computeElementHash(element2, upper, hasher);
    }

    @Override
    public boolean shouldAnonymize(PsiElement root, NodeSpecificHasher hasher) {
        return TreeHasherBase.shouldBeAnonymized(root, (NodeSpecificHasherBase)hasher);
    }

    @Override
    protected TreeHashResult computeElementHash(@NotNull PsiElement root, PsiFragment upper, NodeSpecificHasher hasher) {
        if (root == null) {
            TreeHasherBase.$$$reportNull$$$0(3);
        }
        if (this.myForIndexing) {
            return TreeHashingUtils.computeElementHashForIndexing(this, this.myCallBack, root, upper, hasher);
        }
        List<PsiElement> children2 = hasher.getNodeChildren(root);
        int size2 = children2.size();
        int[] childHashes = new int[size2];
        int[] childCosts = new int[size2];
        TreePsiFragment fragment2 = this.buildFragment(hasher, root, this.getCost(root));
        if (upper != null) {
            fragment2.setParent(upper);
        }
        if (size2 == 0 && !(root instanceof LeafElement)) {
            return new TreeHashResult(0, hasher.getNodeCost(root), fragment2);
        }
        for (int i2 = 0; i2 < size2; ++i2) {
            TreeHashResult res2 = this.hash(children2.get(i2), fragment2, hasher);
            childHashes[i2] = res2.getHash();
            childCosts[i2] = res2.getCost();
        }
        int c = hasher.getNodeCost(root) + AbstractTreeHasher.vector(childCosts);
        int h1 = hasher.getNodeHash(root);
        int discardCost = this.getDiscardCost(root);
        for (int i3 = 0; i3 < size2; ++i3) {
            if (childCosts[i3] > discardCost || !this.ignoreChildHash(children2.get(i3))) continue;
            childHashes[i3] = 0;
        }
        int h = h1 + AbstractTreeHasher.vector(childHashes);
        if (TreeHasherBase.shouldBeAnonymized(root, (NodeSpecificHasherBase)hasher)) {
            h = 0;
        }
        if (this.myCallBack != null) {
            this.myCallBack.add(h, c, fragment2);
        }
        return new TreeHashResult(h, c, fragment2);
    }

    @Override
    protected TreeHashResult hashCodeBlock(List<? extends PsiElement> statements, PsiFragment upper, NodeSpecificHasher hasher, boolean forceHash) {
        if (!this.myForIndexing) {
            return super.hashCodeBlock(statements, upper, hasher, forceHash);
        }
        return TreeHashingUtils.hashCodeBlockForIndexing(this, this.myCallBack, statements, upper, hasher);
    }

    private TreeHashResult computeHash(PsiElement element2, PsiFragment parent, EquivalenceDescriptor descriptor2, NodeSpecificHasher hasher) {
        Couple<Integer> childHashResult;
        NodeSpecificHasherBase ssrHasher = (NodeSpecificHasherBase)hasher;
        PsiElement element22 = DuplocatorUtil.skipNodeIfNecessary(element2, descriptor2, ssrHasher.getNodeFilter());
        boolean canSkip = element22 != element2;
        TreePsiFragment fragment2 = this.buildFragment(hasher, element2, 0);
        if (parent != null) {
            fragment2.setParent(parent);
        }
        int hash = canSkip ? 0 : hasher.getNodeHash(element2);
        int cost = hasher.getNodeCost(element2);
        for (SingleChildDescriptor singleChildDescriptor : descriptor2.getSingleChildDescriptors()) {
            childHashResult = this.computeHash(singleChildDescriptor, (PsiFragment)fragment2, hasher);
            hash = hash * 31 + (Integer)childHashResult.first;
            cost += ((Integer)childHashResult.second).intValue();
        }
        for (MultiChildDescriptor multiChildDescriptor : descriptor2.getMultiChildDescriptors()) {
            childHashResult = this.computeHash(multiChildDescriptor, (PsiFragment)fragment2, hasher);
            hash = hash * 31 + (Integer)childHashResult.first;
            cost += ((Integer)childHashResult.second).intValue();
        }
        for (Object object : descriptor2.getConstants()) {
            int constantHash = object != null ? object.hashCode() : 0;
            hash = hash * 31 + constantHash;
        }
        for (PsiElement[] psiElementArray : descriptor2.getCodeBlocks()) {
            List<PsiElement> filteredBlock = TreeHasherBase.filter(psiElementArray, ssrHasher);
            TreeHashResult childHashResult2 = this.hashCodeBlock(filteredBlock, fragment2, hasher);
            hash = hash * 31 + childHashResult2.getHash();
            cost += childHashResult2.getCost();
        }
        if (this.myCallback != null) {
            this.myCallback.add(hash, cost, fragment2);
        }
        return new TreeHashResult(hash, cost, fragment2);
    }

    public static List<PsiElement> filter(PsiElement[] elements, NodeSpecificHasherBase hasher) {
        ArrayList<PsiElement> filteredElements = new ArrayList<PsiElement>();
        for (PsiElement element2 : elements) {
            if (hasher.getNodeFilter().accepts(element2)) continue;
            filteredElements.add(element2);
        }
        return filteredElements;
    }

    @NotNull
    private Couple<Integer> computeHash(SingleChildDescriptor childDescriptor, PsiFragment parentFragment, NodeSpecificHasher nodeSpecificHasher) {
        PsiElement element2 = childDescriptor.getElement();
        if (element2 == null) {
            Couple couple = Couple.of((Object)0, (Object)0);
            if (couple == null) {
                TreeHasherBase.$$$reportNull$$$0(4);
            }
            return couple;
        }
        Couple<Integer> result2 = this.doComputeHash(childDescriptor, parentFragment, nodeSpecificHasher);
        DuplicatesProfileBase duplicatesProfile = ((NodeSpecificHasherBase)nodeSpecificHasher).getDuplicatesProfile();
        PsiElementRole role = duplicatesProfile.getRole(element2);
        if (role != null && !duplicatesProfile.getDuplocatorState(duplicatesProfile.getLanguage(element2)).distinguishRole(role)) {
            Couple couple = Couple.of((Object)0, (Object)((Integer)result2.second));
            if (couple == null) {
                TreeHasherBase.$$$reportNull$$$0(5);
            }
            return couple;
        }
        Couple<Integer> couple = result2;
        if (couple == null) {
            TreeHasherBase.$$$reportNull$$$0(6);
        }
        return couple;
    }

    private static boolean shouldBeAnonymized(PsiElement element2, NodeSpecificHasherBase nodeSpecificHasher) {
        DuplicatesProfileBase duplicatesProfile = nodeSpecificHasher.getDuplicatesProfile();
        PsiElementRole role = duplicatesProfile.getRole(element2);
        return role != null && !duplicatesProfile.getDuplocatorState(duplicatesProfile.getLanguage(element2)).distinguishRole(role);
    }

    @NotNull
    private Couple<Integer> doComputeHash(SingleChildDescriptor childDescriptor, PsiFragment parentFragment, NodeSpecificHasher nodeSpecificHasher) {
        PsiElement element2 = childDescriptor.getElement();
        if (element2 == null) {
            Couple couple = Couple.of((Object)0, (Object)0);
            if (couple == null) {
                TreeHasherBase.$$$reportNull$$$0(7);
            }
            return couple;
        }
        switch (childDescriptor.getType()) {
            case OPTIONALLY_IN_PATTERN: 
            case DEFAULT: {
                TreeHashResult result2 = this.hash(element2, parentFragment, nodeSpecificHasher);
                Couple couple = Couple.of((Object)result2.getHash(), (Object)result2.getCost());
                if (couple == null) {
                    TreeHasherBase.$$$reportNull$$$0(8);
                }
                return couple;
            }
            case CHILDREN_OPTIONALLY_IN_PATTERN: 
            case CHILDREN: {
                return TreeHasherBase.hashChildResults(this.computeHashesForChildren(element2, parentFragment, nodeSpecificHasher), 31);
            }
            case CHILDREN_IN_ANY_ORDER: {
                return TreeHasherBase.hashChildResults(this.computeHashesForChildren(element2, parentFragment, nodeSpecificHasher), 1);
            }
        }
        Couple couple = Couple.of((Object)0, (Object)0);
        if (couple == null) {
            TreeHasherBase.$$$reportNull$$$0(9);
        }
        return couple;
    }

    @NotNull
    private Couple<Integer> computeHash(MultiChildDescriptor childDescriptor, PsiFragment parentFragment, NodeSpecificHasher nodeSpecificHasher) {
        PsiElement[] elements = childDescriptor.getElements();
        switch (childDescriptor.getType()) {
            case OPTIONALLY_IN_PATTERN: 
            case DEFAULT: {
                return TreeHasherBase.hashChildResults(this.computeHashes(elements, parentFragment, nodeSpecificHasher), 31);
            }
            case IN_ANY_ORDER: {
                return TreeHasherBase.hashChildResults(this.computeHashes(elements, parentFragment, nodeSpecificHasher), 1);
            }
        }
        Couple couple = Couple.of((Object)0, (Object)0);
        if (couple == null) {
            TreeHasherBase.$$$reportNull$$$0(10);
        }
        return couple;
    }

    @NotNull
    private static Couple<Integer> hashChildResults(TreeHashResult[] childResults, int multiplier) {
        int[] hashes = TreeHasherBase.getHashes(childResults);
        int[] costs = TreeHasherBase.getCosts(childResults);
        int hash = AbstractTreeHasher.vector(hashes, multiplier);
        int cost = AbstractTreeHasher.vector(costs);
        Couple couple = Couple.of((Object)hash, (Object)cost);
        if (couple == null) {
            TreeHasherBase.$$$reportNull$$$0(11);
        }
        return couple;
    }

    private TreeHashResult @NotNull [] computeHashesForChildren(PsiElement element2, PsiFragment parentFragment, NodeSpecificHasher nodeSpecificHasher) {
        ArrayList<TreeHashResult> result2 = new ArrayList<TreeHashResult>();
        for (PsiElement child2 = element2.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
            TreeHashResult childResult = this.hash(element2, parentFragment, nodeSpecificHasher);
            result2.add(childResult);
        }
        TreeHashResult[] treeHashResultArray = result2.toArray(new TreeHashResult[0]);
        if (treeHashResultArray == null) {
            TreeHasherBase.$$$reportNull$$$0(12);
        }
        return treeHashResultArray;
    }

    private TreeHashResult @NotNull [] computeHashes(PsiElement[] elements, PsiFragment parentFragment, NodeSpecificHasher nodeSpecificHasher) {
        TreeHashResult[] result2 = new TreeHashResult[elements.length];
        for (int i2 = 0; i2 < elements.length; ++i2) {
            result2[i2] = this.hash(elements[i2], parentFragment, nodeSpecificHasher);
        }
        if (result2 == null) {
            TreeHasherBase.$$$reportNull$$$0(13);
        }
        return result2;
    }

    private static int[] getHashes(TreeHashResult[] results) {
        int[] hashes = new int[results.length];
        for (int i2 = 0; i2 < results.length; ++i2) {
            hashes[i2] = results[i2].getHash();
        }
        return hashes;
    }

    private static int[] getCosts(TreeHashResult[] results) {
        int[] costs = new int[results.length];
        for (int i2 = 0; i2 < results.length; ++i2) {
            costs[i2] = results[i2].getCost();
        }
        return costs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasher";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/treeHash/TreeHasherBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/treeHash/TreeHasherBase";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHash";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeHash";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "hashChildResults";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHashesForChildren";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hash";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeElementHash";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

